/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.Arrays;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiEmbeddedGaugeTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiIndustrialTurbine
extends GuiEmbeddedGaugeTile<TileEntityTurbineCasing> {
    public GuiIndustrialTurbine(InventoryPlayer inventory, TileEntityTurbineCasing tile) {
        super((TileEntityContainerBlock)tile, (Container)new ContainerFilter(inventory, (TileEntityContainerBlock)tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement((GuiElement)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tileEntity, GuiTurbineTab.TurbineTab.STAT, resource));
        this.addGuiElement((GuiElement)new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)this.tileEntity, resource, 164, 16));
        this.addGuiElement((GuiElement)new GuiRateBar((IGuiWrapper)this, new GuiRateBar.IRateInfoHandler(){

            public String getTooltip() {
                return LangUtils.localize((String)"gui.steamInput") + ": " + (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure == null ? 0 : ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).lastSteamInput) + " mB/t";
            }

            public double getLevel() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure == null) {
                    return 0.0;
                }
                double rate = Math.min((double)(((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).lowerVolume * ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).clientDispersers) * MekanismConfig.current().generators.turbineDisperserGasFlow.val(), (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
                if (rate == 0.0) {
                    return 0.0;
                }
                return (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).lastSteamInput / rate;
            }
        }, resource, 40, 13));
        this.addGuiElement((GuiElement)new GuiEnergyInfo(() -> {
            double producing = ((TileEntityTurbineCasing)this.tileEntity).structure == null ? 0.0 : (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow * (MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0) * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            return Arrays.asList(LangUtils.localize((String)"gui.storing") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityTurbineCasing)this.tileEntity).getEnergy(), (double)((TileEntityTurbineCasing)this.tileEntity).getMaxEnergy()), LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)producing) + "/t");
        }, (IGuiWrapper)this, resource));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityTurbineCasing)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityTurbineCasing)this.tileEntity).func_70005_c_()) / 2, 5, 0x404040);
        if (((TileEntityTurbineCasing)this.tileEntity).structure != null) {
            double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            double rate = (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume * ((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
            rate = Math.min(rate, (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
            this.renderScaledText(LangUtils.localize((String)"gui.production") + ": " + MekanismUtils.getEnergyDisplay((double)((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow * energyMultiplier)), 53, 26, 52480, 106);
            this.renderScaledText(LangUtils.localize((String)"gui.flowRate") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow + " mB/t", 53, 35, 52480, 106);
            this.renderScaledText(LangUtils.localize((String)"gui.capacity") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).getFluidCapacity() + " mB", 53, 44, 52480, 106);
            this.renderScaledText(LangUtils.localize((String)"gui.maxFlow") + ": " + rate + " mB/t", 53, 53, 52480, 106);
            String name = LangUtils.localize((String)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).dumpMode.getLangKey());
            this.renderScaledText(name, 156 - (int)((float)this.field_146289_q.func_78256_a(name) * this.getNeededScale(name, 66)), 73, 0x404040, 66);
            int xAxis = mouseX - this.field_147003_i;
            int yAxis = mouseY - this.field_147009_r;
            if (xAxis >= 7 && xAxis <= 39 && yAxis >= 14 && yAxis <= 72) {
                this.displayTooltip(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).fluidStored != null ? LangUtils.localizeFluidStack((FluidStack)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).fluidStored) + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).fluidStored.amount + "mB" : LangUtils.localize((String)"gui.empty"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        if (((TileEntityTurbineCasing)this.tileEntity).structure != null) {
            int displayInt = (Integer)TileEntityGasTank.GasMode.chooseByMode((TileEntityGasTank.GasMode)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).dumpMode, (Object)142, (Object)150, (Object)158);
            this.func_73729_b(this.field_147003_i + 160, this.field_147009_r + 73, 176, displayInt, 8, 8);
            int scaledFluidLevel = ((TileEntityTurbineCasing)this.tileEntity).getScaledFluidLevel(58L);
            if (scaledFluidLevel > 0) {
                this.displayGauge(7, 14, scaledFluidLevel, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).fluidStored, 0);
                this.displayGauge(23, 14, scaledFluidLevel, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).fluidStored, 1);
            }
        }
    }

    protected ResourceLocation getGaugeResource() {
        return this.getGuiLocation();
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - this.field_147003_i;
        int yAxis = y - this.field_147009_r;
        if (xAxis > 160 && xAxis < 169 && yAxis > 73 && yAxis < 82) {
            TileNetworkList data = TileNetworkList.withContents((Object[])new Object[]{(byte)0});
            Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.tileEntity, data));
            SoundHandler.playSound((SoundEvent)SoundEvents.field_187909_gi);
        }
    }

    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png");
    }
}

