/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities;

import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbutilities")
@Config(modid="ftbutilities", category="")
public class FTBUtilitiesConfig {
    @Config.RequiresWorldRestart
    public static final AutoShutdown auto_shutdown = new AutoShutdown();
    public static final AFK afk = new AFK();
    public static final Chat chat = new Chat();
    @Config.RequiresWorldRestart
    @Config.LangKey(value="commands")
    public static final Commands commands = new Commands();
    public static final Login login = new Login();
    @Config.RequiresWorldRestart
    public static final RanksConfig ranks = new RanksConfig();
    public static final WorldConfig world = new WorldConfig();
    @Config.LangKey(value="ftblib.debugging")
    public static final Debugging debugging = new Debugging();

    public static void sync() {
        ConfigManager.sync((String)"ftbutilities", (Config.Type)Config.Type.INSTANCE);
        login.motdComponents = null;
        login.startingItems = null;
        afk.notificationTimer = -1L;
        world.disabledItems = null;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ftbutilities")) {
            FTBUtilitiesConfig.sync();
        }
    }

    public static class Debugging {
        @Config.Comment(value={"Print a message in console every time a chunk is forced or unforced. Recommended to be off, because spam."})
        public boolean log_chunkloading = false;
    }

    public static class WorldConfig {
        @Config.Comment(value={"Logs different events in logs/world.log file."})
        public final WorldLogging logging = new WorldLogging();
        @Config.Comment(value={"Enables chunk claiming."})
        @Config.RequiresWorldRestart
        public boolean chunk_claiming = true;
        @Config.Comment(value={"Enables chunk loading. If chunk_claiming is set to false, changing this won't do anything."})
        @Config.RequiresWorldRestart
        public boolean chunk_loading = true;
        @Config.Comment(value={"If set to true, explosions and hostile mobs in spawn area will be disabled, players won't be able to attack each other in spawn area."})
        public boolean safe_spawn = false;
        @Config.Comment(value={"Enable spawn area in singleplayer."})
        public boolean spawn_area_in_sp = false;
        @Config.Comment(value={"Dimensions where chunk claiming isn't allowed."})
        public int[] blocked_claiming_dimensions = new int[0];
        @Config.Comment(value={"If set to DEFAULT, then players can decide their PVP status."})
        @Config.LangKey(value="player_config.ftbutilities.enable_pvp")
        public EnumTristate enable_pvp = EnumTristate.TRUE;
        @Config.Comment(value={"If set to DEFAULT, then teams can decide their Explosion setting."})
        @Config.LangKey(value="team_config.ftbutilities.explosions")
        public EnumTristate enable_explosions = EnumTristate.DEFAULT;
        @Config.Comment(value={"Spawn radius. You must set spawn-protection in server.properties file to 0!"})
        public int spawn_radius = 0;
        @Config.Comment(value={"Spawn dimension. Overworld by default."})
        public int spawn_dimension = 0;
        @Config.Comment(value={"Unloads erroring chunks if dimension isn't loaded or some other problem occurs."})
        public boolean unload_erroring_chunks = false;
        @Config.Comment(value={"Min /rtp distance"})
        public double rtp_min_distance = 1000.0;
        @Config.Comment(value={"Max /rtp distance"})
        public double rtp_max_distance = 100000.0;
        @Config.Comment(value={"Max tries /rtp does before failure."})
        public int rtp_max_tries = 200;
        @Config.Comment(value={"List of items that will have right-click function disabled on both sides.", "You can use '/inv disable_right_click' command to do with from in-game.", "Syntax: modid:item:metadata. Set metadata to * to ignore it."})
        public String[] disabled_right_click_items = new String[0];
        private List<DisabledItem> disabledItems = null;
        @Config.Comment(value={"Locked time in ticks in spawn dimension.", "-1 - Disabled", "0 - Morning", "6000 - Noon", "12000 - Evening", "18000 - Midnight"})
        @Config.RangeInt(min=-1, max=23999)
        public int forced_spawn_dimension_time = -1;
        @Config.Comment(value={"Locked weather type in spawn dimension.", "-1 - Disabled", "0 - Clear", "1 - Raining", "2 - Thunderstorm"})
        @Config.RangeInt(min=-1, max=2)
        public int forced_spawn_dimension_weather = -1;
        @Config.Comment(value={"Disables player damage when they are stuck in walls."})
        public boolean disable_player_suffocation_damage = false;
        @Config.Comment(value={"Show play time in corner."})
        public boolean show_playtime = false;

        public boolean blockDimension(int dimension) {
            if (!ClaimedChunks.isActive()) {
                return true;
            }
            if (this.blocked_claiming_dimensions.length > 0) {
                for (int i : this.blocked_claiming_dimensions) {
                    if (i != dimension) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isItemRightClickDisabled(ItemStack stack) {
            if (this.disabledItems == null) {
                this.disabledItems = new ArrayList<DisabledItem>();
                for (String s : this.disabled_right_click_items) {
                    String[] s1 = s.split("@", 2);
                    Item item = Item.func_111206_d((String)s1[0]);
                    if (item == null || item == Items.field_190931_a) continue;
                    DisabledItem di = new DisabledItem();
                    di.item = item;
                    di.metadata = s1.length == 1 || s1[1].startsWith("*") ? Short.MAX_VALUE : Integer.parseInt(s1[1].trim());
                    this.disabledItems.add(di);
                }
            }
            if (this.disabledItems.isEmpty()) {
                return false;
            }
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            for (DisabledItem disabledItem : this.disabledItems) {
                if (disabledItem.item != item || disabledItem.metadata != Short.MAX_VALUE && disabledItem.metadata != meta) continue;
                return true;
            }
            return false;
        }

        private static class DisabledItem {
            private Item item;
            private int metadata;

            private DisabledItem() {
            }
        }

        public static class WorldLogging {
            @Config.Comment(value={"Enables world logging."})
            @Config.LangKey(value="addServer.resourcePack.enabled")
            public boolean enabled = false;
            @Config.Comment(value={"Includes creative players in world logging."})
            public boolean include_creative_players = false;
            @Config.Comment(value={"Includes fake players in world logging."})
            public boolean include_fake_players = false;
            @Config.Comment(value={"Logs block placement."})
            public boolean block_placed = true;
            @Config.Comment(value={"Logs block breaking."})
            public boolean block_broken = true;
            @Config.Comment(value={"Logs item clicking in air."})
            public boolean item_clicked_in_air = true;

            public boolean log(EntityPlayerMP player) {
                return !(!this.enabled || !this.include_creative_players && player.field_71075_bZ.field_75098_d || !this.include_fake_players && ServerUtils.isFake((EntityPlayerMP)player));
            }
        }
    }

    public static class RanksConfig {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enables ranks and adds command.x permissions and allows ranks to control them."})
        public boolean enabled = true;
        @Config.Comment(value={"Adds chat colors/rank-specific syntax."})
        public boolean override_chat = true;
        @Config.Comment(value={"Allow to configure commands with ranks. Disable this if you want to use other permission mod for that."})
        public boolean override_commands = true;
    }

    public static class Login {
        @Config.Comment(value={"Enables message of the day."})
        public boolean enable_motd = false;
        @Config.Comment(value={"Enables starting items."})
        public boolean enable_starting_items = false;
        @Config.Comment(value={"Set to false to disable global badges completely, only server-wide badges will be available."})
        public boolean enable_global_badges = true;
        @Config.Comment(value={"Set to false to disable event badges, e.g. Halloween."})
        public boolean enable_event_badges = true;
        @Config.Comment(value={"Message of the day. This will be displayed when player joins the server."})
        public String[] motd = new String[]{"\"Hello player!\""};
        private List<ITextComponent> motdComponents = null;
        private List<ItemStack> startingItems = null;
        @Config.Comment(value={"Items to give player when he first joins the server.", "Format: '{id:\"ID\",Count:X,Damage:X,tag:{}}', Use /print_item to get NBT of item in your hand."})
        public String[] starting_items = new String[]{"{id:\"minecraft:stone_sword\",Count:1,Damage:1,tag:{display:{Name:\"Epic Stone Sword\"}}}"};

        public List<ITextComponent> getMOTD() {
            if (this.motdComponents == null) {
                this.motdComponents = new ArrayList<ITextComponent>();
                if (this.enable_motd) {
                    for (String s : this.motd) {
                        ITextComponent t = JsonUtils.deserializeTextComponent((JsonElement)DataReader.get((String)s).safeJson());
                        if (t == null) continue;
                        this.motdComponents.add(t);
                    }
                }
            }
            return this.motdComponents;
        }

        public List<ItemStack> getStartingItems() {
            if (this.startingItems == null) {
                this.startingItems = new ArrayList<ItemStack>();
                if (this.enable_starting_items) {
                    for (String s : this.starting_items) {
                        try {
                            ItemStack stack = ItemStackSerializer.parseItem((String)s);
                            if (stack.func_190926_b()) continue;
                            this.startingItems.add(stack);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            return this.startingItems;
        }
    }

    public static class Commands {
        public boolean warp = true;
        public boolean home = true;
        public boolean back = true;
        public boolean spawn = true;
        public boolean inv = true;
        public boolean tpl = true;
        public boolean trash_can = true;
        public boolean chunks = true;
        public boolean kickme = true;
        public boolean ranks = true;
        public boolean heal = true;
        public boolean killall = true;
        public boolean nbtedit = true;
        public boolean fly = true;
        public boolean leaderboard = true;
        public boolean tpa = true;
        public boolean nick = true;
        public boolean mute = true;
        public boolean rtp = true;
        public boolean god = true;
        public boolean rec = true;
    }

    public static class Chat {
        @Config.Comment(value={"Adds ~ to player names that have changed nickname to prevent trolling."})
        public boolean add_nickname_tilde = false;
        @Config.Comment(value={"Disable this for some plugin compat. Not that they are supported but sometimes this is all that's needed."})
        public boolean replace_tab_names = true;
    }

    public static class AFK {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        @Config.Comment(value={"Enables afk timer."})
        public boolean enabled = true;
        @Config.Comment(value={"Enables afk timer in singleplayer."})
        public boolean enabled_singleplayer = false;
        @Config.Comment(value={"After how much time it will display notification to all players."})
        public String notification_timer = "5m";
        @Config.Comment(value={"Will print in console when someone goes/comes back from AFK."})
        public boolean log_afk = false;
        private long notificationTimer = -1L;

        public boolean isEnabled(MinecraftServer server) {
            return this.enabled && (this.enabled_singleplayer || !server.func_71264_H());
        }

        public long getNotificationTimer() {
            if (this.notificationTimer < 0L) {
                this.notificationTimer = Ticks.get((String)this.notification_timer).millis();
            }
            return this.notificationTimer;
        }
    }

    public static class AutoShutdown {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        @Config.Comment(value={"Enables auto-shutdown."})
        public boolean enabled = false;
        @Config.Comment(value={"Enables auto-shutdown in singleplayer worlds."})
        public boolean enabled_singleplayer = false;
        @Config.Comment(value={"Server will automatically shut down after X hours.", "Time Format: HH:MM. If the system time matches a value, server will shut down.", "It will look for closest value available that is not equal to current time."})
        public String[] times = new String[]{"04:00", "16:00"};
    }
}

