/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.registries;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.paint.properties.PaintGrid;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CustomPaintModelRegistry {
    static ArrayList<File> jsonList = new ArrayList();
    public PaintGrid wheelchair_icon = this.importedGrid("wheelchair_icon");
    public PaintGrid chevron_icon = this.importedGrid("chevron_icon");
    public PaintGrid pedestrian_low = this.importedGrid("pedestrian_low");
    public PaintGrid pedestrian_high = this.importedGrid("pedestrian_high");
    public PaintGrid merge_arrow_low = this.importedGrid("merge_arrow_low");
    public PaintGrid merge_arrow_high = this.importedGrid("merge_arrow_high");
    public PaintGrid give_way_low = this.importedGrid("give_way_low");
    public PaintGrid give_way_high = this.importedGrid("give_way_high");
    public PaintGrid junction_in_a = this.importedGrid("junction_in_a");
    public PaintGrid junction_in_b = this.importedGrid("junction_in_b");
    public PaintGrid junction_out_a = this.importedGrid("junction_out_a");
    public PaintGrid junction_out_b = this.importedGrid("junction_out_b");
    public PaintGrid junction_mid_a = this.importedGrid("junction_mid_a");
    public PaintGrid junction_mid_b = this.importedGrid("junction_mid_b");
    public PaintGrid chevron_mid_1 = this.importedGrid("chevron_mid_1");
    public PaintGrid chevron_mid_2 = this.importedGrid("chevron_mid_2");
    public PaintGrid chevron_mid_thin_1 = this.importedGrid("chevron_mid_thin_1");
    public PaintGrid chevron_mid_thin_2 = this.importedGrid("chevron_mid_thin_2");
    public PaintGrid chevron_mid_left_1 = this.importedGrid("chevron_mid_left_1");
    public PaintGrid chevron_mid_left_2 = this.importedGrid("chevron_mid_left_2");
    public PaintGrid chevron_mid_thin_left_1 = this.importedGrid("chevron_mid_thin_left_1");
    public PaintGrid chevron_mid_thin_left_2 = this.importedGrid("chevron_mid_thin_left_2");
    public PaintGrid chevron_mid_right_1 = this.importedGrid("chevron_mid_right_1");
    public PaintGrid chevron_mid_right_2 = this.importedGrid("chevron_mid_right_2");
    public PaintGrid chevron_mid_thin_right_1 = this.importedGrid("chevron_mid_thin_right_1");
    public PaintGrid chevron_mid_thin_right_2 = this.importedGrid("chevron_mid_thin_right_2");
    public PaintGrid crossing_diagonal_1 = this.importedGrid("crossing_diagonal_1");
    public PaintGrid crossing_diagonal_2 = this.importedGrid("crossing_diagonal_2");
    public PaintGrid crossing_diagonal_3 = this.importedGrid("crossing_diagonal_3");
    public PaintGrid crossing_diagonal_4 = this.importedGrid("crossing_diagonal_4");
    public PaintGrid empty = this.importedGrid("empty");
    public PaintGrid junction_mid_1 = this.importedGrid("junction_mid_1");
    public PaintGrid junction_mid_2 = this.importedGrid("junction_mid_2");
    public PaintGrid junction_mid_3 = this.importedGrid("junction_mid_3");
    public PaintGrid junction_mid_thin_1 = this.importedGrid("junction_mid_thin_1");
    public PaintGrid junction_mid_thin_2 = this.importedGrid("junction_mid_thin_2");
    public PaintGrid junction_mid_thin_3 = this.importedGrid("junction_mid_thin_3");
    public PaintGrid junction_mid_chevron_2 = this.importedGrid("junction_mid_chevron_2");
    public PaintGrid junction_mid_chevron_3 = this.importedGrid("junction_mid_chevron_3");
    public PaintGrid junction_mid_chevron_4 = this.importedGrid("junction_mid_chevron_4");
    public PaintGrid junction_mid_chevron_thin_3 = this.importedGrid("junction_mid_chevron_thin_3");
    public PaintGrid letter_a = this.importedGrid("letter_a");
    public PaintGrid letter_b = this.importedGrid("letter_b");
    public PaintGrid letter_c = this.importedGrid("letter_c");
    public PaintGrid letter_d = this.importedGrid("letter_d");
    public PaintGrid letter_e = this.importedGrid("letter_e");
    public PaintGrid letter_f = this.importedGrid("letter_f");
    public PaintGrid letter_g = this.importedGrid("letter_g");
    public PaintGrid letter_h = this.importedGrid("letter_h");
    public PaintGrid letter_i = this.importedGrid("letter_i");
    public PaintGrid letter_j = this.importedGrid("letter_j");
    public PaintGrid letter_k = this.importedGrid("letter_k");
    public PaintGrid letter_l = this.importedGrid("letter_l");
    public PaintGrid letter_m = this.importedGrid("letter_m");
    public PaintGrid letter_n = this.importedGrid("letter_n");
    public PaintGrid letter_o = this.importedGrid("letter_o");
    public PaintGrid letter_p = this.importedGrid("letter_p");
    public PaintGrid letter_q = this.importedGrid("letter_q");
    public PaintGrid letter_r = this.importedGrid("letter_r");
    public PaintGrid letter_s = this.importedGrid("letter_s");
    public PaintGrid letter_t = this.importedGrid("letter_t");
    public PaintGrid letter_u = this.importedGrid("letter_u");
    public PaintGrid letter_v = this.importedGrid("letter_v");
    public PaintGrid letter_w = this.importedGrid("letter_w");
    public PaintGrid letter_x = this.importedGrid("letter_x");
    public PaintGrid letter_y = this.importedGrid("letter_y");
    public PaintGrid letter_z = this.importedGrid("letter_z");
    public PaintGrid number_0 = this.importedGrid("number_0");
    public PaintGrid number_1 = this.importedGrid("number_1");
    public PaintGrid number_2 = this.importedGrid("number_2");
    public PaintGrid number_3 = this.importedGrid("number_3");
    public PaintGrid number_4 = this.importedGrid("number_4");
    public PaintGrid number_5 = this.importedGrid("number_5");
    public PaintGrid number_6 = this.importedGrid("number_6");
    public PaintGrid number_7 = this.importedGrid("number_7");
    public PaintGrid number_8 = this.importedGrid("number_8");
    public PaintGrid number_9 = this.importedGrid("number_9");
    public PaintGrid punct_question = this.importedGrid("punct_question");
    public PaintGrid punct_exclamation = this.importedGrid("punct_exclaim");
    public PaintGrid punct_hash = this.importedGrid("punct_hash");
    public PaintGrid punct_slash = this.importedGrid("punct_slash");
    public PaintGrid text_slow_small = this.importedGrid("text_slow_small");
    public PaintGrid text_stop_small = this.importedGrid("text_stop_small");
    public PaintGrid text_bike_small = this.importedGrid("text_bike_small");
    public PaintGrid text_bus_small = this.importedGrid("text_bus_small");
    public PaintGrid text_taxi_small = this.importedGrid("text_taxi_small");
    public PaintGrid text_lane_small = this.importedGrid("text_lane_small");
    public PaintGrid text_keep_small = this.importedGrid("text_keep_small");
    public PaintGrid text_clear_small = this.importedGrid("text_clear_small");
    public PaintGrid text_turn_small = this.importedGrid("text_turn_small");
    public PaintGrid text_left_small = this.importedGrid("text_left_small");
    public PaintGrid text_right_small = this.importedGrid("text_right_small");
    public PaintGrid text_only_small = this.importedGrid("text_only_small");
    public PaintGrid text_no_small = this.importedGrid("text_no_small");
    public PaintGrid text_entry_small = this.importedGrid("text_entry_small");
    public PaintGrid text_bike_icon_small = this.importedGrid("text_bike_icon_small");
    public PaintGrid text_town_small = this.importedGrid("text_town_small");
    public PaintGrid text_city_small = this.importedGrid("text_city_small");
    public PaintGrid text_ctre_small = this.importedGrid("text_ctre_small");
    public PaintGrid text_slow_l = this.importedGrid("text_slow_l");
    public PaintGrid text_stop_l = this.importedGrid("text_stop_l");
    public PaintGrid text_bike_l = this.importedGrid("text_bike_l");
    public PaintGrid text_bus_l = this.importedGrid("text_bus_l");
    public PaintGrid text_taxi_l = this.importedGrid("text_taxi_l");
    public PaintGrid text_lane_l = this.importedGrid("text_lane_l");
    public PaintGrid text_keep_l = this.importedGrid("text_keep_l");
    public PaintGrid text_clear_l = this.importedGrid("text_clear_l");
    public PaintGrid text_turn_l = this.importedGrid("text_turn_l");
    public PaintGrid text_left_l = this.importedGrid("text_left_l");
    public PaintGrid text_right_l = this.importedGrid("text_right_l");
    public PaintGrid text_only_l = this.importedGrid("text_only_l");
    public PaintGrid text_no_l = this.importedGrid("text_no_l");
    public PaintGrid text_entry_l = this.importedGrid("text_entry_l");
    public PaintGrid text_bike_icon_l = this.importedGrid("text_bike_icon_l");
    public PaintGrid text_town_l = this.importedGrid("text_town_l");
    public PaintGrid text_city_l = this.importedGrid("text_city_l");
    public PaintGrid text_ctre_l = this.importedGrid("text_ctre_l");
    public PaintGrid text_slow_m = this.importedGrid("text_slow_m");
    public PaintGrid text_stop_m = this.importedGrid("text_stop_m");
    public PaintGrid text_bike_m = this.importedGrid("text_bike_m");
    public PaintGrid text_bus_m = this.importedGrid("text_bus_m");
    public PaintGrid text_taxi_m = this.importedGrid("text_taxi_m");
    public PaintGrid text_lane_m = this.importedGrid("text_lane_m");
    public PaintGrid text_keep_m = this.importedGrid("text_keep_m");
    public PaintGrid text_clear_m = this.importedGrid("text_clear_m");
    public PaintGrid text_turn_m = this.importedGrid("text_turn_m");
    public PaintGrid text_left_m = this.importedGrid("text_left_m");
    public PaintGrid text_right_m = this.importedGrid("text_right_m");
    public PaintGrid text_only_m = this.importedGrid("text_only_m");
    public PaintGrid text_no_m = this.importedGrid("text_no_m");
    public PaintGrid text_entry_m = this.importedGrid("text_entry_m");
    public PaintGrid text_bike_icon_m = this.importedGrid("text_bike_icon_m");
    public PaintGrid text_town_m = this.importedGrid("text_town_m");
    public PaintGrid text_city_m = this.importedGrid("text_city_m");
    public PaintGrid text_ctre_m = this.importedGrid("text_ctre_m");
    public PaintGrid text_slow_r = this.importedGrid("text_slow_r");
    public PaintGrid text_stop_r = this.importedGrid("text_stop_r");
    public PaintGrid text_bike_r = this.importedGrid("text_bike_r");
    public PaintGrid text_bus_r = this.importedGrid("text_bus_r");
    public PaintGrid text_taxi_r = this.importedGrid("text_taxi_r");
    public PaintGrid text_lane_r = this.importedGrid("text_lane_r");
    public PaintGrid text_keep_r = this.importedGrid("text_keep_r");
    public PaintGrid text_clear_r = this.importedGrid("text_clear_r");
    public PaintGrid text_turn_r = this.importedGrid("text_turn_r");
    public PaintGrid text_left_r = this.importedGrid("text_left_r");
    public PaintGrid text_right_r = this.importedGrid("text_right_r");
    public PaintGrid text_only_r = this.importedGrid("text_only_r");
    public PaintGrid text_no_r = this.importedGrid("text_no_r");
    public PaintGrid text_entry_r = this.importedGrid("text_entry_r");
    public PaintGrid text_bike_icon_r = this.importedGrid("text_bike_icon_r");
    public PaintGrid text_town_r = this.importedGrid("text_town_r");
    public PaintGrid text_city_r = this.importedGrid("text_city_r");
    public PaintGrid text_ctre_r = this.importedGrid("text_ctre_r");
    public PaintGrid junction_side_line_connection_a = this.importedGrid("junction_side_line_connection_a");
    public PaintGrid junction_side_line_connection_b = this.importedGrid("junction_side_line_connection_b");
    public PaintGrid junction_side_line_connection_c = this.importedGrid("junction_side_line_connection_c");
    public PaintGrid junction_side_line_connection_d = this.importedGrid("junction_side_line_connection_d");
    public PaintGrid junction_side_line_connection_thin_a = this.importedGrid("junction_side_line_connection_thin_a");
    public PaintGrid junction_side_line_connection_thin_b = this.importedGrid("junction_side_line_connection_thin_b");
    public PaintGrid junction_side_line_connection_thin_c = this.importedGrid("junction_side_line_connection_thin_c");
    public PaintGrid junction_side_line_connection_thin_d = this.importedGrid("junction_side_line_connection_thin_d");
    public PaintGrid junction_side_line_connection_thick_thick_a = this.importedGrid("junction_side_line_connection_thick_thick_a");
    public PaintGrid junction_side_line_connection_thick_thick_b = this.importedGrid("junction_side_line_connection_thick_thick_b");
    public PaintGrid junction_side_line_connection_thick_thick_c = this.importedGrid("junction_side_line_connection_thick_thick_c");
    public PaintGrid junction_side_line_connection_thick_thick_d = this.importedGrid("junction_side_line_connection_thick_thick_d");
    public PaintGrid junction_mid_line_connection_a = this.importedGrid("junction_mid_line_connection_a");
    public PaintGrid junction_mid_line_connection_b = this.importedGrid("junction_mid_line_connection_b");
    public PaintGrid junction_mid_line_connection_c = this.importedGrid("junction_mid_line_connection_c");
    public PaintGrid junction_mid_line_connection_d = this.importedGrid("junction_mid_line_connection_d");
    private static boolean compiledSystem = false;

    public static void register(FMLPreInitializationEvent event) {
        FurenikusRoads.debug(0, "Starting to load internal paint files");
        jsonList = CustomPaintModelRegistry.getJsonFiles(event.getModMetadata().getClass().getResource("/assets/furenikusroads/paints").getFile(), jsonList);
        if (jsonList.size() > 0) {
            FurenikusRoads.debug(0, "Found " + jsonList.size() + " internal paint files. Loading...");
        } else {
            FurenikusRoads.debug(0, "No internal paint files found; this is a major bug! There will be missing assets in-game.");
        }
    }

    private static ArrayList<File> getJsonFiles(String dir, ArrayList<File> jsonList) {
        File directory = new File(dir);
        File[] files = directory.listFiles();
        if (files == null) {
            FurenikusRoads.debug(0, "Running in production environment; switching to jarfile extraction for internal paint JSONs");
            return CustomPaintModelRegistry.getCompiledJsonFiles(jsonList);
        }
        if (files.length > 0) {
            for (File file : files) {
                if (file == null) continue;
                if (file.isFile()) {
                    jsonList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                CustomPaintModelRegistry.getJsonFiles(file.getAbsolutePath(), jsonList);
            }
        }
        return jsonList;
    }

    private static ArrayList<File> getCompiledJsonFiles(ArrayList<File> foundFiles) {
        compiledSystem = true;
        try {
            URL jarUrl = FurenikusRoads.class.getProtectionDomain().getCodeSource().getLocation();
            JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
            JarFile jar = jarConnection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            int entryCount = 0;
            while (entries.hasMoreElements()) {
                File file;
                ++entryCount;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith("assets/furenikusroads/paints") || !(file = new File(entry.getName())).getName().endsWith(".json")) continue;
                foundFiles.add(file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return foundFiles;
    }

    private File getFileForPaint(String name) {
        for (int i = 0; i < jsonList.size(); ++i) {
            if (!jsonList.get(i).getName().endsWith(name + ".json")) continue;
            return jsonList.get(i);
        }
        return null;
    }

    private PaintGrid importedGrid(String name) {
        File file = this.getFileForPaint(name);
        if (file != null) {
            JsonParser parser = new JsonParser();
            try {
                JsonArray grid;
                JsonObject json = null;
                json = compiledSystem ? (JsonObject)parser.parse(CustomPaintModelRegistry.readFileInJar(file.getName())) : (JsonObject)parser.parse((Reader)new FileReader(file));
                JsonArray jsonArray = grid = json.has("grid") ? json.get("grid").getAsJsonArray() : null;
                if (grid != null) {
                    if (grid.size() != 16 && grid.size() != 32 && grid.size() != 64) {
                        JsonArray gridRow = grid.get(0).getAsJsonArray();
                        FurenikusRoads.debug(0, "#INTERNAL# Paint JSON file " + name + " has malformed Y axis grid. Make sure there are exactly 16, 32 or 64 entries; it has " + grid.size() + " with X: " + gridRow.size());
                        return null;
                    }
                    boolean[][] gridArray = new boolean[grid.size()][grid.size()];
                    for (int i = 0; i < grid.size(); ++i) {
                        JsonArray gridRow = grid.get(i).getAsJsonArray();
                        if (gridRow.size() != grid.size()) {
                            FurenikusRoads.debug(0, "#INTERNAL# Paint JSON file " + name + " has malformed X axis grid. Make sure there are exactly " + grid.size() + " entries; it has " + gridRow.size());
                            return null;
                        }
                        for (int j = 0; j < gridRow.size(); ++j) {
                            char c = gridRow.get(j).getAsCharacter();
                            gridArray[j][i] = c != ' ' && c != '0';
                        }
                    }
                    return new PaintGrid(gridArray);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            FurenikusRoads.debug(0, "Internal paint file for " + name + " was null! This will crash when placing!!");
        }
        return null;
    }

    private static String readFileInJar(String fileName) throws IOException {
        StringBuilder sb = new StringBuilder();
        fileName = "assets/furenikusroads/paints/" + fileName;
        URL jarUrl = FurenikusRoads.class.getProtectionDomain().getCodeSource().getLocation();
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        JarFile jar = jarConnection.getJarFile();
        JarEntry entry = jar.getJarEntry(fileName);
        if (entry != null) {
            String line;
            InputStream inputStream = jar.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            inputStream.close();
        }
        jar.close();
        return sb.toString();
    }
}

