/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.diagonal;

import com.silvaniastudios.roads.blocks.diagonal.HalfBlock;
import com.silvaniastudios.roads.blocks.diagonal.RoadBlockDiagonal;
import com.silvaniastudios.roads.blocks.diagonal.ShapeLibrary;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;

public class DiagonalBakedModelBase
implements IBakedModel {
    protected VertexFormat format;
    Minecraft mc;

    public DiagonalBakedModelBase(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.format = format;
        this.mc = Minecraft.func_71410_x();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        EnumFacing facing = (EnumFacing)extendedState.func_177229_b(RoadBlockDiagonal.FACING);
        HalfBlock blockLeft = new HalfBlock(extendedState, HalfBlock.HalfBlockSide.LEFT);
        HalfBlock blockRight = new HalfBlock(extendedState, HalfBlock.HalfBlockSide.RIGHT);
        blockLeft.setPartnerBlock(blockRight);
        blockRight.setPartnerBlock(blockLeft);
        return this.packQuads(facing, blockLeft, blockRight);
    }

    protected List<BakedQuad> packQuads(EnumFacing facing, HalfBlock blockLeft, HalfBlock blockRight) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        return quads;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:blocks/road_block_standard");
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    protected List<BakedQuad> createTriangle(List<BakedQuad> quads, boolean left, HalfBlock block, double width) {
        List<Object> rawQuads = new ArrayList();
        rawQuads = left ? ShapeLibrary.shapeTriangleLeft(block, width, this.format) : ShapeLibrary.shapeTriangleRight(block, width, this.format);
        return this.shapeBuilder(rawQuads, quads, block);
    }

    protected List<BakedQuad> createTrapezium(List<BakedQuad> quads, boolean left, HalfBlock block, double widthN, double widthW) {
        List<Object> rawQuads = new ArrayList();
        rawQuads = left ? ShapeLibrary.shapeTrapeziumLeft(block, widthN, widthW, this.format) : ShapeLibrary.shapeTrapeziumRight(block, widthN, widthW, this.format);
        return this.shapeBuilder(rawQuads, quads, block);
    }

    protected List<BakedQuad> shapeBuilder(List<Quad> rawQuads, List<BakedQuad> quads, HalfBlock block) {
        int i;
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            rawQuads.set(i, Quad.rotateQuadY(rawQuads.get(i), block.getRotation()));
        }
        if (rawQuads.get(0) != null) {
            rawQuads.get(0).updateUVs();
        }
        if (rawQuads.get(1) != null) {
            rawQuads.get(1).setFlipV(true);
            rawQuads.get(1).updateUVs();
        }
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            BakedQuad baked = rawQuads.get(i).createQuad(block.getColour());
            if (i == 1 && block.isFluid()) {
                baked = rawQuads.get(i).createUnnormalizedQuad(block.getColour());
            }
            quads.add(baked);
        }
        return quads;
    }
}

