/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterContainer;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiTarmacCutter
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("furenikusroads:textures/gui/tarmac_cutter.png");
    private TarmacCutterEntity tileEntity;
    private boolean electric;

    public GuiTarmacCutter(TarmacCutterEntity tileEntity, TarmacCutterContainer container, boolean electric) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 146;
        this.tileEntity = tileEntity;
        this.electric = electric;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawTooltip(2, left, top, mouseX, mouseY);
        if (this.electric) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.electric_tarmac_cutter.name", (Object[])new Object[0]), 6, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.tarmac_cutter.name", (Object[])new Object[0]), 6, 6, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.electric) {
            this.func_73729_b(left + this.field_146999_f - 25, top, 176, 0, 25, this.field_147000_g);
        }
        this.drawFuel(left, top);
        this.drawProgress(left, top);
    }

    private void drawTooltip(int col, int left, int top, int mouseX, int mouseY) {
        if (this.electric) {
            TarmacCutterElectricEntity tcee = (TarmacCutterElectricEntity)this.tileEntity;
            if (mouseX >= left + 155 && mouseX <= left + 169 && mouseY >= top + 7 && mouseY <= top + 49) {
                this.func_146279_a(tcee.energy.getEnergyStored() + "/" + tcee.energy.getMaxEnergyStored(), mouseX - left, mouseY - top + 15);
            }
        } else if (mouseX >= left + 153 && mouseX <= left + 167 && mouseY >= top + 15 && mouseY <= top + 29) {
            this.func_146279_a(this.tileEntity.fuel_remaining + "/" + this.tileEntity.last_fuel_cap, mouseX - left, mouseY - top + 15);
        }
        if (RoadsConfig.general.guiGuide) {
            String a = TextFormatting.RESET + " -> " + TextFormatting.GREEN;
            List<String> inputList = Arrays.asList(I18n.func_135052_a((String)"roads.gui.inputSlot", (Object[])new Object[0]), "", TextFormatting.UNDERLINE + I18n.func_135052_a((String)"roads.gui.valid", (Object[])new Object[0]), TextFormatting.AQUA + I18n.func_135052_a((String)"roads.gui.road_generic_name", (Object[])new Object[0]) + a + I18n.func_135052_a((String)"roads.gui.road_generic_name_cut", (Object[])new Object[0]) + ", " + I18n.func_135052_a((String)"roads.gui.fragment_generic_name", (Object[])new Object[0]));
            if (mouseX >= left + 8 && mouseX <= left + 24 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(0).func_190916_E() == 0) {
                this.func_146283_a(inputList, mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 53 && mouseX <= left + 69 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(1).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.tarmac_cutter.bladeSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 98 && mouseX <= left + 132 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(2).func_190916_E() == 0 && this.tileEntity.inventory.getStackInSlot(3).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.outputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 152 && mouseX <= left + 168 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(4).func_190916_E() == 0 && !this.electric) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fuelSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
        }
    }

    private void drawFuel(int left, int top) {
        if (this.electric) {
            TarmacCutterElectricEntity tcee = (TarmacCutterElectricEntity)this.tileEntity;
            int p = this.getPercentage(tcee.energy.getEnergyStored(), tcee.energy.getMaxEnergyStored());
            int x = Math.round((float)p / 2.5f);
            if (p == 100) {
                x = 42;
            }
            this.func_73729_b(left + 155, top + 7 + (42 - x), 242, 42 - x, 14, x);
        } else {
            int p = this.getPercentage(this.tileEntity.fuel_remaining, this.tileEntity.last_fuel_cap);
            int x = Math.round((float)p / 7.0f);
            this.func_73729_b(left + 153, top + 15 + (14 - x), 229, 14 - x, 13, x);
        }
    }

    private void drawProgress(int left, int top) {
        int p = this.getPercentage(this.tileEntity.timerCount, RoadsConfig.machine.tarmacCutterTickRate);
        int x = Math.round((float)p * 1.6f);
        this.func_73729_b(left + 8, top + 54, 0, 252, x, 4);
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        return y;
    }
}

