/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.blocks.paint.PaintBlockCustomRenderBase;
import com.silvaniastudios.roads.registries.PaintCategoryList;
import com.silvaniastudios.roads.registries.PaintGunItemRegistry;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TextureRegistryHandler {
    public static final TextureRegistryHandler instance = new TextureRegistryHandler();

    private TextureRegistryHandler() {
    }

    @SubscribeEvent
    public void stitcherEventPre(TextureStitchEvent.Pre event) {
        ResourceLocation white_paint = new ResourceLocation("furenikusroads:items/paint_white");
        ResourceLocation yellow_paint = new ResourceLocation("furenikusroads:items/paint_yellow");
        ResourceLocation red_paint = new ResourceLocation("furenikusroads:items/paint_red");
        ResourceLocation block_white_paint = new ResourceLocation("furenikusroads:blocks/paint_white");
        ResourceLocation block_yellow_paint = new ResourceLocation("furenikusroads:blocks/paint_yellow");
        ResourceLocation block_red_paint = new ResourceLocation("furenikusroads:blocks/paint_red");
        ResourceLocation tar_flowing = new ResourceLocation("furenikusroads:fluids/tar_flowing");
        ResourceLocation tar_still = new ResourceLocation("furenikusroads:fluids/tar_still");
        ResourceLocation white_paint_flowing = new ResourceLocation("furenikusroads:fluids/white_paint_flowing");
        ResourceLocation white_paint_still = new ResourceLocation("furenikusroads:fluids/white_paint_still");
        ResourceLocation yellow_paint_flowing = new ResourceLocation("furenikusroads:fluids/yellow_paint_flowing");
        ResourceLocation yellow_paint_still = new ResourceLocation("furenikusroads:fluids/yellow_paint_still");
        ResourceLocation red_paint_flowing = new ResourceLocation("furenikusroads:fluids/red_paint_flowing");
        ResourceLocation red_paint_still = new ResourceLocation("furenikusroads:fluids/red_paint_still");
        ResourceLocation cats_eye_white = new ResourceLocation("furenikusroads:blocks/cats_eye_white");
        ResourceLocation cats_eye_yellow = new ResourceLocation("furenikusroads:blocks/cats_eye_yellow");
        ResourceLocation cats_eye_red = new ResourceLocation("furenikusroads:blocks/cats_eye_red");
        ResourceLocation cats_eye_green = new ResourceLocation("furenikusroads:blocks/cats_eye_green");
        ResourceLocation cats_eye_blue = new ResourceLocation("furenikusroads:blocks/cats_eye_blue");
        ResourceLocation machine_vent_on = new ResourceLocation("furenikusroads:blocks/machine_vent_back_on");
        ResourceLocation paint_filler_display = new ResourceLocation("furenikusroads:blocks/paint_filler_machine_display");
        ResourceLocation sprite_white_paint = new ResourceLocation("furenikusroads:fluids/white_paint_flowing");
        ResourceLocation sprite_yellow_paint = new ResourceLocation("furenikusroads:fluids/yellow_paint_flowing");
        ResourceLocation sprite_red_paint = new ResourceLocation("furenikusroads:fluids/red_paint_flowing");
        ResourceLocation sprite_glass = new ResourceLocation("furenikusroads:blocks/hopper_tank");
        ResourceLocation sprite_glass_top = new ResourceLocation("furenikusroads:blocks/hopper_tank_top");
        ResourceLocation sprite_light_white = new ResourceLocation("furenikusroads:blocks/hopper_type_white");
        ResourceLocation sprite_light_yellow = new ResourceLocation("furenikusroads:blocks/hopper_type_yellow");
        ResourceLocation sprite_light_red = new ResourceLocation("furenikusroads:blocks/hopper_type_red");
        ResourceLocation sprite_light_item = new ResourceLocation("furenikusroads:blocks/hopper_type_item");
        ResourceLocation sprite_light_none = new ResourceLocation("furenikusroads:blocks/hopper_type_none");
        ResourceLocation junction_filter_left = new ResourceLocation("furenikusroads:paints/junction_filter_left_0");
        ResourceLocation junction_filter_left_empty = new ResourceLocation("furenikusroads:paints/junction_filter_left_empty_0");
        ResourceLocation junction_filter_left_thin = new ResourceLocation("furenikusroads:paints/junction_filter_left_thin_0");
        ResourceLocation junction_filter_right = new ResourceLocation("furenikusroads:paints/junction_filter_right_0");
        ResourceLocation junction_filter_right_empty = new ResourceLocation("furenikusroads:paints/junction_filter_right_empty_0");
        ResourceLocation junction_filter_right_thin = new ResourceLocation("furenikusroads:paints/junction_filter_right_thin_0");
        ResourceLocation chevron_left_a = new ResourceLocation("furenikusroads:paints/chevron_left_a_0");
        ResourceLocation chevron_left_a_thin = new ResourceLocation("furenikusroads:paints/chevron_left_a_thin_0");
        ResourceLocation chevron_right_a = new ResourceLocation("furenikusroads:paints/chevron_right_a_0");
        ResourceLocation chevron_right_a_thin = new ResourceLocation("furenikusroads:paints/chevron_right_a_thin_0");
        ResourceLocation chevron_side_line = new ResourceLocation("furenikusroads:paints/chevron_side_line_0");
        ResourceLocation hatch_box = new ResourceLocation("furenikusroads:paints/hatch_box_0");
        ResourceLocation crossing_paint = new ResourceLocation("furenikusroads:paints/crossing_paint_0");
        ResourceLocation arrow_0 = new ResourceLocation("furenikusroads:paints/arrow_0");
        ResourceLocation arrow_4 = new ResourceLocation("furenikusroads:paints/arrow_4");
        ResourceLocation arrow_line = new ResourceLocation("furenikusroads:paints/arrow_line_0");
        ResourceLocation arrow_diagonal_0 = new ResourceLocation("furenikusroads:paints/arrow_diagonal_0");
        ResourceLocation arrow_diagonal_4 = new ResourceLocation("furenikusroads:paints/arrow_diagonal_4");
        event.getMap().func_174942_a(white_paint);
        event.getMap().func_174942_a(yellow_paint);
        event.getMap().func_174942_a(red_paint);
        event.getMap().func_174942_a(block_white_paint);
        event.getMap().func_174942_a(block_yellow_paint);
        event.getMap().func_174942_a(block_red_paint);
        event.getMap().func_174942_a(tar_flowing);
        event.getMap().func_174942_a(tar_still);
        event.getMap().func_174942_a(white_paint_flowing);
        event.getMap().func_174942_a(white_paint_still);
        event.getMap().func_174942_a(yellow_paint_flowing);
        event.getMap().func_174942_a(yellow_paint_still);
        event.getMap().func_174942_a(red_paint_flowing);
        event.getMap().func_174942_a(red_paint_still);
        event.getMap().func_174942_a(cats_eye_white);
        event.getMap().func_174942_a(cats_eye_yellow);
        event.getMap().func_174942_a(cats_eye_red);
        event.getMap().func_174942_a(cats_eye_green);
        event.getMap().func_174942_a(cats_eye_blue);
        event.getMap().func_174942_a(machine_vent_on);
        event.getMap().func_174942_a(paint_filler_display);
        event.getMap().func_174942_a(sprite_white_paint);
        event.getMap().func_174942_a(sprite_yellow_paint);
        event.getMap().func_174942_a(sprite_red_paint);
        event.getMap().func_174942_a(sprite_glass);
        event.getMap().func_174942_a(sprite_glass_top);
        event.getMap().func_174942_a(sprite_light_white);
        event.getMap().func_174942_a(sprite_light_yellow);
        event.getMap().func_174942_a(sprite_light_red);
        event.getMap().func_174942_a(sprite_light_item);
        event.getMap().func_174942_a(sprite_light_none);
        event.getMap().func_174942_a(junction_filter_left);
        event.getMap().func_174942_a(junction_filter_left_empty);
        event.getMap().func_174942_a(junction_filter_left_thin);
        event.getMap().func_174942_a(junction_filter_right);
        event.getMap().func_174942_a(junction_filter_right_empty);
        event.getMap().func_174942_a(junction_filter_right_thin);
        event.getMap().func_174942_a(chevron_left_a);
        event.getMap().func_174942_a(chevron_left_a_thin);
        event.getMap().func_174942_a(chevron_right_a);
        event.getMap().func_174942_a(chevron_right_a_thin);
        event.getMap().func_174942_a(chevron_side_line);
        event.getMap().func_174942_a(hatch_box);
        event.getMap().func_174942_a(crossing_paint);
        event.getMap().func_174942_a(arrow_0);
        event.getMap().func_174942_a(arrow_4);
        event.getMap().func_174942_a(arrow_line);
        event.getMap().func_174942_a(arrow_diagonal_0);
        event.getMap().func_174942_a(arrow_diagonal_4);
        for (int i = 0; i < PaintGunItemRegistry.categoryList.size(); ++i) {
            PaintCategoryList category = PaintGunItemRegistry.categoryList.get(i);
            for (int j = 0; j < category.size(); ++j) {
                PaintBlockBase block = category.getPaint(j);
                String name = block.func_149739_a().substring(20);
                if (category.getMeta(j) > 0) {
                    name = name + "_" + category.getMeta(j);
                }
                ResourceLocation sprite = new ResourceLocation("furenikusroads:items/paint_gun_display/" + name);
                event.getMap().func_174942_a(sprite);
            }
        }
    }

    @SubscribeEvent
    public void paintTextures(TextureStitchEvent.Pre event) {
        int i;
        ArrayList<PaintBlockBase> paints = FRBlocks.paintBlockList;
        ArrayList<String> registry = new ArrayList<String>();
        for (i = 0; i < paints.size(); ++i) {
            PaintBlockCustomRenderBase paint;
            if (!(paints.get(i) instanceof PaintBlockCustomRenderBase) || !(paint = (PaintBlockCustomRenderBase)paints.get(i)).func_149739_a().contains("white")) continue;
            for (int j = 0; j < paint.getCoreMetas().length; ++j) {
                registry.add(TextureRegistryHandler.getTextureNameFromUnloc(paint.func_149739_a()) + "_" + paint.getCoreMetas()[j]);
            }
        }
        for (i = 0; i < registry.size(); ++i) {
            ResourceLocation rl = new ResourceLocation("furenikusroads:paints/" + (String)registry.get(i));
            event.getMap().func_174942_a(rl);
        }
    }

    public static void generateJSONFromTextures() {
        FurenikusRoads.debug(0, "Generating JSONs from textures!");
        ArrayList<File> imageList = new ArrayList<File>();
        String directory = "./conversions/";
        imageList = TextureRegistryHandler.getImagesToConvert(directory, imageList);
        FurenikusRoads.debug(0, "Found " + imageList.size() + " textures to process.");
        for (int i = 0; i < imageList.size(); ++i) {
            TextureRegistryHandler.generatePixelArray(directory, TextureRegistryHandler.getImage(imageList.get(i)), imageList.get(i).getName());
        }
        FurenikusRoads.debug(0, "Generation complete.");
    }

    private static ArrayList<File> getImagesToConvert(String dir, ArrayList<File> imageList) {
        File[] files;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (File file : files = directory.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".png")) {
                imageList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            TextureRegistryHandler.getImagesToConvert(file.getAbsolutePath(), imageList);
        }
        return imageList;
    }

    private static BufferedImage getImage(File file) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return img;
    }

    public static int[][] generatePixelArray(String dir, BufferedImage image, String name) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] pixelArray = new int[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = image.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                pixelArray[y][x] = alpha <= 63 ? 0 : 1;
            }
        }
        FurenikusRoads.debug(0, "Generating text file for image size " + width + ", " + height);
        try {
            int rowCount = 0;
            int colCount = 0;
            FileWriter writer = new FileWriter(dir + name.replace(".png", ".json"));
            writer.write("{\n");
            writer.write("  \"grid\":[\n");
            for (int[] row : pixelArray) {
                writer.write("    [");
                ++rowCount;
                for (int pixel : row) {
                    if (++colCount < row.length) {
                        writer.write(pixel + ",");
                        continue;
                    }
                    writer.write("" + pixel);
                }
                colCount = 0;
                if (rowCount < pixelArray.length) {
                    writer.write("],\n");
                    continue;
                }
                writer.write("]\n");
            }
            writer.write("  ]\n");
            writer.write("}");
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Error writing pixel array to file: " + e.getMessage());
        }
        return pixelArray;
    }

    public static String getTextureNameFromUnloc(String unlocalizedName) {
        return unlocalizedName.replace("white_", "").replace("tile.furenikusroads.", "");
    }
}

