/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintoven;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.FREnergyStorage;
import com.silvaniastudios.roads.blocks.tileentities.paintoven.PaintOvenEntity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class PaintOvenElectricEntity
extends PaintOvenEntity
implements ITickable,
ICapabilityProvider {
    public boolean isProcessing = false;
    int consumedEnergy = 0;
    public FREnergyStorage energy;

    public PaintOvenElectricEntity() {
        this.energy = new FREnergyStorage(RoadsConfig.machine.electricPaintOvenEnergyStorage, RoadsConfig.machine.electricPaintOvenEnergyTransferRate){};
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_73660_a() {
        if (this.energy.getEnergyStored() > RoadsConfig.machine.electricPaintOvenEnergyConsumption) {
            int ept = RoadsConfig.machine.electricPaintOvenEnergyConsumption / RoadsConfig.machine.electricPaintOvenTickRate;
            if (this.timerCount < RoadsConfig.machine.electricPaintOvenTickRate) {
                if (this.shouldTick()) {
                    this.isProcessing = true;
                    ++this.timerCount;
                    this.energy.extractEnergy(ept, false);
                    this.consumedEnergy += ept;
                } else {
                    this.isProcessing = false;
                    this.timerCount = 0;
                }
            } else {
                if (this.consumedEnergy < RoadsConfig.machine.electricPaintOvenEnergyConsumption) {
                    this.energy.extractEnergy(RoadsConfig.machine.electricPaintOvenEnergyConsumption - this.consumedEnergy, false);
                }
                this.process();
                this.timerCount = 0;
            }
        }
        if (!(this.field_145850_b.field_72995_K || this.lastPaint == this.paint.getFluidAmount() && this.lastWater == this.water.getFluidAmount())) {
            this.lastPaint = this.paint.getFluidAmount();
            this.lastWater = this.water.getFluidAmount();
            this.sendUpdates();
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energy")) {
            this.energy.deserializeNBT((NBTTagCompound)nbt.func_74781_a("energy"));
        }
        super.readNBT(nbt);
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("energy", (NBTBase)this.energy.serializeNBT());
        return super.writeNBT(nbt);
    }
}

