/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.IngameListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GroupEntry
extends ListScreenEntryBase {
    protected static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    protected static final ResourceLocation SPEAKER_OFF = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = VoiceChatScreenBase.color(255, 74, 74, 74);
    protected static final int PLAYER_NAME_COLOR = VoiceChatScreenBase.color(255, 255, 255, 255);
    protected final IngameListScreenBase parent;
    protected final Minecraft minecraft;
    protected PlayerState state;
    protected final AdjustVolumeSlider volumeSlider;

    public GroupEntry(IngameListScreenBase parent, PlayerState state) {
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.state = state;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 0, 100, 20, new PlayerVolumeEntry.PlayerVolumeConfigEntry(state.getUuid()));
        this.children.add(this.volumeSlider);
    }

    @Override
    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        ClientVoicechat client;
        super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        GuiScreen.func_73734_a((int)x, (int)y, (int)(x + listWidth), (int)(y + slotHeight), (int)BG_FILL);
        GlStateManager.func_179094_E();
        int outlineSize = slotHeight - 8;
        GlStateManager.func_179137_b((double)(x + 4), (double)(y + 4), (double)0.0);
        float scale = (float)outlineSize / 10.0f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.state.isDisabled() && (client = ClientManager.getClient()) != null && client.getTalkCache().isTalking(this.state.getUuid())) {
            this.minecraft.func_110434_K().func_110577_a(TALK_OUTLINE);
            GuiScreen.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)10, (int)10, (float)16.0f, (float)16.0f);
        }
        this.minecraft.func_110434_K().func_110577_a(GameProfileUtils.getSkin(this.state.getUuid()));
        Gui.func_152125_a((int)1, (int)1, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
        GlStateManager.func_179147_l();
        Gui.func_152125_a((int)1, (int)1, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
        GlStateManager.func_179084_k();
        if (this.state.isDisabled()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)1.0, (double)1.0, (double)0.0);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(SPEAKER_OFF);
            GuiScreen.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        this.minecraft.field_71466_p.func_78276_b(this.state.getName(), x + 4 + outlineSize + 4, y + slotHeight / 2 - this.minecraft.field_71466_p.field_78288_b / 2, PLAYER_NAME_COLOR);
        if (isSelected && !ClientManager.getPlayerStateManager().getOwnID().equals(this.state.getUuid())) {
            this.volumeSlider.func_175211_a(Math.min(listWidth - (4 + outlineSize + 4 + this.minecraft.field_71466_p.func_78256_a(this.state.getName()) + 4 + 4), 100));
            this.volumeSlider.field_146128_h = x + (listWidth - this.volumeSlider.field_146120_f - 4);
            this.volumeSlider.field_146129_i = y + (slotHeight - this.volumeSlider.field_146121_g) / 2;
            this.volumeSlider.func_191745_a(this.minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }
}

