/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartChange_Transfer
extends APacketEntity<APart> {
    private final UUID entityUUID;
    private final int slotIndex;

    public PacketPartChange_Transfer(APart partToTransfer, AEntityF_Multipart<?> entityToTransferTo, JSONPartDefinition partDef) {
        super(partToTransfer);
        this.entityUUID = entityToTransferTo.uniqueUUID;
        this.slotIndex = ((AJSONPartProvider)entityToTransferTo.definition).parts.indexOf(partDef);
    }

    public PacketPartChange_Transfer(ByteBuf buf) {
        super(buf);
        this.entityUUID = PacketPartChange_Transfer.readUUIDFromBuffer(buf);
        this.slotIndex = buf.readByte();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPartChange_Transfer.writeUUIDToBuffer(this.entityUUID, buf);
        buf.writeByte(this.slotIndex);
    }

    @Override
    public boolean handle(AWrapperWorld world, APart part) {
        AEntityF_Multipart entity = (AEntityF_Multipart)world.getEntity(this.entityUUID);
        if (entity != null) {
            JSONPartDefinition partDef = ((AJSONPartProvider)entity.definition).parts.get(this.slotIndex);
            part.linkToEntity(entity, partDef);
            entity.addPart(part, false);
        }
        return false;
    }
}

