/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketEntityRiderChange
extends APacketEntityInteract<AEntityB_Existing, IWrapperEntity> {
    private final boolean mount;
    private final boolean facesForwards;

    public PacketEntityRiderChange(AEntityB_Existing entity, IWrapperEntity rider, boolean facesForwards) {
        super(entity, rider);
        this.mount = true;
        this.facesForwards = facesForwards;
    }

    public PacketEntityRiderChange(AEntityB_Existing entity, IWrapperEntity rider) {
        super(entity, rider);
        this.mount = false;
        this.facesForwards = false;
    }

    public PacketEntityRiderChange(ByteBuf buf) {
        super(buf);
        this.mount = buf.readBoolean();
        this.facesForwards = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeBoolean(this.mount);
        buf.writeBoolean(this.facesForwards);
    }

    @Override
    protected boolean handle(AWrapperWorld world, AEntityB_Existing entity, IWrapperEntity rider) {
        if (this.mount) {
            entity.setRider(rider, this.facesForwards);
        } else {
            entity.removeRider();
        }
        return true;
    }
}

