/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.jsondefs;

import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.jsondefs.AJSONBase;
import minecrafttransportsimulator.packloading.JSONParser;

@JSONParser.JSONDescription(value="Panels are simply things that show the instruments in vehicles, and allow interacting with those instruments.  While not required, they do make standardizing vehicle instrument dispays far easier.  Panels go into the 'panels' folder located in the main pack folder.")
public class JSONPanel
extends AJSONBase {
    @JSONParser.JSONRequired
    public JSONPanelMain panel;

    public static enum ActionType {
        TOGGLE,
        SET,
        INCREMENT;

    }

    public static enum SpecialComponent {
        CAR_LIGHT,
        TURN_SIGNAL,
        NAVIGATION_LIGHT,
        STROBE_LIGHT,
        TAXI_LIGHT,
        LANDING_LIGHT,
        ENGINE_CONTROL,
        ENGINE_ON,
        ENGINE_START,
        TRAILER,
        CUSTOM_VARIABLE,
        BEACON_BOX,
        ROLL_TRIM,
        PITCH_TRIM,
        YAW_TRIM;

    }

    public static class JSONPanelClickAction {
        @JSONParser.JSONDescription(value="The variable to act on.")
        public String variable;
        @JSONParser.JSONDescription(value="The type of action to perform when clicked.")
        public ActionType action;
        @JSONParser.JSONDescription(value="The value to use in the action on the variable (if applicable).")
        public double value;
        @JSONParser.JSONDescription(value="The min value for this control to set.  Only used when the action type is increment.")
        public float clampMin;
        @JSONParser.JSONDescription(value="The max value for this control to set.  Only used when the action type is increment.")
        public float clampMax;
    }

    public static class JSONPanelComponent {
        @JSONParser.JSONDescription(value="The position of where to place this component on the panel, with the anchor at the top-left.")
        public Point3D pos;
        @JSONParser.JSONDescription(value="The width of the texture area, and the component itself.")
        public int width;
        @JSONParser.JSONDescription(value="The height of the texture area, and the component itself.")
        public int height;
        @JSONParser.JSONDescription(value="The top-left coordinate of where this panel's 0-state texture is located.")
        public Point3D textureStart;
        @JSONParser.JSONDescription(value="Descriptive text to be rendered below this control.")
        public String text;
        @JSONParser.JSONDescription(value="The variable used to choose the texture state.  May be omitted if this component doesn't change textures.")
        public String statusVariable;
        @JSONParser.JSONDescription(value="A double-nested list of variables.  If this is set, then this component will not be visible unless a variable in each of the sets is true (think of variables in a set being an OR condition, and each set being AND ed together).")
        public List<List<String>> visibilityVariables;
        @JSONParser.JSONDescription(value="The special component to make this component.  May be null.  If set, special logic will be applied that is per-component.")
        public SpecialComponent specialComponent;
        @JSONParser.JSONDescription(value="The action to perform when this control is clicked.")
        public JSONPanelClickAction clickAction;
        @JSONParser.JSONDescription(value="The action to perform when this control is clicked on the left side.")
        public JSONPanelClickAction clickActionLeft;
        @JSONParser.JSONDescription(value="The action to perform when this control is clicked on the right side.")
        public JSONPanelClickAction clickActionRight;
    }

    public static class JSONPanelMain {
        @JSONParser.JSONRequired
        @JSONParser.JSONDescription(value="The texture sheet to use for this panel.  Contains the background, buttons, switches, etc.  Make sure to include a _lit variant otherwise things will look weird!")
        public String texture;
        @JSONParser.JSONDescription(value="The width of the texture, in pixels.")
        public int textureWidth;
        @JSONParser.JSONDescription(value="The height of the texture, in pixels.")
        public int textureHeight;
        @JSONParser.JSONDescription(value="The width of the background section on the texture, in pixels.  The background must touch the left side!")
        public int backgroundWidth;
        @JSONParser.JSONDescription(value="The height of the background section on the texture, in pixels.  The background must touch the top!")
        public int backgroundHeight;
        @JSONParser.JSONDescription(value="The color for the text in the panel that renders below components.  If this is not included it will default to white.")
        public ColorRGB textColor;
        @JSONParser.JSONDescription(value="Same as textColor, but for the text when the vehicle's lights are on.")
        public ColorRGB litTextColor;
        @JSONParser.JSONDescription(value="A list of components that go onto this panel.  These are things that can be seen and interacted with.")
        public List<JSONPanelComponent> components;
    }
}

