/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.rendering.RenderableObject;

public class GUIComponentCutout
extends AGUIComponent {
    public static final String NORMAL_SUFFIX = ".png";
    public static final String LIT_SUFFIX = "_lit.png";
    protected RenderableObject renderableL;
    private boolean renderFullScreen;
    public int textureXOffset;
    public int textureYOffset;
    public int textureSectionWidth;
    public int textureSectionHeight;

    public GUIComponentCutout(int x, int y, int width, int height) {
        this(x, y, width, height, 0, 0, width, height);
        this.renderFullScreen = true;
    }

    public GUIComponentCutout(int x, int y, int width, int height, int textureXOffset, int textureYOffset) {
        this(x, y, width, height, textureXOffset, textureYOffset, width, height);
    }

    public GUIComponentCutout(int x, int y, int width, int height, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(x, y, width, height);
        this.textureXOffset = textureXOffset;
        this.textureYOffset = textureYOffset;
        this.textureSectionWidth = textureSectionWidth;
        this.textureSectionHeight = textureSectionHeight;
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        RenderableObject currentRenderable;
        if (this.renderable == null || !this.renderable.texture.equals(gui.getTexture())) {
            this.renderable = new RenderableObject("gui_cutout", gui.getTexture(), ColorRGB.WHITE, FloatBuffer.allocate(48), false);
            this.renderableL = new RenderableObject("gui_cutout", gui.getTexture().replace(NORMAL_SUFFIX, LIT_SUFFIX), ColorRGB.WHITE, FloatBuffer.allocate(48), false);
        }
        RenderableObject renderableObject = currentRenderable = renderLitTexture ? this.renderableL : this.renderable;
        if (currentRenderable.isTranslucent == blendingEnabled) {
            if (currentRenderable.vertices.position() == 0) {
                if (this.renderFullScreen) {
                    gui.addRenderToBuffer(currentRenderable.vertices, 0, 0, this.width, this.height, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                } else {
                    gui.addRenderToBuffer(currentRenderable.vertices, 0, 0, this.width, this.height, this.textureXOffset, this.textureYOffset, this.textureXOffset + this.textureSectionWidth, this.textureYOffset + this.textureSectionHeight, gui.getTextureWidth(), gui.getTextureHeight());
                }
                currentRenderable.vertices.flip();
            }
            currentRenderable.transform.setTranslation(this.position);
            currentRenderable.ignoreWorldShading = true;
            currentRenderable.worldLightValue = gui.worldLightValue;
            currentRenderable.disableLighting = renderBright || this.ignoreGUILightingState;
            currentRenderable.render(null);
        }
    }
}

