/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.Iterator;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceCollection;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.RoadFollowingState;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.AEntityVehicleC_Colliding;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

abstract class AEntityVehicleD_Moving
extends AEntityVehicleC_Colliding {
    public static final String LEFTTURNLIGHT_VARIABLE = "left_turn_signal";
    public static final String RIGHTTURNLIGHT_VARIABLE = "right_turn_signal";
    public static final String BRAKE_VARIABLE = "brake";
    public static final String PARKINGBRAKE_VARIABLE = "p_brake";
    public double brake;
    public boolean parkingBrakeOn;
    public static final double MAX_BRAKE = 1.0;
    public boolean locked;
    public static final String LOCKED_VARIABLE = "locked";
    public final UUID ownerUUID;
    public boolean goingInReverse;
    public boolean slipping;
    public boolean skidSteerActive;
    public boolean lockedOnRoad;
    private boolean updateGroundDevicesRequest;
    private int lastBlockCollisionBoxesCount;
    public double groundVelocity;
    public double turningForce;
    public double weightTransfer = 0.0;
    public final RotationMatrix rotation = new RotationMatrix();
    private final IWrapperPlayer placingPlayer;
    public float currentSteeringForceIgnoresSpeed;
    public float currentSteeringForceFactor;
    public float currentBrakingFactor;
    public float currentOverSteer;
    public float currentUnderSteer;
    protected RoadFollowingState frontFollower;
    protected RoadFollowingState rearFollower;
    private RoadLane.LaneSelectionRequest selectedSegment = RoadLane.LaneSelectionRequest.NONE;
    private double totalPathDelta;
    private double prevTotalPathDelta;
    private boolean invertedRoadOrientation;
    private final Point3D serverDeltaM;
    private final Point3D serverDeltaR;
    private double serverDeltaP;
    private final Point3D serverDeltaMApplied = new Point3D();
    private final Point3D serverDeltaRApplied = new Point3D();
    private double serverDeltaPApplied;
    private final Point3D clientDeltaM;
    private final Point3D clientDeltaR;
    private double clientDeltaP;
    private final Point3D clientDeltaMApplied = new Point3D();
    private final Point3D clientDeltaRApplied = new Point3D();
    private double clientDeltaPApplied;
    private final Point3D roadMotion = new Point3D();
    private final Point3D roadRotation = new Point3D();
    private final Point3D vehicleCollisionMotion = new Point3D();
    private final RotationMatrix vehicleCollisionRotation = new RotationMatrix();
    private final Point3D groundMotion = new Point3D();
    private final Point3D motionApplied = new Point3D();
    private final RotationMatrix rotationApplied = new RotationMatrix();
    private double pathingApplied;
    private final Point3D tempBoxPosition = new Point3D();
    private final Point3D normalizedGroundVelocityVector = new Point3D();
    private final Point3D normalizedGroundHeadingVector = new Point3D();
    private AEntityE_Interactable<?> lastCollidedEntity;
    public VehicleGroundDeviceCollection groundDeviceCollective;

    public AEntityVehicleD_Moving(AWrapperWorld world, IWrapperPlayer placingPlayer, ItemVehicle item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        UUID uUID = this.ownerUUID = placingPlayer != null ? placingPlayer.getID() : data.getUUID("ownerUUID");
        if (data != null) {
            this.locked = data.getBoolean(LOCKED_VARIABLE);
            this.prevTotalPathDelta = this.totalPathDelta = data.getDouble("totalPathDelta");
            this.serverDeltaM = data.getPoint3d("serverDeltaM");
            this.serverDeltaR = data.getPoint3d("serverDeltaR");
            this.serverDeltaP = data.getDouble("serverDeltaP");
        } else {
            this.serverDeltaM = new Point3D();
            this.serverDeltaR = new Point3D();
        }
        this.clientDeltaM = this.serverDeltaM.copy();
        this.clientDeltaR = this.serverDeltaR.copy();
        this.clientDeltaP = this.serverDeltaP;
        this.groundDeviceCollective = new VehicleGroundDeviceCollection((EntityVehicleF_Physics)this);
        this.placingPlayer = placingPlayer;
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("VehicleD_Level", true);
        if (this.ticksExisted == 1L && this.placingPlayer != null && !this.world.isClient()) {
            double furthestDownPoint = 0.0;
            for (JSONCollisionGroup collisionGroup : ((JSONVehicle)this.definition).collisionGroups) {
                for (JSONCollisionBox collisionBox : collisionGroup.collisions) {
                    furthestDownPoint = Math.min(collisionBox.pos.y - (double)(collisionBox.height / 2.0f), furthestDownPoint);
                }
            }
            for (APart part : this.allParts) {
                furthestDownPoint = Math.min(part.placementDefinition.pos.y - part.getHeight() / 2.0, furthestDownPoint);
            }
            this.motionApplied.set(0.0, -(furthestDownPoint -= 0.1), 0.0);
            this.rotationApplied.angles.set(0.0, 0.0, 0.0);
            this.position.add(this.motionApplied);
            for (BoundingBox coreBox : this.allBlockCollisionBoxes) {
                coreBox.updateToEntity(this, null);
                if (coreBox.updateCollisions(this.world, new Point3D(0.0, -furthestDownPoint, 0.0), false)) {
                    this.placingPlayer.sendPacket(new PacketPlayerChatMessage(this.placingPlayer, LanguageSystem.INTERACT_VEHICLE_NOSPACE, new Object[0]));
                    if (!this.placingPlayer.isCreative()) {
                        this.placingPlayer.setHeldStack(this.getStack());
                    }
                    this.remove();
                    this.world.endProfiling();
                    return;
                }
                this.addToServerDeltas(null, null, 0.0);
            }
        }
        this.brake = this.getVariable(BRAKE_VARIABLE);
        this.parkingBrakeOn = this.isVariableActive(PARKINGBRAKE_VARIABLE);
        this.locked = this.isVariableActive(LOCKED_VARIABLE);
        if (!((Boolean)ConfigSystem.settings.general.noclipVehicles.value).booleanValue() || this.groundDeviceCollective.isReady()) {
            this.world.beginProfiling("GroundForces", false);
            this.getForcesAndMotions();
            this.world.beginProfiling("GroundOperations", false);
            if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
                this.performGroundOperations();
            } else {
                this.slipping = false;
            }
            this.world.beginProfiling("TotalMovement", false);
            this.moveVehicle();
            if (!this.world.isClient()) {
                this.adjustControlSurfaces();
            }
        }
        this.world.endProfiling();
    }

    @Override
    protected void updateAllpartList() {
        super.updateAllpartList();
        if (this.ticksExisted > 1L) {
            this.updateGroundDevicesRequest = true;
        }
    }

    @Override
    protected void updateEncompassingBox() {
        super.updateEncompassingBox();
        if (this.ticksExisted == 1L || this.updateGroundDevicesRequest || this.lastBlockCollisionBoxesCount != this.allBlockCollisionBoxes.size()) {
            this.groundDeviceCollective.updateMembers();
            this.groundDeviceCollective.updateBounds();
            this.groundDeviceCollective.updateCollisions(true);
            this.updateGroundDevicesRequest = false;
            this.lastBlockCollisionBoxesCount = this.allBlockCollisionBoxes.size();
        }
    }

    @Override
    public void connectTrailer(TowingConnection connection, boolean notifyClient) {
        super.connectTrailer(connection, notifyClient);
        EntityVehicleF_Physics towedVehicle = connection.towedVehicle;
        if (towedVehicle.parkingBrakeOn) {
            towedVehicle.setVariable(PARKINGBRAKE_VARIABLE, 0.0);
        }
        towedVehicle.setVariable(BRAKE_VARIABLE, 0.0);
        towedVehicle.frontFollower = null;
        towedVehicle.rearFollower = null;
        towedVehicle.groundDeviceCollective.groundedGroundDevices.clear();
        if (connection.hitchConnection.mounted) {
            for (APart part : towedVehicle.allParts) {
                if (!(part instanceof PartGroundDevice)) continue;
                PartGroundDevice ground = (PartGroundDevice)part;
                ground.angularVelocity = 0.0;
                ground.skipAngularCalcs = false;
                ground.animateAsOnGround = false;
            }
        }
    }

    @Override
    public void disconnectTrailer(int connectionIndex) {
        TowingConnection connection = (TowingConnection)this.towingConnections.get(connectionIndex);
        if (((JSONVehicle)connection.towedVehicle.definition).motorized.isTrailer) {
            connection.towedVehicle.setVariable(PARKINGBRAKE_VARIABLE, 1.0);
        }
        super.disconnectTrailer(connectionIndex);
    }

    private RoadFollowingState getFollower() {
        Point3D contactPoint = this.groundDeviceCollective.getContactPoint(false);
        if (contactPoint != null) {
            TileEntityRoad road;
            contactPoint.rotate(this.orientation).add(this.position);
            ABlockBase block = this.world.getBlock(contactPoint);
            if (block instanceof BlockCollision && (road = ((BlockCollision)block).getMasterRoad(this.world, contactPoint)) != null) {
                Point3D testPoint = new Point3D();
                for (RoadLane lane : road.lanes) {
                    for (BezierCurve curve : lane.curves) {
                        for (float f = 0.0f; f < curve.pathLength; f += 1.0f) {
                            boolean oppositeDirection;
                            curve.setPointToPositionAt(testPoint, f);
                            if (!testPoint.isDistanceToCloserThan(contactPoint, 1.0)) continue;
                            Point3D testRotation = curve.getRotationAt((float)f).angles;
                            boolean sameDirection = Math.abs(testRotation.getClampedYDelta(this.orientation.angles.y)) < 10.0;
                            boolean bl = oppositeDirection = Math.abs(testRotation.getClampedYDelta(this.orientation.angles.y)) > 170.0;
                            if (!sameDirection && !oppositeDirection) continue;
                            return new RoadFollowingState(lane, curve, sameDirection, f);
                        }
                    }
                }
            }
        }
        return null;
    }

    private void performGroundOperations() {
        float skiddingFactor;
        float brakingFactor;
        float f = brakingFactor = this.towedByConnection == null ? this.getBrakingForce() * this.currentBrakingFactor : 0.0f;
        if (brakingFactor > 0.0f) {
            double brakingForce = (double)(20.0f * brakingFactor) / this.currentMass;
            if (brakingForce > this.velocity) {
                this.motion.x = 0.0;
                this.motion.z = 0.0;
                this.rotation.angles.y = 0.0;
            } else {
                this.motion.x -= brakingForce * this.motion.x / this.velocity;
                this.motion.z -= brakingForce * this.motion.z / this.velocity;
            }
        }
        this.normalizedGroundVelocityVector.set(this.motion.x, 0.0, this.motion.z);
        this.groundVelocity = this.normalizedGroundVelocityVector.length();
        this.normalizedGroundVelocityVector.normalize();
        this.normalizedGroundHeadingVector.set(this.headingVector.x, 0.0, this.headingVector.z);
        this.normalizedGroundHeadingVector.normalize();
        double turningForce = this.getTurningForce();
        double dotProduct = this.normalizedGroundVelocityVector.dotProduct(this.normalizedGroundHeadingVector, true);
        if (this.skidSteerActive) {
            this.goingInReverse = false;
        } else if (!this.goingInReverse && dotProduct < -0.75 && (turningForce == 0.0 || this.velocity < 0.1)) {
            this.goingInReverse = true;
        } else if (this.goingInReverse && dotProduct > 0.75 && (turningForce == 0.0 || this.velocity < 0.1)) {
            this.goingInReverse = false;
        }
        if (turningForce != 0.0) {
            this.rotation.angles.y = this.rotation.angles.y + (this.goingInReverse ? -turningForce : turningForce);
        }
        if ((skiddingFactor = this.getSkiddingForce()) != 0.0f && this.groundVelocity > 0.01) {
            Point3D crossProduct = this.normalizedGroundVelocityVector.crossProduct(this.normalizedGroundHeadingVector);
            double vectorDelta = Math.toDegrees(Math.atan2(crossProduct.y, dotProduct));
            if (this.goingInReverse && dotProduct < 0.0) {
                if (vectorDelta >= 90.0) {
                    vectorDelta = -(180.0 - vectorDelta);
                } else if (vectorDelta <= -90.0) {
                    vectorDelta = 180.0 + vectorDelta;
                }
            }
            if (this.towedByConnection == null) {
                double overSteerForce = Math.max(this.velocity / 4.0, 1.0);
                if (((JSONVehicle)this.definition).motorized.overSteerAccel != 0.0f) {
                    this.weightTransfer += (this.motion.dotProduct(this.motion, false) - this.prevMotion.dotProduct(this.prevMotion, false)) * this.weightTransfer * (double)this.currentOverSteer;
                    if (Math.abs(this.weightTransfer) > (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerAccel) && Math.abs(this.weightTransfer) > (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerDecel)) {
                        this.weightTransfer = ((JSONVehicle)this.definition).motorized.overSteerAccel;
                    } else if (Math.abs(this.weightTransfer) < (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerDecel) && this.weightTransfer < (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerAccel)) {
                        this.weightTransfer = ((JSONVehicle)this.definition).motorized.overSteerDecel;
                    }
                } else {
                    this.weightTransfer = this.currentOverSteer;
                }
                this.rotation.angles.y += crossProduct.y * this.weightTransfer + Math.abs(crossProduct.y) * (double)(-this.currentUnderSteer) * turningForce * overSteerForce;
            }
            if (Math.abs(vectorDelta) > 0.001) {
                double motionFactor = vectorDelta > (double)skiddingFactor ? (double)skiddingFactor / vectorDelta : (vectorDelta < (double)(-skiddingFactor) ? (double)(-skiddingFactor) / vectorDelta : 1.0);
                Point3D idealMotion = this.goingInReverse ? this.normalizedGroundHeadingVector.copy().scale(-this.groundVelocity) : this.normalizedGroundHeadingVector.copy().scale(this.groundVelocity);
                idealMotion.scale(motionFactor).add(this.motion.x * (1.0 - motionFactor), 0.0, this.motion.z * (1.0 - motionFactor));
                this.motion.x = idealMotion.x;
                this.motion.z = idealMotion.z;
                this.slipping = this.towedByConnection == null ? this.world.isClient() && motionFactor != 1.0 && this.velocity > 0.75 : this.towedByConnection.towingVehicle.slipping;
            }
        }
    }

    private float getBrakingForce() {
        double brakingPower = this.parkingBrakeOn ? 1.0 : this.brake;
        float brakingFactor = 0.0f;
        if (brakingPower > 0.0) {
            for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
                brakingFactor += groundDevice.currentMotiveFriction;
            }
            if (brakingPower > 0.0) {
                brakingFactor = (float)((double)brakingFactor + 0.15 * brakingPower * (double)this.groundDeviceCollective.getNumberBoxesInLiquid());
            }
        }
        return brakingFactor;
    }

    private float getSkiddingForce() {
        float skiddingFactor = 0.0f;
        for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
            skiddingFactor += groundDevice.currentLateralFriction;
        }
        return (skiddingFactor = (float)((double)skiddingFactor + 0.5 * (double)this.groundDeviceCollective.getNumberBoxesInLiquid())) > 0.0f ? skiddingFactor : 0.0f;
    }

    private double getTurningForce() {
        this.skidSteerActive = false;
        double steeringAngle = this.getSteeringAngle() * 45.0;
        if (((JSONVehicle)this.definition).motorized.hasPermanentSkidSteer) {
            return steeringAngle / 20.0;
        }
        if (steeringAngle != 0.0) {
            double furthestFrontPoint = 0.0;
            double furthestRearPoint = 0.0;
            double turningDistance = 0.0;
            boolean foundTurningDevice = false;
            for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
                if (groundDevice.wheelbasePoint.z > furthestFrontPoint) {
                    furthestFrontPoint = groundDevice.wheelbasePoint.z;
                }
                if (groundDevice.wheelbasePoint.z < furthestRearPoint) {
                    furthestRearPoint = groundDevice.wheelbasePoint.z;
                }
                if (!groundDevice.placementDefinition.turnsWithSteer) continue;
                foundTurningDevice = true;
            }
            turningDistance = furthestFrontPoint - furthestRearPoint;
            if (turningDistance == 0.0) {
                for (APart part : this.allParts) {
                    if (!(part instanceof PartPropeller) || !part.isInLiquid()) continue;
                    turningDistance = Math.max(turningDistance, Math.abs(part.placementDefinition.pos.z));
                    foundTurningDevice = true;
                    break;
                }
            }
            if (foundTurningDevice && turningDistance > 0.0) {
                if (((JSONVehicle)this.definition).motorized.hasSkidSteer) {
                    if (this.groundDeviceCollective.isReady() && this.groundVelocity < 0.05) {
                        boolean foundNeutralEngine = false;
                        boolean leftWheelGrounded = false;
                        boolean rightWheelGrounded = false;
                        for (APart part : this.parts) {
                            if (part instanceof PartGroundDevice) {
                                if (!this.groundDeviceCollective.groundedGroundDevices.contains(part)) continue;
                                if (part.placementDefinition.pos.x > 0.0) {
                                    leftWheelGrounded = true;
                                    continue;
                                }
                                rightWheelGrounded = true;
                                continue;
                            }
                            if (!(part instanceof PartEngine) || ((PartEngine)part).currentGear != 0 || !((PartEngine)part).running) continue;
                            foundNeutralEngine = true;
                        }
                        boolean bl = this.skidSteerActive = foundNeutralEngine && leftWheelGrounded && rightWheelGrounded;
                    }
                    if (this.skidSteerActive) {
                        return steeringAngle / 20.0;
                    }
                }
                this.turningForce = steeringAngle / turningDistance;
                if (this.groundVelocity > 0.35 && this.currentSteeringForceIgnoresSpeed == 0.0f) {
                    this.turningForce *= Math.pow(0.3f, this.groundVelocity * (double)(1.0f - this.currentSteeringForceFactor) - 0.35);
                } else if (this.currentSteeringForceIgnoresSpeed != 0.0f) {
                    this.turningForce *= (double)this.currentSteeringForceFactor;
                }
                return this.turningForce * this.groundVelocity * (this.speedFactor / 0.35) / 2.0;
            }
        }
        return 0.0;
    }

    private void moveVehicle() {
        if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
            this.world.beginProfiling("GDBInit", true);
            this.collidedEntities.clear();
            this.groundDeviceCollective.updateCollisions(true);
            if (!((JSONVehicle)this.definition).motorized.isAircraft) {
                this.world.beginProfiling("RoadChecks", false);
                if ((this.frontFollower == null || this.rearFollower == null) && this.ticksExisted % 20L == 0L) {
                    Point3D frontContact = this.groundDeviceCollective.getContactPoint(true);
                    Point3D rearContact = this.groundDeviceCollective.getContactPoint(false);
                    if (frontContact != null && rearContact != null) {
                        this.rearFollower = this.getFollower();
                        if (this.rearFollower != null) {
                            float pointDelta = (float)rearContact.distanceTo(frontContact);
                            if (this.towedByConnection == null) {
                                this.frontFollower = new RoadFollowingState(this.rearFollower, false).updateCurvePoints(pointDelta, RoadLane.LaneSelectionRequest.NONE);
                            } else if (this.towedByConnection.towingVehicle.lockedOnRoad) {
                                boolean frontHitch = this.towedByConnection.towingEntity instanceof APart ? ((APart)this.towedByConnection.towingEntity).localOffset.z > 0.0 : this.towedByConnection.hitchConnection.pos.z > 0.0;
                                Point3D towingContact = this.towedByConnection.towingVehicle.groundDeviceCollective.getContactPoint(frontHitch);
                                Point3D towingHitchDelta = this.towedByConnection.hitchConnection.pos.copy().multiply(this.towedByConnection.towingEntity.scale);
                                if (this.towedByConnection.towingEntity instanceof APart) {
                                    APart part = (APart)this.towedByConnection.towingEntity;
                                    towingHitchDelta.rotate(part.localOrientation);
                                    towingHitchDelta.add(part.localOffset);
                                }
                                towingHitchDelta.subtract(towingContact);
                                towingHitchDelta.y = 0.0;
                                boolean frontHookup = this.towedByConnection.towedEntity instanceof APart ? ((APart)this.towedByConnection.towedEntity).localOffset.z > 0.0 : this.towedByConnection.hookupConnection.pos.z > 0.0;
                                Point3D towedContact = this.towedByConnection.towedVehicle.groundDeviceCollective.getContactPoint(frontHookup);
                                Point3D towedHitchDelta = this.towedByConnection.hookupConnection.pos.copy().multiply(this.towedByConnection.towedEntity.scale);
                                if (this.towedByConnection.towedEntity instanceof APart) {
                                    APart part = (APart)this.towedByConnection.towedEntity;
                                    towedHitchDelta.rotate(part.localOrientation);
                                    towedHitchDelta.add(part.localOffset);
                                }
                                towedHitchDelta.subtract(towedContact);
                                towedHitchDelta.y = 0.0;
                                float segmentDelta = (float)(towingHitchDelta.length() + towedHitchDelta.length());
                                this.selectedSegment = this.towedByConnection.towingVehicle.selectedSegment;
                                if (frontHitch) {
                                    if (frontHookup) {
                                        this.invertedRoadOrientation = true;
                                        this.frontFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.frontFollower, this.invertedRoadOrientation);
                                        this.frontFollower.updateCurvePoints(-segmentDelta, this.selectedSegment);
                                        this.rearFollower = new RoadFollowingState(this.frontFollower, false);
                                        this.rearFollower.updateCurvePoints(-pointDelta, this.selectedSegment);
                                    } else {
                                        this.invertedRoadOrientation = false;
                                        this.rearFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.frontFollower, this.invertedRoadOrientation);
                                        this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                                        this.frontFollower = new RoadFollowingState(this.rearFollower, false);
                                        this.frontFollower.updateCurvePoints(pointDelta, this.selectedSegment);
                                    }
                                } else if (frontHookup) {
                                    this.invertedRoadOrientation = false;
                                    this.frontFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.rearFollower, this.invertedRoadOrientation);
                                    this.frontFollower.updateCurvePoints(-segmentDelta, this.selectedSegment);
                                    this.rearFollower = new RoadFollowingState(this.frontFollower, false);
                                    this.rearFollower.updateCurvePoints(-pointDelta, this.selectedSegment);
                                } else {
                                    this.invertedRoadOrientation = true;
                                    this.rearFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.rearFollower, this.invertedRoadOrientation);
                                    this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                                    this.frontFollower = new RoadFollowingState(this.rearFollower, false);
                                    this.frontFollower.updateCurvePoints(pointDelta, this.selectedSegment);
                                }
                            }
                        }
                    }
                }
            }
            if (this.frontFollower != null && this.rearFollower != null) {
                RoadLane.LaneSelectionRequest requestedSegment;
                this.world.beginProfiling("RoadOperations", false);
                if (this.isVariableActive(LEFTTURNLIGHT_VARIABLE) == this.isVariableActive(RIGHTTURNLIGHT_VARIABLE)) {
                    requestedSegment = RoadLane.LaneSelectionRequest.NONE;
                } else if (this.isVariableActive(LEFTTURNLIGHT_VARIABLE)) {
                    requestedSegment = this.goingInReverse ? RoadLane.LaneSelectionRequest.RIGHT : RoadLane.LaneSelectionRequest.LEFT;
                } else {
                    RoadLane.LaneSelectionRequest laneSelectionRequest = requestedSegment = this.goingInReverse ? RoadLane.LaneSelectionRequest.LEFT : RoadLane.LaneSelectionRequest.RIGHT;
                }
                if (this.frontFollower.equals(this.rearFollower)) {
                    this.selectedSegment = requestedSegment;
                }
                float segmentDelta = (float)(this.totalPathDelta - this.prevTotalPathDelta);
                this.prevTotalPathDelta = this.totalPathDelta;
                this.frontFollower = this.frontFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                this.rearFollower = this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                Point3D rearPoint = this.groundDeviceCollective.getContactPoint(false);
                if (this.frontFollower != null && this.rearFollower != null && rearPoint != null) {
                    rearPoint.rotate(this.orientation).add(this.position);
                    Point3D rearDesiredPoint = this.rearFollower.getCurrentPoint();
                    this.roadMotion.set(rearDesiredPoint);
                    this.roadMotion.subtract(rearPoint);
                    if (this.roadMotion.length() > 1.0) {
                        this.roadMotion.set(0.0, 0.0, 0.0);
                        this.frontFollower = null;
                        this.rearFollower = null;
                    } else {
                        this.motion.y = 0.0;
                        Point3D desiredVector = this.frontFollower.getCurrentPoint().subtract(rearDesiredPoint);
                        double yawDelta = Math.toDegrees(Math.atan2(desiredVector.x, desiredVector.z));
                        double pitchDelta = -Math.toDegrees(Math.atan2(desiredVector.y, Math.hypot(desiredVector.x, desiredVector.z)));
                        double rollDelta = this.rearFollower.getCurrentRoll();
                        if (((JSONVehicle)this.definition).motorized.maxTiltAngle != 0.0f) {
                            rollDelta -= (double)((JSONVehicle)this.definition).motorized.maxTiltAngle * 2.0 * Math.min(0.5, this.velocity / 2.0) * this.getSteeringAngle();
                        }
                        this.roadRotation.set(pitchDelta - this.orientation.angles.x, yawDelta, rollDelta - this.orientation.angles.z);
                        this.roadRotation.y = this.roadRotation.getClampedYDelta(this.orientation.angles.y);
                        if (!this.world.isClient()) {
                            if (this.towedByConnection != null) {
                                this.addToSteeringAngle(this.towedByConnection.towingVehicle.getSteeringAngle() - this.getSteeringAngle());
                            } else {
                                this.addToSteeringAngle((this.goingInReverse ? -this.roadRotation.y : this.roadRotation.y) * 1.5);
                            }
                        }
                    }
                } else {
                    this.frontFollower = null;
                    this.rearFollower = null;
                }
            }
            this.groundMotion.set(0.0, 0.0, 0.0);
            boolean fallingDown = this.motion.y < 0.0;
            boolean bl = this.lockedOnRoad = this.frontFollower != null && this.rearFollower != null;
            if (!this.lockedOnRoad) {
                this.world.beginProfiling("GroundBoostCheck", false);
                this.groundMotion.y = this.groundDeviceCollective.getMaxCollisionDepth() / this.speedFactor;
                if (this.groundMotion.y > 0.0) {
                    this.world.beginProfiling("GroundBoostApply", false);
                    this.groundMotion.y = Math.min(this.groundMotion.y, (Double)ConfigSystem.settings.general.climbSpeed.value / this.speedFactor);
                    if (this.motion.y <= 0.0 && this.motion.y + this.groundMotion.y > 0.0) {
                        this.groundMotion.y += this.motion.y;
                        this.motion.y = 0.0;
                    } else {
                        this.motion.y += this.groundMotion.y;
                        this.groundMotion.y = 0.0;
                    }
                    this.groundDeviceCollective.updateCollisions(false);
                }
                this.world.beginProfiling("CollisionCheck_" + this.allBlockCollisionBoxes.size(), false);
                if (this.isCollisionBoxCollided()) {
                    this.world.beginProfiling("CollisionHandling", false);
                    if (this.towedByConnection != null) {
                        Point3D initalMotion = this.motion.copy();
                        if (this.correctCollidingMovement()) {
                            this.world.endProfiling();
                            return;
                        }
                        this.towedByConnection.towingVehicle.motion.add(this.motion).subtract(initalMotion);
                    } else if (this.correctCollidingMovement()) {
                        this.world.endProfiling();
                        return;
                    }
                    this.groundDeviceCollective.updateCollisions(false);
                }
                if (!this.groundDeviceCollective.isBlockedVertically() && (fallingDown || this.towedByConnection != null)) {
                    this.world.beginProfiling("GroundHandlingPitch", false);
                    this.groundDeviceCollective.performPitchCorrection(this.groundMotion);
                    if (this.groundDeviceCollective.canDoRollChecks()) {
                        this.world.beginProfiling("GroundHandlingRoll", false);
                        this.groundDeviceCollective.performRollCorrection(this.groundMotion);
                    }
                    if (((JSONVehicle)this.definition).motorized.maxTiltAngle != 0.0f) {
                        this.rotation.angles.z = -this.orientation.angles.z - (double)((JSONVehicle)this.definition).motorized.maxTiltAngle * 2.0 * Math.min(0.5, this.velocity / 2.0) * this.getSteeringAngle();
                    }
                }
            }
            if (!this.collidedEntities.isEmpty()) {
                this.world.beginProfiling("EntityMoveAlong", false);
                Iterator iterator = this.collidedEntities.iterator();
                if (iterator.hasNext()) {
                    AEntityE_Interactable interactable = (AEntityE_Interactable)iterator.next();
                    if (interactable instanceof AEntityVehicleD_Moving) {
                        this.vehicleCollisionRotation.set(interactable.orientation).multiplyTranspose(interactable.prevOrientation);
                        this.vehicleCollisionRotation.convertToAngles();
                    }
                    Point3D centerOffset = this.position.copy().subtract(interactable.prevPosition);
                    this.vehicleCollisionMotion.set(centerOffset);
                    this.vehicleCollisionMotion.rotate(this.vehicleCollisionRotation);
                    this.vehicleCollisionMotion.subtract(centerOffset);
                    this.vehicleCollisionMotion.add(interactable.position).subtract(interactable.prevPosition);
                    if (this.lastCollidedEntity == null) {
                        this.lastCollidedEntity = interactable;
                        this.motion.subtract(this.lastCollidedEntity.motion);
                    }
                }
            } else if (this.lastCollidedEntity != null) {
                this.motion.add(this.lastCollidedEntity.motion);
                this.lastCollidedEntity = null;
            }
            this.world.beginProfiling("ApplyMotions", false);
            this.motionApplied.set(this.motion).scale(this.speedFactor).add(this.groundMotion);
            this.rotationApplied.angles.set(this.rotation.angles);
            if (this.lockedOnRoad) {
                this.motionApplied.add(this.roadMotion);
                this.rotationApplied.angles.add(this.roadRotation);
                if (this.towedByConnection != null) {
                    this.pathingApplied = this.towedByConnection.towingVehicle.pathingApplied;
                    if (this.invertedRoadOrientation) {
                        this.pathingApplied = -this.pathingApplied;
                    }
                } else {
                    this.pathingApplied = this.goingInReverse ? -this.velocity * this.speedFactor : this.velocity * this.speedFactor;
                }
            } else {
                this.pathingApplied = 0.0;
            }
            if (this.lastCollidedEntity != null) {
                this.motionApplied.add(this.vehicleCollisionMotion);
                this.rotationApplied.angles.add(this.vehicleCollisionRotation.angles);
            }
            this.position.add(this.motionApplied);
            if (!this.rotationApplied.angles.isZero()) {
                this.rotationApplied.updateToAngles();
                this.orientation.multiply(this.rotationApplied).convertToAngles();
            }
            this.totalPathDelta += this.pathingApplied;
            if (this.world.isClient()) {
                this.clientDeltaM.add(this.motionApplied);
                this.clientDeltaMApplied.set(this.serverDeltaM).subtract(this.clientDeltaM);
                if (!this.clientDeltaMApplied.isZero()) {
                    this.clientDeltaMApplied.x *= Math.abs(this.clientDeltaMApplied.x);
                    this.clientDeltaMApplied.y *= Math.abs(this.clientDeltaMApplied.y);
                    this.clientDeltaMApplied.z *= Math.abs(this.clientDeltaMApplied.z);
                    this.clientDeltaMApplied.scale(0.04).clamp(5.0);
                    this.clientDeltaM.add(this.clientDeltaMApplied);
                    this.position.add(this.clientDeltaMApplied);
                }
                if (!this.rotationApplied.angles.isZero()) {
                    this.rotationApplied.angles.set(this.orientation.angles).subtract(this.prevOrientation.angles).clamp180();
                    this.clientDeltaR.add(this.rotationApplied.angles);
                }
                this.clientDeltaRApplied.set(this.serverDeltaR).subtract(this.clientDeltaR);
                if (!this.clientDeltaRApplied.isZero()) {
                    this.clientDeltaRApplied.x *= Math.abs(this.clientDeltaRApplied.x);
                    this.clientDeltaRApplied.y *= Math.abs(this.clientDeltaRApplied.y);
                    this.clientDeltaRApplied.z *= Math.abs(this.clientDeltaRApplied.z);
                    this.clientDeltaRApplied.scale(0.04).clamp(5.0);
                    this.clientDeltaR.add(this.clientDeltaRApplied);
                    this.orientation.angles.add(this.clientDeltaRApplied);
                    this.orientation.updateToAngles();
                }
                this.clientDeltaP += this.pathingApplied;
                this.clientDeltaPApplied = this.serverDeltaP - this.clientDeltaP;
                if (this.clientDeltaPApplied != 0.0) {
                    this.clientDeltaPApplied *= Math.abs(this.clientDeltaPApplied);
                    this.clientDeltaPApplied *= 0.04;
                    if (this.clientDeltaPApplied > 5.0) {
                        this.clientDeltaPApplied = 5.0;
                    } else if (this.clientDeltaPApplied < -5.0) {
                        this.clientDeltaPApplied = -5.0;
                    }
                    this.clientDeltaP += this.clientDeltaPApplied;
                    this.totalPathDelta += this.clientDeltaPApplied;
                }
            } else {
                this.addToServerDeltas(null, null, 0.0);
            }
        } else {
            this.world.beginProfiling("ApplyMotions", true);
            this.motionApplied.set(this.motion).scale(this.speedFactor);
            this.position.add(this.motionApplied);
            this.orientation.set(this.rotation).convertToAngles();
            EntityVehicleF_Physics towingVehicle = this.towedByConnection.towingVehicle;
            if (this.world.isClient()) {
                this.clientDeltaM.add(towingVehicle.clientDeltaMApplied);
                this.clientDeltaR.add(towingVehicle.clientDeltaRApplied);
                this.clientDeltaP += towingVehicle.clientDeltaPApplied;
            } else {
                this.serverDeltaM.add(towingVehicle.serverDeltaMApplied);
                this.serverDeltaR.add(towingVehicle.serverDeltaRApplied);
                this.serverDeltaP += towingVehicle.serverDeltaPApplied;
            }
        }
        this.world.endProfiling();
    }

    private boolean isCollisionBoxCollided() {
        if (this.motion.length() > 0.001) {
            boolean clearedCache = false;
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                this.tempBoxPosition.set(box.globalCenter).subtract(this.position).rotate(this.rotation).subtract(box.globalCenter).add(this.position).addScaled(this.motion, this.speedFactor);
                if (!box.collidesWithLiquids && this.world.checkForCollisions(box, this.tempBoxPosition, !clearedCache, (Boolean)ConfigSystem.settings.general.blockBreakage.value)) {
                    return true;
                }
                clearedCache = true;
            }
        }
        return false;
    }

    private boolean correctCollidingMovement() {
        double hardnessHitThisTick = 0.0;
        Point3D collisionMotion = this.motion.copy().scale(this.speedFactor);
        for (BoundingBox box : this.allBlockCollisionBoxes) {
            if (!box.updateCollisions(this.world, collisionMotion, true)) continue;
            float hardnessHitThisBox = 0.0f;
            boolean inhibitMovement = false;
            for (Point3D blockPosition : box.collidingBlockPositions) {
                float blockHardness = this.world.getBlockHardness(blockPosition);
                if (this.world.isBlockLiquid(blockPosition)) continue;
                if (((Boolean)ConfigSystem.settings.general.blockBreakage.value).booleanValue() && (double)blockHardness <= this.velocity * this.currentMass / 250.0 && blockHardness >= 0.0f) {
                    hardnessHitThisBox += blockHardness;
                    if (collisionMotion.y > -0.01) {
                        hardnessHitThisTick += (double)blockHardness;
                    }
                    this.motion.scale(Math.max(1.0 - (double)(blockHardness * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0));
                    if (this.ticksExisted > 500L) {
                        if (this.world.isClient()) continue;
                        this.world.destroyBlock(blockPosition, true);
                        if (box.groupDef == null || !(blockHardness > 0.0f)) continue;
                        this.damageCollisionBox(box, blockHardness >= 20.0f ? (double)(blockHardness * 2.0f) : (double)(blockHardness * 4.0f));
                        continue;
                    }
                }
                inhibitMovement = true;
            }
            if (((Boolean)ConfigSystem.settings.general.vehicleDestruction.value).booleanValue() && hardnessHitThisTick > this.currentMass / (0.75 + this.velocity) / 250.0 && !this.world.isClient()) {
                APart partHit = this.getPartWithBox(box);
                if (partHit != null) {
                    hardnessHitThisTick -= (double)hardnessHitThisBox;
                    this.removePart(partHit, true, null);
                } else {
                    this.destroy(box);
                    return false;
                }
            }
            if (!inhibitMovement) continue;
            this.motion.subtract(box.currentCollisionDepth.scale(1.0 / this.speedFactor));
            collisionMotion.set(this.motion.copy().scale(this.speedFactor));
        }
        if (!this.rotation.angles.isZero()) {
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                this.tempBoxPosition.set(box.globalCenter).subtract(this.position).rotate(this.rotation).add(this.position).addScaled(this.motion, this.speedFactor);
                if (!box.updateCollisions(this.world, this.tempBoxPosition.subtract(box.globalCenter), false)) continue;
                this.rotation.setToZero();
                break;
            }
        }
        return false;
    }

    public void addToServerDeltas(Point3D motionAdded, Point3D rotationAdded, double pathingAdded) {
        if (rotationAdded != null) {
            this.serverDeltaM.add(motionAdded);
            this.serverDeltaR.add(rotationAdded);
            this.serverDeltaP += pathingAdded;
        } else if (!this.motionApplied.isZero()) {
            this.serverDeltaMApplied.set(this.motionApplied);
            this.serverDeltaM.add(this.motionApplied);
            if (!this.orientation.angles.equals(this.prevOrientation.angles)) {
                this.rotationApplied.angles.set(this.orientation.angles).subtract(this.prevOrientation.angles).clamp180();
                this.serverDeltaRApplied.set(this.rotationApplied.angles);
                this.serverDeltaR.add(this.rotationApplied.angles);
            }
            this.serverDeltaPApplied += this.pathingApplied;
            this.serverDeltaP += this.pathingApplied;
            InterfaceManager.packetInterface.sendToAllClients(new PacketVehicleServerMovement((EntityVehicleF_Physics)this, this.motionApplied, this.rotationApplied.angles, this.pathingApplied));
        }
    }

    public void toggleLock() {
        this.locked = !this.locked;
        this.toggleVariable(LOCKED_VARIABLE);
        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, LOCKED_VARIABLE));
        if (this.locked) {
            Iterator iterator = this.variables.keySet().iterator();
            while (iterator.hasNext()) {
                String variable = (String)iterator.next();
                if (!variable.contains("door")) continue;
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, variable));
                iterator.remove();
            }
        }
    }

    public AEntityE_Interactable.PlayerOwnerState getOwnerState(IWrapperPlayer player) {
        boolean canPlayerEdit;
        boolean bl = canPlayerEdit = player.isOP() || this.ownerUUID == null || player.getID().equals(this.ownerUUID);
        return player.isOP() ? AEntityE_Interactable.PlayerOwnerState.ADMIN : (canPlayerEdit ? AEntityE_Interactable.PlayerOwnerState.OWNER : AEntityE_Interactable.PlayerOwnerState.USER);
    }

    protected abstract double getSteeringAngle();

    protected abstract void addToSteeringAngle(double var1);

    protected abstract void getForcesAndMotions();

    protected abstract void adjustControlSurfaces();

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean(LOCKED_VARIABLE, this.locked);
        if (this.ownerUUID != null) {
            data.setUUID("ownerUUID", this.ownerUUID);
        }
        data.setPoint3d("serverDeltaM", this.serverDeltaM);
        data.setPoint3d("serverDeltaR", this.serverDeltaR);
        data.setDouble("serverDeltaP", this.serverDeltaP);
        return data;
    }
}

