/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONConnection;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;

public class TowingConnection {
    private final UUID hitchEntityUUID;
    private final UUID hookupEntityUUID;
    public final int hitchGroupIndex;
    public final int hitchConnectionIndex;
    public final int hookupGroupIndex;
    public final int hookupConnectionIndex;
    public EntityVehicleF_Physics towingVehicle;
    public AEntityE_Interactable<?> towingEntity;
    public EntityVehicleF_Physics towedVehicle;
    public AEntityE_Interactable<?> towedEntity;
    public JSONConnectionGroup hitchConnectionGroup;
    public JSONConnection hitchConnection;
    public JSONConnectionGroup hookupConnectionGroup;
    public JSONConnection hookupConnection;
    public final Point3D hitchPriorPosition = new Point3D();
    public final Point3D hitchCurrentPosition = new Point3D();
    public final Point3D hookupPriorPosition = new Point3D();
    public final Point3D hookupCurrentPosition = new Point3D();

    public TowingConnection(AEntityE_Interactable<?> hitchEntity, int hitchGroupIndex, int hitchConnectionIndex, AEntityE_Interactable<?> hookupEntity, int hookupGroupIndex, int hookupConnectionIndex) {
        this.hitchEntityUUID = hitchEntity.uniqueUUID;
        this.hookupEntityUUID = hookupEntity.uniqueUUID;
        this.hitchGroupIndex = hitchGroupIndex;
        this.hitchConnectionIndex = hitchConnectionIndex;
        this.hookupGroupIndex = hookupGroupIndex;
        this.hookupConnectionIndex = hookupConnectionIndex;
        this.towingVehicle = hitchEntity instanceof APart ? ((APart)hitchEntity).vehicleOn : (EntityVehicleF_Physics)hitchEntity;
        this.towedVehicle = hookupEntity instanceof APart ? ((APart)hookupEntity).vehicleOn : (EntityVehicleF_Physics)hookupEntity;
        this.initConnection(hitchEntity.world);
    }

    public TowingConnection(IWrapperNBT data) {
        this.hitchEntityUUID = data.getUUID("hitchEntityUUID");
        this.hookupEntityUUID = data.getUUID("hookupEntityUUID");
        this.hitchGroupIndex = data.getInteger("hitchGroupIndex");
        this.hitchConnectionIndex = data.getInteger("hitchConnectionIndex");
        this.hookupGroupIndex = data.getInteger("hookupGroupIndex");
        this.hookupConnectionIndex = data.getInteger("hookupConnectionIndex");
    }

    public boolean initConnection(AWrapperWorld world) {
        if (this.towingEntity == null) {
            this.towingEntity = (AEntityE_Interactable)world.getEntity(this.hitchEntityUUID);
            if (this.towingEntity != null && this.towingEntity.ticksExisted > 5L) {
                EntityVehicleF_Physics entityVehicleF_Physics = this.towingVehicle = this.towingEntity instanceof APart ? ((APart)this.towingEntity).vehicleOn : (EntityVehicleF_Physics)this.towingEntity;
                if (((AJSONInteractableEntity)this.towingEntity.definition).connectionGroups.size() > this.hitchGroupIndex) {
                    this.hitchConnectionGroup = ((AJSONInteractableEntity)this.towingEntity.definition).connectionGroups.get(this.hitchGroupIndex);
                    if (this.hitchConnectionGroup.connections.size() > this.hitchConnectionIndex) {
                        this.hitchConnection = this.hitchConnectionGroup.connections.get(this.hitchConnectionIndex);
                    }
                }
            }
        }
        if (this.towedEntity == null) {
            this.towedEntity = (AEntityE_Interactable)world.getEntity(this.hookupEntityUUID);
            if (this.towedEntity != null && this.towedEntity.ticksExisted > 5L) {
                EntityVehicleF_Physics entityVehicleF_Physics = this.towedVehicle = this.towedEntity instanceof APart ? ((APart)this.towedEntity).vehicleOn : (EntityVehicleF_Physics)this.towedEntity;
                if (((AJSONInteractableEntity)this.towedEntity.definition).connectionGroups.size() > this.hookupGroupIndex) {
                    this.hookupConnectionGroup = ((AJSONInteractableEntity)this.towedEntity.definition).connectionGroups.get(this.hookupGroupIndex);
                    if (this.hookupConnectionGroup.connections.size() > this.hookupConnectionIndex) {
                        this.hookupConnection = this.hookupConnectionGroup.connections.get(this.hookupConnectionIndex);
                    }
                }
            }
        }
        return this.hitchConnection != null && this.hookupConnection != null && this.towedVehicle != this.towingVehicle;
    }

    public IWrapperNBT save(IWrapperNBT data) {
        data.setUUID("hitchEntityUUID", this.hitchEntityUUID);
        data.setUUID("hookupEntityUUID", this.hookupEntityUUID);
        data.setInteger("hitchGroupIndex", this.hitchGroupIndex);
        data.setInteger("hitchConnectionIndex", this.hitchConnectionIndex);
        data.setInteger("hookupGroupIndex", this.hookupGroupIndex);
        data.setInteger("hookupConnectionIndex", this.hookupConnectionIndex);
        return data;
    }
}

