/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.Particle;
import cam72cam.mod.render.opengl.DirectDraw;
import cam72cam.mod.render.opengl.RenderState;
import cam72cam.mod.render.opengl.Texture;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.world.World;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import util.Matrix4;

public class SmokeParticle
extends Particle {
    private final double rot;
    private final SmokeParticleData data;

    public SmokeParticle(SmokeParticleData data) {
        this.data = data;
        this.rot = Math.random() * 360.0;
    }

    public boolean depthTestEnabled() {
        return false;
    }

    public void render(RenderState ctx, float partialTicks) {
    }

    public static void renderAll(List<SmokeParticle> particles, RenderState state, float partialTicks) {
        state.cull_face(false);
        Map<Identifier, List<SmokeParticle>> partitioned = particles.stream().collect(Collectors.groupingBy(p -> p.data.texture));
        for (Identifier texture : partitioned.keySet()) {
            state.texture(Texture.wrap((Identifier)texture));
            DirectDraw buffer = new DirectDraw();
            for (SmokeParticle particle : partitioned.get(texture)) {
                double life = (float)particle.ticks / (float)particle.data.lifespan;
                double expansionRate = 16.0;
                double radius = particle.data.diameter * (Math.sqrt(life) * expansionRate + 1.0) * 0.5;
                float alpha = (particle.data.thickness + 0.25f) * (1.0f - (float)Math.sqrt(life));
                Matrix4 matrix = new Matrix4();
                float darken = 0.9f - particle.data.darken * 0.9f;
                matrix.translate(particle.renderX, particle.renderY, particle.renderZ);
                particle.lookAtPlayer(matrix);
                matrix.scale(radius, radius, radius);
                matrix.rotate(Math.toRadians(particle.rot), 0.0, 0.0, 1.0);
                matrix.translate(0.5, 0.0, 0.0);
                matrix.rotate(Math.toRadians(-particle.rot), 0.0, 0.0, 1.0);
                double angle = (float)particle.ticks + partialTicks;
                matrix.rotate(Math.toRadians(angle), 0.0, 0.0, 1.0);
                buffer.vertex(matrix.apply(new Vec3d(-1.0, -1.0, 0.0))).uv(0.0, 0.0).color((double)darken, (double)darken, (double)darken, (double)alpha);
                buffer.vertex(matrix.apply(new Vec3d(-1.0, 1.0, 0.0))).uv(0.0, 1.0).color((double)darken, (double)darken, (double)darken, (double)alpha);
                buffer.vertex(matrix.apply(new Vec3d(1.0, 1.0, 0.0))).uv(1.0, 1.0).color((double)darken, (double)darken, (double)darken, (double)alpha);
                buffer.vertex(matrix.apply(new Vec3d(1.0, -1.0, 0.0))).uv(1.0, 0.0).color((double)darken, (double)darken, (double)darken, (double)alpha);
            }
            buffer.draw(state);
        }
    }

    public static class SmokeParticleData
    extends Particle.ParticleData {
        private final float darken;
        private final float thickness;
        private final double diameter;
        private final Identifier texture;

        public SmokeParticleData(World world, Vec3d pos, Vec3d motion, int lifespan, float darken, float thickness, double diameter, Identifier texture) {
            super(world, pos, motion, lifespan);
            this.darken = darken;
            this.thickness = thickness;
            this.diameter = diameter;
            this.texture = texture;
        }
    }
}

