/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.entity.physics.chrono.ChronoState;
import cam72cam.immersiverailroading.entity.physics.chrono.ServerChronoState;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.RealBB;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.custom.ICollision;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class EntityMoveableRollingStock
extends EntityRidableRollingStock
implements ICollision {
    public static final String DAMAGE_SOURCE_HIT = "immersiverailroading:hitByTrain";
    public static final String DAMAGE_SOURCE_HIT_IN_DARKNESS = "immersiverailroading:hitByTrainInDarkness";
    @TagField(value="frontYaw")
    private Float frontYaw;
    @TagField(value="rearYaw")
    private Float rearYaw;
    @TagField(value="distanceTraveled")
    public double distanceTraveled = 0.0;
    private Speed currentSpeed;
    @TagField(value="positions", mapper=TickPos.ListTagMapper.class)
    public List<TickPos> positions = new ArrayList<TickPos>();
    public List<SimulationState> states = new ArrayList<SimulationState>();
    private RealBB boundingBox;
    private float[][] heightMapCache;
    @TagSync
    @TagField(value="IND_BRAKE")
    private float independentBrake = 0.0f;
    @TagSync
    @TagField(value="BRAKE_PRESSURE")
    private float trainBrakePressure = 0.0f;
    @TagSync
    @TagField(value="SLIDING")
    public boolean sliding = false;
    public long lastCollision = 0L;
    public boolean newlyPlaced = false;

    @Override
    public void load(TagCompound data) {
        super.load(data);
        if (this.frontYaw == null) {
            this.frontYaw = Float.valueOf(this.getRotationYaw());
        }
        if (this.rearYaw == null) {
            this.rearYaw = Float.valueOf(this.getRotationYaw());
        }
    }

    public void initPositions(TickPos tp) {
        this.positions = new ArrayList<TickPos>();
        this.positions.add(tp);
    }

    public void clearHeightMap() {
        this.heightMapCache = null;
        this.boundingBox = null;
    }

    private float[][] getHeightMap() {
        if (this.heightMapCache == null) {
            this.heightMapCache = this.getDefinition().createHeightMap(this);
        }
        return this.heightMapCache;
    }

    public RealBB getCollision() {
        if (this.boundingBox == null) {
            this.boundingBox = this.getDefinition().getBounds(this.getRotationYaw(), this.gauge).offset(this.getPosition()).withHeightMap(this.getHeightMap()).contract(new Vec3d(0.0, 0.5 * this.gauge.scale(), 0.0)).offset(new Vec3d(0.0, 0.5 * this.gauge.scale(), 0.0));
        }
        return this.boundingBox;
    }

    public Speed getCurrentSpeed() {
        if (this.currentSpeed == null) {
            Vec3d motion = this.getVelocity();
            float speed = (float)Math.sqrt(motion.x * motion.x + motion.y * motion.y + motion.z * motion.z);
            if (Float.isNaN(speed)) {
                speed = 0.0f;
            }
            this.currentSpeed = Speed.fromMinecraft(speed);
        }
        return this.currentSpeed;
    }

    public void setCurrentSpeed(Speed newSpeed) {
        this.currentSpeed = newSpeed;
    }

    public void handleTickPosPacket(List<TickPos> newPositions) {
        if (newPositions.size() != 0) {
            this.clearPositionCache();
            if (ChronoState.getState(this.getWorld()) == null) {
                this.positions.clear();
            } else {
                int tickID = (int)Math.floor(ChronoState.getState(this.getWorld()).getTickID());
                List newIds = newPositions.stream().map(p -> p.tickID).collect(Collectors.toList());
                this.positions.removeAll(this.positions.stream().filter(p -> p.tickID < tickID - 30 || p.tickID > tickID + 60 || newIds.contains(p.tickID)).collect(Collectors.toList()));
            }
            this.positions.addAll(newPositions);
        }
    }

    public SimulationState getCurrentState() {
        int tickID = ServerChronoState.getState(this.getWorld()).getServerTickID();
        for (SimulationState state : this.states) {
            if (state.tickID != tickID) continue;
            return state;
        }
        return null;
    }

    public TickPos getTickPos() {
        if (ChronoState.getState(this.getWorld()) == null) {
            return null;
        }
        double tick = ChronoState.getState(this.getWorld()).getTickID();
        int currentTickID = (int)Math.floor(tick);
        int nextTickID = (int)Math.ceil(tick);
        TickPos current = null;
        TickPos next = null;
        for (TickPos position : this.positions) {
            if (position.tickID == currentTickID) {
                current = position;
            }
            if (position.tickID == nextTickID) {
                next = position;
            }
            if (current == null || next == null) continue;
            break;
        }
        if (current == null) {
            return null;
        }
        if (next == null || current == next || this.getWorld().isServer) {
            return current;
        }
        return TickPos.skew(current, next, tick);
    }

    @Override
    public void onDrag(Control<?> control, double newValue) {
        super.onDrag(control, newValue);
        switch (control.part.type) {
            case INDEPENDENT_BRAKE_X: {
                if (!this.getDefinition().isLinearBrakeControl()) break;
                this.setIndependentBrake(this.getControlPosition(control));
            }
        }
    }

    @Override
    public void onDragRelease(Control<?> control) {
        super.onDragRelease(control);
        if (!this.getDefinition().isLinearBrakeControl() && control.part.type == ModelComponentType.INDEPENDENT_BRAKE_X) {
            this.setControlPosition(control, 0.5f);
        }
    }

    @Override
    protected float defaultControlPosition(Control<?> control) {
        switch (control.part.type) {
            case INDEPENDENT_BRAKE_X: {
                return this.getDefinition().isLinearBrakeControl() ? 0.0f : 0.5f;
            }
        }
        return super.defaultControlPosition(control);
    }

    @Override
    public void onTick() {
        TickPos currentPos;
        super.onTick();
        if (this.getWorld().isServer) {
            SimulationState state;
            if (this.getDefinition().hasIndependentBrake()) {
                for (Control<?> control : this.getDefinition().getModel().getControls()) {
                    if (this.getDefinition().isLinearBrakeControl() || control.part.type != ModelComponentType.INDEPENDENT_BRAKE_X) continue;
                    this.setIndependentBrake(Math.max(0.0f, Math.min(1.0f, this.getIndependentBrake() + (this.getControlPosition(control) - 0.5f) / 8.0f)));
                }
            }
            if ((state = this.getCurrentState()) != null) {
                this.trainBrakePressure = state.brakePressure;
                this.sliding = state.sliding;
                if (state.collided > 0.1 && (long)this.getTickCount() - this.lastCollision > 20L) {
                    this.lastCollision = this.getTickCount();
                    new SoundPacket(this.getDefinition().collision_sound, this.getPosition(), this.getVelocity(), (float)Math.min(1.0, state.collided), 1.0f, (int)(100.0 * this.gauge.scale()), this.soundScale(), SoundPacket.PacketSoundCategory.COLLISION).sendToObserving((Entity)this);
                }
                for (Vec3i bp : state.blocksToBreak) {
                    this.getWorld().breakBlock(bp, Config.ConfigDamage.dropSnowBalls || !this.getWorld().isSnow(bp));
                }
                for (Vec3i bp : state.trackToUpdate) {
                    TileRailBase te = (TileRailBase)this.getWorld().getBlockEntity(bp, TileRailBase.class);
                    if (te == null) continue;
                    te.cleanSnow();
                    te.stockOverhead(this);
                }
            }
        }
        if (this.getWorld().isClient) {
            this.getDefinition().getModel().onClientTick(this);
        }
        if ((currentPos = this.getTickPos()) == null) {
            return;
        }
        Vec3d vec3d = this.getPosition();
        double prevPosX = vec3d.x;
        double prevPosY = vec3d.y;
        double prevPosZ = vec3d.z;
        this.setRotationYaw(currentPos.rotationYaw);
        this.setRotationPitch(currentPos.rotationPitch);
        this.frontYaw = Float.valueOf(currentPos.frontYaw);
        this.rearYaw = Float.valueOf(currentPos.rearYaw);
        this.currentSpeed = currentPos.speed;
        if (!this.sliding) {
            this.distanceTraveled += (double)((float)this.currentSpeed.minecraft() * this.getTickSkew());
            this.distanceTraveled %= 32000.0;
        }
        this.setPosition(currentPos.position);
        this.setVelocity(this.getPosition().subtract(prevPosX, prevPosY, prevPosZ));
        if (this.getVelocity().length() > 0.001) {
            this.clearPositionCache();
        }
        if (Math.abs(this.getCurrentSpeed().metric()) > 1.0) {
            List entitiesWithin = this.getWorld().getEntities(entity -> (entity.isLiving() || entity.isPlayer()) && this.getCollision().intersects(entity.getBounds()), Entity.class);
            for (Entity entity2 : entitiesWithin) {
                if (entity2 instanceof EntityMoveableRollingStock || entity2.getRiding() instanceof EntityMoveableRollingStock || entity2.isPlayer() && entity2.getTickCount() < 100 || !this.getCollision().intersects(entity2.getBounds())) continue;
                entity2.setVelocity(this.getVelocity().scale(2.0));
                double speedDamage = Math.abs(this.getCurrentSpeed().metric()) / Config.ConfigDamage.entitySpeedDamage;
                if (!(speedDamage > 1.0)) continue;
                boolean isBlockDark = (double)this.getWorld().getBlockLightLevel(entity2.getBlockPosition()) < 0.5;
                boolean isNightime = this.getWorld().getTime() > 13000L && this.getWorld().getTime() < 23000L;
                boolean isDark = isBlockDark && isNightime;
                entity2.directDamage(isDark ? DAMAGE_SOURCE_HIT_IN_DARKNESS : DAMAGE_SOURCE_HIT, speedDamage);
            }
            RealBB bb = this.getCollision().offset(new Vec3d(0.0, this.gauge.scale() * 2.0, 0.0));
            List entitiesAbove = this.getWorld().getEntities(entity -> (entity.isLiving() || entity.isPlayer()) && bb.intersects(entity.getBounds()), Entity.class);
            for (Entity entity3 : entitiesAbove) {
                if (entity3 instanceof EntityMoveableRollingStock || entity3.getRiding() instanceof EntityMoveableRollingStock || !bb.intersects(entity3.getBounds())) continue;
                entity3.setVelocity(this.getVelocity().add(0.0, entity3.getVelocity().y, 0.0));
            }
        }
        if (this.getWorld().isServer) {
            this.setControlPosition("MOVINGFORWARD", this.getCurrentSpeed().minecraft() > 0.0 ? 1.0f : 0.0f);
            this.setControlPosition("NOTMOVING", this.getCurrentSpeed().minecraft() == 0.0 ? 1.0f : 0.0f);
            this.setControlPosition("MOVINGBACKWARD", this.getCurrentSpeed().minecraft() < 0.0 ? 1.0f : 0.0f);
        }
    }

    protected void clearPositionCache() {
        this.boundingBox = null;
    }

    public float getFrontYaw() {
        if (this.frontYaw != null) {
            return this.frontYaw.floatValue();
        }
        return this.getRotationYaw();
    }

    public void setFrontYaw(float frontYaw) {
        this.frontYaw = Float.valueOf(frontYaw);
    }

    public float getRearYaw() {
        if (this.rearYaw != null) {
            return this.rearYaw.floatValue();
        }
        return this.getRotationYaw();
    }

    public void setRearYaw(float rearYaw) {
        this.rearYaw = Float.valueOf(rearYaw);
    }

    public float getTickSkew() {
        ChronoState state = ChronoState.getState(this.getWorld());
        return state != null ? (float)state.getTickSkew() : 1.0f;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.getWorld().isClient) {
            this.getDefinition().getModel().onClientRemoved(this);
        }
    }

    @Override
    public void handleKeyPress(Player source, KeyTypes key, boolean disableIndependentThrottle) {
        float independentBrakeNotch = 0.04f;
        if (source.hasPermission(Permissions.BRAKE_CONTROL)) {
            switch (key) {
                case INDEPENDENT_BRAKE_UP: {
                    this.setIndependentBrake(this.getIndependentBrake() + independentBrakeNotch);
                    break;
                }
                case INDEPENDENT_BRAKE_ZERO: {
                    this.setIndependentBrake(0.0f);
                    break;
                }
                case INDEPENDENT_BRAKE_DOWN: {
                    this.setIndependentBrake(this.getIndependentBrake() - independentBrakeNotch);
                    break;
                }
                default: {
                    super.handleKeyPress(source, key, disableIndependentThrottle);
                    break;
                }
            }
        } else {
            super.handleKeyPress(source, key, disableIndependentThrottle);
        }
    }

    public float getIndependentBrake() {
        return this.getDefinition().hasIndependentBrake() ? this.independentBrake : 0.0f;
    }

    public void setIndependentBrake(float newIndependentBrake) {
        newIndependentBrake = Math.min(1.0f, Math.max(0.0f, newIndependentBrake));
        if (this.getIndependentBrake() != newIndependentBrake && this.getDefinition().hasIndependentBrake()) {
            if (this.getDefinition().isLinearBrakeControl()) {
                this.setControlPositions(ModelComponentType.INDEPENDENT_BRAKE_X, newIndependentBrake);
            }
            this.independentBrake = newIndependentBrake;
        }
    }

    public float getBrakePressure() {
        return this.trainBrakePressure;
    }

    @Deprecated
    public TickPos getCurrentTickPosAndPrune() {
        return this.getTickPos();
    }

    public double getBrakeSystemEfficiency() {
        return this.getDefinition().getBrakeShoeFriction();
    }

    public boolean isSliding() {
        return this.sliding;
    }

    public double getDirectFrictionNewtons(List<Vec3i> track) {
        double newtons = this.getWeight() * 9.8;
        double retardedNewtons = 0.0;
        for (Vec3i bp : track) {
            TileRailBase te = (TileRailBase)this.getWorld().getBlockEntity(bp, TileRailBase.class);
            if (te == null || te.getAugment() != Augment.SPEED_RETARDER) continue;
            double red = this.getWorld().getRedstone(bp);
            retardedNewtons += red / 15.0 / (double)track.size() * newtons;
        }
        double independentNewtons = this.getDefinition().directFrictionCoefficient * (double)this.getIndependentBrake() * newtons;
        double pressureNewtons = this.getDefinition().directFrictionCoefficient * (double)this.getBrakePressure() * newtons;
        return retardedNewtons + independentNewtons + pressureNewtons;
    }

    public double getBrakeAdhesionEfficiency() {
        return 1.0;
    }
}

