/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.waila;

import bletch.common.utils.StringUtils;
import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.entities.EntityArchitect;
import net.tangotek.tektopia.entities.EntityGuard;
import net.tangotek.tektopia.entities.EntityMerchant;
import net.tangotek.tektopia.entities.EntityTradesman;
import net.tangotek.tektopia.entities.EntityVillagerTek;

@ParametersAreNonnullByDefault
public class TektopiaEntityWaila
implements IWailaEntityProvider {
    private static String NBT_TAG_BEDPOSITION = "bedPosition";
    private static String NBT_TAG_DAYSALIVE = "daysAlive";
    private static String NBT_TAG_HASVILLAGE = "hasVillage";
    private static String NBT_TAG_VILLAGENAME = "villageName";

    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return accessor.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> currentTip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (entity instanceof EntityVillagerTek) {
            EntityVillagerTek villager = (EntityVillagerTek)entity;
            String tooltip = TextFormatting.RESET.toString();
            ITextComponent textComponent = villager.func_145748_c_();
            if (villager.getProfessionType() == null || textComponent.func_150254_d() == null) {
                textComponent = null;
            }
            if (textComponent != null) {
                String villagerName = textComponent.func_150254_d();
                tooltip = tooltip + villagerName;
            } else {
                String villagerName = villager.func_70005_c_();
                if (villager instanceof EntityGuard && ((EntityGuard)villager).isCaptain()) {
                    String profession = TextUtils.translate("entity.captain.name", new Object[0]);
                    villagerName = profession + " " + villagerName;
                }
                tooltip = tooltip + TextFormatting.WHITE + villagerName;
            }
            tooltip = villager.isMale() ? tooltip + " " + TextUtils.SYMBOL_MALE : tooltip + " " + TextUtils.SYMBOL_FEMALE;
            if (!StringUtils.isNullOrWhitespace(tooltip).booleanValue() && !tooltip.equalsIgnoreCase(TextFormatting.RESET.toString())) {
                if (currentTip.size() > 0) {
                    currentTip.set(0, tooltip);
                } else {
                    currentTip.add(tooltip);
                }
            } else if (currentTip.size() > 0) {
                currentTip.remove(0);
            }
        }
        return currentTip;
    }

    public List<String> getWailaBody(Entity entity, List<String> currentTip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (ModConfig.waila.useSneaking && !accessor.getPlayer().func_70093_af()) {
            return currentTip;
        }
        if (!ModConfig.waila.entities.showEntityInformation) {
            return currentTip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        String output = "";
        if (entity instanceof EntityVillagerTek) {
            EntityVillagerTek villager = (EntityVillagerTek)entity;
            boolean showVillageDetails = false;
            if (entity instanceof EntityArchitect) {
                output = TextUtils.translate("entity.architect.name", new Object[0]);
                currentTip.add(TextFormatting.DARK_AQUA + output);
                float health = villager.func_110143_aJ();
                output = TextUtils.translate("gui.villager.health", new Object[0]) + " " + TextFormatting.WHITE + health;
                currentTip.add(TextFormatting.DARK_AQUA + output);
                showVillageDetails = true;
            } else if (entity instanceof EntityMerchant) {
                output = TextUtils.translate("entity.merchant.name", new Object[0]);
                currentTip.add(TextFormatting.DARK_AQUA + output);
            } else if (entity instanceof EntityTradesman) {
                output = TextUtils.translate("entity.tradesman.name", new Object[0]);
                currentTip.add(TextFormatting.DARK_AQUA + output);
                float health = villager.func_110143_aJ();
                output = TextUtils.translate("gui.villager.health", new Object[0]) + " " + TextFormatting.WHITE + health;
                currentTip.add(TextFormatting.DARK_AQUA + output);
                showVillageDetails = true;
            } else if (villager.getProfessionType() != null) {
                String profession = "";
                int professionSkillLevel = 0;
                ProfessionType professionType = villager.getProfessionType();
                switch (professionType) {
                    case CHILD: 
                    case NITWIT: {
                        output = profession = TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                        currentTip.add(TextFormatting.DARK_AQUA + output);
                        showVillageDetails = true;
                        break;
                    }
                    case NOMAD: {
                        output = profession = TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                        currentTip.add(TextFormatting.DARK_AQUA + output);
                        break;
                    }
                    case GUARD: {
                        int professionBaseSkillLevel;
                        profession = villager instanceof EntityGuard && ((EntityGuard)villager).isCaptain() ? TextUtils.translate("entity." + ProfessionType.CAPTAIN.name + ".name", new Object[0]) : TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                        professionSkillLevel = villager.getSkill(professionType);
                        output = profession;
                        if (professionSkillLevel > 0) {
                            if (villager.getBlessed() > 0) {
                                professionBaseSkillLevel = villager.getBaseSkill(professionType);
                                output = output + " - level " + TextFormatting.GREEN + professionSkillLevel + TextFormatting.WHITE + " (" + professionBaseSkillLevel + ")";
                            } else {
                                output = output + " - level " + TextFormatting.WHITE + professionSkillLevel;
                            }
                        }
                        currentTip.add(TextFormatting.DARK_AQUA + output);
                        showVillageDetails = true;
                        break;
                    }
                    default: {
                        int professionBaseSkillLevel;
                        profession = TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                        professionSkillLevel = villager.getSkill(professionType);
                        output = profession;
                        if (professionSkillLevel > 0) {
                            if (villager.getBlessed() > 0) {
                                professionBaseSkillLevel = villager.getBaseSkill(professionType);
                                output = output + " - level " + TextFormatting.GREEN + professionSkillLevel + TextFormatting.WHITE + " (" + professionBaseSkillLevel + ")";
                            } else {
                                output = output + " - level " + TextFormatting.WHITE + professionSkillLevel;
                            }
                        }
                        currentTip.add(TextFormatting.DARK_AQUA + output);
                        showVillageDetails = true;
                    }
                }
                int daysAlive = villager.getDaysAlive();
                if (daysAlive <= 0 && tag.func_74764_b(NBT_TAG_DAYSALIVE)) {
                    daysAlive = tag.func_74762_e(NBT_TAG_DAYSALIVE);
                }
                if (daysAlive > 0) {
                    output = TextUtils.translate("gui.villager.daysalive", new Object[0]) + " " + TextFormatting.WHITE + daysAlive;
                    currentTip.add(TextFormatting.DARK_AQUA + output);
                }
                float health = villager.func_110143_aJ();
                output = TextUtils.translate("gui.villager.health", new Object[0]) + " " + TextFormatting.WHITE + health;
                currentTip.add(TextFormatting.DARK_AQUA + output);
                int hunger = villager.getHunger();
                output = TextUtils.translate("gui.villager.hunger", new Object[0]) + " " + TextFormatting.WHITE + hunger;
                currentTip.add(TextFormatting.DARK_AQUA + output);
                int happy = villager.getHappy();
                output = TextUtils.translate("gui.villager.happy", new Object[0]) + " " + TextFormatting.WHITE + happy;
                currentTip.add(TextFormatting.DARK_AQUA + output);
                int intelligence = villager.getIntelligence();
                output = TextUtils.translate("gui.villager.intelligence", new Object[0]) + " " + TextFormatting.WHITE + intelligence;
                currentTip.add(TextFormatting.DARK_AQUA + output);
                int blessed = villager.getBlessed();
                if (blessed > 0) {
                    output = TextUtils.translate("gui.villager.blessedlevels", new Object[0]) + " " + TextFormatting.WHITE + blessed;
                    currentTip.add(TextFormatting.DARK_AQUA + output);
                }
                boolean addProfessionCountShown = false;
                for (ProfessionType addProfessionType : TektopiaUtils.getProfessionTypes()) {
                    if (addProfessionType == villager.getProfessionType()) continue;
                    profession = TextUtils.translate("entity." + addProfessionType.name + ".name", new Object[0]);
                    professionSkillLevel = villager.getSkill(addProfessionType);
                    if (professionSkillLevel <= 0) continue;
                    if (!addProfessionCountShown) {
                        output = TextUtils.translate("gui.villager.additionalprofessions", new Object[0]);
                        currentTip.add(TextFormatting.WHITE + output);
                        addProfessionCountShown = true;
                    }
                    output = "\u2022 " + profession + " - " + TextFormatting.WHITE + professionSkillLevel;
                    currentTip.add(TextFormatting.DARK_AQUA + output);
                }
            }
            if (showVillageDetails) {
                Village village = villager.getVillage();
                if (village != null) {
                    String villageName = village.getName();
                    output = TextUtils.translate("gui.villager.villagename", new Object[0]) + " " + TextFormatting.WHITE + villageName;
                    currentTip.add(TextFormatting.DARK_AQUA + output);
                    boolean hasBed = villager.getBedPos() != null;
                    output = TextUtils.translate("gui.villager.hasbed", new Object[0]) + " " + TextFormatting.WHITE + (hasBed ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                    currentTip.add(TextFormatting.DARK_AQUA + output);
                } else if (tag.func_74764_b(NBT_TAG_HASVILLAGE)) {
                    String villageName = tag.func_74764_b(NBT_TAG_VILLAGENAME) ? tag.func_74779_i(NBT_TAG_VILLAGENAME) : "";
                    output = TextUtils.translate("gui.villager.villagename", new Object[0]) + " " + TextFormatting.WHITE + villageName;
                    currentTip.add(TextFormatting.DARK_AQUA + output);
                    if (tag.func_74764_b(NBT_TAG_BEDPOSITION)) {
                        boolean hasBed = true;
                        output = TextUtils.translate("gui.villager.hasbed", new Object[0]) + " " + TextFormatting.WHITE + (hasBed ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                        currentTip.add(TextFormatting.DARK_AQUA + output);
                    }
                }
            }
        }
        return currentTip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currentTip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        entity.func_189511_e(tag);
        if (entity instanceof EntityVillagerTek) {
            tag.func_74768_a(NBT_TAG_DAYSALIVE, ((EntityVillagerTek)entity).getDaysAlive());
            tag.func_74757_a(NBT_TAG_HASVILLAGE, ((EntityVillagerTek)entity).hasVillage());
            if (((EntityVillagerTek)entity).hasVillage()) {
                Village village = ((EntityVillagerTek)entity).getVillage();
                tag.func_74778_a(NBT_TAG_VILLAGENAME, village.getName());
                if (((EntityVillagerTek)entity).getBedPos() != null) {
                    tag.func_74772_a(NBT_TAG_BEDPOSITION, ((EntityVillagerTek)entity).getBedPos().func_177986_g());
                }
            }
        }
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        TektopiaEntityWaila entityProvider = new TektopiaEntityWaila();
        ArrayList<String> processed = new ArrayList<String>();
        for (Class<?> entity : TektopiaEntityWaila.getTektopiaEntities()) {
            String key = entity.getTypeName();
            if (processed.contains(key)) continue;
            processed.add(key);
            registrar.registerNBTProvider((IWailaEntityProvider)entityProvider, entity);
            registrar.registerHeadProvider((IWailaEntityProvider)entityProvider, entity);
            registrar.registerBodyProvider((IWailaEntityProvider)entityProvider, entity);
            if (!ModConfig.debug.enableDebug || !ModConfig.debug.showWailaEntitiesRegistered) continue;
            LoggerUtils.instance.writeLine("Registered WAILA information for entity " + key, true);
        }
    }

    private static ArrayList<Class<?>> getTektopiaEntities() {
        ArrayList list = new ArrayList();
        list.add(EntityVillagerTek.class);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.contains(((Class)list.get(i)).getSuperclass())) continue;
            list.remove(i);
        }
        list.sort(Comparator.comparing(Class::getTypeName));
        list.trimToSize();
        return list;
    }
}

