/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.top;

import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.core.ModConfig;
import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TektopiaBlockTop {

    public static class getTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static final String KEY_SUFFIX_DESCRIPTION = ".description";
        public static final String KEY_SUFFIX_TOOLTIP = ".tooltip";
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "tektopiainformation:default";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
                    Block block = state.func_177230_c();
                    if (block.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")) {
                        getTheOneProbe.addProbeInfo(mode, probeInfo, player, world, state, data);
                    }
                }
            });
            probe.registerBlockDisplayOverride((mode, probeInfo, player, world, state, data) -> {
                Block block = state.func_177230_c();
                if (block.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")) {
                    return getTheOneProbe.overrideStandardInfo(mode, probeInfo, player, world, state, data);
                }
                return false;
            });
            return null;
        }

        private static boolean addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
            List<String> value;
            if (ModConfig.top.useSneaking && mode == ProbeMode.NORMAL) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            ItemStack itemStack = data.getPickBlock();
            if (!itemStack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")) {
                itemStack = tileEntity != null ? new ItemStack(state.func_177230_c(), 1, tileEntity.func_145832_p()) : new ItemStack(state.func_177230_c());
            }
            if (ModConfig.top.blocks.showBlockTooltip) {
                String translateKey_tooltip = itemStack.func_77977_a() + KEY_SUFFIX_TOOLTIP;
                if (ModConfig.debug.enableDebug && ModConfig.debug.showTopBlockTranslationKey) {
                    probeInfo.text(TextUtils.translate("gui.translationkey", new Object[0]) + " " + translateKey_tooltip);
                }
                if ((value = TextUtils.translateMulti(translateKey_tooltip, new Object[0])) != null && value.size() > 0) {
                    value.forEach(v -> probeInfo.text(v));
                }
            }
            if (ModConfig.top.blocks.showBlockInformation) {
                String translateKey_description = itemStack.func_77977_a() + KEY_SUFFIX_DESCRIPTION;
                if (ModConfig.debug.enableDebug && ModConfig.debug.showTopBlockTranslationKey) {
                    probeInfo.text(TextUtils.translate("gui.translationkey", new Object[0]) + " " + translateKey_description);
                }
                if ((value = TextUtils.translateMulti(translateKey_description, new Object[0])) != null && value.size() > 0) {
                    value.forEach(v -> probeInfo.text(v));
                }
            }
            return true;
        }

        private static boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
            return false;
        }
    }
}

