/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.ModIdentification;
import bletch.tektopiainformation.TektopiaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.entities.EntityVillageNavigator;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class EntityData {
    protected static final String NBTTAG_VILLAGE_ENTITYID = "id";
    protected static final String NBTTAG_VILLAGE_ENTITYCLASSNAME = "class";
    protected static final String NBTTAG_VILLAGE_ENTITYMODID = "modid";
    protected static final String NBTTAG_VILLAGE_ENTITYNAME = "name";
    protected static final String NBTTAG_VILLAGE_ENTITYLEVEL = "lvl";
    protected static final String NBTTAG_VILLAGE_ENTITYHEALTH = "health";
    protected static final String NBTTAG_VILLAGE_ENTITYMAXHEALTH = "maxhealth";
    protected static final String NBTTAG_VILLAGE_ENTITYHOMEPOSITION = "home";
    protected static final String NBTTAG_VILLAGE_ENTITYCURRENTPOSITION = "pos";
    protected static final String NBTTAG_VILLAGE_ENTITYTOTALARMOR = "armor";
    protected static final String NBTTAG_VILLAGE_ENTITYARMOR = "armorlist";
    protected static final String NBTTAG_VILLAGE_ENTITYEQUIPMENT = "equiplist";
    protected static List<Entity> entityList = null;
    protected int id;
    protected String className;
    protected String modId;
    protected String name;
    protected int level;
    protected float health;
    protected float maxHealth;
    protected BlockPos homePosition;
    protected BlockPos currentPosition;
    protected int totalArmorValue;
    protected List<ItemStack> armor = null;
    protected List<ItemStack> equipment = null;

    protected EntityData() {
        this.clearData();
    }

    protected EntityData(EntityVillageNavigator entity, Boolean populateEntity) {
        this.clearData();
        if (populateEntity.booleanValue()) {
            this.populateData(entity);
        }
    }

    protected EntityData(NBTTagCompound nbtTag) {
        this.readNBT(nbtTag);
    }

    public int getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getModId() {
        return this.modId;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public BlockPos getCurrentPosition() {
        return this.currentPosition;
    }

    public int getTotalArmorValue() {
        return this.totalArmorValue;
    }

    public List<ItemStack> getArmor() {
        return Collections.unmodifiableList(this.armor == null ? new ArrayList() : this.armor);
    }

    public List<ItemStack> getEquipment() {
        return Collections.unmodifiableList(this.equipment == null ? new ArrayList() : this.equipment);
    }

    public EntityVillageNavigator getVillagerEntity() {
        if (entityList != null && entityList.size() > 0) {
            return entityList.stream().filter(e -> e instanceof EntityVillagerTek && e.func_145782_y() == this.id).findFirst().orElse(null);
        }
        return null;
    }

    protected void clearData() {
        this.id = 0;
        this.className = "";
        this.modId = "tektopiainformation";
        this.name = "";
        this.level = 0;
        this.health = 0.0f;
        this.maxHealth = 20.0f;
        this.homePosition = null;
        this.currentPosition = null;
        this.totalArmorValue = 0;
        this.armor = new ArrayList<ItemStack>();
        this.equipment = new ArrayList<ItemStack>();
    }

    protected void populateData(EntityVillageNavigator entity) {
        if (entity != null) {
            this.id = entity.func_145782_y();
            this.className = entity.getClass().getSimpleName().toLowerCase();
            this.modId = ModIdentification.getEntityModId((Entity)entity);
            this.level = 1;
            this.name = entity.func_70005_c_();
            this.health = entity.func_110143_aJ();
            this.maxHealth = entity.func_110138_aP();
            this.currentPosition = entity.func_180425_c();
            this.totalArmorValue = entity.func_70658_aO();
            this.armor.addAll((Collection)entity.func_184193_aE());
            this.equipment.addAll((Collection)entity.func_184214_aD());
            this.equipment.removeIf(i -> i == null || i.func_190926_b());
        }
    }

    public void readNBT(NBTTagCompound nbtTag) {
        int index;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.id = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYID) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_ENTITYID) : 0;
        this.className = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYCLASSNAME) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_ENTITYCLASSNAME) : "";
        this.modId = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYMODID) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_ENTITYMODID) : "tektopiainformation";
        this.name = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYNAME) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_ENTITYNAME) : "";
        this.level = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYLEVEL) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_ENTITYLEVEL) : 0;
        this.health = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYHEALTH) ? nbtTag.func_74760_g(NBTTAG_VILLAGE_ENTITYHEALTH) : 0.0f;
        this.maxHealth = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYMAXHEALTH) ? nbtTag.func_74760_g(NBTTAG_VILLAGE_ENTITYMAXHEALTH) : 0.0f;
        this.homePosition = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYHOMEPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_ENTITYHOMEPOSITION)) : null;
        this.currentPosition = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYCURRENTPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_ENTITYCURRENTPOSITION)) : null;
        int n = this.totalArmorValue = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYTOTALARMOR) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_ENTITYTOTALARMOR) : 0;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYARMOR)) {
            NBTTagList nbtTagListArmor = nbtTag.func_150295_c(NBTTAG_VILLAGE_ENTITYARMOR, 10);
            this.armor = new ArrayList<ItemStack>(nbtTagListArmor.func_74745_c());
            for (index = 0; index < nbtTagListArmor.func_74745_c(); ++index) {
                NBTTagCompound nbtTagArmorItem = nbtTagListArmor.func_150305_b(index);
                if (nbtTagArmorItem.func_82582_d()) {
                    this.armor.add(ItemStack.field_190927_a);
                    continue;
                }
                this.armor.add(new ItemStack(nbtTagArmorItem));
            }
            Collections.reverse(this.armor);
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_ENTITYEQUIPMENT)) {
            NBTTagList nbtTagListEquipment = nbtTag.func_150295_c(NBTTAG_VILLAGE_ENTITYEQUIPMENT, 10);
            this.equipment = new ArrayList<ItemStack>(nbtTagListEquipment.func_74745_c());
            for (index = 0; index < nbtTagListEquipment.func_74745_c(); ++index) {
                this.equipment.add(new ItemStack(nbtTagListEquipment.func_150305_b(index)));
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        nbtTag.func_74768_a(NBTTAG_VILLAGE_ENTITYID, this.id);
        nbtTag.func_74778_a(NBTTAG_VILLAGE_ENTITYCLASSNAME, this.className);
        nbtTag.func_74778_a(NBTTAG_VILLAGE_ENTITYMODID, this.modId);
        nbtTag.func_74778_a(NBTTAG_VILLAGE_ENTITYNAME, this.name);
        if (this.level > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_ENTITYLEVEL, this.level);
        }
        if (this.health > 0.0f) {
            nbtTag.func_74776_a(NBTTAG_VILLAGE_ENTITYHEALTH, this.health);
        }
        if (this.maxHealth > 0.0f) {
            nbtTag.func_74776_a(NBTTAG_VILLAGE_ENTITYMAXHEALTH, this.maxHealth);
        }
        if (this.homePosition != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_ENTITYHOMEPOSITION, this.homePosition.func_177986_g());
        }
        if (this.currentPosition != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_ENTITYCURRENTPOSITION, this.currentPosition.func_177986_g());
        }
        if (this.totalArmorValue > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_ENTITYTOTALARMOR, this.totalArmorValue);
        }
        if (this.armor != null && this.armor.size() > 0) {
            NBTTagList nbtTagListArmor = new NBTTagList();
            int emptyCount = 0;
            for (ItemStack itemStack : this.armor) {
                if (itemStack == null) continue;
                if (itemStack.func_190926_b()) {
                    nbtTagListArmor.func_74742_a((NBTBase)new NBTTagCompound());
                    ++emptyCount;
                    continue;
                }
                NBTTagCompound nbtTagArmorItem = itemStack.func_77955_b(new NBTTagCompound());
                nbtTagListArmor.func_74742_a((NBTBase)nbtTagArmorItem);
            }
            if (emptyCount != nbtTagListArmor.func_74745_c() && !nbtTagListArmor.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_ENTITYARMOR, (NBTBase)nbtTagListArmor);
            }
        }
        if (this.equipment != null && this.equipment.size() > 0) {
            NBTTagList nbtTagListEquipment = new NBTTagList();
            for (ItemStack itemStack : this.equipment) {
                NBTTagCompound nbtTagEquipmentItem;
                if (itemStack == null || itemStack.func_190926_b() || (nbtTagEquipmentItem = itemStack.func_77955_b(new NBTTagCompound())).func_82582_d()) continue;
                nbtTagListEquipment.func_74742_a((NBTBase)nbtTagEquipmentItem);
            }
            if (!nbtTagListEquipment.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_ENTITYEQUIPMENT, (NBTBase)nbtTagListEquipment);
            }
        }
        return nbtTag;
    }

    public static void resetEntityList() {
        entityList = null;
        if (TektopiaInformation.proxy.isRemote()) {
            entityList = Minecraft.func_71410_x().field_71441_e.func_72910_y();
        }
    }
}

