/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.gui;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class GuiTooltip {
    private int left;
    private int top;
    private int leftOffset = 0;
    private int topOffset = 0;
    private int width;
    private int height;
    private final List<String> tooltip;

    public GuiTooltip(int left, int top, int width, int height, List<String> tooltip) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.tooltip = tooltip;
    }

    public GuiTooltip(int left, int top, int leftOffset, int topOffset, int width, int height, List<String> tooltip) {
        this.left = left;
        this.top = top;
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
        this.width = width;
        this.height = height;
        this.tooltip = tooltip;
    }

    public GuiTooltip(int left, int top, int width, int height, String tooltip) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.tooltip = Arrays.asList(tooltip);
    }

    public GuiTooltip(int left, int top, int leftOffset, int topOffset, int width, int height, String tooltip) {
        this.left = left;
        this.top = top;
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
        this.width = width;
        this.height = height;
        this.tooltip = Arrays.asList(tooltip);
    }

    public GuiTooltip addPosition(BlockPos position) {
        this.left += position.func_177958_n();
        this.top += position.func_177952_p();
        return this;
    }

    public int getLeft() {
        return this.left + this.leftOffset;
    }

    public int getTop() {
        return this.top + this.topOffset;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRight() {
        return this.getLeft() + this.width;
    }

    public int getBottom() {
        return this.getTop() + this.height;
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }

    public GuiTooltip multiplyPosition(int factor) {
        this.left *= factor;
        this.top *= factor;
        return this;
    }

    public GuiTooltip multipleOffset(int factor) {
        this.leftOffset *= factor;
        this.topOffset *= factor;
        return this;
    }

    public GuiTooltip multiplySize(int factor) {
        this.width *= factor;
        this.height *= factor;
        return this;
    }

    public GuiTooltip setPosition(int left, int top) {
        this.left = left;
        this.top = top;
        return this;
    }

    public GuiTooltip setPosition(BlockPos position) {
        this.left = position.func_177958_n();
        this.top = position.func_177952_p();
        return this;
    }

    public boolean withinBounds(int x, int y, float scale) {
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        return this.getLeft() <= scaledX && this.getTop() <= scaledY && this.getRight() >= scaledX && this.getBottom() >= scaledY;
    }
}

