/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.utility;

import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.utility.Logz;

public class JarExtract {
    public static final boolean DEVELOPMENT = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    public static int copy(String src, File dst) {
        if (DEVELOPMENT) {
            Logz.info("Running in a development environment, copying '%s' from assets folder", src);
            File srcFile = new File(CompactMachines3.class.getResource("/" + src).getFile());
            try {
                FileUtils.copyDirectory((File)srcFile, (File)dst);
            }
            catch (IOException e) {
                Logz.error("Error while copy files from development environment:", new Object[0]);
                e.printStackTrace();
            }
        } else {
            return JarExtract.extract(src, dst.getPath());
        }
        return -1;
    }

    private static int extract(String src, String dst) {
        URL srcUrl = CompactMachines3.class.getResource("/" + src);
        if (srcUrl == null || !srcUrl.getProtocol().equals("jar")) {
            Logz.error("Error while extracting files from jar: unable to get Resource URL for '%s'.", src);
            return 0;
        }
        int count = 0;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)srcUrl.openConnection();
            JarFile zipFile = jarURLConnection.getJarFile();
            Enumeration<? extends ZipEntry> zipEntries = ((ZipFile)zipFile).entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String zipName = zipEntry.getName();
                if (!zipName.startsWith(src)) continue;
                File dstFile = new File(dst + File.separator + zipName.substring(src.length()));
                if (zipEntry.isDirectory()) {
                    dstFile.mkdir();
                    continue;
                }
                InputStream inputStream = ((ZipFile)zipFile).getInputStream(zipEntry);
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dstFile));
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                inputStream.close();
                ((OutputStream)outputStream).close();
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }
}

