/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.music;

import CoroUtil.music.MusicPlayer;
import CoroUtil.music.NoteEntry;
import CoroUtil.music.NoteHelper;
import CoroUtil.music.Sequencer;
import java.util.ArrayList;
import java.util.List;

public class Melody {
    public Sequencer sequencer;
    public int ticksPlaying = 0;
    public List<NoteEntry> listNotes = new ArrayList<NoteEntry>();
    public int octive = 4;
    public int bar = 0;
    public int channel = 5;
    public int instrument = 100;
    public int velocity = 100;
    public float length = NoteHelper.NOTE_FULL;

    public Melody(Sequencer parSeq) {
        this.sequencer = parSeq;
    }

    public void setMidiData(int parChannel, int parInstrument) {
        this.channel = parChannel;
        this.instrument = parInstrument;
        MusicPlayer.mc[this.channel].programChange(0, MusicPlayer.instr[this.instrument].getPatch().getProgram());
    }

    public void addNote(int parNote, float parStart, float parLength) {
        NoteEntry note = new NoteEntry(parNote, parStart, parLength);
        this.listNotes.add(note);
    }

    public void tick() {
        for (int i = 0; i < this.listNotes.size(); ++i) {
            NoteEntry note = this.listNotes.get(i);
            if (this.ticksPlaying == this.getNoteStart(note)) {
                System.out.println("Start note! " + note.note);
                MusicPlayer.mc[this.channel].noteOn(this.octive * NoteHelper.NOTES_IN_OCTIVE + note.note, this.velocity);
            }
            if (this.ticksPlaying != this.getNoteEnd(note)) continue;
            System.out.println("End note! " + note.note);
            MusicPlayer.mc[this.channel].noteOff(this.octive * NoteHelper.NOTES_IN_OCTIVE + note.note);
        }
        if ((float)this.ticksPlaying == this.length * (float)NoteHelper.CONV_BEAT_TO_FASTEST_NOTE * (float)NoteHelper.CONV_BEAT_TO_TICK) {
            this.reset();
        } else {
            ++this.ticksPlaying;
        }
    }

    public void reset() {
        this.ticksPlaying = 0;
    }

    public void stop() {
        this.reset();
    }

    public int getNoteStart(NoteEntry parNote) {
        return (int)(parNote.start * (float)NoteHelper.CONV_BEAT_TO_FASTEST_NOTE * (float)NoteHelper.CONV_BEAT_TO_TICK);
    }

    public int getNoteEnd(NoteEntry parNote) {
        return (int)(parNote.start * (float)NoteHelper.CONV_BEAT_TO_FASTEST_NOTE * (float)NoteHelper.CONV_BEAT_TO_TICK) + (int)(parNote.length * (float)NoteHelper.CONV_BEAT_TO_FASTEST_NOTE * (float)NoteHelper.CONV_BEAT_TO_TICK);
    }
}

