/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox.entrys;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.signalbox.entrys.INetworkSavable;
import com.troblecodings.signals.signalbox.entrys.IPathEntry;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PathOptionEntry
implements INetworkSavable {
    private final Map<PathEntryType<?>, IPathEntry<?>> pathEntrys = new HashMap();

    public <T> Optional<T> getEntry(PathEntryType<T> type) {
        if (!this.pathEntrys.containsKey(type)) {
            return Optional.empty();
        }
        return Optional.of(this.pathEntrys.get(type).getValue());
    }

    public <T> void setEntry(PathEntryType<T> type, T value) {
        if (value == null) {
            this.pathEntrys.remove(type);
            return;
        }
        IPathEntry pathEntry = this.pathEntrys.computeIfAbsent(type, pType -> pType.newValue());
        pathEntry.setValue(value);
    }

    public void removeEntry(PathEntryType<?> type) {
        this.pathEntrys.remove(type);
    }

    public boolean containsEntry(PathEntryType<?> type) {
        return this.pathEntrys.containsKey(type);
    }

    public int hashCode() {
        return Objects.hash(this.pathEntrys);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PathOptionEntry other = (PathOptionEntry)obj;
        return Objects.equals(this.pathEntrys, other.pathEntrys);
    }

    public String toString() {
        return "PathOptionEntry [pathEntrys=" + this.pathEntrys + "]";
    }

    @Override
    public void write(NBTWrapper tag) {
        this.pathEntrys.forEach((type, option) -> {
            NBTWrapper entry = new NBTWrapper();
            option.write(entry);
            tag.putWrapper(type.getName(), entry);
        });
    }

    @Override
    public void read(NBTWrapper tag) {
        List<PathEntryType> tagSet = tag.keySet().stream().map(PathEntryType::getType).collect(Collectors.toList());
        tagSet.forEach(entry -> {
            if (entry != null) {
                if (tag.contains(entry.getName())) {
                    IPathEntry path = entry.newValue();
                    path.read(tag.getWrapper(entry.getName()));
                    this.pathEntrys.put((PathEntryType<?>)entry, path);
                } else {
                    this.pathEntrys.remove(entry);
                }
            }
        });
    }

    @Override
    public void readNetwork(ReadBuffer buffer) {
        int size = buffer.getByteToUnsignedInt();
        for (int i = 0; i < size; ++i) {
            PathEntryType<?> type = PathEntryType.ALL_ENTRIES.get(buffer.getByteToUnsignedInt());
            IPathEntry entry = this.pathEntrys.computeIfAbsent(type, _u -> type.newValue());
            entry.readNetwork(buffer);
            this.pathEntrys.put(type, entry);
        }
    }

    @Override
    public void writeNetwork(WriteBuffer buffer) {
        buffer.putByte((byte)this.pathEntrys.size());
        this.pathEntrys.forEach((type, entry) -> {
            buffer.putByte((byte)type.getID());
            entry.writeNetwork(buffer);
        });
    }

    public void writeUpdateNetwork(WriteBuffer builder) {
        builder.putByte((byte)1);
        builder.putByte((byte)PathEntryType.PATHUSAGE.getID());
        this.pathEntrys.get(PathEntryType.PATHUSAGE).writeNetwork(builder);
    }
}

