/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.core.ModeIdentifier;
import com.troblecodings.signals.enums.ShowSubsidiary;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import java.util.Objects;
import net.minecraft.util.math.BlockPos;

public class MainSignalIdentifier {
    public final ModeIdentifier identifier;
    public final BlockPos pos;
    public SignalState state = SignalState.RED;

    public MainSignalIdentifier(ModeIdentifier identifier, BlockPos pos, SignalState state) {
        this(identifier.point, identifier.mode, pos);
        this.state = state;
    }

    public MainSignalIdentifier(Point point, ModeSet mode, BlockPos pos) {
        this.identifier = new ModeIdentifier(point, mode);
        this.pos = pos;
    }

    public void writeNetwork(WriteBuffer buffer) {
        this.identifier.writeNetwork(buffer);
        buffer.putBlockPos(this.pos);
        buffer.putEnumValue(this.state);
    }

    public Point getPoint() {
        return this.identifier.point;
    }

    public ModeSet getModeSet() {
        return this.identifier.mode;
    }

    public static MainSignalIdentifier of(ReadBuffer buffer) {
        return new MainSignalIdentifier(ModeIdentifier.of(buffer), buffer.getBlockPos(), buffer.getEnumValue(SignalState.class));
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.pos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MainSignalIdentifier other = (MainSignalIdentifier)obj;
        return Objects.equals(this.identifier, other.identifier) && Objects.equals(this.pos, other.pos);
    }

    public String toString() {
        return "MainSignalIdentifier [ModeIdentifier=" + this.identifier + ",pos=" + this.pos + ",state=" + (Object)((Object)this.state) + "]";
    }

    public static enum SignalState {
        RED,
        GREEN,
        OFF,
        SUBSIDIARY_GREEN,
        SUBSIDIARY_RED,
        SUBSIDIARY_OFF;


        public static SignalState combine(ShowSubsidiary show) {
            if (show == null) {
                return SUBSIDIARY_RED;
            }
            switch (show) {
                case SIGNAL_RED: {
                    return SUBSIDIARY_RED;
                }
                case SIGNAL_GREEN: {
                    return SUBSIDIARY_GREEN;
                }
            }
            return SUBSIDIARY_OFF;
        }
    }
}

