/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.parser;

import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.parser.LogicParser;
import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.parser.MethodInfo;
import com.troblecodings.signals.parser.StringInteger;
import com.troblecodings.signals.parser.ValuePack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class FunctionParsingInfo {
    private static final HashMap<Class, Function<FunctionParsingInfo, Object>> PARAMETER_PARSER = new HashMap();
    private final HashMap<String, SEProperty> propertyCache = new HashMap();
    private final HashMap<String, ValuePack> predicateCache = new HashMap();
    private final HashMap<String, StringInteger> strIntCache = new HashMap();
    public String argument = "";
    public final String signalName;
    public final List<SEProperty> properties;
    private Map<String, MethodInfo> translationTable;

    public FunctionParsingInfo(Map<String, MethodInfo> translationTable, Signal signal) {
        this(signal);
        this.translationTable = translationTable;
    }

    public FunctionParsingInfo(Signal signalSystem) {
        this(Objects.requireNonNull(signalSystem).getSignalTypeName(), signalSystem.getProperties());
    }

    public FunctionParsingInfo(String signalSystem, List<SEProperty> properties) {
        this.signalName = signalSystem;
        this.properties = properties;
        this.translationTable = LogicParser.TRANSLATION_TABLE;
    }

    public Object[] getParameter(Class[] parameter, String[] arguments) {
        Object[] parameters = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.argument = arguments[i];
            parameters[i] = PARAMETER_PARSER.get(parameter[i]).apply(this);
        }
        return parameters;
    }

    public Object getProperty() {
        return this.getProperty(this.argument);
    }

    public Object getProperty(String propertyName) {
        String name = propertyName.toLowerCase();
        SEProperty property = this.propertyCache.computeIfAbsent(name, _u -> this.properties.stream().filter(noneCache -> noneCache.getName().equalsIgnoreCase(name)).findAny().orElse(null));
        if (property == null) {
            throw new LogicalParserException(String.format("Could not make predicate=%s with system=%S!", name, this.signalName) + " Valid Properties: " + this.properties);
        }
        return property;
    }

    public Object getPredicate() {
        ValuePack predicate = this.predicateCache.computeIfAbsent(this.argument.toLowerCase(), _u -> {
            String[] parts = this.argument.split("\\.");
            if (parts.length != 2) {
                throw new LogicalParserException(String.format("Syntax error predicate need to have the form PROPERTY.NAME but was %s", this.argument));
            }
            this.argument = parts[0];
            SEProperty property = (SEProperty)this.getProperty();
            String value = parts[1].toUpperCase();
            if (!property.getParent().isValid(new String(value))) {
                throw new ContentPackException("[" + value + "] is not a valid state of " + property + "! Valid States: " + property.getParent().getAllowedValues());
            }
            return new ValuePack(property, ext -> ext.equals(value));
        });
        if (predicate == null) {
            throw new LogicalParserException(String.format("Could not make predicate=%s with system=%S!", this.argument, this.signalName));
        }
        return predicate;
    }

    public Object getStringInt() {
        StringInteger strInt = this.strIntCache.computeIfAbsent(this.argument.toLowerCase(), _u -> {
            String[] parts = this.argument.split("\\.");
            if (parts.length != 2) {
                throw new LogicalParserException(String.format("Syntax error speedValue need to have the form PROPERTY.NAME but was %s", this.argument));
            }
            return new StringInteger(parts[0], Integer.parseInt(parts[1]));
        });
        return strInt;
    }

    public Object getString() {
        return this.argument;
    }

    public Object getBoolean() {
        return Boolean.valueOf(this.argument);
    }

    public Map<String, MethodInfo> getTable() {
        return this.translationTable;
    }

    static {
        PARAMETER_PARSER.put(SEProperty.class, FunctionParsingInfo::getProperty);
        PARAMETER_PARSER.put(ValuePack.class, FunctionParsingInfo::getPredicate);
        PARAMETER_PARSER.put(StringInteger.class, FunctionParsingInfo::getStringInt);
        PARAMETER_PARSER.put(String.class, FunctionParsingInfo::getString);
        PARAMETER_PARSER.put(Boolean.class, FunctionParsingInfo::getBoolean);
    }
}

