/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.core.SubsidiaryState;
import java.util.Objects;

public class SubsidiaryEntry {
    public final SubsidiaryState enumValue;
    public final boolean state;
    private static final String SUBSIDIARY_VALUE = "subsidiaryValue";

    public SubsidiaryEntry(SubsidiaryState enumValue, boolean state) {
        this.state = state;
        this.enumValue = enumValue;
    }

    public void writeNetwork(WriteBuffer buffer) {
        this.enumValue.writeNetwork(buffer);
        buffer.putByte((byte)(this.state ? 1 : 0));
    }

    public static SubsidiaryEntry of(ReadBuffer buffer) {
        return new SubsidiaryEntry(SubsidiaryState.of(buffer), buffer.getByte() == 1);
    }

    public void writeNBT(NBTWrapper tag) {
        this.enumValue.writeNBT(tag);
        tag.putBoolean(SUBSIDIARY_VALUE, this.state);
    }

    public static SubsidiaryEntry of(NBTWrapper tag) {
        return new SubsidiaryEntry(SubsidiaryState.of(tag), tag.getBoolean(SUBSIDIARY_VALUE));
    }

    public int hashCode() {
        return Objects.hash(this.enumValue, this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubsidiaryEntry other = (SubsidiaryEntry)obj;
        return Objects.equals(this.enumValue, other.enumValue) && this.state == other.state;
    }
}

