/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public abstract class TileEntityCraneBase
extends TileEntityMachineBase
implements ITickable {
    private EnumFacing outputOverride = null;
    private EnumFacing cachedOutputOverride = null;

    public TileEntityCraneBase(int scount) {
        super(scount);
    }

    public TileEntityCraneBase(int scount, int slotlimit) {
        super(scount, slotlimit);
    }

    public void func_73660_a() {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K && this.cachedOutputOverride != this.outputOverride) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.cachedOutputOverride = this.outputOverride;
        }
    }

    public EnumFacing getInputSide() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        switch (currentFacing) {
            case NORTH: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.SOUTH;
    }

    public EnumFacing getOutputSide() {
        EnumFacing override = this.getOutputOverride();
        if (override != null) {
            return override;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        switch (currentFacing) {
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getOutputOverride() {
        return this.outputOverride;
    }

    public void setOutputOverride(EnumFacing direction) {
        EnumFacing oldSide = this.getOutputSide();
        if (oldSide == direction) {
            direction = direction.func_176734_d();
        }
        this.outputOverride = direction;
        if (direction == this.getInputSide()) {
            this.setInput(oldSide);
        } else {
            this.onBlockChanged();
        }
    }

    public void setInput(EnumFacing direction) {
        this.outputOverride = this.getOutputSide();
        EnumFacing oldSide = this.getInputSide();
        if (oldSide == direction) {
            direction = direction.func_176734_d();
        }
        boolean needSwapOutput = direction == this.getOutputSide();
        this.field_145850_b.func_180501_a(this.field_174879_c, this.func_145838_q().func_176223_P(), needSwapOutput ? 4 : 3);
        if (needSwapOutput) {
            this.setOutputOverride(oldSide);
        }
    }

    protected void onBlockChanged() {
        if (!this.func_145830_o()) {
            return;
        }
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_145838_q().func_176223_P(), this.func_145838_q().func_176223_P(), 3);
        this.func_70296_d();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputOverride = nbt.func_150297_b("CraneOutputOverride", 1) ? EnumFacing.values()[nbt.func_74771_c("CraneOutputOverride")] : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.outputOverride != null) {
            nbt.func_74774_a("CraneOutputOverride", (byte)this.outputOverride.ordinal());
        }
        return nbt;
    }
}

