/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.config.MachineConfig;
import com.hbm.entity.effect.EntitySpear;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.AdvancementManager;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.NBTPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class TileEntityRBMKBase
extends TileEntity
implements INBTPacketReceiver,
ITickable,
IControllable {
    public static int rbmkHeight = 4;
    public double heat = 20.0;
    public double jumpheight = 0.0;
    public float downwardSpeed = 0.0f;
    public boolean falling = false;
    public static final byte gravity = 5;
    public int water;
    public static final int maxWater = 320000;
    public int steam;
    public static final int maxSteam = 320000;
    public static final ForgeDirection[] heatDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    protected TileEntityRBMKBase[] heatCache = new TileEntityRBMKBase[4];
    protected static boolean diag = false;
    public static HashSet<TileEntityRBMKBase> columns = new HashSet();

    public boolean hasLid() {
        if (!this.isLidRemovable()) {
            return true;
        }
        return this.func_145832_p() != RBMKBase.DIR_NO_LID.ordinal() + 10;
    }

    public boolean isLidRemovable() {
        return true;
    }

    public double maxHeat() {
        return 1500.0;
    }

    public double passiveCooling() {
        return RBMKDials.getPassiveCooling(this.field_145850_b);
    }

    public boolean shouldUpdate() {
        return true;
    }

    public int trackingRange() {
        return 150;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.moveHeat();
            if (RBMKDials.getReasimBoilers(this.field_145850_b)) {
                this.boilWater();
            }
            this.coolPassively();
            this.jump();
            NBTTagCompound data = new NBTTagCompound();
            this.func_189515_b(data);
            this.networkPack(data, this.trackingRange());
        }
    }

    private void jump() {
        if (this.heat <= (double)MachineConfig.rbmkJumpTemp && !this.falling) {
            return;
        }
        if (!this.falling) {
            if (this.heat > (double)MachineConfig.rbmkJumpTemp) {
                if (this.jumpheight > 0.0 || this.field_145850_b.field_73012_v.nextInt((int)(25.0 * this.maxHeat() / (this.heat - (double)MachineConfig.rbmkJumpTemp + 200.0)) + 1) == 0) {
                    double change = (this.heat - (double)MachineConfig.rbmkJumpTemp) * 2.0E-4;
                    double heightLimit = (this.heat - (double)MachineConfig.rbmkJumpTemp) * 0.002;
                    this.jumpheight += change;
                    if (this.jumpheight > heightLimit) {
                        this.jumpheight = heightLimit;
                        this.falling = true;
                    }
                }
            } else {
                this.falling = true;
            }
        } else if (this.jumpheight > 0.0) {
            this.downwardSpeed += 5.0f * 0.05f;
            this.jumpheight -= (double)this.downwardSpeed;
        } else {
            this.jumpheight = 0.0;
            this.downwardSpeed = 0.0f;
            this.falling = false;
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + rbmkHeight + 1), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.rbmkLid, SoundCategory.BLOCKS, 2.0f, 1.0f);
        }
    }

    private void boilWater() {
        if (this.heat < 100.0) {
            return;
        }
        double heatConsumption = RBMKDials.getBoilerHeatConsumption(this.field_145850_b);
        double availableHeat = (this.heat - 100.0) / heatConsumption;
        double availableWater = this.water;
        double availableSpace = 320000 - this.steam;
        int processedWater = (int)Math.floor(Math.min(availableHeat, Math.min(availableWater, availableSpace)) * RBMKDials.getReaSimBoilerSpeed(this.field_145850_b));
        this.water -= processedWater;
        this.steam += processedWater;
        this.heat -= (double)processedWater * heatConsumption;
    }

    private void moveHeat() {
        ArrayList<TileEntityRBMKBase> rec = new ArrayList<TileEntityRBMKBase>();
        rec.add(this);
        double heatTot = this.heat;
        int waterTot = this.water;
        int steamTot = this.steam;
        int index = 0;
        for (ForgeDirection forgeDirection : heatDirs) {
            TileEntity te;
            if (this.heatCache[index] != null && this.heatCache[index].func_145837_r()) {
                this.heatCache[index] = null;
            }
            if (this.heatCache[index] == null && (te = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + forgeDirection.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + forgeDirection.offsetZ))) instanceof TileEntityRBMKBase) {
                TileEntityRBMKBase base;
                this.heatCache[index] = base = (TileEntityRBMKBase)te;
            }
            ++index;
        }
        for (TileEntityRBMKBase tileEntityRBMKBase : this.heatCache) {
            if (tileEntityRBMKBase == null) continue;
            rec.add(tileEntityRBMKBase);
            heatTot += tileEntityRBMKBase.heat;
            waterTot += tileEntityRBMKBase.water;
            steamTot += tileEntityRBMKBase.steam;
        }
        int n = rec.size();
        double stepSize = RBMKDials.getColumnHeatFlow(this.field_145850_b);
        if (n > 1) {
            double d = heatTot / (double)n;
            int tWater = waterTot / n;
            int rWater = waterTot % n;
            int tSteam = steamTot / n;
            int rSteam = steamTot % n;
            for (TileEntityRBMKBase tileEntityRBMKBase : rec) {
                double delta = d - tileEntityRBMKBase.heat;
                tileEntityRBMKBase.heat += delta * stepSize;
                tileEntityRBMKBase.water = tWater;
                tileEntityRBMKBase.steam = tSteam;
            }
            this.water += rWater;
            this.steam += rSteam;
            this.func_70296_d();
        }
    }

    protected void coolPassively() {
        this.heat -= this.passiveCooling();
        if (this.heat < 20.0) {
            this.heat = 20.0;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (!diag) {
            super.func_145839_a(nbt);
        }
        this.heat = nbt.func_74769_h("heat");
        this.jumpheight = nbt.func_74769_h("jumpheight");
        this.water = nbt.func_74762_e("realSimWater");
        this.steam = nbt.func_74762_e("realSimSteam");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (!diag) {
            super.func_189515_b(nbt);
        }
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74780_a("jumpheight", this.jumpheight);
        nbt.func_74768_a("realSimWater", this.water);
        nbt.func_74768_a("realSimSteam", this.steam);
        return nbt;
    }

    public void networkPack(NBTTagCompound nbt, int range) {
        diag = true;
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new NBTPacket(nbt, this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)range));
        }
        diag = false;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        diag = true;
        this.func_145839_a(nbt);
        diag = false;
    }

    public void getDiagData(NBTTagCompound nbt) {
        diag = true;
        this.func_189515_b(nbt);
        diag = false;
        nbt.func_82580_o("jumpheight");
    }

    @SideOnly(value=Side.CLIENT)
    public static void diagnosticPrintHook(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        RayTraceResult mop = mc.field_71476_x;
        ScaledResolution resolution = event.getResolution();
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_178782_a()).func_177230_c() instanceof RBMKBase) {
            RBMKBase rbmk = (RBMKBase)world.func_180495_p(mop.func_178782_a()).func_177230_c();
            int[] pos = rbmk.findCore((IBlockAccess)world, mop.func_178782_a().func_177958_n(), mop.func_178782_a().func_177956_o(), mop.func_178782_a().func_177952_p());
            if (pos == null) {
                return;
            }
            TileEntityRBMKBase te = (TileEntityRBMKBase)world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
            NBTTagCompound flush = new NBTTagCompound();
            te.getDiagData(flush);
            Set keys = flush.func_150296_c();
            GL11.glPushMatrix();
            int pX = resolution.func_78326_a() / 2 + 8;
            int pZ = resolution.func_78328_b() / 2;
            ArrayList<String> exceptions = new ArrayList<String>();
            exceptions.add("x");
            exceptions.add("y");
            exceptions.add("z");
            exceptions.add("items");
            exceptions.add("id");
            String title = "Dump of Ordered Data Diagnostic (DODD)";
            mc.field_71466_p.func_78276_b(title, pX + 1, pZ - 19, 24576);
            mc.field_71466_p.func_78276_b(title, pX, pZ - 20, 65280);
            mc.field_71466_p.func_78276_b(I18nUtil.resolveKey(rbmk.func_149739_a() + ".name", new Object[0]), pX + 1, pZ - 9, 0x606000);
            mc.field_71466_p.func_78276_b(I18nUtil.resolveKey(rbmk.func_149739_a() + ".name", new Object[0]), pX, pZ - 10, 0xFFFF00);
            Object[] ents = new String[keys.size()];
            keys.toArray(ents);
            Arrays.sort(ents);
            for (Object key : ents) {
                if (exceptions.contains(key)) continue;
                mc.field_71466_p.func_78276_b((String)key + ": " + flush.func_74781_a((String)key), pX, pZ, 0xFFFFFF);
                pZ += 10;
            }
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
        }
    }

    public void onOverheat() {
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(i), Blocks.field_150353_l.func_176223_P());
        }
    }

    public void onMelt(int reduce) {
        this.standardMelt(reduce);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
    }

    protected void standardMelt(int reduce) {
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        for (int i = h; i >= 0; --i) {
            if (i <= h + 1 - reduce) {
                if (reduce > 1 && i == h + 1 - reduce) {
                    this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + i, this.field_174879_c.func_177952_p()), ModBlocks.pribris_burning.func_176223_P());
                } else {
                    this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + i, this.field_174879_c.func_177952_p()), ModBlocks.pribris.func_176223_P());
                }
            } else {
                this.field_145850_b.func_175698_g(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + i, this.field_174879_c.func_177952_p()));
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(i));
            this.field_145850_b.func_184138_a(this.field_174879_c.func_177981_b(i), state, state, 3);
        }
    }

    protected void spawnDebris(EntityRBMKDebris.DebrisType type) {
        EntityRBMKDebris debris = new EntityRBMKDebris(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + rbmkHeight, (double)this.field_174879_c.func_177952_p() + 0.5, type);
        debris.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
        debris.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
        debris.field_70181_x = 0.5 + this.field_145850_b.field_73012_v.nextDouble() * 1.5;
        if (type == EntityRBMKDebris.DebrisType.LID) {
            debris.field_70159_w *= 0.5;
            debris.field_70181_x += 0.5;
            debris.field_70179_y *= 0.5;
        }
        this.field_145850_b.func_72838_d((Entity)debris);
    }

    public void meltdown() {
        RBMKBase.dropLids = false;
        columns.clear();
        this.getFF(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        int minX = this.field_174879_c.func_177958_n();
        int maxX = this.field_174879_c.func_177958_n();
        int minZ = this.field_174879_c.func_177952_p();
        int maxZ = this.field_174879_c.func_177952_p();
        for (TileEntityRBMKBase rbmk : columns) {
            if (rbmk.field_174879_c.func_177958_n() < minX) {
                minX = rbmk.field_174879_c.func_177958_n();
            }
            if (rbmk.field_174879_c.func_177958_n() > maxX) {
                maxX = rbmk.field_174879_c.func_177958_n();
            }
            if (rbmk.field_174879_c.func_177952_p() < minZ) {
                minZ = rbmk.field_174879_c.func_177952_p();
            }
            if (rbmk.field_174879_c.func_177952_p() <= maxZ) continue;
            maxZ = rbmk.field_174879_c.func_177952_p();
        }
        for (TileEntityRBMKBase rbmk : columns) {
            int distFromMinX = rbmk.field_174879_c.func_177958_n() - minX;
            int distFromMaxX = maxX - rbmk.field_174879_c.func_177958_n();
            int distFromMinZ = rbmk.field_174879_c.func_177952_p() - minZ;
            int distFromMaxZ = maxZ - rbmk.field_174879_c.func_177952_p();
            int minDist = Math.min(distFromMinX, Math.min(distFromMaxX, Math.min(distFromMinZ, distFromMaxZ)));
            rbmk.onMelt(minDist + 1);
        }
        for (TileEntityRBMKBase rbmk : columns) {
            if (!(rbmk instanceof TileEntityRBMKRod) || this.field_145850_b.func_180495_p(new BlockPos(rbmk.field_174879_c.func_177958_n(), rbmk.field_174879_c.func_177956_o(), rbmk.field_174879_c.func_177952_p())).func_177230_c() != ModBlocks.corium_block) continue;
            for (int x = rbmk.field_174879_c.func_177958_n() - 1; x <= rbmk.field_174879_c.func_177958_n() + 1; ++x) {
                for (int y = rbmk.field_174879_c.func_177956_o() - 1; y <= rbmk.field_174879_c.func_177956_o() + 1; ++y) {
                    for (int z = rbmk.field_174879_c.func_177952_p() - 1; z <= rbmk.field_174879_c.func_177952_p() + 1; ++z) {
                        Block b = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (this.field_145850_b.field_73012_v.nextInt(3) != 0 || b != ModBlocks.pribris && b != ModBlocks.pribris_burning) continue;
                        if (RBMKBase.digamma) {
                            this.field_145850_b.func_175656_a(new BlockPos(x, y, z), ModBlocks.pribris_digamma.func_176223_P());
                            continue;
                        }
                        this.field_145850_b.func_175656_a(new BlockPos(x, y, z), ModBlocks.pribris_radiating.func_176223_P());
                    }
                }
            }
        }
        int smallDim = Math.max(maxX - minX, maxZ - minZ) * 2;
        int avgX = minX + (maxX - minX) / 2;
        int avgZ = minZ + (maxZ - minZ) / 2;
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "rbmkmush");
        data.func_74776_a("scale", (float)smallDim);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)avgX + 0.5, this.field_174879_c.func_177956_o() + rbmkHeight, (double)avgZ + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)avgX + 0.5, (double)(this.field_174879_c.func_177956_o() + rbmkHeight), (double)avgZ + 0.5, 250.0));
        MainRegistry.proxy.effectNT(data);
        this.field_145850_b.func_184148_a(null, (double)avgX + 0.5, (double)(this.field_174879_c.func_177956_o() + rbmkHeight >> 1), (double)avgZ + 0.5, HBMSoundHandler.rbmk_explosion, SoundCategory.BLOCKS, 50.0f, 1.0f);
        List list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 50) + 0.5, (double)(this.field_174879_c.func_177956_o() - 50) + 0.5, (double)(this.field_174879_c.func_177952_p() - 50) + 0.5, (double)(this.field_174879_c.func_177958_n() + 50) + 0.5, (double)(this.field_174879_c.func_177956_o() + 50) + 0.5, (double)(this.field_174879_c.func_177952_p() + 50) + 0.5));
        for (EntityPlayer e : list) {
            AdvancementManager.grantAchievement(e, AdvancementManager.progress_rbmk_boom);
        }
        if (RBMKBase.digamma) {
            EntitySpear spear = new EntitySpear(this.field_145850_b);
            spear.field_70165_t = (double)avgX + 0.5;
            spear.field_70161_v = (double)avgZ + 0.5;
            spear.field_70163_u = this.field_174879_c.func_177956_o() + rbmkHeight + 100;
            this.field_145850_b.func_72838_d((Entity)spear);
        }
        RBMKBase.dropLids = true;
        RBMKBase.digamma = false;
    }

    private void getFF(int x, int y, int z) {
        TileEntityRBMKBase rbmk;
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileEntityRBMKBase && !columns.contains(rbmk = (TileEntityRBMKBase)te)) {
            columns.add(rbmk);
            this.getFF(x + 1, y, z);
            this.getFF(x - 1, y, z);
            this.getFF(x, y, z + 1);
            this.getFF(x, y, z - 1);
        }
    }

    public boolean isModerated() {
        return false;
    }

    public abstract TileEntityRBMKConsole.ColumnType getConsoleType();

    public NBTTagCompound getNBTForConsole() {
        return null;
    }

    public static List<String> getFancyStats(NBTTagCompound nbt) {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + rbmkHeight + 10), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        HashMap<String, DataValue> data = new HashMap<String, DataValue>();
        data.put("heat", new DataValueFloat((float)this.heat));
        data.put("RSIM_feed", new DataValueFloat(this.water));
        data.put("RSIM_steam", new DataValueFloat(this.steam));
        return data;
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }
}

