/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.google.common.base.Predicate;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.FluidCombustionRecipes;
import com.hbm.inventory.container.ContainerOilburner;
import com.hbm.inventory.gui.GUIOilburner;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityHeaterOilburner
extends TileEntityMachineBase
implements IGUIProvider,
IHeatSource,
IControlReceiver,
IFluidHandler,
ITickable,
ITankPacketAcceptor {
    public boolean isOn = false;
    public FluidTank tank = new FluidTank(16000);
    public Fluid fluidType = ModForgeFluids.gas;
    private int cacheHeat = FluidCombustionRecipes.getFlameEnergy(this.fluidType);
    public int setting = 1;
    public int heatEnergy = 0;
    public static final int maxHeatEnergy = 1000000;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation texture;
    AxisAlignedBB bb = null;

    public TileEntityHeaterOilburner() {
        super(3);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateTankType();
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tank}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (this.inputValidForTank() && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 0, 1)) {
                if (this.tank.getFluid() != null) {
                    this.fluidType = this.tank.getFluid().getFluid();
                }
                this.func_70296_d();
            }
            boolean shouldCool = true;
            if (this.isOn && this.cacheHeat > 0 && this.heatEnergy < 1000000) {
                int burnRate = this.setting;
                int toBurn = Math.min(burnRate, this.tank.getFluidAmount());
                this.tank.drain(toBurn, true);
                this.heatEnergy += this.cacheHeat * toBurn;
                this.func_70296_d();
                shouldCool = false;
            }
            if (this.heatEnergy >= 1000000) {
                shouldCool = false;
            }
            if (shouldCool) {
                this.heatEnergy = Math.max(this.heatEnergy - Math.max(this.heatEnergy / 1000, 1), 0);
                this.func_70296_d();
            }
            NBTTagCompound data = new NBTTagCompound();
            this.tank.writeToNBT(data);
            data.func_74778_a("fluidType", this.fluidType.getName());
            data.func_74757_a("isOn", this.isOn);
            data.func_74768_a("heatEnergy", this.heatEnergy);
            data.func_74774_a("setting", (byte)this.setting);
            data.func_74768_a("cacheHeat", this.cacheHeat);
            this.networkPack(data, 25);
        }
    }

    private void updateTankType() {
        ItemStack slotId = this.inventory.getStackInSlot(2);
        Item itemId = slotId.func_77973_b();
        if (itemId == ModItems.forge_fluid_identifier) {
            Fluid fluid = ItemForgeFluidIdentifier.getType(slotId);
            int energy = FluidCombustionRecipes.getFlameEnergy(fluid);
            if (this.fluidType != fluid) {
                this.fluidType = fluid;
                this.tank.setFluid(null);
                this.cacheHeat = energy;
                this.func_70296_d();
            }
        }
    }

    private boolean inputValidForTank() {
        ItemStack slotInput = this.inventory.getStackInSlot(0);
        if (slotInput != ItemStack.field_190927_a && this.tank != null) {
            return FFUtils.checkRestrictions(slotInput, (Predicate<FluidStack>)((Predicate)f -> f.getFluid() == this.fluidType));
        }
        return false;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public String getName() {
        return "container.heaterOilburner";
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt);
        if (nbt.func_74764_b("fluidType")) {
            this.fluidType = FluidRegistry.getFluid((String)nbt.func_74779_i("fluidType"));
        }
        this.isOn = nbt.func_74767_n("isOn");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.setting = nbt.func_74771_c("setting");
        this.cacheHeat = nbt.func_74762_e("cacheHeat");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
        if (nbt.func_74764_b("fluidType")) {
            this.fluidType = FluidRegistry.getFluid((String)nbt.func_74779_i("fluidType"));
        }
        this.isOn = nbt.func_74767_n("isOn");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.setting = nbt.func_74771_c("setting");
        this.cacheHeat = nbt.func_74762_e("cacheHeat");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.tank.writeToNBT(nbt);
        if (this.fluidType != null) {
            nbt.func_74778_a("fluidType", this.fluidType.getName());
        }
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        nbt.func_74774_a("setting", (byte)this.setting);
        nbt.func_74768_a("cacheHeat", this.cacheHeat);
        return super.func_189515_b(nbt);
    }

    public void toggleSettingUp() {
        ++this.setting;
        if (this.setting > 100) {
            this.setting = 1;
        }
    }

    public void toggleSettingDown() {
        --this.setting;
        if (this.setting < 1) {
            this.setting = 100;
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.fluidType && resource.amount > 0) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerOilburner(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (this.texture == null) {
            this.texture = new ResourceLocation("hbm:textures/gui/machine/gui_oilburner.png");
        }
        return new GUIOilburner(player.field_71071_by, this, this.texture);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_174818_b(this.field_174879_c) <= 256.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            this.isOn = !this.isOn;
        }
        this.func_70296_d();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

