/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.amlfrom1710;

import com.hbm.render.amlfrom1710.QuadComparator;
import com.hbm.render.amlfrom1710.TesselatorVertexState;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.PriorityQueue;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Tessellator {
    private static int nativeBufferSize = 0x200000;
    private static int trivertsInBuffer = nativeBufferSize / 48 * 6;
    public static boolean renderingWorldRenderer = false;
    public boolean defaultTexture = false;
    private int rawBufferSize = 0;
    public int textureID = 0;
    private static ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)(nativeBufferSize * 4));
    private static IntBuffer intBuffer = byteBuffer.asIntBuffer();
    private static FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
    private static ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
    private int[] rawBuffer;
    private int vertexCount;
    private double textureU;
    private double textureV;
    private int brightness;
    private int color;
    public boolean hasColor;
    private boolean hasTexture;
    private boolean hasBrightness;
    public boolean hasNormals;
    private int rawBufferIndex;
    private int addedVertices;
    private boolean isColorDisabled;
    private int drawMode;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int normal;
    public static final Tessellator instance = new Tessellator(0x200000);
    private boolean isDrawing;
    private int bufferSize;
    private static final String __OBFID = "CL_00000960";
    private int r;
    private int g;
    private int b;
    private int a;
    private float normalTestX;
    private float normalTestY;
    private float normalTestZ;

    private Tessellator(int p_i1250_1_) {
    }

    public Tessellator() {
    }

    public int draw() {
        this.hasColor = false;
        this.hasNormals = false;
        this.xOffset = 0.0;
        this.yOffset = 0.0;
        this.zOffset = 0.0;
        net.minecraft.client.renderer.Tessellator.func_178181_a().func_78381_a();
        return 1;
    }

    public TesselatorVertexState getVertexState(float p_147564_1_, float p_147564_2_, float p_147564_3_) {
        int i;
        int[] aint = new int[this.rawBufferIndex];
        PriorityQueue<Object> priorityqueue = new PriorityQueue<Object>(this.rawBufferIndex, new QuadComparator(this.rawBuffer, p_147564_1_ + (float)this.xOffset, p_147564_2_ + (float)this.yOffset, p_147564_3_ + (float)this.zOffset));
        int b0 = 32;
        for (i = 0; i < this.rawBufferIndex; i += b0) {
            priorityqueue.add(i);
        }
        i = 0;
        while (!priorityqueue.isEmpty()) {
            int j = (Integer)priorityqueue.remove();
            for (int k = 0; k < b0; ++k) {
                aint[i + k] = this.rawBuffer[j + k];
            }
            i += b0;
        }
        System.arraycopy(aint, 0, this.rawBuffer, 0, aint.length);
        return new TesselatorVertexState(aint, this.rawBufferIndex, this.vertexCount, this.hasTexture, this.hasBrightness, this.hasNormals, this.hasColor);
    }

    public void setVertexState(TesselatorVertexState p_147565_1_) {
        while (p_147565_1_.getRawBuffer().length > this.rawBufferSize && this.rawBufferSize > 0) {
            this.rawBufferSize <<= 1;
        }
        if (this.rawBufferSize > this.rawBuffer.length) {
            this.rawBuffer = new int[this.rawBufferSize];
        }
        System.arraycopy(p_147565_1_.getRawBuffer(), 0, this.rawBuffer, 0, p_147565_1_.getRawBuffer().length);
        this.rawBufferIndex = p_147565_1_.getRawBufferIndex();
        this.vertexCount = p_147565_1_.getVertexCount();
        this.hasTexture = p_147565_1_.getHasTexture();
        this.hasBrightness = p_147565_1_.getHasBrightness();
        this.hasColor = p_147565_1_.getHasColor();
        this.hasNormals = p_147565_1_.getHasNormals();
    }

    private void reset() {
        this.vertexCount = 0;
        byteBuffer.clear();
        this.rawBufferIndex = 0;
        this.addedVertices = 0;
    }

    public void startDrawingQuads() {
        this.startDrawing(7, DefaultVertexFormats.field_181710_j);
    }

    public void startDrawingQuadsColor() {
        this.startDrawing(7, DefaultVertexFormats.field_181712_l);
    }

    public void startDrawing(int mode) {
        this.startDrawing(mode, DefaultVertexFormats.field_181710_j);
    }

    public void startDrawing(int glMode, VertexFormat format) {
        this.isColorDisabled = false;
        net.minecraft.client.renderer.Tessellator.func_178181_a().func_178180_c().func_181668_a(glMode, format);
    }

    public void setTextureUV(double p_78385_1_, double p_78385_3_) {
        this.hasTexture = true;
        this.textureU = p_78385_1_;
        this.textureV = p_78385_3_;
    }

    public void setBrightness(int p_78380_1_) {
        this.hasBrightness = true;
        this.brightness = p_78380_1_;
    }

    public void setColorOpaque_F(float p_78386_1_, float p_78386_2_, float p_78386_3_) {
        this.setColorOpaque((int)(p_78386_1_ * 255.0f), (int)(p_78386_2_ * 255.0f), (int)(p_78386_3_ * 255.0f));
    }

    public void setColorRGBA_F(float p_78369_1_, float p_78369_2_, float p_78369_3_, float p_78369_4_) {
        this.setColorRGBA((int)(p_78369_1_ * 255.0f), (int)(p_78369_2_ * 255.0f), (int)(p_78369_3_ * 255.0f), (int)(p_78369_4_ * 255.0f));
    }

    public void setColorOpaque(int p_78376_1_, int p_78376_2_, int p_78376_3_) {
        this.setColorRGBA(p_78376_1_, p_78376_2_, p_78376_3_, 255);
    }

    public void setColorRGBA(int p_78370_1_, int p_78370_2_, int p_78370_3_, int p_78370_4_) {
        if (!this.isColorDisabled) {
            if (p_78370_1_ > 255) {
                p_78370_1_ = 255;
            }
            if (p_78370_2_ > 255) {
                p_78370_2_ = 255;
            }
            if (p_78370_3_ > 255) {
                p_78370_3_ = 255;
            }
            if (p_78370_4_ > 255) {
                p_78370_4_ = 255;
            }
            if (p_78370_1_ < 0) {
                p_78370_1_ = 0;
            }
            if (p_78370_2_ < 0) {
                p_78370_2_ = 0;
            }
            if (p_78370_3_ < 0) {
                p_78370_3_ = 0;
            }
            if (p_78370_4_ < 0) {
                p_78370_4_ = 0;
            }
            this.hasColor = true;
            this.r = p_78370_1_;
            this.g = p_78370_2_;
            this.b = p_78370_3_;
            this.a = p_78370_4_;
            this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? p_78370_4_ << 24 | p_78370_3_ << 16 | p_78370_2_ << 8 | p_78370_1_ : p_78370_1_ << 24 | p_78370_2_ << 16 | p_78370_3_ << 8 | p_78370_4_;
        }
    }

    public void func_154352_a(byte p_154352_1_, byte p_154352_2_, byte p_154352_3_) {
        this.setColorOpaque(p_154352_1_ & 0xFF, p_154352_2_ & 0xFF, p_154352_3_ & 0xFF);
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        BufferBuilder buf = net.minecraft.client.renderer.Tessellator.func_178181_a().func_178180_c();
        buf.func_181662_b(x + this.xOffset, y + this.yOffset, z + this.zOffset).func_187315_a(u, v);
        if (this.hasColor) {
            buf.func_181669_b(this.r, this.g, this.b, this.a);
        }
        if (this.hasNormals) {
            buf.func_181663_c(this.normalTestX, this.normalTestY, this.normalTestZ);
        }
        buf.func_181675_d();
    }

    public void addVertex(double x, double y, double z) {
        BufferBuilder buf = net.minecraft.client.renderer.Tessellator.func_178181_a().func_178180_c();
        buf.func_181662_b(x + this.xOffset, y + this.yOffset, z + this.zOffset);
        if (this.hasColor) {
            buf.func_181669_b(this.r, this.g, this.b, this.a);
        }
        if (this.hasNormals) {
            buf.func_181663_c(this.normalTestX, this.normalTestY, this.normalTestZ);
        }
        buf.func_181675_d();
    }

    public void setColorOpaque_I(int p_78378_1_) {
        int j = p_78378_1_ >> 16 & 0xFF;
        int k = p_78378_1_ >> 8 & 0xFF;
        int l = p_78378_1_ & 0xFF;
        this.setColorOpaque(j, k, l);
    }

    public void setColorRGBA_I(int p_78384_1_, int p_78384_2_) {
        int k = p_78384_1_ >> 16 & 0xFF;
        int l = p_78384_1_ >> 8 & 0xFF;
        int i1 = p_78384_1_ & 0xFF;
        this.setColorRGBA(k, l, i1, p_78384_2_);
    }

    public void disableColor() {
        this.isColorDisabled = true;
    }

    public void setNormal(float x, float y, float z) {
        this.hasNormals = true;
        this.normalTestX = x;
        this.normalTestY = y;
        this.normalTestZ = z;
    }

    public void setTranslation(double p_78373_1_, double p_78373_3_, double p_78373_5_) {
        this.xOffset = p_78373_1_;
        this.yOffset = p_78373_3_;
        this.zOffset = p_78373_5_;
    }

    public void addTranslation(float p_78372_1_, float p_78372_2_, float p_78372_3_) {
        this.xOffset += (double)p_78372_1_;
        this.yOffset += (double)p_78372_2_;
        this.zOffset += (double)p_78372_3_;
    }

    static {
        Tessellator.instance.defaultTexture = true;
    }
}

