/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.physics.AABBCollider;
import com.hbm.physics.Contact;
import com.hbm.physics.RigidBody;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticlePhysicsBlocks
extends Particle {
    public RigidBody body;
    public AxisAlignedBB[] boxes;
    public BlockPos[] blocks;
    public BlockPos createPos;
    public boolean didInit = false;
    int callListId;

    public ParticlePhysicsBlocks(World world, double posXIn, double posYIn, double posZIn, BlockPos createPos, BlockPos[] blocks) {
        super(world, posXIn, posYIn, posZIn);
        this.blocks = blocks;
        this.createPos = createPos;
        this.init();
    }

    public void init() {
        int offsetY = 0;
        this.body = new RigidBody(this.field_187122_b, this.field_187126_f, this.field_187127_g, this.field_187128_h);
        ArrayList<AABBCollider> boxs = new ArrayList<AABBCollider>();
        for (BlockPos pos : this.blocks) {
            ArrayList boxes2 = new ArrayList();
            IBlockState state = this.field_187122_b.func_180495_p(pos);
            state.func_185908_a(this.field_187122_b, pos, TileEntity.INFINITE_EXTENT_AABB, boxes2, null, false);
            for (AxisAlignedBB box : boxes2) {
                boolean light = state.func_177230_c() == Blocks.field_150362_t || state.func_177230_c() == Blocks.field_150361_u;
                float mass = light ? 0.25f : 1.0f;
                boxs.add(new AABBCollider(box.func_72317_d(-this.field_187126_f, -this.field_187127_g + (double)offsetY, -this.field_187128_h), mass));
            }
        }
        this.boxes = new AxisAlignedBB[boxs.size()];
        for (int i = 0; i < this.boxes.length; ++i) {
            this.boxes[i] = ((AABBCollider)boxs.get((int)i)).box;
        }
        this.body.addColliders(boxs.toArray(new AABBCollider[0]));
        Vec3d impulse = Minecraft.func_71410_x().field_71439_g.func_70040_Z().func_186678_a(0.6 * (double)this.body.mass);
        this.body.impulseVelocity(new Vec3(impulse.field_72450_a, 0.0, impulse.field_72449_c), new Vec3(this.field_187126_f + 0.5, this.field_187127_g, this.field_187128_h + 0.5));
        this.body.friction = 0.8f;
        this.field_70547_e = 1000;
        this.callListId = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.callListId, (int)4864);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos pos : this.blocks) {
            IBlockState state = this.field_187122_b.func_180495_p(pos);
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_187498_b((IBlockAccess)this.field_187122_b, model, state, pos.func_177982_a(0, offsetY, 0), buf, true, MathHelper.func_180186_a((Vec3i)pos));
        }
        tes.func_78381_a();
        GL11.glEndList();
    }

    public void func_189213_a() {
        this.body.minecraftTimestep();
        ++this.field_70546_d;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
            GL11.glDeleteLists((int)this.callListId, (int)1);
        }
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GL11.glPushMatrix();
        double entPosX = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double entPosY = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double entPosZ = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        field_70556_an = entPosX;
        field_70554_ao = entPosY;
        field_70555_ap = entPosZ;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)4.0f);
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        for (Contact contact : this.body.contacts.contacts) {
            if (contact == null) continue;
        }
        this.body.doGlTransform(new Vec3(field_70556_an, field_70554_ao, field_70555_ap), partialTicks);
        GL11.glTranslated((double)(-this.createPos.func_177958_n()), (double)(-this.createPos.func_177956_o()), (double)(-this.createPos.func_177952_p()));
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)4.0f);
        for (Contact contact : this.boxes) {
        }
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179089_o();
        GlStateManager.func_179103_j((int)7425);
        GL11.glCallList((int)this.callListId);
        GlStateManager.func_179103_j((int)7424);
        GL11.glPopMatrix();
    }
}

