/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.handler.HbmShaderManager2;
import com.hbm.handler.LightningGenerator;
import com.hbm.main.ResourceManager;
import com.hbm.particle.lightning_test.TrailRenderer2;
import com.hbm.util.BobMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleLightningStrip
extends Particle {
    public List<LightningPoint> points = new ArrayList<LightningPoint>();
    public float forkChance = 0.2f;
    public float minNewPointDist = 0.1f;
    public float motionScaleTan = 0.03f;
    public float motionScaleNorm = 0.01f;
    public float field_187134_n = 0.004f;
    public boolean doTransform = false;

    public ParticleLightningStrip(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_70547_e = 122;
    }

    public void setNewPoint(Vec3d point) {
        float scale = 0.01f;
        float scale2 = 0.002f;
        Vec3d pos = point.func_72441_c((double)((this.field_187122_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * scale), (double)((this.field_187122_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * scale), (double)((this.field_187122_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * scale));
        Vec3d motion = new Vec3d((double)((this.field_187122_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * scale2), (double)((this.field_187122_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * scale2), (double)((this.field_187122_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * scale2));
        LightningGenerator.LightningNode fork = null;
        if (this.points.size() >= 1) {
            Vec3d direction = point.func_178788_d(this.points.get((int)(this.points.size() - 1)).ogPos);
            double dot = direction.func_72430_b(pos.func_178788_d(this.points.get((int)(this.points.size() - 1)).ogPos));
            Vec3d project = direction.func_186678_a(dot / direction.func_189985_c());
            direction = direction.func_72432_b();
            motion = motion.func_178787_e(pos.func_178788_d(project).func_72432_b().func_186678_a((double)this.motionScaleTan)).func_178787_e(direction.func_186678_a((double)this.motionScaleNorm));
            if (this.field_187122_b.field_73012_v.nextFloat() < this.forkChance) {
                LightningGenerator.LightningGenInfo i = new LightningGenerator.LightningGenInfo();
                i.randAmount = 0.03f;
                i.subdivisions = 3;
                i.subdivRecurse = 1;
                i.forkChance = 0.1f;
                fork = LightningGenerator.generateLightning(new Vec3d(0.0, 0.0, 0.0), BobMathUtil.randVecInCone(direction, 20.0f).func_186678_a((double)-0.3f), i);
            }
        }
        LightningPoint lPoint = new LightningPoint(point, pos, motion);
        lPoint.fork = fork;
        this.points.add(lPoint);
        if (this.points.size() >= 3 && this.points.get((int)(this.points.size() - 3)).pos.func_72436_e(point) < (double)(this.minNewPointDist * this.minNewPointDist)) {
            this.points.remove(this.points.size() - 2);
        }
    }

    public void func_189213_a() {
        ++this.field_70546_d;
        if (this.field_70546_d > this.field_70547_e) {
            this.func_187112_i();
        }
        for (LightningPoint p : this.points) {
            p.prevPos = p.pos;
            p.pos = p.pos.func_178787_e(p.motion);
            p.motion = p.motion.func_186678_a(0.96);
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.points.size() >= 2) {
            if (this.doTransform) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-field_70556_an), (double)(-field_70554_ao), (double)(-field_70555_ap));
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            ResourceManager.lightning.use();
            ResourceManager.lightning.uniform4f("duck", 1.0f, 1.0f, 1.0f, 1.0f);
            ResourceManager.lightning.uniform1f("age", (float)this.field_70546_d + partialTicks);
            int list = GL11.glGenLists((int)1);
            GL11.glNewList((int)list, (int)4864);
            float time = ((float)this.field_70546_d + partialTicks) * 0.012f;
            ArrayList<Vec3d> currentPoints = new ArrayList<Vec3d>(this.points.size());
            for (int i = 0; i < this.points.size(); ++i) {
                LightningPoint p = this.points.get(i);
                Vec3d pos = BobMathUtil.lerp(p.prevPos, p.pos, partialTicks);
                float override = (float)i / (float)this.points.size();
                override = 1.0f - MathHelper.func_76131_a((float)(override - time * time * time), (float)0.001f, (float)1.0f);
                ResourceManager.lightning.uniform1f("fadeoverride", override);
                if (p.fork != null) {
                    if (this.doTransform) {
                        LightningGenerator.render(p.fork, new Vec3d(field_70556_an, field_70554_ao + (double)entityIn.func_70047_e(), field_70555_ap), this.field_187134_n * 0.5f, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, false, null);
                    } else {
                        LightningGenerator.render(p.fork, new Vec3d(0.0, 0.0, 0.0), this.field_187134_n * 0.5f, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, false, null);
                    }
                }
                currentPoints.add(pos);
            }
            ResourceManager.lightning.uniform1f("fadeoverride", 1.0f);
            ResourceManager.lightning.uniform1i("vertices", currentPoints.size() * 3 + 2);
            if (this.doTransform) {
                TrailRenderer2.draw(new Vec3d(field_70556_an, field_70554_ao + (double)entityIn.func_70047_e(), field_70555_ap), currentPoints, this.field_187134_n);
            } else {
                TrailRenderer2.draw(new Vec3d(0.0, 0.0, 0.0), currentPoints, this.field_187134_n);
            }
            GL11.glEndList();
            GL11.glCallList((int)list);
            HbmShaderManager2.bloomData.func_147610_a(false);
            ResourceManager.lightning.uniform4f("duck", 0.6f, 0.8f, 1.0f, 1.0f);
            GL11.glCallList((int)list);
            GL11.glCallList((int)list);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            GL11.glDeleteLists((int)list, (int)1);
            HbmShaderManager2.releaseShader();
            GlStateManager.func_179084_k();
            if (this.doTransform) {
                GL11.glPopMatrix();
            }
        }
    }

    public static class LightningPoint {
        Vec3d ogPos;
        Vec3d pos;
        Vec3d prevPos;
        Vec3d motion;
        LightningGenerator.LightningNode fork = null;

        public LightningPoint(Vec3d ogPos, Vec3d pos, Vec3d motion) {
            this.ogPos = ogPos;
            this.pos = pos;
            this.prevPos = pos;
            this.motion = motion;
        }
    }
}

