/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.handler.MissileStruct;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemMissile;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCustomMissile
extends Item {
    public ItemCustomMissile(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        ModItems.ALL_ITEMS.add(this);
    }

    public static ItemStack buildMissile(Item chip, Item warhead, Item fuselage, Item stability, Item thruster) {
        if (stability == null) {
            return ItemCustomMissile.buildMissile(new ItemStack(chip), new ItemStack(warhead), new ItemStack(fuselage), null, new ItemStack(thruster));
        }
        return ItemCustomMissile.buildMissile(new ItemStack(chip), new ItemStack(warhead), new ItemStack(fuselage), new ItemStack(stability), new ItemStack(thruster));
    }

    public static ItemStack buildMissile(ItemStack chip, ItemStack warhead, ItemStack fuselage, ItemStack stability, ItemStack thruster) {
        ItemStack missile = new ItemStack(ModItems.missile_custom);
        ItemCustomMissile.writeToNBT(missile, "chip", Item.func_150891_b((Item)chip.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "warhead", Item.func_150891_b((Item)warhead.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "fuselage", Item.func_150891_b((Item)fuselage.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "thruster", Item.func_150891_b((Item)thruster.func_77973_b()));
        if (stability != null) {
            ItemCustomMissile.writeToNBT(missile, "stability", Item.func_150891_b((Item)stability.func_77973_b()));
        }
        return missile;
    }

    private static void writeToNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(key, value);
    }

    public static int readFromNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e(key);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        try {
            ItemMissile chip = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "chip"));
            ItemMissile warhead = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "warhead"));
            ItemMissile fuselage = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "fuselage"));
            ItemMissile stability = null;
            Item item = Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "stability"));
            if (item instanceof ItemMissile) {
                stability = (ItemMissile)item;
            }
            ItemMissile thruster = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "thruster"));
            tooltip.add(TextFormatting.BOLD + "Warhead: " + TextFormatting.GRAY + warhead.getWarhead((ItemMissile.WarheadType)((Object)warhead.attributes[0])));
            tooltip.add(TextFormatting.BOLD + "Strength: " + TextFormatting.RED + (Float)warhead.attributes[1]);
            tooltip.add(TextFormatting.BOLD + "Fuel Type: " + TextFormatting.GRAY + fuselage.getFuel((ItemMissile.FuelType)((Object)fuselage.attributes[0])));
            tooltip.add(TextFormatting.BOLD + "Fuel amount: " + TextFormatting.GRAY + (Float)fuselage.attributes[1] + "l");
            tooltip.add(TextFormatting.BOLD + "Chip inaccuracy: " + TextFormatting.GRAY + ((Float)chip.attributes[0]).floatValue() * 100.0f + "%");
            if (stability != null) {
                tooltip.add(TextFormatting.BOLD + "Fin inaccuracy: " + TextFormatting.GRAY + ((Float)stability.attributes[0]).floatValue() * 100.0f + "%");
            } else {
                tooltip.add(TextFormatting.BOLD + "Fin inaccuracy: " + TextFormatting.GRAY + "100%");
            }
            tooltip.add(TextFormatting.BOLD + "Size: " + TextFormatting.GRAY + fuselage.getSize(fuselage.top) + "/" + fuselage.getSize(fuselage.bottom));
            float health = warhead.health + fuselage.health + thruster.health;
            if (stability != null) {
                health += stability.health;
            }
            tooltip.add(TextFormatting.BOLD + "Health: " + TextFormatting.GREEN + health + "HP");
        }
        catch (ClassCastException x) {
            return;
        }
    }

    public static MissileStruct getStruct(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || stack.func_77978_p() == null || !(stack.func_77973_b() instanceof ItemCustomMissile)) {
            return null;
        }
        try {
            ItemMissile warhead = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "warhead"));
            ItemMissile fuselage = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "fuselage"));
            ItemMissile stability = null;
            Item item = Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "stability"));
            if (item instanceof ItemMissile) {
                stability = (ItemMissile)item;
            }
            ItemMissile thruster = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "thruster"));
            MissileStruct missile = new MissileStruct(warhead, fuselage, stability, thruster);
            return missile;
        }
        catch (ClassCastException x) {
            return null;
        }
    }
}

