/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard;

import com.hbm.blocks.ModBlocks;
import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardSystem;
import com.hbm.hazard.transformer.HazardTransformerRadiationNBT;
import com.hbm.hazard.type.HazardTypeAsbestos;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.hazard.type.HazardTypeBlinding;
import com.hbm.hazard.type.HazardTypeCoal;
import com.hbm.hazard.type.HazardTypeDigamma;
import com.hbm.hazard.type.HazardTypeExplosive;
import com.hbm.hazard.type.HazardTypeHot;
import com.hbm.hazard.type.HazardTypeHydroactive;
import com.hbm.hazard.type.HazardTypeRadiation;
import com.hbm.items.ModItems;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

public class HazardRegistry {
    public static final float co60 = 30.0f;
    public static final float sr90 = 15.0f;
    public static final float tc99 = 2.75f;
    public static final float i131 = 150.0f;
    public static final float xe135 = 1250.0f;
    public static final float cs137 = 20.0f;
    public static final float au198 = 500.0f;
    public static final float pb209 = 10000.0f;
    public static final float at209 = 7500.0f;
    public static final float po210 = 75.0f;
    public static final float ra226 = 7.5f;
    public static final float ac227 = 30.0f;
    public static final float th232 = 0.1f;
    public static final float thf = 1.75f;
    public static final float u = 0.35f;
    public static final float u233 = 5.0f;
    public static final float u235 = 1.0f;
    public static final float u238 = 0.25f;
    public static final float uf = 0.5f;
    public static final float np237 = 2.5f;
    public static final float npf = 1.5f;
    public static final float pu = 7.5f;
    public static final float purg = 6.25f;
    public static final float pu238 = 10.0f;
    public static final float pu239 = 5.0f;
    public static final float pu240 = 7.5f;
    public static final float pu241 = 25.0f;
    public static final float puf = 4.25f;
    public static final float am241 = 8.5f;
    public static final float am242 = 9.5f;
    public static final float amrg = 9.0f;
    public static final float amf = 4.75f;
    public static final float mox = 2.5f;
    public static final float sa326 = 15.0f;
    public static final float sa327 = 17.5f;
    public static final float saf = 5.85f;
    public static final float les = 2.52f;
    public static final float mes = 5.25f;
    public static final float hes = 8.8f;
    public static final float gh336 = 5.0f;
    public static final float radsource_mult = 0.5f;
    public static final float pobe = 37.5f;
    public static final float rabe = 3.75f;
    public static final float pube = 5.0f;
    public static final float aupb = 5250.0f;
    public static final float zfb_bi = 0.35f;
    public static final float zfb_pu241 = 12.5f;
    public static final float zfb_am_mix = 4.5f;
    public static final float bf = 300000.0f;
    public static final float sr = 1.5f;
    public static final float sb = 3.0f;
    public static final float trx = 25.0f;
    public static final float trn = 0.1f;
    public static final float wst = 15.0f;
    public static final float wstv = 7.5f;
    public static final float yc = 0.42000002f;
    public static final float fo = 10.0f;
    public static final float nugget = 0.1f;
    public static final float ingot = 1.0f;
    public static final float gem = 1.0f;
    public static final float ore = 1.0f;
    public static final float plate = 1.0f;
    public static final float wire = 0.125f;
    public static final float powder_mult = 3.0f;
    public static final float powder = 3.0f;
    public static final float powder_tiny = 0.3f;
    public static final float block = 10.0f;
    public static final float crystal = 10.0f;
    public static final float billet = 0.5f;
    public static final float rtg = 1.5f;
    public static final float rod = 0.5f;
    public static final float rod_dual = 1.0f;
    public static final float rod_quad = 2.0f;
    public static final float rod_rbmk = 4.0f;
    public static final HazardTypeBase RADIATION = new HazardTypeRadiation();
    public static final HazardTypeBase DIGAMMA = new HazardTypeDigamma();
    public static final HazardTypeBase HOT = new HazardTypeHot();
    public static final HazardTypeBase BLINDING = new HazardTypeBlinding();
    public static final HazardTypeBase ASBESTOS = new HazardTypeAsbestos();
    public static final HazardTypeBase COAL = new HazardTypeCoal();
    public static final HazardTypeBase HYDROACTIVE = new HazardTypeHydroactive();
    public static final HazardTypeBase EXPLOSIVE = new HazardTypeExplosive();

    public static void registerItems() {
        HazardSystem.register(Items.field_151016_H, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register(Blocks.field_150335_W, HazardRegistry.makeData(EXPLOSIVE, 4.0f));
        HazardSystem.register(Items.field_151158_bO, HazardRegistry.makeData(EXPLOSIVE, 4.0f));
        HazardSystem.register("dustCoal", HazardRegistry.makeData(COAL, 3.0f));
        HazardSystem.register("dustSmallCoal", HazardRegistry.makeData(COAL, 0.3f));
        HazardSystem.register("dustLignite", HazardRegistry.makeData(COAL, 3.0f));
        HazardSystem.register("dustSmallLignite", HazardRegistry.makeData(COAL, 0.3f));
        HazardSystem.register(ModItems.ingot_semtex, HazardRegistry.makeData(EXPLOSIVE, 10.0f));
        HazardSystem.register(ModBlocks.block_semtex, HazardRegistry.makeData(EXPLOSIVE, 40.0f));
        HazardSystem.register(ModItems.trinitite, HazardRegistry.makeData(RADIATION, 0.1f));
        HazardSystem.register(ModItems.nuclear_waste_long, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.nuclear_waste_long_tiny, HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(ModItems.nuclear_waste_short, new HazardData().addEntry(RADIATION, 30.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.nuclear_waste_short_tiny, new HazardData().addEntry(RADIATION, 3.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.nuclear_waste_long_depleted, HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(ModItems.nuclear_waste_long_depleted_tiny, HazardRegistry.makeData(RADIATION, 0.05f));
        HazardSystem.register(ModItems.nuclear_waste_short_depleted, HazardRegistry.makeData(RADIATION, 3.0f));
        HazardSystem.register(ModItems.nuclear_waste_short_depleted_tiny, HazardRegistry.makeData(RADIATION, 0.3f));
        HazardSystem.register(ModItems.nuclear_waste, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardSystem.register(ModItems.nuclear_waste_tiny, HazardRegistry.makeData(RADIATION, 1.5f));
        HazardSystem.register(ModItems.nuclear_waste_vitrified, HazardRegistry.makeData(RADIATION, 7.5f));
        HazardSystem.register(ModItems.nuclear_waste_vitrified_tiny, HazardRegistry.makeData(RADIATION, 0.75f));
        HazardSystem.register(ModItems.waste_uranium, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardSystem.register(ModItems.waste_thorium, HazardRegistry.makeData(RADIATION, 10.0f));
        HazardSystem.register(ModItems.waste_plutonium, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardSystem.register(ModItems.waste_mox, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardSystem.register(ModItems.waste_schrabidium, new HazardData().addEntry(RADIATION, 15.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.waste_uranium_hot, new HazardData().addEntry(RADIATION, 10.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.waste_thorium_hot, new HazardData().addEntry(RADIATION, 15.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.waste_plutonium_hot, new HazardData().addEntry(RADIATION, 15.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.waste_mox_hot, new HazardData().addEntry(RADIATION, 15.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.waste_schrabidium_hot, new HazardData().addEntry(RADIATION, 40.0f).addEntry(HOT, 5.0f).addEntry(BLINDING, 5.0f));
        HazardSystem.register(ModItems.nugget_uranium_fuel, HazardRegistry.makeData(RADIATION, 0.05f));
        HazardSystem.register(ModItems.billet_uranium_fuel, HazardRegistry.makeData(RADIATION, 0.25f));
        HazardSystem.register(ModItems.ingot_uranium_fuel, HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(ModBlocks.block_uranium_fuel, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.nugget_plutonium_fuel, HazardRegistry.makeData(RADIATION, 0.425f));
        HazardSystem.register(ModItems.billet_plutonium_fuel, HazardRegistry.makeData(RADIATION, 2.125f));
        HazardSystem.register(ModItems.ingot_plutonium_fuel, HazardRegistry.makeData(RADIATION, 4.25f));
        HazardSystem.register(ModBlocks.block_plutonium_fuel, HazardRegistry.makeData(RADIATION, 42.5f));
        HazardSystem.register(ModItems.nugget_thorium_fuel, HazardRegistry.makeData(RADIATION, 0.175f));
        HazardSystem.register(ModItems.billet_thorium_fuel, HazardRegistry.makeData(RADIATION, 0.875f));
        HazardSystem.register(ModItems.ingot_thorium_fuel, HazardRegistry.makeData(RADIATION, 1.75f));
        HazardSystem.register(ModBlocks.block_thorium_fuel, HazardRegistry.makeData(RADIATION, 17.5f));
        HazardSystem.register(ModItems.nugget_neptunium_fuel, HazardRegistry.makeData(RADIATION, 0.15f));
        HazardSystem.register(ModItems.billet_neptunium_fuel, HazardRegistry.makeData(RADIATION, 0.75f));
        HazardSystem.register(ModItems.ingot_neptunium_fuel, HazardRegistry.makeData(RADIATION, 1.5f));
        HazardSystem.register(ModItems.nugget_mox_fuel, HazardRegistry.makeData(RADIATION, 0.25f));
        HazardSystem.register(ModItems.billet_mox_fuel, HazardRegistry.makeData(RADIATION, 1.25f));
        HazardSystem.register(ModItems.ingot_mox_fuel, HazardRegistry.makeData(RADIATION, 2.5f));
        HazardSystem.register(ModBlocks.block_mox_fuel, HazardRegistry.makeData(RADIATION, 25.0f));
        HazardSystem.register(ModItems.nugget_americium_fuel, HazardRegistry.makeData(RADIATION, 0.475f));
        HazardSystem.register(ModItems.billet_americium_fuel, HazardRegistry.makeData(RADIATION, 2.375f));
        HazardSystem.register(ModItems.ingot_americium_fuel, HazardRegistry.makeData(RADIATION, 4.75f));
        HazardSystem.register(ModItems.nugget_schrabidium_fuel, HazardRegistry.makeData(RADIATION, 0.585f));
        HazardSystem.register(ModItems.billet_schrabidium_fuel, HazardRegistry.makeData(RADIATION, 2.925f));
        HazardSystem.register(ModItems.ingot_schrabidium_fuel, HazardRegistry.makeData(RADIATION, 5.85f));
        HazardSystem.register(ModBlocks.block_schrabidium_fuel, HazardRegistry.makeData(RADIATION, 58.5f));
        HazardSystem.register(ModItems.nugget_hes, HazardRegistry.makeData(RADIATION, 0.585f));
        HazardSystem.register(ModItems.billet_hes, HazardRegistry.makeData(RADIATION, 2.925f));
        HazardSystem.register(ModItems.ingot_hes, HazardRegistry.makeData(RADIATION, 5.85f));
        HazardSystem.register(ModItems.nugget_les, HazardRegistry.makeData(RADIATION, 0.585f));
        HazardSystem.register(ModItems.billet_les, HazardRegistry.makeData(RADIATION, 2.925f));
        HazardSystem.register(ModItems.ingot_les, HazardRegistry.makeData(RADIATION, 5.85f));
        HazardSystem.register(ModItems.billet_balefire_gold, HazardRegistry.makeData(RADIATION, 250.0f));
        HazardSystem.register(ModItems.billet_po210be, HazardRegistry.makeData(RADIATION, 18.75f));
        HazardSystem.register(ModItems.billet_ra226be, HazardRegistry.makeData(RADIATION, 1.875f));
        HazardSystem.register(ModItems.billet_pu238be, HazardRegistry.makeData(RADIATION, 2.5f));
        HazardSystem.trafos.add(new HazardTransformerRadiationNBT());
    }

    private static HazardData makeData() {
        return new HazardData();
    }

    private static HazardData makeData(HazardTypeBase hazard) {
        return new HazardData().addEntry(hazard);
    }

    private static HazardData makeData(HazardTypeBase hazard, float level) {
        return new HazardData().addEntry(hazard, level);
    }

    private static HazardData makeData(HazardTypeBase hazard, float level, boolean override) {
        return new HazardData().addEntry(hazard, level, override);
    }
}

