/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.HomeData;
import bletch.tektopiainformation.network.data.VillageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureType;

public class HomesData {
    protected static final String NBTTAG_VILLAGE_HOMES = "homes";
    protected static final String NBTTAG_VILLAGE_HOMESLIST = "list";
    protected static final String NBTTAG_VILLAGE_HOMETYPECOUNTS = "types";
    protected static final String NBTTAG_VILLAGE_HOMETYPENAME = "name";
    protected static final String NBTTAG_VILLAGE_HOMETYPECOUNT = "count";
    protected VillageData villageData;
    protected List<HomeData> homes;
    protected Map<VillageStructureType, Integer> homeTypeCounts;

    public HomesData() {
        this.populateData(null, null);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getHomesCount() {
        return this.homes == null ? 0 : this.homes.size();
    }

    public List<HomeData> getHomes() {
        return this.homes == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.homes.stream().sorted(Comparator.comparing(c -> c.getStructureType().name()).thenComparing(HomeData::getFramePosition)).collect(Collectors.toList()));
    }

    public List<HomeData> getHomesByType(VillageStructureType structureType) {
        return this.homes == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.homes.stream().filter(h -> h.getStructureType().equals((Object)structureType)).sorted(Comparator.comparing(HomeData::getFramePosition)).collect(Collectors.toList()));
    }

    public HomeData getHome(int index) {
        return this.homes == null ? null : this.homes.get(index);
    }

    public HomeData getHomeById(int homeId) {
        return this.homes == null ? null : (HomeData)this.homes.stream().filter(r -> homeId > 0 && homeId == r.getHomeId()).findFirst().orElse(null);
    }

    public HomeData getHomeByBedPosition(BlockPos bedPosition) {
        return this.homes == null ? null : (HomeData)this.homes.stream().filter(h -> bedPosition != null && h.getBedPositions().contains(bedPosition)).findFirst().orElse(null);
    }

    public HomeData getHomeByFramePosition(BlockPos framePosition) {
        return this.homes == null ? null : (HomeData)this.homes.stream().filter(h -> framePosition != null && framePosition.equals((Object)h.getFramePosition())).findFirst().orElse(null);
    }

    public Map<VillageStructureType, Integer> getHomeTypeCounts() {
        return this.homeTypeCounts == null ? Collections.unmodifiableMap(new LinkedHashMap()) : Collections.unmodifiableMap(this.homeTypeCounts.entrySet().stream().sorted(Comparator.comparing(c -> ((VillageStructureType)c.getKey()).name())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public int getHomeTypeCount(VillageStructureType structureType) {
        return this.homeTypeCounts != null && structureType != null && this.homeTypeCounts.containsKey(structureType) ? this.homeTypeCounts.get(structureType) : 0;
    }

    public int getResidentCountByType(VillageStructureType structureType) {
        int[] total = new int[]{0};
        if (this.homes != null) {
            this.homes.stream().filter(h -> structureType != null && structureType.equals((Object)h.getStructureType())).forEach(h -> {
                total[0] = total[0] + h.getResidentsCount();
            });
        }
        return total[0];
    }

    public int getMaxBeds() {
        int[] total = new int[]{0};
        if (this.homes != null) {
            this.homes.forEach(h -> {
                total[0] = total[0] + h.getMaxBeds();
            });
        }
        return total[0];
    }

    public int getTotalBeds() {
        int[] total = new int[]{0};
        if (this.homes != null) {
            this.homes.forEach(h -> {
                total[0] = total[0] + h.getBedCount();
            });
        }
        return total[0];
    }

    protected void clearData() {
        this.homes = new ArrayList<HomeData>();
        this.homeTypeCounts = new LinkedHashMap<VillageStructureType, Integer>();
    }

    public void populateData(VillageData villageData, Village village) {
        this.clearData();
        this.villageData = villageData;
        if (village != null) {
            Map<VillageStructureType, List<VillageStructure>> homesList = TektopiaUtils.getVillageHomes(village);
            for (Map.Entry<VillageStructureType, List<VillageStructure>> entry : homesList.entrySet()) {
                List<VillageStructure> structures = homesList.get(entry.getKey());
                this.homeTypeCounts.put(entry.getKey(), structures.size());
                for (VillageStructure structure : structures) {
                    this.homes.add(new HomeData(villageData, structure));
                }
            }
        }
    }

    public void readNBT(VillageData villageData, NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.villageData = villageData;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMES)) {
            int index;
            NBTTagCompound nbtHomesData = nbtTag.func_74775_l(NBTTAG_VILLAGE_HOMES);
            if (nbtHomesData.func_74764_b(NBTTAG_VILLAGE_HOMETYPECOUNTS)) {
                NBTTagList nbtTagHomeCounts = nbtHomesData.func_150295_c(NBTTAG_VILLAGE_HOMETYPECOUNTS, 10);
                for (index = 0; index < nbtTagHomeCounts.func_74745_c(); ++index) {
                    NBTTagCompound nbtTagHomeCount = nbtTagHomeCounts.func_150305_b(index);
                    VillageStructureType homeType = VillageStructureType.valueOf((String)nbtTagHomeCount.func_74779_i(NBTTAG_VILLAGE_HOMETYPENAME));
                    this.homeTypeCounts.put(homeType, nbtTagHomeCount.func_74762_e(NBTTAG_VILLAGE_HOMETYPECOUNT));
                }
            }
            if (nbtHomesData.func_74764_b(NBTTAG_VILLAGE_HOMESLIST)) {
                NBTTagList nbtTagListHomes = nbtHomesData.func_150295_c(NBTTAG_VILLAGE_HOMESLIST, 10);
                for (index = 0; index < nbtTagListHomes.func_74745_c(); ++index) {
                    this.homes.add(new HomeData(villageData, nbtTagListHomes.func_150305_b(index)));
                }
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        NBTTagCompound nbtHomesData = new NBTTagCompound();
        if (this.homeTypeCounts != null) {
            NBTTagList nbtTagListHomeCounts = new NBTTagList();
            for (Map.Entry entry : this.homeTypeCounts.entrySet()) {
                NBTTagCompound nbtTagHomeCount = new NBTTagCompound();
                nbtTagHomeCount.func_74778_a(NBTTAG_VILLAGE_HOMETYPENAME, ((VillageStructureType)entry.getKey()).name());
                nbtTagHomeCount.func_74768_a(NBTTAG_VILLAGE_HOMETYPECOUNT, ((Integer)entry.getValue()).intValue());
                nbtTagListHomeCounts.func_74742_a((NBTBase)nbtTagHomeCount);
            }
            if (!nbtTagListHomeCounts.func_82582_d()) {
                nbtHomesData.func_74782_a(NBTTAG_VILLAGE_HOMETYPECOUNTS, (NBTBase)nbtTagListHomeCounts);
            }
        }
        if (this.homes != null) {
            NBTTagList nbtTagListHomes = new NBTTagList();
            for (HomeData homeData : this.homes) {
                NBTTagCompound nbtTagHome = homeData.writeNBT(new NBTTagCompound());
                if (nbtTagHome.func_82582_d()) continue;
                nbtTagListHomes.func_74742_a((NBTBase)nbtTagHome);
            }
            if (!nbtTagListHomes.func_82582_d()) {
                nbtHomesData.func_74782_a(NBTTAG_VILLAGE_HOMESLIST, (NBTBase)nbtTagListHomes);
            }
        }
        if (!nbtHomesData.func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_HOMES, (NBTBase)nbtHomesData);
        }
        return nbtTag;
    }
}

