/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.gui;

import bletch.common.utils.Font;
import bletch.common.utils.RenderUtils;
import bletch.common.utils.StringUtils;
import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.TektopiaInformation;
import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.core.ModSounds;
import bletch.tektopiainformation.enums.GuiMapMarkerType;
import bletch.tektopiainformation.enums.GuiMapQuadrant;
import bletch.tektopiainformation.enums.GuiPageType;
import bletch.tektopiainformation.gui.GuiBookmark;
import bletch.tektopiainformation.gui.GuiButton;
import bletch.tektopiainformation.gui.GuiHyperlink;
import bletch.tektopiainformation.gui.GuiMapMarker;
import bletch.tektopiainformation.gui.GuiPage;
import bletch.tektopiainformation.gui.GuiTexture;
import bletch.tektopiainformation.gui.GuiTooltip;
import bletch.tektopiainformation.network.data.EconomyData;
import bletch.tektopiainformation.network.data.EnemiesData;
import bletch.tektopiainformation.network.data.EnemyData;
import bletch.tektopiainformation.network.data.EntityData;
import bletch.tektopiainformation.network.data.HomeData;
import bletch.tektopiainformation.network.data.HomesData;
import bletch.tektopiainformation.network.data.ResidentData;
import bletch.tektopiainformation.network.data.ResidentsData;
import bletch.tektopiainformation.network.data.StructureData;
import bletch.tektopiainformation.network.data.StructuresData;
import bletch.tektopiainformation.network.data.VillageData;
import bletch.tektopiainformation.network.data.VisitorData;
import bletch.tektopiainformation.network.data.VisitorsData;
import bletch.tektopiainformation.utils.LoggerUtils;
import java.awt.Color;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.structures.VillageStructureType;
import org.lwjgl.input.Mouse;

public class GuiTektopiaBook
extends GuiScreen {
    private static final String BUTTON_KEY_BACK = "back";
    private static final String BUTTON_KEY_PREVIOUSPAGE = "previouspage";
    private static final String BUTTON_KEY_PREVIOUSSUBPAGE = "previoussubpage";
    private static final String BUTTON_KEY_NEXTPAGE = "nextpage";
    private static final String BUTTON_KEY_NEXTSUBPAGE = "nextsubpage";
    private static final String BUTTON_KEY_STARTBOOK = "startbook";
    private static final String BUTTON_KEY_ENDBOOK = "endbook";
    private static final String BUTTON_KEY_CLOSE = "close";
    private static final String BUTTON_KEY_AIFILTER = "aifilter";
    private static final String BUTTON_KEY_INVENTORY = "inventory";
    private static final String BUTTON_KEY_CLEARSELECTION = "clearselection";
    private static final String BUTTON_KEY_AIFILTERLINK = "aifilterLink";
    private static final String BUTTON_KEY_MAPLINK = "mapLink";
    private static final String BUTTON_KEY_HOMELINK = "homeLink";
    private static final String BUTTON_KEY_PROFESSIONLINK = "professionLink";
    private static final String BUTTON_KEY_RESIDENTLINK = "residentLink";
    private static final String BUTTON_KEY_STATISTICLINK = "statisticLink";
    private static final String BUTTON_KEY_STRUCTURELINK = "structureLink";
    private static final String BUTTON_KEY_VISITORLINK = "visitorLink";
    private static final String BUTTON_KEY_SHOWMAPBOUNDARIES = "showmapboundaries";
    private static final String BUTTON_KEY_SHOWMAPENEMIES = "showmapenemies";
    private static final String BUTTON_KEY_SHOWMAPHOMES = "showmaphomes";
    private static final String BUTTON_KEY_SHOWMAPVISITORS = "showmapvisitors";
    private static final String BUTTON_KEY_SHOWMAPPLAYER = "showmapplayer";
    private static final String BUTTON_KEY_SHOWMAPRESIDENTS = "showmapresidents";
    private static final String BUTTON_KEY_SHOWMAPSTRUCTURES = "showmapstructures";
    private static final String BUTTON_KEY_SHOWMAPTOWNHALL = "showmaptownhall";
    private static final String BUTTON_KEY_SHOWMAPSELECTEDONLY = "showmapselectedonly";
    private static final String BUTTON_KEY_SHOWMAPSELECTEDALWAYS = "showmapselectedalways";
    private static final String BOOKMARK_KEY_AIFILTER = "aifilters";
    private static final String BOOKMARK_KEY_ECONOMY = "economy";
    private static final String BOOKMARK_KEY_ENEMIES = "enemies";
    private static final String BOOKMARK_KEY_HOMES = "homes";
    private static final String BOOKMARK_KEY_MAP = "map";
    private static final String BOOKMARK_KEY_PROFESSIONS = "professions";
    private static final String BOOKMARK_KEY_RESIDENTS = "residents";
    private static final String BOOKMARK_KEY_STATISTICS = "statistics";
    private static final String BOOKMARK_KEY_STRUCTURES = "structures";
    private static final String BOOKMARK_KEY_VILLAGE = "village";
    private static final String BOOKMARK_KEY_VISITORS = "visitors";
    private static final String SUBPAGE_KEY_AIFILTER = "aifilter";
    private static final String SUBPAGE_KEY_INVENTORY = "inventory";
    private static final int BOOK_WIDTH = 512;
    private static final int BOOK_HEIGHT = 400;
    private static final int BOOKMARK_LEFT_X = -17;
    private static final int BOOKMARK_RIGHT_X = 488;
    private static final int BOOKMARK_WIDTH = 35;
    private static final int BOOKMARK_HEIGHT = 26;
    private static final int BOOKMARK_TOP_Y = 16;
    private static final int BOOKMARK_SPACE_Y = 2;
    private static final int PROFESSION_WIDTH = 56;
    private static final int PROFESSION_HEIGHT = 90;
    private static final int PAGE_HEADER_Y = 20;
    private static final int PAGE_BODY_Y = 32;
    private static final int PAGE_FOOTER_Y = 335;
    private static final int PAGE_LEFTPAGE_LEFTMARGIN_X = 35;
    private static final int PAGE_LEFTPAGE_RIGHTMARGIN_X = 247;
    private static final int PAGE_LEFTPAGE_WIDTH = 212;
    private static final int PAGE_LEFTPAGE_CENTER_X = 141;
    private static final int PAGE_LEFTPAGE_LEFTCENTER_X = 88;
    private static final int PAGE_RIGHTPAGE_LEFTMARGIN_X = 268;
    private static final int PAGE_RIGHTPAGE_RIGHTMARGIN_X = 480;
    private static final int PAGE_RIGHTPAGE_WIDTH = 212;
    private static final int PAGE_RIGHTPAGE_CENTER_X = 374;
    private static final int PAGE_RIGHTPAGE_LEFTCENTER_X = 321;
    private static final int PAGE_LANDSCAPE_WIDTH = 480;
    private static final int PAGE_LANDSCAPE_HEIGHT = 384;
    private static final int PAGE_PORTRAIT_WIDTH = 384;
    private static final int PAGE_PORTRAIT_HEIGHT = 384;
    private static final int SUBPAGE_LANDSCAPE_LEFT_X = 40;
    private static final int SUBPAGE_LANDSCAPE_TOP_Y = 55;
    private static final int SUBPAGE_LANDSCAPE_RIGHT_X = 440;
    private static final int SUBPAGE_LANDSCAPE_BOTTOM_Y = 320;
    private static final int SUBPAGE_LANDSCAPE_WIDTH = 400;
    private static final int SUBPAGE_LANDSCAPE_CENTER_X = 240;
    private static final int SUBPAGE_PORTRAIT_LEFT_X = 65;
    private static final int SUBPAGE_PORTRAIT_TOP_Y = 25;
    private static final int SUBPAGE_PORTRAIT_RIGHT_X = 315;
    private static final int SUBPAGE_PORTRAIT_BOTTOM_Y = 350;
    private static final int SUBPAGE_PORTRAIT_WIDTH = 250;
    private static final int SUBPAGE_PORTRAIT_CENTER_X = 190;
    private static final int MAP_PAGE_LEFT_X = 55;
    private static final int MAP_PAGE_TOP_Y = 70;
    private static final int MAP_PAGE_RIGHT_X = 455;
    private static final int MAP_PAGE_BOTTOM_Y = 310;
    private static final int MAP_PAGE_MIDDLE_X = 321;
    private static final int MAP_PAGE_MIDDLE_Y = 190;
    private static final int MAP_HEADER_Y = 45;
    private static final int MAP_AXIS_LENGTH_X = 120;
    private static final int MAP_AXIS_LENGTH_Y = 120;
    private static final int MAP_AXIS_INTERVAL_X = 10;
    private static final int MAP_AXIS_INTERVAL_Y = 10;
    private static final int MAP_AXIS_INTERVAL_X_COUNT = 12;
    private static final int MAP_AXIS_INTERVAL_Y_COUNT = 12;
    private static final float MAP_MARKER_SELECTED_SCALE = 1.5f;
    private static final int MAP_MARKER_SIZE = 16;
    private static final int MAP_TOOLTIP_SIZE_STRUCTURE = 10;
    private static final int MAP_TOOLTIP_SIZE_ENTITY = 5;
    private static final int LABEL_TRAILINGSPACE_X = 10;
    private static final int LINE_SPACE_Y = 2;
    private static final int LINE_SPACE_Y_HEADER = 2;
    private static final int LINE_SPACE_Y_IMAGE = 6;
    private static final int STRUCTURETYPES_PER_PAGE = 24;
    private static final int STRUCTURES_PER_PAGE = 22;
    private static final int STRUCTUREOCCUPANTS_PER_PAGE = 15;
    private static final int HOMETYPES_PER_PAGE = 24;
    private static final int HOMES_PER_PAGE = 21;
    private static final int HOMEBEDS_PER_PAGE = 6;
    private static final int PROFESSIONTYPES_PER_PAGE = 24;
    private static final int PROFESSIONS_PER_PAGE = 22;
    private static final int RESIDENTS_PER_PAGE = 24;
    private static final int VISITORS_PER_PAGE = 24;
    private static final int VISITORVENDORLIST0_PER_PAGE = 8;
    private static final int VISITORVENDORLIST_PER_PAGE = 15;
    private static final int ENEMIES_PER_PAGE = 24;
    private static final int STATRESIDENTS_PER_PAGE = 20;
    private static final int STATSTRUCTURES_PER_PAGE = 20;
    private static final int RESIDENTVENDORLIST_PER_PAGE = 15;
    private static final int SALESHISTORY_PER_PAGE = 16;
    private static final int SALESHISTORYLIST_PER_PAGE = 4;
    private static final int RECENTEATS_PER_PAGE = 5;
    private static final int ADDITIONALPROFESSIONS_PER_PAGE = 4;
    private static final int AIFILTERLIST_PER_PAGE = 23;
    private static final int INVENTORY_PER_LINE = 9;
    private static final int INVENTORYLINES_PER_PAGE = 3;
    private static final int AIFILTERRESIDENTS_PER_PAGE = 10;
    private static final ResourceLocation book = new ResourceLocation("tektopiainformation", "textures/gui/gui_book.png");
    private static final ResourceLocation bookmarkLeft = new ResourceLocation("tektopiainformation", "textures/gui/bookmark_left.png");
    private static final ResourceLocation bookmarkRight = new ResourceLocation("tektopiainformation", "textures/gui/bookmark_right.png");
    private static final ResourceLocation buttonBack = new ResourceLocation("tektopiainformation", "textures/gui/button_back.png");
    private static final ResourceLocation buttonPreviousPage = new ResourceLocation("tektopiainformation", "textures/gui/button_previous.png");
    private static final ResourceLocation buttonNextPage = new ResourceLocation("tektopiainformation", "textures/gui/button_next.png");
    private static final ResourceLocation buttonStartBook = new ResourceLocation("tektopiainformation", "textures/gui/button_start.png");
    private static final ResourceLocation buttonEndBook = new ResourceLocation("tektopiainformation", "textures/gui/button_end.png");
    private static final ResourceLocation buttonClose = new ResourceLocation("tektopiainformation", "textures/gui/button_close.png");
    private static final ResourceLocation buttonAiFilter = new ResourceLocation("tektopiainformation", "textures/gui/button_aifilter.png");
    private static final ResourceLocation buttonInventory = new ResourceLocation("tektopiainformation", "textures/gui/button_inventory.png");
    private static final ResourceLocation inventory = new ResourceLocation("tektopiainformation", "textures/gui/gui_inventory.png");
    private static final ResourceLocation page_landscape = new ResourceLocation("tektopiainformation", "textures/gui/gui_paper_landscape.png");
    private static final ResourceLocation page_portrait = new ResourceLocation("tektopiainformation", "textures/gui/gui_paper_portrait.png");
    private static final ResourceLocation mapMarkerTownHall = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_townhall.png");
    private static final ResourceLocation mapMarkerStructure = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_structure.png");
    private static final ResourceLocation mapMarkerHome = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_home.png");
    private static final ResourceLocation mapMarkerResidentFemale = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_resident_female.png");
    private static final ResourceLocation mapMarkerResidentMale = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_resident_male.png");
    private static final ResourceLocation mapMarkerVisitor = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_visitor.png");
    private static final ResourceLocation mapMarkerEnemy = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_enemy.png");
    private static final ResourceLocation mapMarkerPlayer = new ResourceLocation("tektopiainformation", "textures/gui/map_marker_player.png");
    private static final ResourceLocation mapCheckmarkTick = new ResourceLocation("tektopiainformation", "textures/gui/checkmark_tick.png");
    private static final ResourceLocation mapCheckmarkCross = new ResourceLocation("tektopiainformation", "textures/gui/checkmark_cross.png");
    private static Boolean showMapBoundaries = true;
    private static Boolean showMapTownHall = true;
    private static Boolean showMapStructures = true;
    private static Boolean showMapHomes = true;
    private static Boolean showMapResidents = true;
    private static Boolean showMapPlayer = true;
    private static Boolean showMapVisitors = true;
    private static Boolean showMapEnemies = true;
    private static Boolean showSelectedAlways = false;
    private Boolean showSelectedOnly = false;
    private VillageData villageData;
    private HashMap<String, ResourceLocation> bookmarkResources;
    private ArrayList<GuiPage> pages;
    private ArrayList<GuiBookmark> bookmarks;
    private final ArrayList<GuiButton> buttons;
    private ArrayList<GuiTooltip> tooltips;
    private Stack<Integer> pageHistory;
    private int leftPageIndex;
    private String subPageKey;
    private int subPageIndex;
    private int subPageCount;
    private float scale;
    private int x;
    private int y;
    private int xPageLandscape;
    private int yPageLandscape;
    private int xPagePortrait;
    private int yPagePortrait;

    public GuiTektopiaBook(VillageData villageData) {
        this.villageData = villageData;
        this.pages = new ArrayList();
        this.bookmarks = new ArrayList();
        this.buttons = new ArrayList();
        this.tooltips = new ArrayList();
        this.pageHistory = new Stack();
        this.scale = 1.0f;
        this.setLeftPageIndex(0);
        this.createBookmarkResources();
        this.createPages();
        this.setSubPage(null);
    }

    public VillageData getVillageData() {
        return this.villageData;
    }

    public int getLeftPageIndex() {
        return this.leftPageIndex;
    }

    public int getRightPageIndex() {
        return this.leftPageIndex + 1;
    }

    public boolean isStartOfBook() {
        return this.getLeftPageIndex() <= this.pages.stream().mapToInt(p -> p.getPageIndex()).min().orElse(0);
    }

    public boolean isEndOfBook() {
        return this.getRightPageIndex() >= this.pages.stream().mapToInt(p -> p.getPageIndex()).max().orElse(0);
    }

    public boolean func_73868_f() {
        return ModConfig.gui.tektopiaInformationBook.doesGuiPauseGame;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float oldZLevel;
        super.func_146276_q_();
        this.scale = 10.0f;
        this.scale = Math.min(this.scale, (float)this.field_146294_l / 512.0f);
        this.scale = Math.min(this.scale, (float)this.field_146295_m / 400.0f);
        this.x = (int)Math.max(1.0f, ((float)this.field_146294_l / this.scale - 512.0f) / 2.0f);
        this.y = (int)Math.max(1.0f, ((float)this.field_146295_m / this.scale - 400.0f) / 2.0f) + 10;
        this.xPageLandscape = this.x + 256 - 240;
        this.yPageLandscape = 0;
        this.xPagePortrait = this.x + 256 - 192;
        this.yPagePortrait = 0;
        this.tooltips.clear();
        this.createBookmarks();
        this.createButtons();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(book, this.field_73735_i, this.x, this.y, 0.0f, 0.0f, 512, 400, 512.0f, 512.0f);
        for (GuiBookmark bookmark : this.bookmarks) {
            if (bookmark.getBackground() != null && bookmark.getBackground().getTexture() != null) {
                oldZLevel = this.setZLevel(bookmark.getBackground().getZLevel());
                RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(bookmark.getBackground().getTexture(), this.field_73735_i, bookmark.getBackground().getLeft(), bookmark.getBackground().getTop(), bookmark.getBackground().getTextureLeft(), bookmark.getBackground().getTextureTop(), bookmark.getBackground().getWidth(), bookmark.getBackground().getHeight(), bookmark.getBackground().getTextureWidth(), bookmark.getBackground().getTextureHeight());
                this.setZLevel(oldZLevel);
            }
            if (bookmark.getIcon() == null || bookmark.getIcon().getTexture() == null) continue;
            oldZLevel = this.setZLevel(bookmark.getBackground().getZLevel());
            RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(bookmark.getIcon().getTexture(), this.field_73735_i, bookmark.getIcon().getLeft(), bookmark.getIcon().getTop(), bookmark.getIcon().getTextureLeft(), bookmark.getIcon().getTextureTop(), bookmark.getIcon().getWidth(), bookmark.getIcon().getHeight(), bookmark.getIcon().getTextureWidth(), bookmark.getIcon().getTextureHeight());
            this.setZLevel(oldZLevel);
        }
        Font.small.printLeft("", this.x, this.y, this.field_73735_i);
        this.drawPages(mouseX, mouseY, partialTicks);
        this.drawSubPages(mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (GuiButton button : this.buttons) {
            if (button.getIcon() == null || button.getIcon().getTexture() == null) continue;
            oldZLevel = this.setZLevel(button.getIcon().getZLevel());
            RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(button.getIcon().getTexture(), this.field_73735_i, button.getIcon().getLeft(), button.getIcon().getTop(), button.getIcon().getTextureLeft(), button.getIcon().getTextureTop(), button.getIcon().getWidth(), button.getIcon().getHeight(), button.getIcon().getTextureWidth(), button.getIcon().getTextureHeight());
            this.setZLevel(oldZLevel);
        }
        GlStateManager.func_179121_F();
        for (GuiTooltip tooltip : this.tooltips) {
            if (tooltip == null || !tooltip.withinBounds(mouseX, mouseY, this.scale)) continue;
            super.func_146283_a(tooltip.getTooltip(), mouseX, mouseY);
            break;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int pageScroll = Integer.signum(Mouse.getEventDWheel());
        if (pageScroll != 0) {
            if (this.isSubPageOpen().booleanValue()) {
                this.setSubPageIndex(this.subPageIndex + -pageScroll);
            } else {
                this.setLeftPageIndex(this.leftPageIndex + -(pageScroll * 2));
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.keyHandled = false;
        if (this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == keyCode) {
            super.func_73869_a(typedChar, 1);
            return;
        }
        switch (keyCode) {
            case 1: {
                if (!this.isSubPageOpen().booleanValue()) break;
                this.setSubPage(null);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                this.keyHandled = true;
                break;
            }
            case 17: 
            case 30: 
            case 200: 
            case 203: {
                if (this.isSubPageOpen().booleanValue()) {
                    this.movePreviousSubPage();
                    break;
                }
                this.movePreviousPage();
                break;
            }
            case 31: 
            case 32: 
            case 205: 
            case 208: {
                if (this.isSubPageOpen().booleanValue()) {
                    this.moveNextSubPage();
                    break;
                }
                this.moveNextPage();
                break;
            }
            case 199: {
                if (this.isSubPageOpen().booleanValue()) {
                    this.moveFirstSubPage();
                    break;
                }
                this.moveFirstPage();
                break;
            }
            case 207: {
                if (this.isSubPageOpen().booleanValue()) {
                    this.moveLastSubPage();
                    break;
                }
                this.moveLastPage();
                break;
            }
            case 201: {
                this.movePreviousBookmark();
                break;
            }
            case 209: {
                this.moveNextBookmark();
                break;
            }
            case 14: {
                if (this.isSubPageOpen().booleanValue()) break;
                this.movePreviousPageHistory();
                break;
            }
            case 63: {
                this.outputVillageDetails();
            }
        }
        if (!this.keyHandled) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (GuiBookmark bookmark : this.bookmarks) {
                if (bookmark == null || !bookmark.withinBounds(mouseX, mouseY, this.scale)) continue;
                this.actionPerformed(bookmark);
                break;
            }
            for (int i = this.buttons.size() - 1; i >= 0; --i) {
                GuiButton button = this.buttons.get(i);
                if (button == null || !button.withinBounds(mouseX, mouseY, this.scale)) continue;
                this.actionPerformed(button);
                break;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        this.clearPageHistory();
        this.pageHistory = null;
        this.tooltips.clear();
        this.tooltips = null;
        this.bookmarks.clear();
        this.bookmarks = null;
        this.pages.clear();
        this.pages = null;
        this.bookmarkResources.clear();
        this.bookmarkResources = null;
        this.villageData = null;
    }

    protected void addPage(GuiPage page) {
        if (page == null) {
            return;
        }
        this.pages.add(page);
        LoggerUtils.instance.info("Adding page " + page.getBookmarkKey() + "::" + (Object)((Object)page.getGuiPageType()) + "::" + page.getDataKey(), true);
    }

    protected void createBookmarkResources() {
        this.bookmarkResources = new HashMap();
        this.bookmarkResources.put(BOOKMARK_KEY_AIFILTER, new ResourceLocation("tektopiainformation", "textures/gui/button_aifilter.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_ECONOMY, new ResourceLocation("tektopiainformation", "textures/gui/icon_economy.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_ENEMIES, new ResourceLocation("tektopiainformation", "textures/gui/icon_enemy.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_HOMES, new ResourceLocation("tektopiainformation", "textures/gui/icon_home.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_MAP, new ResourceLocation("tektopiainformation", "textures/gui/icon_map.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_PROFESSIONS, new ResourceLocation("tektopiainformation", "textures/gui/icon_profession.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_RESIDENTS, new ResourceLocation("tektopiainformation", "textures/gui/icon_resident.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_STATISTICS, new ResourceLocation("tektopiainformation", "textures/gui/icon_statistics.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_STRUCTURES, new ResourceLocation("tektopiainformation", "textures/gui/icon_structure.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_VILLAGE, new ResourceLocation("tektopiainformation", "textures/gui/icon_summary.png"));
        this.bookmarkResources.put(BOOKMARK_KEY_VISITORS, new ResourceLocation("tektopiainformation", "textures/gui/icon_visitor.png"));
    }

    protected void createBookmarks() {
        int[] tXL = new int[]{this.x + -17};
        int[] tXR = new int[]{this.x + 488};
        int[] tY = new int[]{this.y + 16};
        this.bookmarks.clear();
        this.pages.stream().filter(p -> !Objects.equals(p.getBookmarkKey(), "")).forEach(p -> {
            GuiBookmark bookmark = new GuiBookmark(p.getBookmarkKey(), p.getPageIndex());
            ResourceLocation icon = null;
            if (this.bookmarkResources.containsKey(p.getBookmarkKey())) {
                icon = this.bookmarkResources.get(p.getBookmarkKey());
            }
            if (p.getPageIndex() <= this.getLeftPageIndex()) {
                bookmark.setBackground(bookmarkLeft, this.field_73735_i, tXL[0], tY[0], 35, 26, 0, 0, 75, 75);
                if (icon != null) {
                    bookmark.setIcon(icon, this.field_73735_i, tXL[0] + 12, tY[0] + 5, 16, 16, 0, 0, 16, 16);
                    tXL[0] = tXL[0] + 1;
                }
            } else {
                bookmark.setBackground(bookmarkRight, this.field_73735_i, tXR[0], tY[0], 35, 26, 0, 0, 75, 75);
                if (icon != null) {
                    bookmark.setIcon(icon, this.field_73735_i, tXR[0] + 7, tY[0] + 5, 16, 16, 0, 0, 16, 16);
                    tXR[0] = tXR[0] + 1;
                }
            }
            this.bookmarks.add(bookmark);
            String tooltipText = bookmark.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(tooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(bookmark.getBackground().getLeft(), bookmark.getBackground().getTop(), bookmark.getBackground().getWidth(), bookmark.getBackground().getHeight(), tooltipText));
            }
            tY[0] = tY[0] + 28;
        });
    }

    protected void createButtons() {
        String tooltipText;
        GuiButton button;
        int tY;
        int tX;
        this.buttons.clear();
        if (!this.isSubPageOpen().booleanValue() && !this.pageHistory.empty()) {
            tX = this.x + 247 - 16;
            tY = this.y + 335 - 5;
            button = new GuiButton(BUTTON_KEY_BACK);
            button.setIcon(buttonBack, this.field_73735_i, tX, tY, 16, 16, 0, 0, 16, 16);
            this.buttons.add(button);
            tooltipText = button.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(tooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(button.getIcon().getLeft(), button.getIcon().getTop(), button.getIcon().getWidth(), button.getIcon().getHeight(), tooltipText));
            }
        }
        if (!this.isStartOfBook()) {
            tX = this.x + 35 + 4;
            tY = this.y + 335 - 5;
            button = new GuiButton(BUTTON_KEY_STARTBOOK);
            button.setIcon(buttonStartBook, this.field_73735_i, tX, tY, 16, 16, 0, 0, 16, 16);
            this.buttons.add(button);
            tooltipText = button.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(tooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(button.getIcon().getLeft(), button.getIcon().getTop(), button.getIcon().getWidth(), button.getIcon().getHeight(), tooltipText));
            }
            tX += button.getIcon().getWidth() + 4;
            button = new GuiButton(BUTTON_KEY_PREVIOUSPAGE);
            button.setIcon(buttonPreviousPage, this.field_73735_i, tX, tY, 16, 16, 0, 0, 16, 16);
            this.buttons.add(button);
            tooltipText = button.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(tooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(button.getIcon().getLeft(), button.getIcon().getTop(), button.getIcon().getWidth(), button.getIcon().getHeight(), tooltipText));
            }
            tX += button.getIcon().getWidth() + 4;
        }
        if (!this.isEndOfBook()) {
            tX = this.x + 480 - 20;
            tY = this.y + 335 - 5;
            button = new GuiButton(BUTTON_KEY_ENDBOOK);
            button.setIcon(buttonEndBook, this.field_73735_i, tX, tY, 16, 16, 0, 0, 16, 16);
            this.buttons.add(button);
            tooltipText = button.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(tooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(button.getIcon().getLeft(), button.getIcon().getTop(), button.getIcon().getWidth(), button.getIcon().getHeight(), tooltipText));
            }
            tX -= button.getIcon().getWidth() + 4;
            button = new GuiButton(BUTTON_KEY_NEXTPAGE);
            button.setIcon(buttonNextPage, this.field_73735_i, tX, tY, 16, 16, 0, 0, 16, 16);
            this.buttons.add(button);
            tooltipText = button.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(tooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(button.getIcon().getLeft(), button.getIcon().getTop(), button.getIcon().getWidth(), button.getIcon().getHeight(), tooltipText));
            }
            int n = tX - (button.getIcon().getWidth() + 4);
        }
    }

    protected void createPages() {
        int page;
        int pages;
        int count;
        int page2;
        int pages2;
        int count2;
        int page3;
        int pages3;
        this.pages.clear();
        if (this.villageData == null) {
            return;
        }
        EconomyData economyData = this.villageData.getEconomyData();
        HomesData homesData = this.villageData.getHomesData();
        ResidentsData residentsData = this.villageData.getResidentsData();
        StructuresData structuresData = this.villageData.getStructuresData();
        VisitorsData visitorsData = this.villageData.getVisitorsData();
        EnemiesData enemiesData = this.villageData.getEnemiesData();
        int startPageIndex = 0;
        int pageIndex = 0;
        this.addPage(new GuiPage(GuiPageType.INSIDECOVER, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.addPage(new GuiPage(GuiPageType.TITLE, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_VILLAGE, 0), BOOKMARK_KEY_VILLAGE));
        this.addPage(new GuiPage(GuiPageType.VILLAGE, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        if (structuresData != null) {
            int count3;
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_STRUCTURES, 0), BOOKMARK_KEY_STRUCTURES));
            Map<VillageStructureType, Integer> structureTypeCounts = structuresData.getStructureTypeCounts();
            if (structureTypeCounts != null && (count3 = structureTypeCounts.size()) > 0) {
                pages3 = count3 / 24;
                if (count3 % 24 > 0) {
                    ++pages3;
                }
                for (page3 = 0; page3 < pages3; ++page3) {
                    this.addPage(new GuiPage(GuiPageType.STRUCTURE, pageIndex++, GuiTektopiaBook.getPageKey("", page3)));
                }
            }
            for (VillageStructureType structureType : structureTypeCounts.keySet()) {
                List<StructureData> structuresByType = structuresData.getStructuresByType(structureType);
                count2 = structuresByType.size();
                if (count2 <= 0) continue;
                pages2 = count2 / 22;
                if (count2 % 22 > 0) {
                    ++pages2;
                }
                for (page2 = 0; page2 < pages2; ++page2) {
                    this.addPage(new GuiPage(GuiPageType.STRUCTURETYPE, pageIndex++, GuiTektopiaBook.getStructureTypePageKey(structureType, page2)));
                }
            }
            for (StructureData structure : structuresData.getStructures()) {
                count = structure.getOccupantCount();
                pages = count / 15;
                if (count % 15 > 0) {
                    ++pages;
                }
                pages = Math.max(1, pages);
                for (page = 0; page < pages; ++page) {
                    if (page == 0 && this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == structure.getStructureId()) {
                        startPageIndex = pageIndex;
                    } else if (page == 0 && this.villageData.getFramePosition() != null && structure.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)structure.getFramePosition())) {
                        startPageIndex = pageIndex;
                    }
                    this.addPage(new GuiPage(GuiPageType.STRUCTURE, pageIndex++, GuiTektopiaBook.getStructureDetailPageKey(structure.getStructureId(), page)));
                }
            }
        }
        if (homesData != null) {
            int count4;
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_HOMES, 0), BOOKMARK_KEY_HOMES));
            Map<VillageStructureType, Integer> homeTypeCounts = homesData.getHomeTypeCounts();
            if (homeTypeCounts != null && (count4 = homeTypeCounts.size()) > 0) {
                pages3 = count4 / 24;
                if (count4 % 24 > 0) {
                    ++pages3;
                }
                for (page3 = 0; page3 < pages3; ++page3) {
                    this.addPage(new GuiPage(GuiPageType.HOME, pageIndex++, GuiTektopiaBook.getPageKey("", page3)));
                }
            }
            if (homesData.getHomes() != null) {
                for (VillageStructureType homeType : homeTypeCounts.keySet()) {
                    List<HomeData> homesByType = homesData.getHomesByType(homeType);
                    count2 = homesByType.size();
                    if (count2 <= 0) continue;
                    pages2 = count2 / 21;
                    if (count2 % 21 > 0) {
                        ++pages2;
                    }
                    for (page2 = 0; page2 < pages2; ++page2) {
                        this.addPage(new GuiPage(GuiPageType.HOMETYPE, pageIndex++, GuiTektopiaBook.getStructureTypePageKey(homeType, page2)));
                    }
                }
                for (HomeData homeData : homesData.getHomes()) {
                    count = homeData.getMaxBeds();
                    if (count <= 0) continue;
                    pages = count / 6;
                    if (count % 6 > 0) {
                        ++pages;
                    }
                    for (page = 0; page < pages; ++page) {
                        if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == homeData.getHomeId()) {
                            startPageIndex = pageIndex;
                        } else if (page == 0 && this.villageData.getFramePosition() != null && homeData.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)homeData.getFramePosition())) {
                            startPageIndex = pageIndex;
                        }
                        this.addPage(new GuiPage(GuiPageType.HOME, pageIndex++, GuiTektopiaBook.getStructureDetailPageKey(homeData.getHomeId(), page)));
                    }
                }
            }
        }
        if (residentsData != null) {
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_PROFESSIONS, 0), BOOKMARK_KEY_PROFESSIONS));
            Map<String, Integer> professionTypeCounts = residentsData.getProfessionTypeCountsAll();
            int count5 = professionTypeCounts.size();
            pages3 = count5 / 24;
            if (count5 % 24 > 0) {
                ++pages3;
            }
            pages3 = Math.max(1, pages3);
            for (page3 = 0; page3 < pages3; ++page3) {
                this.addPage(new GuiPage(GuiPageType.PROFESSION, pageIndex++, GuiTektopiaBook.getPageKey("", page3)));
            }
            for (Map.Entry<String, Integer> entry : professionTypeCounts.entrySet()) {
                count5 = entry.getValue();
                if (count5 <= 0) continue;
                pages3 = count5 / 22;
                if (count5 % 22 > 0) {
                    ++pages3;
                }
                for (page = 0; page < pages3; ++page) {
                    this.addPage(new GuiPage(GuiPageType.PROFESSIONTYPE, pageIndex++, GuiTektopiaBook.getProfessionDetailPageKey(entry.getKey(), page)));
                }
            }
        }
        if (residentsData != null) {
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_RESIDENTS, 0), BOOKMARK_KEY_RESIDENTS));
            int count6 = residentsData.getResidentsCountAll();
            int pages4 = count6 / 24;
            if (count6 % 24 > 0) {
                ++pages4;
            }
            pages4 = Math.max(1, pages4);
            for (int page4 = 0; page4 < pages4; ++page4) {
                this.addPage(new GuiPage(GuiPageType.RESIDENT, pageIndex++, GuiTektopiaBook.getPageKey("", page4)));
            }
            for (ResidentData residentData : residentsData.getResidents()) {
                if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == residentData.getId()) {
                    startPageIndex = pageIndex;
                }
                if (this.villageData.getBedPosition() != null && residentData.getBedPosition() != null && this.villageData.getBedPosition().equals((Object)residentData.getBedPosition())) {
                    startPageIndex = pageIndex;
                }
                this.addPage(new GuiPage(GuiPageType.RESIDENT, pageIndex++, GuiTektopiaBook.getResidentDetailPageKey(residentData.getId())));
            }
        }
        if (visitorsData != null) {
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_VISITORS, 0), BOOKMARK_KEY_VISITORS));
            int count7 = visitorsData.getVisitorsCount();
            int pages5 = count7 / 24;
            if (count7 % 24 > 0) {
                ++pages5;
            }
            pages5 = Math.max(1, pages5);
            for (int page5 = 0; page5 < pages5; ++page5) {
                this.addPage(new GuiPage(GuiPageType.VISITOR, pageIndex++, GuiTektopiaBook.getPageKey("", page5)));
            }
            for (VisitorData visitorData : visitorsData.getVisitors()) {
                MerchantRecipeList recipeList;
                if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == visitorData.getId()) {
                    startPageIndex = pageIndex;
                }
                this.addPage(new GuiPage(GuiPageType.VISITOR, pageIndex++, GuiTektopiaBook.getPageKey("" + visitorData.getId(), 0)));
                if (!visitorData.isVendor() || (count7 = (recipeList = visitorData.getRecipeList()).size() - 8) <= 0) continue;
                pages5 = count7 / 15;
                if (count7 % 15 > 0) {
                    ++pages5;
                }
                for (page = 0; page < pages5; ++page) {
                    this.addPage(new GuiPage(GuiPageType.VISITOR, pageIndex++, GuiTektopiaBook.getResidentDetailPageKey(visitorData.getId(), page + 1)));
                }
            }
        }
        if (enemiesData != null) {
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_ENEMIES, 0), BOOKMARK_KEY_ENEMIES));
            int count8 = enemiesData.getEnemiesCount();
            int pages6 = count8 / 24;
            if (count8 % 24 > 0) {
                ++pages6;
            }
            pages6 = Math.max(1, pages6);
            for (int page6 = 0; page6 < pages6; ++page6) {
                this.addPage(new GuiPage(GuiPageType.ENEMY, pageIndex++, GuiTektopiaBook.getPageKey("", page6)));
            }
        }
        if (residentsData != null) {
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_AIFILTER, 0), BOOKMARK_KEY_AIFILTER));
            Map<String, Integer> professionTypeCounts = residentsData.getProfessionTypeCounts();
            int count9 = professionTypeCounts.size();
            int pages7 = count9 / 24;
            if (count9 % 24 > 0) {
                ++pages7;
            }
            pages7 = Math.max(1, pages7);
            for (int page7 = 0; page7 < pages7; ++page7) {
                this.addPage(new GuiPage(GuiPageType.AIFILTER, pageIndex++, GuiTektopiaBook.getPageKey("", page7)));
            }
            for (Map.Entry<String, Integer> entry : professionTypeCounts.entrySet()) {
                count9 = entry.getValue();
                if (count9 <= 0) continue;
                pages7 = count9 / 10;
                if (count9 % 10 > 0) {
                    ++pages7;
                }
                for (page = 0; page < pages7; ++page) {
                    this.addPage(new GuiPage(GuiPageType.AIFILTER, pageIndex++, GuiTektopiaBook.getAIFilterDetailPageKey(entry.getKey(), page)));
                }
            }
        }
        if (residentsData != null || structuresData != null) {
            List<StructureData> overcrowdingList;
            Map<Integer, List<ResidentData>> hungerMap;
            Map<Integer, List<ResidentData>> happinessMap;
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_STATISTICS, 0), BOOKMARK_KEY_STATISTICS));
            this.addPage(new GuiPage(GuiPageType.STATS, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            Map<Integer, List<ResidentData>> map = happinessMap = residentsData != null ? residentsData.getResidentHappinessStatistics() : null;
            if (happinessMap != null) {
                for (Map.Entry<Integer, List<ResidentData>> happinessEntry : happinessMap.entrySet()) {
                    int count10 = happinessEntry.getValue().size();
                    int pages8 = count10 / 20;
                    if (count10 % 20 > 0) {
                        ++pages8;
                    }
                    pages8 = Math.max(1, pages8);
                    for (page = 0; page < pages8; ++page) {
                        this.addPage(new GuiPage(GuiPageType.STATS, pageIndex++, GuiTektopiaBook.getStatisticsPageKey("happiness", happinessEntry.getKey(), page)));
                    }
                }
            }
            Map<Integer, List<ResidentData>> map2 = hungerMap = residentsData != null ? residentsData.getResidentHungerStatistics() : null;
            if (hungerMap != null) {
                for (Map.Entry<Integer, List<ResidentData>> hungerEntry : hungerMap.entrySet()) {
                    int count11 = hungerEntry.getValue().size();
                    pages2 = count11 / 20;
                    if (count11 % 20 > 0) {
                        ++pages2;
                    }
                    pages2 = Math.max(1, pages2);
                    for (page2 = 0; page2 < pages2; ++page2) {
                        this.addPage(new GuiPage(GuiPageType.STATS, pageIndex++, GuiTektopiaBook.getStatisticsPageKey("hunger", hungerEntry.getKey(), page2)));
                    }
                }
            }
            List<StructureData> list = overcrowdingList = structuresData != null ? structuresData.getStructuresOvercrowded() : null;
            if (overcrowdingList != null) {
                int count12 = overcrowdingList.size();
                int pages9 = count12 / 20;
                if (count12 % 20 > 0) {
                    ++pages9;
                }
                pages9 = Math.max(1, pages9);
                for (page = 0; page < pages9; ++page) {
                    this.addPage(new GuiPage(GuiPageType.STATS, pageIndex++, GuiTektopiaBook.getStatisticsPageKey("overcrowding", 0, page)));
                }
            }
        }
        if (economyData != null) {
            MerchantRecipeList recipeList;
            ResidentData tradesman;
            int count13;
            MerchantRecipeList recipeList2;
            if (pageIndex % 2 != 0) {
                this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
            }
            this.addPage(new GuiPage(GuiPageType.SUMMARY, pageIndex++, GuiTektopiaBook.getPageKey(BOOKMARK_KEY_ECONOMY, 0), BOOKMARK_KEY_ECONOMY));
            ResidentData architect = residentsData.getArchitect();
            if (architect != null && (recipeList2 = architect.getRecipeList()) != null && !recipeList2.isEmpty() && (count13 = recipeList2.size()) > 0) {
                int pages10 = count13 / 15;
                if (count13 % 15 > 0) {
                    ++pages10;
                }
                for (int page8 = 0; page8 < pages10; ++page8) {
                    this.addPage(new GuiPage(GuiPageType.ECONOMY, pageIndex++, GuiTektopiaBook.getPageKey("architectitems", page8)));
                }
            }
            if ((tradesman = residentsData.getTradesman()) != null && (recipeList = tradesman.getRecipeList()) != null && !recipeList.isEmpty() && (count = recipeList.size()) > 0) {
                int pages11 = count / 15;
                if (count % 15 > 0) {
                    ++pages11;
                }
                for (page = 0; page < pages11; ++page) {
                    this.addPage(new GuiPage(GuiPageType.ECONOMY, pageIndex++, GuiTektopiaBook.getPageKey("tradesmanitems", page)));
                }
            }
            count = economyData.getMerchantSales();
            int pages12 = count / 64;
            if (count % 64 > 0) {
                ++pages12;
            }
            pages12 = Math.max(1, pages12);
            for (int page9 = 0; page9 < pages12; ++page9) {
                this.addPage(new GuiPage(GuiPageType.ECONOMY, pageIndex++, GuiTektopiaBook.getPageKey("saleshistory", page9)));
            }
        }
        if (pageIndex % 2 != 0) {
            this.addPage(new GuiPage(GuiPageType.BLANK, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        }
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey(GuiMapQuadrant.ALL.name(), 0), BOOKMARK_KEY_MAP));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey(GuiMapQuadrant.NORTHWEST.name(), 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey(GuiMapQuadrant.NORTHEAST.name(), 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey(GuiMapQuadrant.SOUTHWEST.name(), 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey(GuiMapQuadrant.SOUTHEAST.name(), 0)));
        this.addPage(new GuiPage(GuiPageType.MAP, pageIndex++, GuiTektopiaBook.getPageKey("", 0)));
        this.setLeftPageIndex(startPageIndex);
    }

    protected void drawPageHeader(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        String headerText = TextUtils.translate("tektopiaBook.name", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(headerText).booleanValue()) {
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(headerText, this.x + 35, this.y + 20, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printRight(headerText, this.x + 480, this.y + 20, this.field_73735_i);
            }
        }
    }

    protected void drawPageFooter(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        if (guiPage.isLeftPage()) {
            Font.small.printCentered(this.leftPageIndex, this.x + 141, this.y + 335, this.field_73735_i);
        }
        if (guiPage.isRightPage()) {
            Font.small.printCentered(this.leftPageIndex + 1, this.x + 374, this.y + 335, this.field_73735_i);
        }
    }

    protected void drawPages(int mouseX, int mouseY, float partialTicks) {
        int[] pageIndex = new int[]{this.leftPageIndex};
        for (int index = 0; index < 2; ++index) {
            GuiPage guiPage = this.pages.stream().filter(p -> p.getPageIndex() == pageIndex[0]).findFirst().orElse(null);
            if (guiPage != null) {
                switch (guiPage.getGuiPageType()) {
                    case BLANK: {
                        this.drawPageBlank(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case AIFILTER: {
                        this.drawPageAIFilter(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case ECONOMY: {
                        this.drawPageEconomy(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case ENEMY: {
                        this.drawPageEnemy(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case HOME: {
                        this.drawPageHome(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case HOMETYPE: {
                        this.drawPageHomeType(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case MAP: {
                        this.drawPageMap(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case PROFESSION: {
                        this.drawPageProfession(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case PROFESSIONTYPE: {
                        this.drawPageProfessionType(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case RESIDENT: {
                        this.drawPageResident(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case STATS: {
                        this.drawPageStatistics(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case STRUCTURE: {
                        this.drawPageStructure(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case STRUCTURETYPE: {
                        this.drawPageStructureType(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case SUMMARY: {
                        this.drawPageSummary(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case TITLE: {
                        this.drawPageTitle(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case VILLAGE: {
                        this.drawPageVillage(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                    case VISITOR: {
                        this.drawPageVisitor(mouseX, mouseY, partialTicks, guiPage);
                        break;
                    }
                }
            }
            pageIndex[0] = pageIndex[0] + 1;
        }
    }

    protected void drawPageBlank(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
    }

    protected void drawPageAIFilter(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        block41: {
            int page;
            String continued;
            ResidentsData residentsData;
            String[] dataKey;
            int x2;
            int x1;
            int indentX;
            int y;
            block40: {
                int page2;
                Map<String, Integer> mainProfessionTypeCounts;
                this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
                this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
                y = this.y + 32;
                indentX = 10;
                x1 = 0;
                x2 = 0;
                dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
                residentsData = this.villageData.getResidentsData();
                continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
                if (!dataKey[0].equals("")) break block40;
                String typeHeader = TextUtils.translate("tektopiaBook.professions.professiontypes", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(typeHeader).booleanValue()) {
                    if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                        typeHeader = typeHeader + " " + continued;
                    }
                    typeHeader = TextFormatting.DARK_BLUE + typeHeader;
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(typeHeader, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(typeHeader, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                Map<String, Integer> map = mainProfessionTypeCounts = residentsData != null ? residentsData.getProfessionTypeCounts() : null;
                if (mainProfessionTypeCounts == null) break block41;
                int[] maxLength = new int[]{0};
                String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
                String countHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.count", new Object[0]);
                maxLength[0] = maxLength[0] + Font.small.getStringWidth(countHeader);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(countHeader, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(countHeader, this.x + 374, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page2 = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page2 = 0;
                }
                int startIndex = page2 * 24;
                int endIndex = Math.min(mainProfessionTypeCounts.size(), startIndex + 24);
                List subList = mainProfessionTypeCounts.entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
                for (Map.Entry professionTypeEntry : subList) {
                    String typeName = GuiTektopiaBook.getTypeName((String)professionTypeEntry.getKey());
                    int typeCount = (Integer)professionTypeEntry.getValue();
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(typeName, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(typeCount, this.x + 141 + maxLength[0], y, this.field_73735_i);
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(typeName);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(typeName, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(typeCount, this.x + 374 + maxLength[0], y, this.field_73735_i);
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(typeName);
                    }
                    if (!this.isSubPageOpen().booleanValue() && typeCount > 0) {
                        GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_AIFILTERLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.AIFILTER, GuiTektopiaBook.getAIFilterDetailPageKey((String)professionTypeEntry.getKey())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.aifilterdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                break block41;
            }
            String professionType = dataKey[0];
            List<ResidentData> residents = residentsData != null ? residentsData.getResidentsByType(professionType, false) : null;
            String typeName = GuiTektopiaBook.getTypeName(professionType);
            if (!StringUtils.isNullOrWhitespace(typeName).booleanValue()) {
                if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                    typeName = typeName + " " + continued;
                }
                typeName = TextFormatting.DARK_BLUE + typeName;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(typeName, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(typeName, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            if (dataKey[1].equals("0")) {
                String totalLabel = TextUtils.translate("tektopiaBook.professiontypes.total", new Object[0]);
                String totalText = "";
                if (!StringUtils.isNullOrWhitespace(totalLabel).booleanValue()) {
                    if (residents != null) {
                        totalText = totalText + "" + residents.size();
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(totalLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(totalText, this.x + 141 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(totalLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(totalText, this.x + 374 + indentX, y, this.field_73735_i);
                    }
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2 + 2;
            String header = TextUtils.translate("tektopiaBook.aifilters.header", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                header = TextFormatting.DARK_BLUE + header;
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(header, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(header, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String nameHeader = TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(nameHeader).booleanValue()) {
                nameHeader = TextFormatting.UNDERLINE + nameHeader;
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                }
            }
            try {
                page = Integer.parseInt(dataKey[1]);
            }
            catch (NumberFormatException e) {
                page = 0;
            }
            int startIndex = page * 10;
            int endIndex = Math.min(residents.size(), startIndex + 10);
            int xIndent = indentX;
            int yStart = y;
            int valueWidth = Math.max(Font.small.getStringWidth(TextUtils.SYMBOL_GREENTICK), Font.small.getStringWidth(TextUtils.SYMBOL_REDCROSS));
            int aiFilterNameMaxLength = 100;
            List<ResidentData> subList = residents.subList(startIndex, endIndex);
            for (ResidentData resident : subList) {
                GuiTooltip toolTip;
                String residentHeader = TextFormatting.UNDERLINE + (resident.isMale() ? TextUtils.SYMBOL_MALE : TextUtils.SYMBOL_FEMALE);
                String residentName = GuiTektopiaBook.formatResidentName(resident.isMale(), resident.getName(), true);
                if (guiPage.isLeftPage()) {
                    Font.small.printCentered(residentHeader, this.x + 141 + xIndent, y, this.field_73735_i);
                    x1 = this.x + 141 + xIndent - valueWidth / 2;
                    x2 = x1 + valueWidth;
                }
                if (guiPage.isRightPage()) {
                    Font.small.printCentered(residentHeader, this.x + 374 + xIndent, y, this.field_73735_i);
                    x1 = this.x + 374 + xIndent - valueWidth / 2;
                    x2 = x1 + valueWidth;
                }
                if (!this.isSubPageOpen().booleanValue()) {
                    GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_AIFILTERLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(resident.getId())));
                    button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    List<String> tooltips = Arrays.asList(residentName, GuiTektopiaBook.formatResidentLevel(resident.getLevel(), resident.getBaseLevel(), true, true), TextUtils.translate("tektopiaBook.links.aifilterdetails", new Object[0]));
                    toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, tooltips);
                    this.tooltips.add(toolTip);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                int aiFilterIndex = 0;
                for (Map.Entry<String, Boolean> aiFilter : resident.getAiFilters().entrySet()) {
                    String aiFilterValue;
                    if (aiFilterIndex++ >= 23) break;
                    if (subList.indexOf(resident) == 0) {
                        String aiFilterName = GuiTektopiaBook.getAiFilterName(aiFilter.getKey());
                        String aiFilterNameShort = Font.small.trimStringToWidth(aiFilterName, aiFilterNameMaxLength, true);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(aiFilterNameShort, this.x + 35 + indentX, y, this.field_73735_i);
                            x1 = this.x + 35 + indentX;
                            x2 = x1 + Font.small.getStringWidth(aiFilterNameShort);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(aiFilterNameShort, this.x + 268 + indentX, y, this.field_73735_i);
                            x1 = this.x + 268 + indentX;
                            x2 = x1 + Font.small.getStringWidth(aiFilterNameShort);
                        }
                        if (!this.isSubPageOpen().booleanValue() && !aiFilterName.equals(aiFilterNameShort)) {
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, aiFilterName);
                            this.tooltips.add(toolTip);
                        }
                    }
                    String string = aiFilterValue = aiFilter.getValue() != false ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS;
                    if (guiPage.isLeftPage()) {
                        Font.small.printCentered(aiFilterValue, this.x + 141 + xIndent, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printCentered(aiFilterValue, this.x + 374 + xIndent, y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                xIndent += valueWidth + 2;
                y = yStart;
            }
        }
    }

    protected void drawPageEconomy(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
        if (dataKey[0].equals("architectitems") || dataKey[0].equals("tradesmanitems")) {
            String header;
            ResidentsData residentsData = this.villageData.getResidentsData();
            MerchantRecipeList recipeList = null;
            if (dataKey[0].equals("architectitems")) {
                ResidentData architect = residentsData != null ? residentsData.getArchitect() : null;
                MerchantRecipeList merchantRecipeList = recipeList = architect != null ? architect.getRecipeList() : null;
            }
            if (dataKey[0].equals("tradesmanitems")) {
                ResidentData tradesman = residentsData != null ? residentsData.getTradesman() : null;
                MerchantRecipeList merchantRecipeList = recipeList = tradesman != null ? tradesman.getRecipeList() : null;
            }
            if (!StringUtils.isNullOrWhitespace(header = TextUtils.translate("tektopiaBook.economy." + dataKey[0], new Object[0])).booleanValue()) {
                if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                    header = header + " " + continued;
                }
                header = TextFormatting.DARK_BLUE + header;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String sellHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.sell", new Object[0]);
            String buyHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.buy", new Object[0]);
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(sellHeader, this.x + 35 + indentX, y, this.field_73735_i);
                Font.small.printLeft(buyHeader, this.x + 141, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printLeft(sellHeader, this.x + 268 + indentX, y, this.field_73735_i);
                Font.small.printLeft(buyHeader, this.x + 374, y, this.field_73735_i);
            }
            y += Font.small.fontRenderer.field_78288_b + 6;
            if (recipeList != null && recipeList.size() > 0) {
                int page;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 15;
                int endIndex = Math.min(recipeList.size(), startIndex + 15);
                List subList = recipeList.subList(startIndex, endIndex);
                for (MerchantRecipe recipe : subList) {
                    ItemStack buyItem1Stack = recipe.func_77394_a();
                    ItemStack buyItem2Stack = recipe.func_77396_b();
                    ItemStack sellItemStack = recipe.func_77397_d();
                    List buyItem1Tooltip = buyItem1Stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (buyItem1Stack.func_77948_v() && buyItem1Tooltip.size() > 0) {
                        buyItem1Tooltip.set(0, TextFormatting.AQUA + (String)buyItem1Tooltip.get(0));
                    }
                    List buyItem2Tooltip = buyItem2Stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (buyItem2Stack.func_77948_v() && buyItem2Tooltip.size() > 0) {
                        buyItem2Tooltip.set(0, TextFormatting.AQUA + (String)buyItem2Tooltip.get(0));
                    }
                    List sellTooltip = sellItemStack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (sellItemStack.func_77948_v() && sellTooltip.size() > 0) {
                        sellTooltip.set(0, TextFormatting.AQUA + (String)sellTooltip.get(0));
                    }
                    if (guiPage.isLeftPage()) {
                        if (!buyItem1Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem1Stack, this.x + 35 + indentX, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem1Stack, this.x + 35 + indentX, y - 5, null);
                            if (buyItem1Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 35 + indentX, y - 5, 16, 16, buyItem1Tooltip));
                            }
                        }
                        if (!buyItem2Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem2Stack, this.x + 35 + indentX + 20, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem2Stack, this.x + 35 + indentX + 20, y - 5, null);
                            if (buyItem2Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 35 + indentX + 20, y - 5, 16, 16, buyItem2Tooltip));
                            }
                        }
                        if (!sellItemStack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, sellItemStack, this.x + 141, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, sellItemStack, this.x + 141, y - 5, null);
                            if (sellTooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 141, y - 5, 16, 16, sellTooltip));
                            }
                        }
                    }
                    if (guiPage.isRightPage()) {
                        if (!buyItem1Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem1Stack, this.x + 268 + indentX, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem1Stack, this.x + 268 + indentX, y - 5, null);
                            if (buyItem1Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 268 + indentX, y - 5, 16, 16, buyItem1Tooltip));
                            }
                        }
                        if (!buyItem2Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem2Stack, this.x + 268 + indentX + 20, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem2Stack, this.x + 268 + indentX + 20, y - 5, null);
                            if (buyItem2Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 268 + indentX + 20, y - 5, 16, 16, buyItem2Tooltip));
                            }
                        }
                        if (!sellItemStack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, sellItemStack, this.x + 374, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, sellItemStack, this.x + 374, y - 5, null);
                            if (sellTooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 374, y - 5, 16, 16, sellTooltip));
                            }
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2 + 6;
                }
            }
        }
        if (dataKey[0].equals("saleshistory")) {
            List<ItemStack> salesHistory;
            EconomyData economyData = this.villageData.getEconomyData();
            String header = TextUtils.translate("tektopiaBook.economy.salesHistory", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                    header = header + " " + continued;
                }
                header = TextFormatting.DARK_BLUE + header;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 6;
            if (economyData != null && (salesHistory = economyData.getSalesHistory()) != null && salesHistory.size() > 0) {
                int page;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 64;
                int endIndex = Math.min(salesHistory.size(), startIndex + 16);
                int yTop = y;
                int xLStart = this.x + 35 + indentX;
                int xRStart = this.x + 268 + indentX;
                for (int i = 0; i < 4 && startIndex < salesHistory.size(); ++i) {
                    int xL = xLStart + i * (16 + indentX);
                    int xR = xRStart + i * (16 + indentX);
                    if (xL > this.x + 247 - 16 - indentX) {
                        xL = this.x + 247 - 16 - indentX;
                    }
                    if (xR > this.x + 480 - 16 - indentX) {
                        xR = this.x + 480 - 16 - indentX;
                    }
                    List<ItemStack> subList = salesHistory.subList(startIndex, endIndex);
                    for (ItemStack itemStack : subList) {
                        List itemStackTooltip = itemStack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                        if (itemStack.func_77948_v() && itemStackTooltip.size() > 0) {
                            itemStackTooltip.set(0, TextFormatting.AQUA + (String)itemStackTooltip.get(0));
                        }
                        if (guiPage.isLeftPage()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, itemStack, xL, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, xL, y - 5, null);
                            if (itemStackTooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(xL, y - 5, 16, 16, itemStackTooltip));
                            }
                        }
                        if (guiPage.isRightPage()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, itemStack, xR, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, xR, y - 5, null);
                            if (itemStackTooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(xR, y - 5, 16, 16, itemStackTooltip));
                            }
                        }
                        y += Font.small.fontRenderer.field_78288_b + 2 + 6;
                    }
                    y = yTop;
                    endIndex = Math.min(salesHistory.size(), (startIndex += 16) + 16);
                }
            }
        }
    }

    protected void drawPageEnemy(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int x4 = 0;
        int x5 = 0;
        int x6 = 0;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        EnemiesData enemiesData = this.villageData.getEnemiesData();
        if (dataKey[0].equals("")) {
            String pageHeader = TextUtils.translate("tektopiaBook.enemies.enemies", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(pageHeader).booleanValue()) {
                pageHeader = TextFormatting.DARK_BLUE + pageHeader;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(pageHeader, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(pageHeader, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            List<EnemyData> enemies = enemiesData.getEnemies();
            if (enemies != null) {
                int page;
                String enemyHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.enemy", new Object[0]);
                String taskHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.task", new Object[0]);
                String positionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.position", new Object[0]);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(enemyHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(taskHeader, this.x + 88 + indentX + indentX, y, this.field_73735_i);
                    Font.small.printRight(positionHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(enemyHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(taskHeader, this.x + 321 + indentX + indentX, y, this.field_73735_i);
                    Font.small.printRight(positionHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 24;
                int endIndex = Math.min(enemies.size(), startIndex + 24);
                int maxTaskLength = 60;
                List<EnemyData> subList = enemies.subList(startIndex, endIndex);
                for (EnemyData enemy : subList) {
                    String enemyName = enemy.getName();
                    String enemyLevel = "";
                    if (enemy.getLevel() > 0) {
                        enemyLevel = TextUtils.translate("tektopiaBook.enemies.level", new Object[0]) + " " + enemy.getLevel();
                    }
                    String enemyTask = GuiTektopiaBook.getAiTaskName(enemy.getCurrentTask());
                    String enemyTaskShort = Font.small.trimStringToWidth(enemyTask, maxTaskLength, true);
                    String enemyPosition = GuiTektopiaBook.formatBlockPos(enemy.getCurrentPosition());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(enemyName, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(enemyTaskShort, this.x + 88 + indentX + indentX, y, this.field_73735_i);
                        Font.small.printRight(enemyPosition, this.x + 247, y, this.field_73735_i);
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(enemyName);
                        x3 = this.x + 88 + indentX + indentX;
                        x4 = x3 + Font.small.getStringWidth(enemyTaskShort);
                        x6 = this.x + 247;
                        x5 = x6 - Font.small.getStringWidth(enemyPosition);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(enemyName, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(enemyTaskShort, this.x + 321 + indentX + indentX, y, this.field_73735_i);
                        Font.small.printRight(enemyPosition, this.x + 480, y, this.field_73735_i);
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(enemyName);
                        x3 = this.x + 321 + indentX + indentX;
                        x4 = x3 + Font.small.getStringWidth(enemyTaskShort);
                        x6 = this.x + 480;
                        x5 = x6 - Font.small.getStringWidth(enemyPosition);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        GuiTooltip toolTip;
                        if (!StringUtils.isNullOrWhitespace(enemyLevel).booleanValue()) {
                            ArrayList<String> enemyLevelTooltip = new ArrayList<String>();
                            enemyLevelTooltip.add(enemyLevel);
                            if (ModConfig.debug.enableDebug) {
                                enemyLevelTooltip.add("(" + TextUtils.translate("tektopiaBook.id", new Object[0]) + enemy.getId() + ")");
                            }
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, enemyLevelTooltip);
                            this.tooltips.add(toolTip);
                        }
                        toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, enemyTask);
                        this.tooltips.add(toolTip);
                        GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.ENEMY, GuiTektopiaBook.getResidentDetailPageKey(enemy.getId())));
                        button.setIcon(x5, y, x6 - x5, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x5, y, x6 - x5, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
            }
        }
    }

    protected void drawPageHome(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        block77: {
            int homeId;
            String continued;
            HomesData homesData;
            String[] dataKey;
            int x4;
            int x3;
            int x2;
            int x1;
            int indentX;
            int y;
            block76: {
                int page;
                Map<VillageStructureType, Integer> homeTypeCounts;
                this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
                this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
                y = this.y + 32;
                indentX = 10;
                x1 = 0;
                x2 = 0;
                x3 = 0;
                x4 = 0;
                dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
                homesData = this.villageData.getHomesData();
                continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
                if (!dataKey[0].equals("")) break block76;
                String typeHeader = TextUtils.translate("tektopiaBook.homes.hometypes", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(typeHeader).booleanValue()) {
                    typeHeader = TextFormatting.DARK_BLUE + typeHeader;
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(typeHeader, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(typeHeader, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                Map<VillageStructureType, Integer> map = homeTypeCounts = homesData != null ? homesData.getHomeTypeCounts() : null;
                if (homeTypeCounts == null) break block77;
                int[] maxLength = new int[]{0};
                String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
                String countHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.count", new Object[0]);
                maxLength[0] = maxLength[0] + Font.small.getStringWidth(countHeader);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(countHeader, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(countHeader, this.x + 374, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 24;
                int endIndex = Math.min(homeTypeCounts.size(), startIndex + 24);
                List subList = homeTypeCounts.entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
                for (Map.Entry entry : subList) {
                    String typeName = GuiTektopiaBook.getStructureTypeName((VillageStructureType)entry.getKey());
                    int typeCount = homeTypeCounts.get(entry.getKey());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(typeName, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(typeCount, this.x + 141 + maxLength[0], y, this.field_73735_i);
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(typeName);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(typeName, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(typeCount, this.x + 374 + maxLength[0], y, this.field_73735_i);
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(typeName);
                    }
                    if (!this.isSubPageOpen().booleanValue() && typeCount > 0) {
                        GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_HOMELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.HOMETYPE, GuiTektopiaBook.getStructureTypePageKey((VillageStructureType)entry.getKey())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.homedetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                break block77;
            }
            try {
                homeId = Integer.parseInt(dataKey[0]);
            }
            catch (NumberFormatException e) {
                homeId = 0;
            }
            HomeData homeData = homesData.getHomeById(homeId);
            if (homeData != null) {
                int page;
                GuiTooltip toolTip;
                GuiHyperlink button;
                String header = homeData.getStructureTypeName();
                if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                    if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == homeData.getHomeId()) {
                        header = TextFormatting.UNDERLINE + header;
                    } else if (this.villageData.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)homeData.getFramePosition())) {
                        header = TextFormatting.UNDERLINE + header;
                    }
                    if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                        header = header + " " + continued;
                    }
                    header = TextFormatting.DARK_BLUE + header;
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String framePositionLabel = TextUtils.translate("tektopiaBook.homes.frameposition", new Object[0]);
                String framePositionText = "";
                if (!StringUtils.isNullOrWhitespace(framePositionLabel).booleanValue()) {
                    framePositionText = framePositionText + GuiTektopiaBook.formatBlockPos(homeData.getFramePosition());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(framePositionLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(framePositionText, this.x + 141, y, this.field_73735_i);
                        x1 = this.x + 141;
                        x2 = x1 + Font.small.getStringWidth(framePositionText);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(framePositionLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(framePositionText, this.x + 374, y, this.field_73735_i);
                        x1 = this.x + 374;
                        x2 = x1 + Font.small.getStringWidth(framePositionText);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.HOME, GuiTektopiaBook.getStructureDetailPageKey(homeData.getHomeId())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String residentsLabel = TextUtils.translate("tektopiaBook.homes.totalresidents", new Object[0]);
                String residentsText = "";
                if (!StringUtils.isNullOrWhitespace(residentsLabel).booleanValue()) {
                    residentsText = residentsText + "" + homeData.getResidentsCount();
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(residentsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(residentsText, this.x + 141 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(residentsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(residentsText, this.x + 374 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (dataKey[1].equals("0")) {
                    String adultLabel = TextUtils.translate("tektopiaBook.homes.adults", new Object[0]);
                    String adultText = "";
                    if (!StringUtils.isNullOrWhitespace(adultLabel).booleanValue()) {
                        adultText = adultText + "" + homeData.getAdultCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(adultLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(adultText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(adultLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(adultText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String childLabel = TextUtils.translate("tektopiaBook.homes.children", new Object[0]);
                    String childText = "";
                    if (!StringUtils.isNullOrWhitespace(childLabel).booleanValue()) {
                        childText = childText + "" + homeData.getChildCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(childLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(childText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(childLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(childText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String maleLabel = TextUtils.translate("tektopiaBook.homes.males", new Object[0]);
                    String maleText = "";
                    if (!StringUtils.isNullOrWhitespace(maleLabel).booleanValue()) {
                        maleText = maleText + "" + homeData.getMaleCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(maleLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(maleText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(maleLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(maleText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String femaleLabel = TextUtils.translate("tektopiaBook.homes.females", new Object[0]);
                    String femaleText = "";
                    if (!StringUtils.isNullOrWhitespace(femaleLabel).booleanValue()) {
                        femaleText = femaleText + "" + homeData.getFemaleCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(femaleLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(femaleText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(femaleLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(femaleText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                    String tilesperoccupantLabel = TextUtils.translate("tektopiaBook.homes.tileinformation", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(tilesperoccupantLabel).booleanValue()) {
                        tilesperoccupantLabel = TextFormatting.DARK_BLUE + tilesperoccupantLabel;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(tilesperoccupantLabel, this.x + 35, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(tilesperoccupantLabel, this.x + 268, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String currentBedsLabel = TextUtils.translate("tektopiaBook.homes.currentbeds", new Object[0]);
                    String currentBedsText = "";
                    String maxBedsText = "";
                    if (!StringUtils.isNullOrWhitespace(currentBedsLabel).booleanValue()) {
                        currentBedsText = currentBedsText + "" + homeData.getBedCount();
                        maxBedsText = maxBedsText + " / " + homeData.getMaxBeds();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(currentBedsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(currentBedsText, this.x + 141 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(maxBedsText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(currentBedsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(currentBedsText, this.x + 374 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(maxBedsText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String floorTilesLabel = TextUtils.translate("tektopiaBook.homes.tilesperbed", new Object[0]);
                    String floorTilesText = "";
                    if (!StringUtils.isNullOrWhitespace(floorTilesLabel).booleanValue()) {
                        floorTilesText = floorTilesText + "" + homeData.getTilesPerVillager();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(floorTilesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(floorTilesText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(floorTilesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(floorTilesText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    floorTilesLabel = TextUtils.translate("tektopiaBook.homes.requiredtiles", new Object[0]);
                    floorTilesText = "";
                    if (!StringUtils.isNullOrWhitespace(floorTilesLabel).booleanValue()) {
                        floorTilesText = floorTilesText + "" + homeData.getTilesPerVillager() * homeData.getBedCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(floorTilesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(floorTilesText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(floorTilesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(floorTilesText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    floorTilesLabel = TextUtils.translate("tektopiaBook.homes.currenttiles", new Object[0]);
                    floorTilesText = "";
                    if (!StringUtils.isNullOrWhitespace(floorTilesLabel).booleanValue()) {
                        floorTilesText = floorTilesText + "" + homeData.getFloorTileCount();
                        floorTilesText = homeData.getFloorTileCount() < homeData.getTilesPerVillager() * homeData.getBedCount() ? TextFormatting.DARK_RED + floorTilesText : TextFormatting.DARK_GREEN + floorTilesText;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(floorTilesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(floorTilesText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(floorTilesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(floorTilesText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                } else {
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                String bedsText = TextUtils.translate("tektopiaBook.homes.beds", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(bedsText).booleanValue()) {
                    bedsText = TextFormatting.DARK_BLUE + bedsText;
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(bedsText, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(bedsText, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                List<BlockPos> bedPositions = homeData.getBedPositions();
                int[] maxLength = new int[]{0};
                maxLength[0] = maxLength[0] + 10;
                String indexHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.index", new Object[0]);
                String positionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.position", new Object[0]);
                String residentHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.resident", new Object[0]);
                String levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.level", new Object[0]);
                if (guiPage.isLeftPage()) {
                    Font.small.printRight(indexHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(positionHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printLeft(residentHeader, this.x + 141, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printRight(indexHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(positionHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printLeft(residentHeader, this.x + 374, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 6;
                int endIndex = Math.min(homeData.getMaxBeds(), startIndex + 6);
                for (int bedIndex = startIndex; bedIndex < endIndex; ++bedIndex) {
                    BlockPos bedPosition;
                    String bedText = "" + (bedIndex + 1);
                    String bedPositionText = "";
                    String residentName = "";
                    String residentProfession = "";
                    String residentLevel = "";
                    ResidentData residentData = null;
                    int y1 = 0;
                    int y2 = 0;
                    BlockPos blockPos = bedPosition = bedIndex < bedPositions.size() ? bedPositions.get(bedIndex) : null;
                    if (bedPosition == null) {
                        bedPositionText = bedPositionText + TextFormatting.DARK_RED + TextUtils.translate("tektopiaBook.missing", new Object[0]);
                    } else {
                        bedPositionText = bedPositionText + "" + GuiTektopiaBook.formatBlockPos(bedPosition);
                        residentData = homeData.getResidentByBedPosition(bedPosition);
                        if (residentData != null) {
                            residentName = residentName + GuiTektopiaBook.formatResidentName(residentData.isMale(), residentData.getName(), true);
                            residentProfession = residentProfession + GuiTektopiaBook.getTypeName(residentData.getProfessionType());
                            ProfessionType professionType = TektopiaUtils.getProfessionType(residentData.getProfessionType());
                            if (professionType != null) {
                                switch (professionType) {
                                    case CHILD: 
                                    case NITWIT: {
                                        break;
                                    }
                                    default: {
                                        residentLevel = GuiTektopiaBook.formatResidentLevel(residentData.getLevel(), residentData.getBaseLevel(), false, false);
                                    }
                                }
                            }
                        } else {
                            residentName = TextFormatting.GOLD + TextUtils.translate("tektopiaBook.empty", new Object[0]);
                        }
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(bedText, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(bedPositionText, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printLeft(residentName, this.x + 141, y, this.field_73735_i);
                        Font.small.printRight(residentLevel, this.x + 247, y, this.field_73735_i);
                        x1 = this.x + 141;
                        x2 = x1 + Font.small.getStringWidth(residentName);
                        y1 = y;
                        Font.small.printLeft(residentProfession, this.x + 141, y += Font.small.fontRenderer.field_78288_b, this.field_73735_i);
                        x3 = this.x + 141;
                        x4 = x3 + Font.small.getStringWidth(residentProfession);
                        y2 = y;
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(bedText, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(bedPositionText, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printLeft(residentName, this.x + 374, y, this.field_73735_i);
                        Font.small.printRight(residentLevel, this.x + 480, y, this.field_73735_i);
                        x1 = this.x + 374;
                        x2 = x1 + Font.small.getStringWidth(residentName);
                        y1 = y;
                        Font.small.printLeft(residentProfession, this.x + 374, y += Font.small.fontRenderer.field_78288_b, this.field_73735_i);
                        x3 = this.x + 374;
                        x4 = x3 + Font.small.getStringWidth(residentProfession);
                        y2 = y;
                    }
                    if (!this.isSubPageOpen().booleanValue() && residentData != null) {
                        button = new GuiHyperlink(BUTTON_KEY_RESIDENTLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(residentData.getId())));
                        button.setIcon(x1, y1, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y1, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.residentdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                        button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey(residentProfession)));
                        button.setIcon(x3, y2, x4 - x3, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x3, y2, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
            }
        }
    }

    protected void drawPageHomeType(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int x4 = 0;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        VillageStructureType homeType = VillageStructureType.valueOf((String)dataKey[0]);
        HomesData homesData = this.villageData.getHomesData();
        Map<VillageStructureType, Integer> homeTypeCounts = homesData != null ? homesData.getHomeTypeCounts() : null;
        List<HomeData> homes = homesData != null ? homesData.getHomesByType(homeType) : null;
        String typeName = GuiTektopiaBook.getStructureTypeName(homeType);
        String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
        String summary = TextUtils.translate("tektopiaBook.summary", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(typeName).booleanValue()) {
            typeName = typeName + " " + summary;
            if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                typeName = typeName + " " + continued;
            }
            typeName = TextFormatting.DARK_BLUE + typeName;
            if (guiPage.isLeftPage()) {
                Font.normal.printLeft(typeName, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printLeft(typeName, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (dataKey[1].equals("0")) {
            String totalLabel = TextUtils.translate("tektopiaBook.hometypes.totalhomes", new Object[0]);
            String totalText = "";
            if (!StringUtils.isNullOrWhitespace(totalLabel).booleanValue()) {
                if (homeTypeCounts != null && homeTypeCounts.containsKey(homeType)) {
                    totalText = totalText + "" + homeTypeCounts.get(homeType);
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(totalLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(totalText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(totalLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(totalText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String residentsLabel = TextUtils.translate("tektopiaBook.homes.totalresidents", new Object[0]);
            String residentsText = "";
            if (!StringUtils.isNullOrWhitespace(residentsLabel).booleanValue()) {
                if (this.villageData.getResidentsData() != null) {
                    residentsText = residentsText + "" + homesData.getResidentCountByType(homeType);
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(residentsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(residentsText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(residentsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(residentsText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String header = TextUtils.translate("tektopiaBook.hometypes.frameposition", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
            header = TextFormatting.DARK_BLUE + header;
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(header, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printLeft(header, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (homes != null) {
            int page;
            int[] maxLength = new int[]{0, 0};
            maxLength[0] = maxLength[0] + 10;
            String indexHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.index", new Object[0]);
            String positionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.position", new Object[0]);
            String residentsHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.hometypes.residents", new Object[0]);
            String validTextHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.valid", new Object[0]);
            maxLength[1] = maxLength[1] + Font.small.getStringWidth(residentsHeader);
            if (guiPage.isLeftPage()) {
                Font.small.printRight(indexHeader, this.x + 35 + indentX, y, this.field_73735_i);
                Font.small.printLeft(positionHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                Font.small.printLeft(residentsHeader, this.x + 141, y, this.field_73735_i);
                Font.small.printRight(validTextHeader, this.x + 247, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printRight(indexHeader, this.x + 268 + indentX, y, this.field_73735_i);
                Font.small.printLeft(positionHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                Font.small.printLeft(residentsHeader, this.x + 374, y, this.field_73735_i);
                Font.small.printRight(validTextHeader, this.x + 480, y, this.field_73735_i);
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            try {
                page = Integer.parseInt(dataKey[1]);
            }
            catch (NumberFormatException e) {
                page = 0;
            }
            int startIndex = page * 21;
            int endIndex = Math.min(homes.size(), startIndex + 21);
            List<HomeData> subList = homes.subList(startIndex, endIndex);
            for (HomeData home : subList) {
                String indexName = "" + (startIndex + subList.indexOf(home) + 1);
                String framePosition = GuiTektopiaBook.formatBlockPos(home.getFramePosition());
                if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == home.getHomeId()) {
                    framePosition = TextFormatting.UNDERLINE + framePosition;
                } else if (this.villageData.getFramePosition() != null && home.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)home.getFramePosition())) {
                    framePosition = TextFormatting.UNDERLINE + framePosition;
                }
                String residentText = "" + (home.getResidentsCount() >= 0 ? Integer.valueOf(home.getResidentsCount()) : "0");
                String validText = "" + (home.isValid() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                if (guiPage.isLeftPage()) {
                    Font.small.printRight(indexName, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(framePosition, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printRight(residentText, this.x + 141 + maxLength[1], y, this.field_73735_i);
                    Font.small.printRight(validText, this.x + 247, y, this.field_73735_i);
                    x2 = this.x + 35 + indentX;
                    x1 = x2 - Font.small.getStringWidth(indexName);
                    x3 = this.x + 35 + indentX + maxLength[0];
                    x4 = x3 + Font.small.getStringWidth(framePosition);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printRight(indexName, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(framePosition, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printRight(residentText, this.x + 374 + maxLength[1], y, this.field_73735_i);
                    Font.small.printRight(validText, this.x + 480, y, this.field_73735_i);
                    x2 = this.x + 268 + indentX;
                    x1 = x2 - Font.small.getStringWidth(indexName);
                    x3 = this.x + 268 + indentX + maxLength[0];
                    x4 = x3 + Font.small.getStringWidth(framePosition);
                }
                if (!this.isSubPageOpen().booleanValue()) {
                    GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_HOMELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.HOME, GuiTektopiaBook.getStructureDetailPageKey(home.getHomeId())));
                    button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.homedetails", new Object[0]));
                    this.tooltips.add(toolTip);
                    button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.HOME, GuiTektopiaBook.getStructureDetailPageKey(home.getHomeId())));
                    button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                    this.tooltips.add(toolTip);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawPageMap(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        GuiButton button;
        GuiTexture buttonIcon;
        int markerSize;
        BlockPos villageOffset;
        int tooltipOffset;
        int tooltipSize;
        int markerOffset;
        List<String> tooltips;
        String position;
        StructureData townHallStructure;
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        if (dataKey[0].equals("")) {
            return;
        }
        this.drawSubPageLandscapeBackground(mouseX, mouseY, partialTicks);
        StructureData structureData = townHallStructure = this.villageData == null ? null : this.villageData.getTownHall();
        if (townHallStructure == null) {
            return;
        }
        BlockPos villageOrigin = townHallStructure.getFramePosition();
        ArrayList<GuiMapMarker> mapMarkers = new ArrayList<GuiMapMarker>();
        if (showMapTownHall.booleanValue() || showSelectedAlways.booleanValue()) {
            BlockPos structurePoint = townHallStructure.getFramePosition();
            BlockPos villageOffset2 = structurePoint.func_177973_b((Vec3i)villageOrigin);
            String string = TextFormatting.DARK_GREEN + GuiTektopiaBook.getStructureTypeName(townHallStructure.getStructureType());
            position = TextUtils.translate("tektopiaBook.homes.frameposition", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(structurePoint);
            tooltips = Arrays.asList(string, position);
            int markerSize2 = 16;
            markerOffset = 0;
            tooltipSize = 10;
            tooltipOffset = 0;
            int priority = 1;
            if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == townHallStructure.getStructureId()) {
                markerSize2 = (int)((float)markerSize2 * 1.5f);
                markerOffset = markerSize2 - 16;
                tooltipSize = (int)((float)tooltipSize * 1.5f);
                tooltipOffset = tooltipSize - 10;
                priority = 2;
            } else if (this.villageData.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)townHallStructure.getFramePosition())) {
                markerSize2 = (int)((float)markerSize2 * 1.5f);
                markerOffset = markerSize2 - 16;
                tooltipSize = (int)((float)tooltipSize * 1.5f);
                tooltipOffset = tooltipSize - 10;
                priority = 2;
            }
            if (showMapTownHall != false && this.showSelectedOnly == false || this.showSelectedOnly != false && priority > 1 || showSelectedAlways.booleanValue() && priority > 1) {
                GuiTexture icon = new GuiTexture(mapMarkerTownHall, this.field_73735_i, villageOffset2.func_177958_n() - markerOffset / 2, villageOffset2.func_177952_p() - markerOffset, markerSize2, markerSize2, 0, 0, markerSize2, markerSize2);
                GuiTooltip guiTooltip = new GuiTooltip(villageOffset2.func_177958_n() - tooltipOffset / 2, villageOffset2.func_177952_p() - markerOffset, 2, 1, tooltipSize, tooltipSize, tooltips);
                GuiMapMarker mapMarker = new GuiMapMarker(GuiTektopiaBook.getStructureTypePageKey(townHallStructure.getStructureType()), GuiMapMarkerType.TOWNHALL, icon, villageOffset2, guiTooltip);
                mapMarker.setPriority(priority);
                mapMarkers.add(mapMarker);
            }
        }
        if (showMapHomes.booleanValue() || showSelectedAlways.booleanValue()) {
            HomesData homesData = this.villageData.getHomesData();
            for (HomeData homeData : homesData.getHomes()) {
                void var20_71;
                BlockPos structurePoint = homeData.getFramePosition();
                villageOffset = structurePoint.func_177973_b((Vec3i)villageOrigin);
                String name2 = TextFormatting.DARK_GREEN + GuiTektopiaBook.getStructureTypeName(homeData.getStructureType());
                String position2 = TextUtils.translate("tektopiaBook.homes.frameposition", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(structurePoint);
                List<String> tooltips2 = Arrays.asList(name2, position2);
                int markerSize3 = 16;
                int markerOffset2 = 0;
                int tooltipSize2 = 10;
                boolean bl = false;
                int priority = 1;
                if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == homeData.getHomeId()) {
                    markerSize3 = (int)((float)markerSize3 * 1.5f);
                    markerOffset2 = markerSize3 - 16;
                    tooltipSize2 = (int)((float)tooltipSize2 * 1.5f);
                    int n = tooltipSize2 - 10;
                    priority = 2;
                } else if (this.villageData.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)homeData.getFramePosition())) {
                    markerSize3 = (int)((float)markerSize3 * 1.5f);
                    markerOffset2 = markerSize3 - 16;
                    tooltipSize2 = (int)((float)tooltipSize2 * 1.5f);
                    int n = tooltipSize2 - 10;
                    priority = 2;
                }
                if (!(showMapHomes != false && this.showSelectedOnly == false || this.showSelectedOnly != false && priority > 1) && (!showSelectedAlways.booleanValue() || priority <= true)) continue;
                GuiTexture icon = new GuiTexture(mapMarkerHome, this.field_73735_i, villageOffset.func_177958_n() - markerOffset2 / 2, villageOffset.func_177952_p() - markerOffset2, markerSize3, markerSize3, 0, 0, markerSize3, markerSize3);
                GuiTooltip tooltip = new GuiTooltip(villageOffset.func_177958_n() - var20_71 / 2, villageOffset.func_177952_p() - markerOffset2, 2, 1, tooltipSize2, tooltipSize2, tooltips2);
                GuiMapMarker mapMarker = new GuiMapMarker(GuiTektopiaBook.getStructureDetailPageKey(homeData.getHomeId()), GuiMapMarkerType.HOME, icon, villageOffset, tooltip);
                mapMarker.setPriority(priority);
                mapMarkers.add(mapMarker);
            }
        }
        if (showMapStructures.booleanValue() || showSelectedAlways.booleanValue()) {
            StructuresData structuresData = this.villageData.getStructuresData();
            Iterator<EntityData> excludeTypes = TektopiaUtils.getVillageHomeTypes();
            excludeTypes.add((EntityData)VillageStructureType.TOWNHALL);
            for (StructureData structure : structuresData.getStructures()) {
                void var20_75;
                if (excludeTypes.contains(structure.getStructureType())) continue;
                BlockPos structurePoint = structure.getFramePosition();
                BlockPos villageOffset3 = structurePoint.func_177973_b((Vec3i)villageOrigin);
                String name3 = TextFormatting.DARK_GREEN + GuiTektopiaBook.getStructureTypeName(structure.getStructureType());
                String position3 = TextUtils.translate("tektopiaBook.homes.frameposition", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(structurePoint);
                List<String> tooltips3 = Arrays.asList(name3, position3);
                markerSize = 16;
                int markerOffset3 = 0;
                int n = 10;
                int tooltipOffset3 = 0;
                int priority = 1;
                if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == structure.getStructureId()) {
                    markerSize = (int)((float)markerSize * 1.5f);
                    markerOffset3 = markerSize - 16;
                    int n2 = (int)((float)n * 1.5f);
                    tooltipOffset3 = n2 - 10;
                    priority = 2;
                } else if (this.villageData.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)structure.getFramePosition())) {
                    markerSize = (int)((float)markerSize * 1.5f);
                    markerOffset3 = markerSize - 16;
                    int n3 = (int)((float)n * 1.5f);
                    tooltipOffset3 = n3 - 10;
                    priority = 2;
                }
                if (!(showMapStructures != false && this.showSelectedOnly == false || this.showSelectedOnly != false && priority > 1) && (!showSelectedAlways.booleanValue() || priority <= true)) continue;
                GuiTexture icon = new GuiTexture(mapMarkerStructure, this.field_73735_i, villageOffset3.func_177958_n() - markerOffset3 / 2, villageOffset3.func_177952_p() - markerOffset3, markerSize, markerSize, 0, 0, markerSize, markerSize);
                GuiTooltip tooltip = new GuiTooltip(villageOffset3.func_177958_n() - tooltipOffset3 / 2, villageOffset3.func_177952_p() - markerOffset3, 2, 1, (int)var20_75, (int)var20_75, tooltips3);
                GuiMapMarker mapMarker = new GuiMapMarker(GuiTektopiaBook.getStructureTypePageKey(structure.getStructureType()), GuiMapMarkerType.STRUCTURE, icon, villageOffset3, tooltip);
                mapMarker.setPriority(priority);
                mapMarkers.add(mapMarker);
            }
        }
        if (showMapResidents.booleanValue() || showSelectedAlways.booleanValue()) {
            ResidentsData residentsData = this.villageData.getResidentsData();
            for (ResidentData residentData : residentsData.getResidents()) {
                BlockPos residentPoint = residentData.getCurrentPosition();
                villageOffset = residentPoint.func_177973_b((Vec3i)villageOrigin);
                String name4 = GuiTektopiaBook.formatResidentName(residentData.isMale(), residentData.getName(), true);
                String profession = GuiTektopiaBook.getTypeName(residentData.getProfessionType());
                String level = "";
                String health = TextUtils.translate("tektopiaBook.residents.health", new Object[0]) + " " + GuiTektopiaBook.formatResidentStatistic(residentData.getHealth(), residentData.getMaxHealth(), true);
                String position4 = TextUtils.translate("tektopiaBook.residents.position", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(residentData.getCurrentPosition());
                ProfessionType professionType = TektopiaUtils.getProfessionType(residentData.getProfessionType());
                if (professionType != null) {
                    switch (professionType) {
                        case CHILD: 
                        case NITWIT: {
                            break;
                        }
                        default: {
                            level = GuiTektopiaBook.formatResidentLevel(residentData.getLevel(), residentData.getBaseLevel(), false, true);
                        }
                    }
                }
                List<String> list = Arrays.asList(name4, profession, level, health, position4);
                int markerSize4 = 16;
                int markerOffset4 = 0;
                int tooltipSize4 = 5;
                int tooltipOffset4 = 0;
                int priority = 1;
                if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == residentData.getId()) {
                    markerSize4 = (int)((float)markerSize4 * 1.5f);
                    markerOffset4 = markerSize4 - 16;
                    tooltipSize4 = (int)((float)tooltipSize4 * 1.5f);
                    tooltipOffset4 = tooltipSize4 - 5;
                    priority = 2;
                }
                if (!(showMapResidents != false && this.showSelectedOnly == false || this.showSelectedOnly != false && priority > 1) && (!showSelectedAlways.booleanValue() || priority <= true)) continue;
                ResourceLocation texture = residentData.isMale() ? mapMarkerResidentMale : mapMarkerResidentFemale;
                GuiTexture icon = new GuiTexture(texture, this.field_73735_i, villageOffset.func_177958_n() - markerOffset4 / 2, villageOffset.func_177952_p() - markerOffset4, markerSize4, markerSize4, 0, 0, markerSize4, markerSize4);
                GuiTooltip tooltip = new GuiTooltip(villageOffset.func_177958_n() - tooltipOffset4 / 2, villageOffset.func_177952_p() - markerOffset4, 5, 1, tooltipSize4, tooltipSize4, list);
                GuiMapMarker mapMarker = new GuiMapMarker(GuiTektopiaBook.getResidentDetailPageKey(residentData.getId()), GuiMapMarkerType.RESIDENT, icon, villageOffset, tooltip);
                mapMarker.setPriority(priority);
                mapMarkers.add(mapMarker);
            }
        }
        if (showMapVisitors.booleanValue() || showSelectedAlways.booleanValue()) {
            VisitorsData visitorsData = this.villageData.getVisitorsData();
            for (VisitorData visitorData : visitorsData.getVisitors()) {
                int n;
                BlockPos visitorPoint = visitorData.getCurrentPosition();
                villageOffset = visitorPoint.func_177973_b((Vec3i)villageOrigin);
                String name5 = GuiTektopiaBook.formatResidentName(visitorData.isMale(), visitorData.getName(), true);
                String profession = GuiTektopiaBook.getTypeName(visitorData.getProfessionType());
                String professionTypes = TextUtils.translate("tektopiaBook.professions.professiontypes", new Object[0]);
                String position5 = TextUtils.translate("tektopiaBook.residents.position", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(visitorData.getCurrentPosition());
                ArrayList<String> tooltips5 = new ArrayList<String>();
                tooltips5.add(name5);
                if (!StringUtils.isNullOrWhitespace(profession).booleanValue()) {
                    tooltips5.add(profession);
                }
                if (visitorData.getAdditionalProfessionsCount() > 0) {
                    tooltips5.add(professionTypes);
                    for (Map.Entry entry : visitorData.getAdditionalProfessions().entrySet()) {
                        String additionalProfessionText = GuiTektopiaBook.getTypeName((String)entry.getKey());
                        String additionalProfessionLevel = GuiTektopiaBook.formatResidentLevel((Integer)entry.getValue(), (Integer)entry.getValue(), false, true);
                        tooltips5.add(TextFormatting.AQUA + "\u2022" + " " + additionalProfessionText + " - " + additionalProfessionLevel);
                    }
                }
                tooltips5.add(position5);
                int markerSize5 = 16;
                boolean bl = false;
                int tooltipSize5 = 5;
                int tooltipOffset5 = 0;
                int priority = 1;
                if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == visitorData.getId()) {
                    markerSize5 = (int)((float)markerSize5 * 1.5f);
                    n = markerSize5 - 16;
                    tooltipSize5 = (int)((float)tooltipSize5 * 1.5f);
                    tooltipOffset5 = tooltipSize5 - 5;
                    priority = 2;
                }
                if (!(showMapVisitors != false && this.showSelectedOnly == false || this.showSelectedOnly != false && priority > 1) && (!showSelectedAlways.booleanValue() || priority <= true)) continue;
                GuiTexture icon = new GuiTexture(mapMarkerVisitor, this.field_73735_i, villageOffset.func_177958_n() - n / 2, villageOffset.func_177952_p() - n, markerSize5, markerSize5, 0, 0, markerSize5, markerSize5);
                GuiTooltip tooltip = new GuiTooltip(villageOffset.func_177958_n() - tooltipOffset5 / 2, villageOffset.func_177952_p() - n, 5, 1, tooltipSize5, tooltipSize5, tooltips5);
                GuiMapMarker mapMarker = new GuiMapMarker(GuiTektopiaBook.getResidentDetailPageKey(visitorData.getId()), GuiMapMarkerType.VISITOR, icon, villageOffset, tooltip);
                mapMarker.setPriority(priority);
                mapMarkers.add(mapMarker);
            }
        }
        if (showMapEnemies.booleanValue() || showSelectedAlways.booleanValue()) {
            EnemiesData enemiesData = this.villageData.getEnemiesData();
            for (EnemyData enemyData : enemiesData.getEnemies()) {
                int n;
                BlockPos enemyPoint = enemyData.getCurrentPosition();
                villageOffset = enemyPoint.func_177973_b((Vec3i)villageOrigin);
                String name6 = TextFormatting.AQUA + enemyData.getName();
                String level = "";
                if (enemyData.getLevel() > 0) {
                    level = TextUtils.translate("tektopiaBook.enemies.level", new Object[0]) + " " + enemyData.getLevel();
                }
                String position6 = TextUtils.translate("tektopiaBook.residents.position", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(enemyData.getCurrentPosition());
                List<String> tooltips6 = Arrays.asList(name6, level, position6);
                markerSize = 16;
                int markerOffset6 = 0;
                int n4 = 5;
                int tooltipOffset6 = 0;
                int priority = 1;
                if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == enemyData.getId()) {
                    markerSize = (int)((float)markerSize * 1.5f);
                    markerOffset6 = markerSize - 16;
                    n = (int)((float)n4 * 1.5f);
                    tooltipOffset6 = n - 5;
                    priority = 2;
                }
                if (!(showMapEnemies != false && this.showSelectedOnly == false || this.showSelectedOnly != false && priority > 1) && (!showSelectedAlways.booleanValue() || priority <= true)) continue;
                GuiTexture icon = new GuiTexture(mapMarkerEnemy, this.field_73735_i, villageOffset.func_177958_n() - markerOffset6 / 2, villageOffset.func_177952_p() - markerOffset6, markerSize, markerSize, 0, 0, markerSize, markerSize);
                GuiTooltip tooltip = new GuiTooltip(villageOffset.func_177958_n() - tooltipOffset6 / 2, villageOffset.func_177952_p() - markerOffset6, 5, 1, n, n, tooltips6);
                GuiMapMarker mapMarker = new GuiMapMarker(GuiTektopiaBook.getResidentDetailPageKey(enemyData.getId()), GuiMapMarkerType.ENEMY, icon, villageOffset, tooltip);
                mapMarker.setPriority(priority);
                mapMarkers.add(mapMarker);
            }
        }
        if (showMapPlayer.booleanValue() && this.villageData.getPlayerPosition() != null) {
            BlockPos playerPoint = this.villageData.getPlayerPosition();
            BlockPos villageOffset2 = playerPoint.func_177973_b((Vec3i)villageOrigin);
            String string = TextFormatting.AQUA + "Player";
            position = TextUtils.translate("tektopiaBook.residents.position", new Object[0]) + " " + GuiTektopiaBook.formatBlockPos(this.villageData.getPlayerPosition());
            tooltips = Arrays.asList(string, position);
            int markerSize2 = 16;
            markerOffset = 0;
            tooltipSize = 5;
            tooltipOffset = 0;
            if (!this.showSelectedOnly.booleanValue()) {
                GuiTexture icon = new GuiTexture(mapMarkerPlayer, this.field_73735_i, villageOffset2.func_177958_n() - markerOffset / 2, villageOffset2.func_177952_p() - markerOffset, markerSize2, markerSize2, 0, 0, markerSize2, markerSize2);
                GuiTooltip tooltip = new GuiTooltip(villageOffset2.func_177958_n() - tooltipOffset / 2, villageOffset2.func_177952_p() - markerOffset, 5, 1, tooltipSize, tooltipSize, tooltips);
                GuiMapMarker guiMapMarker = new GuiMapMarker(GuiTektopiaBook.getPageKey("player", 0), GuiMapMarkerType.PLAYER, icon, villageOffset2, tooltip);
                mapMarkers.add(guiMapMarker);
            }
        }
        Collections.sort(mapMarkers);
        int x = this.x + 55;
        int y = this.y + 70;
        int n = 120;
        String originLabel = TextUtils.translate("tektopiaBook.village.origin", new Object[0]);
        String originText = "";
        if (!StringUtils.isNullOrWhitespace(originLabel).booleanValue()) {
            originText = originText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageOrigin());
            Font.small.printLeft(originLabel, x, y, this.field_73735_i);
            Font.small.printRight(originText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarynorthwest", new Object[0]);
        String boundaryText = "";
        if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
            boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageNorthWestCorner());
            Font.small.printLeft(boundaryLabel, x, y, this.field_73735_i);
            Font.small.printRight(boundaryText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarynortheast", new Object[0]);
        boundaryText = "";
        if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
            boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageNorthEastCorner());
            Font.small.printLeft(boundaryLabel, x, y, this.field_73735_i);
            Font.small.printRight(boundaryText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarysouthwest", new Object[0]);
        boundaryText = "";
        if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
            boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageSouthWestCorner());
            Font.small.printLeft(boundaryLabel, x, y, this.field_73735_i);
            Font.small.printRight(boundaryText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarysoutheast", new Object[0]);
        boundaryText = "";
        if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
            boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageSouthEastCorner());
            Font.small.printLeft(boundaryLabel, x, y, this.field_73735_i);
            Font.small.printRight(boundaryText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String structuresLabel = TextUtils.translate("tektopiaBook.structuretypes.total", new Object[0]);
        String structuresText = "";
        if (!StringUtils.isNullOrWhitespace(structuresLabel).booleanValue()) {
            if (this.villageData.getStructuresData() != null) {
                structuresText = structuresText + "" + this.villageData.getStructuresData().getStructuresCount();
            }
            Font.small.printLeft(structuresLabel, x, y, this.field_73735_i);
            Font.small.printRight(structuresText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        String homesLabel = TextUtils.translate("tektopiaBook.hometypes.totalhomes", new Object[0]);
        String homesText = "";
        if (!StringUtils.isNullOrWhitespace(homesLabel).booleanValue()) {
            if (this.villageData.getStructuresData() != null) {
                homesText = homesText + "" + this.villageData.getHomesData().getHomesCount();
            }
            Font.small.printLeft(homesLabel, x, y, this.field_73735_i);
            Font.small.printRight(homesText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        String string = TextUtils.translate("tektopiaBook.residents.total", new Object[0]);
        String residentsText = "";
        if (!StringUtils.isNullOrWhitespace(string).booleanValue()) {
            if (this.villageData.getResidentsData() != null) {
                residentsText = residentsText + "" + this.villageData.getResidentsData().getResidentsCountAll();
            }
            Font.small.printLeft(string, x, y, this.field_73735_i);
            Font.small.printRight(residentsText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        String visitorsLabel = TextUtils.translate("tektopiaBook.visitors.total", new Object[0]);
        String visitorsText = "";
        if (!StringUtils.isNullOrWhitespace(visitorsLabel).booleanValue()) {
            if (this.villageData.getResidentsData() != null) {
                visitorsText = visitorsText + "" + this.villageData.getVisitorsData().getVisitorsCount();
            }
            Font.small.printLeft(visitorsLabel, x, y, this.field_73735_i);
            Font.small.printRight(visitorsText, x + n, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b;
        String enemiesLabel = TextUtils.translate("tektopiaBook.enemies.total", new Object[0]);
        String enemiesText = "";
        if (!StringUtils.isNullOrWhitespace(enemiesLabel).booleanValue()) {
            if (this.villageData.getResidentsData() != null) {
                enemiesText = enemiesText + "" + this.villageData.getEnemiesData().getEnemiesCount();
            }
            Font.small.printLeft(enemiesLabel, x, y, this.field_73735_i);
            Font.small.printRight(enemiesText, x + n, y, this.field_73735_i);
        }
        y = this.y + 310 - 10;
        int n5 = 16;
        String filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showplayer", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(filterText).booleanValue()) {
            buttonIcon = new GuiTexture(showMapPlayer != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPPLAYER, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showenemies", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapEnemies != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPENEMIES, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showvisitors", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapVisitors != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPVISITORS, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showresidents", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapResidents != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPRESIDENTS, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showstructures", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapStructures != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPSTRUCTURES, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showhomes", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapHomes != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPHOMES, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showtownhall", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapTownHall != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPTOWNHALL, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter.showboundaries", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showMapBoundaries != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPBOUNDARIES, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.filter", new Object[0])).booleanValue()) {
            Font.normal.printLeft(filterText, x, y + 1, this.field_73735_i);
            y -= Font.normal.fontRenderer.field_78288_b;
        }
        y -= 4;
        filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.options.showselectedonly", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(filterText).booleanValue()) {
            buttonIcon = new GuiTexture(this.showSelectedOnly != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPSELECTEDONLY, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.options.showselectedalways", new Object[0])).booleanValue()) {
            buttonIcon = new GuiTexture(showSelectedAlways != false ? mapCheckmarkTick : mapCheckmarkCross, this.field_73735_i, x, y, 10, 10, 0, 0, 10, 10);
            button = new GuiButton(BUTTON_KEY_SHOWMAPSELECTEDALWAYS, buttonIcon);
            this.buttons.add(button);
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.options.clearselected", new Object[0])).booleanValue()) {
            GuiHyperlink linkButton = new GuiHyperlink(BUTTON_KEY_CLEARSELECTION, "");
            linkButton.setIcon(x + n5, y + 1, Font.small.getStringWidth(filterText), Font.small.fontRenderer.field_78288_b);
            this.buttons.add(linkButton);
            String linkTooltipText = TextUtils.translate("tektopiaBook.map.options.clearselectedtooltip", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(linkTooltipText).booleanValue()) {
                GuiTooltip linkTooltip = new GuiTooltip(x + n5, y + 1, Font.small.getStringWidth(linkTooltipText), Font.small.fontRenderer.field_78288_b, linkTooltipText);
                this.tooltips.add(linkTooltip);
            }
            Font.small.printLeft(filterText, x + n5, y + 1, this.field_73735_i);
            y -= Font.small.fontRenderer.field_78288_b;
        }
        if (!StringUtils.isNullOrWhitespace(filterText = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.options", new Object[0])).booleanValue()) {
            Font.normal.printLeft(filterText, x, y + 1, this.field_73735_i);
            y -= Font.normal.fontRenderer.field_78288_b;
        }
        if (showMapBoundaries.booleanValue()) {
            if (dataKey[0].equals(GuiMapQuadrant.ALL.name()) || dataKey[0].equals(GuiMapQuadrant.SOUTHWEST.name()) || dataKey[0].equals(GuiMapQuadrant.SOUTHEAST.name())) {
                super.func_73730_a(this.x + 321 - 120, this.x + 321 + 120, this.y + 70, Color.GRAY.getRGB());
                if (!dataKey[0].equals(GuiMapQuadrant.ALL.name())) {
                    int iX = this.x + 321 - 120;
                    for (int i = 0; i < 13; ++i) {
                        super.func_73728_b(iX, this.y + 190 - 120 - 2, this.y + 190 - 120 + 2, Color.GRAY.getRGB());
                        iX += 20;
                    }
                }
            }
            if (dataKey[0].equals(GuiMapQuadrant.ALL.name()) || dataKey[0].equals(GuiMapQuadrant.NORTHWEST.name()) || dataKey[0].equals(GuiMapQuadrant.NORTHEAST.name())) {
                super.func_73730_a(this.x + 321 - 120, this.x + 321 + 120, this.y + 310, Color.GRAY.getRGB());
                if (!dataKey[0].equals(GuiMapQuadrant.ALL.name())) {
                    int iX = this.x + 321 - 120;
                    for (int i = 0; i < 13; ++i) {
                        super.func_73728_b(iX, this.y + 190 + 120 - 2, this.y + 190 + 120 + 2, Color.GRAY.getRGB());
                        iX += 20;
                    }
                }
            }
            if (dataKey[0].equals(GuiMapQuadrant.ALL.name()) || dataKey[0].equals(GuiMapQuadrant.NORTHEAST.name()) || dataKey[0].equals(GuiMapQuadrant.SOUTHEAST.name())) {
                super.func_73728_b(this.x + 321 - 120, this.y + 190 - 120, this.y + 190 + 120, Color.GRAY.getRGB());
                if (!dataKey[0].equals(GuiMapQuadrant.ALL.name())) {
                    int iY = this.y + 190 - 120;
                    for (int i = 0; i < 13; ++i) {
                        super.func_73730_a(this.x + 321 - 120 - 1, this.x + 321 - 120 + 1, iY, Color.GRAY.getRGB());
                        iY += 20;
                    }
                }
            }
            if (dataKey[0].equals(GuiMapQuadrant.ALL.name()) || dataKey[0].equals(GuiMapQuadrant.NORTHWEST.name()) || dataKey[0].equals(GuiMapQuadrant.SOUTHWEST.name())) {
                super.func_73728_b(this.x + 321 + 120, this.y + 190 - 120, this.y + 190 + 120, Color.GRAY.getRGB());
                if (!dataKey[0].equals(GuiMapQuadrant.ALL.name())) {
                    int iY = this.y + 190 - 120;
                    for (int i = 0; i < 13; ++i) {
                        super.func_73730_a(this.x + 321 + 120 - 1, this.x + 321 + 120 + 1, iY, Color.GRAY.getRGB());
                        iY += 20;
                    }
                }
            }
            if (dataKey[0].equals(GuiMapQuadrant.ALL.name())) {
                super.func_73730_a(this.x + 321 - 120, this.x + 321 + 120, this.y + 190, Color.GRAY.getRGB());
                int iX = this.x + 321 - 120 + 10;
                for (int i = 1; i < 24; ++i) {
                    super.func_73728_b(iX, this.y + 190 - 2, this.y + 190 + 2, Color.GRAY.getRGB());
                    iX += 10;
                }
            }
            if (dataKey[0].equals(GuiMapQuadrant.ALL.name())) {
                super.func_73728_b(this.x + 321, this.y + 190 - 120, this.y + 190 + 120, Color.GRAY.getRGB());
                int iY = this.y + 190 - 120 + 10;
                for (int i = 1; i < 24; ++i) {
                    super.func_73730_a(this.x + 321 - 1, this.x + 321 + 1, iY, Color.GRAY.getRGB());
                    iY += 10;
                }
            }
        }
        GuiMapQuadrant quadrant = GuiMapQuadrant.valueOf(dataKey[0]);
        String quadrantName = null;
        int factor = 1;
        BlockPos mapOrigin = null;
        switch (quadrant) {
            case ALL: {
                int xZeroPoint = this.x + 313;
                int yZeroPoint = this.y + (190 - 16 * factor);
                mapOrigin = new BlockPos(xZeroPoint, 0, yZeroPoint);
                break;
            }
            case NORTHEAST: {
                quadrantName = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.quadrantnortheast", new Object[0]);
                factor = 2;
                int xZeroPoint = this.x + 321 - 120 - 16 * factor / 2;
                int yZeroPoint = this.y + 310 - 16 * factor;
                mapOrigin = new BlockPos(xZeroPoint, 0, yZeroPoint);
                break;
            }
            case NORTHWEST: {
                quadrantName = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.quadrantnorthwest", new Object[0]);
                factor = 2;
                int xZeroPoint = this.x + 321 + 120 - 16 * factor / 2;
                int yZeroPoint = this.y + 310 - 16 * factor;
                mapOrigin = new BlockPos(xZeroPoint, 0, yZeroPoint);
                break;
            }
            case SOUTHEAST: {
                quadrantName = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.quadrantsoutheast", new Object[0]);
                factor = 2;
                int xZeroPoint = this.x + 321 - 120 - 16 * factor / 2;
                int yZeroPoint = this.y + 70 - 16 * factor;
                mapOrigin = new BlockPos(xZeroPoint, 0, yZeroPoint);
                break;
            }
            case SOUTHWEST: {
                quadrantName = TextFormatting.DARK_BLUE + TextUtils.translate("tektopiaBook.map.quadrantsouthwest", new Object[0]);
                factor = 2;
                int xZeroPoint = this.x + 321 + 120 - 16 * factor / 2;
                int yZeroPoint = this.y + 70 - 16 * factor;
                mapOrigin = new BlockPos(xZeroPoint, 0, yZeroPoint);
                break;
            }
        }
        if (!StringUtils.isNullOrWhitespace(quadrantName).booleanValue()) {
            Font.normal.printLeft(quadrantName, this.x + 55, this.y + 45 + 5, this.field_73735_i);
        }
        if (mapOrigin != null) {
            for (GuiMapMarker mapMarker : mapMarkers) {
                if (!mapMarker.isInQuadrant(quadrant).booleanValue()) continue;
                mapMarker.addPosition(townHallStructure.getFramePosition());
                if (mapMarker.getTooltip() != null) {
                    mapMarker.getTooltip().multiplySize(factor);
                    mapMarker.getTooltip().multiplyPosition(factor).multipleOffset(factor).addPosition(mapOrigin);
                    this.tooltips.add(0, mapMarker.getTooltip());
                }
                if (mapMarker.getIcon() != null) {
                    mapMarker.getIcon().multiplySize(factor);
                    mapMarker.getIcon().multiplyPosition(factor).addPosition(mapOrigin);
                }
                this.buttons.add(mapMarker);
            }
        }
    }

    protected void drawPageProfession(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        Map<String, Integer> professionTypeCounts;
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        int x1 = 0;
        int x2 = 0;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        ResidentsData residentsData = this.villageData.getResidentsData();
        String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
        String typeHeader = TextUtils.translate("tektopiaBook.professions.professiontypes", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(typeHeader).booleanValue()) {
            if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                typeHeader = typeHeader + " " + continued;
            }
            typeHeader = TextFormatting.DARK_BLUE + typeHeader;
            if (guiPage.isLeftPage()) {
                Font.normal.printLeft(typeHeader, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printLeft(typeHeader, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        Map<String, Integer> map = professionTypeCounts = residentsData != null ? residentsData.getProfessionTypeCountsAll() : null;
        if (professionTypeCounts != null) {
            int page;
            int[] maxLength = new int[]{0};
            String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
            String countHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.count", new Object[0]);
            maxLength[0] = maxLength[0] + Font.small.getStringWidth(countHeader);
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                Font.small.printLeft(countHeader, this.x + 141, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                Font.small.printLeft(countHeader, this.x + 374, y, this.field_73735_i);
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            try {
                page = Integer.parseInt(dataKey[1]);
            }
            catch (NumberFormatException e) {
                page = 0;
            }
            int startIndex = page * 24;
            int endIndex = Math.min(professionTypeCounts.size(), startIndex + 24);
            List subList = professionTypeCounts.entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
            for (Map.Entry entry : subList) {
                String typeName = GuiTektopiaBook.getTypeName((String)entry.getKey());
                int typeCount = (Integer)entry.getValue();
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(typeName, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(typeCount, this.x + 141 + maxLength[0], y, this.field_73735_i);
                    x1 = this.x + 35 + indentX;
                    x2 = x1 + Font.small.getStringWidth(typeName);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(typeName, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(typeCount, this.x + 374 + maxLength[0], y, this.field_73735_i);
                    x1 = this.x + 268 + indentX;
                    x2 = x1 + Font.small.getStringWidth(typeName);
                }
                if (!this.isSubPageOpen().booleanValue() && typeCount > 0) {
                    GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey((String)entry.getKey())));
                    button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                    this.tooltips.add(toolTip);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
            }
        }
    }

    protected void drawPageProfessionType(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        int x1 = 0;
        int x2 = 0;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        String professionType = dataKey[0];
        ResidentsData residentsData = this.villageData.getResidentsData();
        Map<String, Integer> professionTypeCounts = residentsData != null ? residentsData.getProfessionTypeCountsAll() : null;
        List<ResidentData> residents = residentsData != null ? residentsData.getResidentsByType(professionType, true) : null;
        String typeName = GuiTektopiaBook.getTypeName(professionType);
        String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
        String summary = TextUtils.translate("tektopiaBook.summary", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(typeName).booleanValue()) {
            typeName = typeName + " " + summary;
            if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                typeName = typeName + " " + continued;
            }
            typeName = TextFormatting.DARK_BLUE + typeName;
            if (guiPage.isLeftPage()) {
                Font.normal.printLeft(typeName, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printLeft(typeName, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (dataKey[1].equals("0")) {
            String totalLabel = TextUtils.translate("tektopiaBook.professiontypes.total", new Object[0]);
            String totalText = "";
            if (!StringUtils.isNullOrWhitespace(totalLabel).booleanValue()) {
                if (professionTypeCounts != null && professionTypeCounts.containsKey(professionType)) {
                    totalText = totalText + "" + professionTypeCounts.get(professionType);
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(totalLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(totalText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(totalLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(totalText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String header = TextUtils.translate("tektopiaBook.professiontypes.residents", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
            header = TextFormatting.DARK_BLUE + header;
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(header, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printLeft(header, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (residents != null) {
            int page;
            int[] maxLength = new int[]{0};
            maxLength[0] = maxLength[0] + 10;
            String bedHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.bed", new Object[0]);
            String residentHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.resident", new Object[0]);
            String levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.level", new Object[0]);
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(bedHeader, this.x + 35, y, this.field_73735_i);
                Font.small.printLeft(residentHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printLeft(bedHeader, this.x + 268, y, this.field_73735_i);
                Font.small.printLeft(residentHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            try {
                page = Integer.parseInt(dataKey[1]);
            }
            catch (NumberFormatException e) {
                page = 0;
            }
            int startIndex = page * 22;
            int endIndex = Math.min(residents.size(), startIndex + 22);
            List<ResidentData> subList = residents.subList(startIndex, endIndex);
            for (ResidentData resident : subList) {
                String residentBed = "";
                if (resident.getCanHaveBed()) {
                    residentBed = residentBed + (resident.hasBed() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                }
                String residentName = GuiTektopiaBook.formatResidentName(resident.isMale(), resident.getName(), true);
                String residentLevel = "";
                ProfessionType pt = TektopiaUtils.getProfessionType(professionType);
                if (pt != null) {
                    switch (pt) {
                        case CHILD: 
                        case NITWIT: {
                            break;
                        }
                        default: {
                            residentLevel = residentLevel + GuiTektopiaBook.formatResidentLevel(resident.getLevel(), resident.getBaseLevel(), false, false);
                        }
                    }
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printRight(residentBed, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(residentName, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printRight(residentLevel, this.x + 247, y, this.field_73735_i);
                    x1 = this.x + 35 + indentX + maxLength[0];
                    x2 = x1 + Font.small.getStringWidth(residentName);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printRight(residentBed, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(residentName, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printRight(residentLevel, this.x + 480, y, this.field_73735_i);
                    x1 = this.x + 268 + indentX + maxLength[0];
                    x2 = x1 + Font.small.getStringWidth(residentName);
                }
                if (!this.isSubPageOpen().booleanValue()) {
                    GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_RESIDENTLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(resident.getId())));
                    button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.residentdetails", new Object[0]));
                    this.tooltips.add(toolTip);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
            }
        }
    }

    protected void drawPageResident(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        block149: {
            ResidentData resident;
            int residentId;
            StructuresData structuresData;
            ResidentsData residentsData;
            String[] dataKey;
            int x4;
            int x3;
            int x2;
            int x1;
            int indentX;
            int y;
            block148: {
                int page;
                this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
                this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
                y = this.y + 32;
                indentX = 10;
                x1 = 0;
                x2 = 0;
                x3 = 0;
                x4 = 0;
                dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
                residentsData = this.villageData.getResidentsData();
                structuresData = this.villageData.getStructuresData();
                if (!dataKey[0].equals("")) break block148;
                String pageHeader = TextUtils.translate("tektopiaBook.residents.residents", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(pageHeader).booleanValue()) {
                    pageHeader = TextFormatting.DARK_BLUE + pageHeader;
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(pageHeader, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(pageHeader, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                List<ResidentData> residents = residentsData.getResidents();
                if (residents == null) break block149;
                int[] maxLength = new int[]{0};
                maxLength[0] = maxLength[0] + 10;
                String bedHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.bed", new Object[0]);
                String sleepHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.sleep", new Object[0]);
                String residentHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.resident", new Object[0]);
                String professionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.profession", new Object[0]);
                String levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.level", new Object[0]);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(bedHeader, this.x + 35, y, this.field_73735_i);
                    Font.small.printLeft(sleepHeader, this.x + 35 + maxLength[0] + 5, y, this.field_73735_i);
                    Font.small.printLeft(residentHeader, this.x + 35 + indentX + maxLength[0] + indentX + 7, y, this.field_73735_i);
                    Font.small.printLeft(professionHeader, this.x + 141 + indentX + indentX + 15, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(bedHeader, this.x + 268, y, this.field_73735_i);
                    Font.small.printLeft(sleepHeader, this.x + 268 + maxLength[0] + 5, y, this.field_73735_i);
                    Font.small.printLeft(residentHeader, this.x + 268 + indentX + maxLength[0] + indentX + 7, y, this.field_73735_i);
                    Font.small.printLeft(professionHeader, this.x + 374 + indentX + indentX + 15, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 24;
                int endIndex = Math.min(residents.size(), startIndex + 24);
                List<ResidentData> subList = residents.subList(startIndex, endIndex);
                for (ResidentData resident2 : subList) {
                    String residentBed = "";
                    if (resident2.getCanHaveBed()) {
                        residentBed = residentBed + (resident2.hasBed() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                    }
                    String residentSleep = "";
                    if (resident2.getCanHaveBed()) {
                        residentSleep = residentSleep + (resident2.isSleeping() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                    }
                    String residentName = GuiTektopiaBook.formatResidentName(resident2.isMale(), resident2.getName(), true);
                    String residentProfession = GuiTektopiaBook.getTypeName(resident2.getProfessionType());
                    String residentLevel = "";
                    ProfessionType pt = TektopiaUtils.getProfessionType(resident2.getProfessionType());
                    if (pt != null) {
                        switch (pt) {
                            case CHILD: 
                            case NITWIT: {
                                break;
                            }
                            default: {
                                residentLevel = residentLevel + GuiTektopiaBook.formatResidentLevel(resident2.getLevel(), resident2.getBaseLevel(), false, false);
                            }
                        }
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(residentBed, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(residentSleep, this.x + 35 + indentX + maxLength[0] + 7, y, this.field_73735_i);
                        Font.small.printLeft(residentName, this.x + 35 + indentX + maxLength[0] + indentX + 7, y, this.field_73735_i);
                        Font.small.printLeft(residentProfession, this.x + 141 + indentX + indentX + 15, y, this.field_73735_i);
                        Font.small.printRight(residentLevel, this.x + 247, y, this.field_73735_i);
                        x1 = this.x + 35 + indentX + maxLength[0] + indentX + 7;
                        x2 = x1 + Font.small.getStringWidth(residentName);
                        x3 = this.x + 141 + indentX + indentX + 15;
                        x4 = x3 + Font.small.getStringWidth(residentProfession);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(residentBed, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(residentSleep, this.x + 268 + indentX + maxLength[0] + 7, y, this.field_73735_i);
                        Font.small.printLeft(residentName, this.x + 268 + indentX + maxLength[0] + indentX + 7, y, this.field_73735_i);
                        Font.small.printLeft(residentProfession, this.x + 374 + indentX + indentX + 15, y, this.field_73735_i);
                        Font.small.printRight(residentLevel, this.x + 480, y, this.field_73735_i);
                        x1 = this.x + 268 + indentX + maxLength[0] + indentX + 7;
                        x2 = x1 + Font.small.getStringWidth(residentName);
                        x3 = this.x + 374 + indentX + indentX + 15;
                        x4 = x3 + Font.small.getStringWidth(residentProfession);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_RESIDENTLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(resident2.getId())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        ArrayList<String> residentNameTooltip = new ArrayList<String>();
                        residentNameTooltip.add(TextUtils.translate("tektopiaBook.links.residentdetails", new Object[0]));
                        if (ModConfig.debug.enableDebug) {
                            residentNameTooltip.add("(" + TextUtils.translate("tektopiaBook.id", new Object[0]) + resident2.getId() + ")");
                        }
                        GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, residentNameTooltip);
                        this.tooltips.add(toolTip);
                        button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey(residentProfession)));
                        button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                break block149;
            }
            try {
                residentId = Integer.parseInt(dataKey[0]);
            }
            catch (NumberFormatException e) {
                residentId = 0;
            }
            ResidentData residentData = resident = residentId > 0 ? residentsData.getResidentById(residentId) : null;
            if (resident != null) {
                GuiTooltip toolTip;
                GuiHyperlink button;
                List tooltip;
                String header = GuiTektopiaBook.stripTextFormatting(resident.getName());
                if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                    if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == residentId) {
                        header = TextFormatting.UNDERLINE + header;
                    }
                    if (this.villageData.getBedPosition() != null && this.villageData.getBedPosition().equals((Object)resident.getBedPosition())) {
                        header = TextFormatting.UNDERLINE + header;
                    }
                    header = resident.isMale() ? TextFormatting.BLUE + header + " " + TextUtils.SYMBOL_MALE : TextFormatting.LIGHT_PURPLE + header + " " + TextUtils.SYMBOL_FEMALE;
                    if (ModConfig.debug.enableDebug) {
                        header = header + TextFormatting.RESET + " (" + TextUtils.translate("tektopiaBook.id", new Object[0]) + resident.getId() + ")";
                    }
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                    }
                }
                if (!resident.isVendor()) {
                    String inventoryText;
                    String aiFilterText = TextUtils.translate("tektopiaBook.residents.viewaifilters", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(aiFilterText).booleanValue()) {
                        if (guiPage.isLeftPage()) {
                            x1 = this.x + 247 - 22;
                        }
                        if (guiPage.isRightPage()) {
                            x1 = this.x + 480 - 22;
                        }
                        if (this.isSubPageOpen().booleanValue()) {
                            RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(buttonAiFilter, this.field_73735_i, x1, y - 5, 0.0f, 0.0f, 24, 24, 24.0f, 24.0f);
                        } else {
                            GuiButton aiFilterButton = new GuiButton("aifilter");
                            aiFilterButton.setIcon(buttonAiFilter, this.field_73735_i, x1, y - 5, 24, 24, 0, 0, 24, 24);
                            aiFilterButton.setButtonData(GuiTektopiaBook.getAiFilterSubPageKey(residentId));
                            this.buttons.add(aiFilterButton);
                            GuiTooltip aiFilterToolTip = new GuiTooltip(x1, y - 5, 24, 24, aiFilterText);
                            this.tooltips.add(aiFilterToolTip);
                        }
                    }
                    if (!StringUtils.isNullOrWhitespace(inventoryText = TextUtils.translate("tektopiaBook.residents.viewinventory", new Object[0])).booleanValue()) {
                        if (guiPage.isLeftPage()) {
                            x1 = this.x + 247 - 44;
                        }
                        if (guiPage.isRightPage()) {
                            x1 = this.x + 480 - 44;
                        }
                        if (this.isSubPageOpen().booleanValue()) {
                            RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(buttonInventory, this.field_73735_i, x1, y - 5, 0.0f, 0.0f, 24, 24, 24.0f, 24.0f);
                        } else {
                            GuiButton inventoryButton = new GuiButton("inventory");
                            inventoryButton.setIcon(buttonInventory, this.field_73735_i, x1, y - 5, 24, 24, 0, 0, 24, 24);
                            inventoryButton.setButtonData(GuiTektopiaBook.getInventorySubPageKey(residentId));
                            this.buttons.add(inventoryButton);
                            GuiTooltip inventoryToolTip = new GuiTooltip(x1, y - 5, 24, 24, inventoryText);
                            this.tooltips.add(inventoryToolTip);
                        }
                    }
                }
                int tXL = this.x + 191;
                int tXR = this.x + 424;
                int tY = (y += Font.small.fontRenderer.field_78288_b + 2 + 2) + 6;
                String gender = resident.isMale() ? "m" : "f";
                ResourceLocation residentResource = new ResourceLocation("tektopiainformation", "textures/professions/" + resident.getProfessionType() + "_" + gender + ".png");
                if (guiPage.isLeftPage()) {
                    RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(residentResource, this.field_73735_i, tXL, tY, 0.0f, 0.0f, 56, 90, 56.0f, 90.0f);
                }
                if (guiPage.isRightPage()) {
                    RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(residentResource, this.field_73735_i, tXR, tY, 0.0f, 0.0f, 56, 90, 56.0f, 90.0f);
                }
                tXL -= 20;
                tXR -= 20;
                tY = y + 10;
                float oldZLevel = this.addZLevel(5.0f);
                for (ItemStack itemStack : resident.getArmor()) {
                    if (itemStack != null && !itemStack.func_190926_b()) {
                        tooltip = itemStack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                        if (itemStack.func_77948_v() && tooltip.size() > 0) {
                            tooltip.set(0, TextFormatting.AQUA + (String)tooltip.get(0));
                        }
                        if (guiPage.isLeftPage()) {
                            RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, itemStack, tXL, tY, true);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, tXL, tY, null);
                            if (!this.isSubPageOpen().booleanValue() && tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(tXL, tY, 16, 16, tooltip));
                            }
                        }
                        if (guiPage.isRightPage()) {
                            RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, itemStack, tXR, tY, true);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, tXR, tY, null);
                            if (!this.isSubPageOpen().booleanValue() && tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(tXR, tY, 16, 16, tooltip));
                            }
                        }
                    }
                    tY += 20;
                }
                tXL -= 20;
                tXR -= 20;
                tY = y + 10;
                for (ItemStack itemStack : resident.getEquipment()) {
                    if (itemStack != null && !itemStack.func_190926_b()) {
                        tooltip = itemStack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                        if (itemStack.func_77948_v() && tooltip.size() > 0) {
                            tooltip.set(0, TextFormatting.AQUA + (String)tooltip.get(0));
                        }
                        if (guiPage.isLeftPage()) {
                            RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, itemStack, tXL, tY, true);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, tXL, tY, null);
                            if (!this.isSubPageOpen().booleanValue() && tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(tXL, tY, 16, 16, tooltip));
                            }
                        }
                        if (guiPage.isRightPage()) {
                            RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, itemStack, tXR, tY, true);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, tXR, tY, null);
                            if (!this.isSubPageOpen().booleanValue() && tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(tXR, tY, 16, 16, tooltip));
                            }
                        }
                    }
                    tY += 20;
                }
                this.setZLevel(oldZLevel);
                String professionLabel = TextUtils.translate("tektopiaBook.residents.profession", new Object[0]);
                String professionText = "";
                if (!StringUtils.isNullOrWhitespace(professionLabel).booleanValue()) {
                    professionText = professionText + GuiTektopiaBook.getTypeName(resident.getProfessionType());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(professionLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(professionText, this.x + 88 + indentX, y, this.field_73735_i);
                        x1 = this.x + 88 + indentX;
                        x2 = x1 + Font.small.getStringWidth(professionLabel);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(professionLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(professionText, this.x + 321 + indentX, y, this.field_73735_i);
                        x1 = this.x + 321 + indentX;
                        x2 = x1 + Font.small.getStringWidth(professionLabel);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey(professionText)));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String levelLabel = TextUtils.translate("tektopiaBook.residents.level", new Object[0]);
                String levelText = "";
                ProfessionType pt = TektopiaUtils.getProfessionType(resident.getProfessionType());
                if (pt != null && !StringUtils.isNullOrWhitespace(levelLabel).booleanValue()) {
                    switch (pt) {
                        case CHILD: 
                        case NITWIT: {
                            break;
                        }
                        default: {
                            levelText = GuiTektopiaBook.formatResidentLevel(resident.getLevel(), resident.getBaseLevel(), true, false);
                        }
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(levelLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(levelText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(levelLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(levelText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String daysAliveLabel = TextUtils.translate("tektopiaBook.residents.daysalive", new Object[0]);
                String daysAliveText = "";
                if (!StringUtils.isNullOrWhitespace(daysAliveLabel).booleanValue()) {
                    if (resident.getDaysAlive() > 0) {
                        daysAliveText = daysAliveText + "" + resident.getDaysAlive();
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(daysAliveLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(daysAliveText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(daysAliveLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(daysAliveText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String healthLabel = TextUtils.translate("tektopiaBook.residents.health", new Object[0]);
                String healthText = "";
                if (!StringUtils.isNullOrWhitespace(healthLabel).booleanValue()) {
                    healthText = healthText + GuiTektopiaBook.formatResidentStatistic(resident.getHealth(), resident.getMaxHealth(), true);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(healthLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(healthText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(healthLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(healthText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String hungerLabel = TextUtils.translate("tektopiaBook.residents.hunger", new Object[0]);
                String hungerText = "";
                if (!StringUtils.isNullOrWhitespace(hungerLabel).booleanValue()) {
                    hungerText = hungerText + GuiTektopiaBook.formatResidentStatistic(resident.getHunger(), resident.getMaxHunger(), true);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(hungerLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(hungerText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(hungerLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(hungerText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String happinessLabel = TextUtils.translate("tektopiaBook.residents.happiness", new Object[0]);
                String happinessText = "";
                if (!StringUtils.isNullOrWhitespace(happinessLabel).booleanValue()) {
                    happinessText = happinessText + GuiTektopiaBook.formatResidentStatistic(resident.getHappy(), resident.getMaxHappy(), true);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(happinessLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(happinessText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(happinessLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(happinessText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String intelligenceLabel = TextUtils.translate("tektopiaBook.residents.intelligence", new Object[0]);
                String intelligenceText = "";
                if (!StringUtils.isNullOrWhitespace(intelligenceLabel).booleanValue()) {
                    intelligenceText = intelligenceText + GuiTektopiaBook.formatResidentStatistic(resident.getIntelligence(), resident.getMaxIntelligence(), true);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(intelligenceLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(intelligenceText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(intelligenceLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(intelligenceText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String blessedLabel = TextUtils.translate("tektopiaBook.residents.blessed", new Object[0]);
                String blessedText = "";
                if (!StringUtils.isNullOrWhitespace(blessedLabel).booleanValue()) {
                    blessedText = blessedText + (resident.isBlessed() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(blessedLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(blessedText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(blessedLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(blessedText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String totalArmorLabel = TextUtils.translate("tektopiaBook.residents.totalarmorvalue", new Object[0]);
                String totalArmorText = "";
                if (!StringUtils.isNullOrWhitespace(totalArmorLabel).booleanValue()) {
                    totalArmorText = totalArmorText + "" + resident.getTotalArmorValue();
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(totalArmorLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(totalArmorText, this.x + 88 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(totalArmorLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(totalArmorText, this.x + 321 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (!resident.isVendor()) {
                    String workTimeLabel = TextUtils.translate("tektopiaBook.residents.worktime", new Object[0]);
                    String workTimeText = "";
                    if (!StringUtils.isNullOrWhitespace(workTimeLabel).booleanValue()) {
                        LocalTime startTimeValue = LocalTime.of(6, 0).plusSeconds(resident.getWorkStartSeconds());
                        LocalTime finishTimeValue = LocalTime.of(6, 0).plusSeconds(resident.getWorkFinishSeconds());
                        workTimeText = workTimeText + startTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss")) + " - " + finishTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                        if (TektopiaUtils.isTimeOfDay(this.villageData.getVillageTicks(), resident.getWorkStartTicks(), resident.getWorkFinishTicks())) {
                            workTimeText = TextFormatting.DARK_AQUA + workTimeText;
                        }
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(workTimeLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(workTimeText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(workTimeLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(workTimeText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String sleepTimeLabel = TextUtils.translate("tektopiaBook.residents.sleeptime", new Object[0]);
                    String sleepTimeText = "";
                    if (!StringUtils.isNullOrWhitespace(sleepTimeLabel).booleanValue()) {
                        LocalTime startTimeValue = LocalTime.of(6, 0).plusSeconds(resident.getSleepStartSeconds());
                        LocalTime finishTimeValue = LocalTime.of(6, 0).plusSeconds(resident.getSleepFinishSeconds());
                        sleepTimeText = sleepTimeText + startTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss")) + " - " + finishTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                        if (TektopiaUtils.isTimeOfDay(this.villageData.getVillageTicks(), resident.getSleepStartTicks(), resident.getSleepFinishTicks())) {
                            sleepTimeText = TextFormatting.DARK_AQUA + sleepTimeText;
                        }
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(sleepTimeLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(sleepTimeText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(sleepTimeLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(sleepTimeText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String taskLabel = TextUtils.translate("tektopiaBook.residents.task", new Object[0]);
                    String taskText = "";
                    if (!StringUtils.isNullOrWhitespace(taskLabel).booleanValue()) {
                        taskText = taskText + GuiTektopiaBook.getAiTaskName(resident.getCurrentTask());
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(taskLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(taskText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(taskLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(taskText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                } else {
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                HomeData homeData = null;
                StructureData structureData = null;
                if (resident.hasBed() && this.villageData.getHomesData() != null) {
                    homeData = this.villageData.getHomesData().getHomeByBedPosition(resident.getBedPosition());
                } else if (resident.getHomePosition() != null && this.villageData.getStructuresData() != null) {
                    structureData = this.villageData.getStructuresData().getStructureByFramePosition(resident.getHomePosition());
                }
                String homeStructureLabel = TextUtils.translate("tektopiaBook.residents.home", new Object[0]);
                String homeStructureText = "";
                String homeStructurePosition = "";
                if (!StringUtils.isNullOrWhitespace(homeStructureLabel).booleanValue()) {
                    int structureId = 0;
                    int textLength = 0;
                    if (homeData != null) {
                        homeStructureText = homeStructureText + " " + homeData.getStructureTypeName();
                        homeStructurePosition = homeStructurePosition + " (" + GuiTektopiaBook.formatBlockPos(homeData.getFramePosition()) + ")";
                        structureId = homeData.getHomeId();
                    } else if (structureData != null) {
                        homeStructureText = homeStructureText + " " + structureData.getStructureTypeName();
                        homeStructurePosition = homeStructurePosition + " (" + GuiTektopiaBook.formatBlockPos(structureData.getFramePosition()) + ")";
                    }
                    textLength = Font.small.getStringWidth(homeStructureText);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(homeStructureLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(homeStructureText, this.x + 141 - indentX, y, this.field_73735_i);
                        Font.small.printLeft(homeStructurePosition, this.x + 141 - indentX + textLength, y, this.field_73735_i);
                        x1 = this.x + 141 - indentX;
                        x2 = x1 + Font.small.getStringWidth(homeStructureText);
                        x3 = this.x + 141 - indentX + textLength;
                        x4 = x3 + Font.small.getStringWidth(homeStructurePosition);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(homeStructureLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(homeStructureText, this.x + 374 - indentX, y, this.field_73735_i);
                        Font.small.printLeft(homeStructurePosition, this.x + 374 - indentX + textLength, y, this.field_73735_i);
                        x1 = this.x + 374 - indentX;
                        x2 = x1 + Font.small.getStringWidth(homeStructureText);
                        x3 = this.x + 374 - indentX + textLength;
                        x4 = x3 + Font.small.getStringWidth(homeStructurePosition);
                    }
                    if (!this.isSubPageOpen().booleanValue() && structureId > 0) {
                        button = new GuiHyperlink(BUTTON_KEY_HOMELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.HOME, GuiTektopiaBook.getStructureDetailPageKey(structureId)));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.homedetails", new Object[0]));
                        this.tooltips.add(toolTip);
                        button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.HOME, GuiTektopiaBook.getStructureDetailPageKey(structureId)));
                        button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (resident.getCanHaveBed()) {
                    String bedPositionLabel = TextUtils.translate("tektopiaBook.residents.bed", new Object[0]);
                    String bedPositionText = "";
                    if (!StringUtils.isNullOrWhitespace(bedPositionLabel).booleanValue()) {
                        if (resident.hasBed()) {
                            bedPositionText = bedPositionText + " " + GuiTektopiaBook.formatBlockPos(resident.getBedPosition());
                        }
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(bedPositionLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(bedPositionText, this.x + 141 - indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(bedPositionLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(bedPositionText, this.x + 374 - indentX, y, this.field_73735_i);
                        }
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                String currentStructureLabel = TextUtils.translate("tektopiaBook.residents.structure", new Object[0]);
                String currentStructureText = "";
                String currentStructurePosition = "";
                if (!StringUtils.isNullOrWhitespace(currentStructureLabel).booleanValue()) {
                    int structureId = 0;
                    int textLength = 0;
                    if (structuresData != null && resident.getCurrentStructure() != null) {
                        structureData = structuresData.getStructureByFramePosition(resident.getCurrentStructure());
                        if (structureData != null) {
                            currentStructureText = currentStructureText + " " + structureData.getStructureTypeName();
                            currentStructurePosition = currentStructurePosition + " (" + GuiTektopiaBook.formatBlockPos(resident.getCurrentStructure()) + ")";
                            structureId = structureData.getStructureId();
                        }
                    } else if (homeData != null && resident.getCurrentPosition() != null && resident.getBedPosition() != null) {
                        BlockPos positionCurrent = resident.getCurrentPosition();
                        BlockPos positionCurrent2 = positionCurrent.func_177979_c(1);
                        BlockPos positionBed = resident.getBedPosition();
                        if (positionCurrent.equals((Object)positionBed) || positionCurrent2.equals((Object)positionBed)) {
                            currentStructureText = currentStructureText + " " + homeData.getStructureTypeName();
                            currentStructurePosition = currentStructurePosition + " (" + GuiTektopiaBook.formatBlockPos(homeData.getFramePosition()) + ")";
                            structureId = homeData.getHomeId();
                        }
                    }
                    textLength = Font.small.getStringWidth(currentStructureText);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(currentStructureLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(currentStructureText, this.x + 141 - indentX, y, this.field_73735_i);
                        Font.small.printLeft(currentStructurePosition, this.x + 141 - indentX + textLength, y, this.field_73735_i);
                        x1 = this.x + 141 - indentX;
                        x2 = x1 + Font.small.getStringWidth(currentStructureText);
                        x3 = this.x + 141 - indentX + textLength;
                        x4 = x3 + Font.small.getStringWidth(currentStructurePosition);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(currentStructureLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(currentStructureText, this.x + 374 - indentX, y, this.field_73735_i);
                        Font.small.printLeft(currentStructurePosition, this.x + 374 - indentX + textLength, y, this.field_73735_i);
                        x1 = this.x + 374 - indentX;
                        x2 = x1 + Font.small.getStringWidth(currentStructureText);
                        x3 = this.x + 374 - indentX + textLength;
                        x4 = x3 + Font.small.getStringWidth(currentStructurePosition);
                    }
                    if (!this.isSubPageOpen().booleanValue() && structureId > 0) {
                        button = new GuiHyperlink(BUTTON_KEY_STRUCTURELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structureId)));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.structuredetails", new Object[0]));
                        this.tooltips.add(toolTip);
                        button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structureId)));
                        button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String currentPositionLabel = TextUtils.translate("tektopiaBook.residents.position", new Object[0]);
                String currentPositionText = "";
                if (!StringUtils.isNullOrWhitespace(currentPositionLabel).booleanValue()) {
                    currentPositionText = currentPositionText + " " + GuiTektopiaBook.formatBlockPos(resident.getCurrentPosition());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(currentPositionLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(currentPositionText, this.x + 141 - indentX, y, this.field_73735_i);
                        x1 = this.x + 141 - indentX;
                        x2 = x1 + Font.small.getStringWidth(currentPositionText);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(currentPositionLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(currentPositionText, this.x + 374 - indentX, y, this.field_73735_i);
                        x1 = this.x + 374 - indentX;
                        x2 = x1 + Font.small.getStringWidth(currentPositionText);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(resident.getId())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                if (!resident.isVendor()) {
                    String recentEatsHeader = TextUtils.translate("tektopiaBook.residents.recenteats", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(recentEatsHeader).booleanValue()) {
                        recentEatsHeader = TextFormatting.DARK_BLUE + recentEatsHeader;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(recentEatsHeader, this.x + 35, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(recentEatsHeader, this.x + 268, y, this.field_73735_i);
                        }
                        y += Font.small.fontRenderer.field_78288_b;
                        List<ItemStack> recentEats = resident.getRecentEats();
                        int startIndex = 0;
                        int endIndex = Math.min(5, startIndex + recentEats.size());
                        tXL = this.x + 35 + indentX;
                        tXR = this.x + 268 + indentX;
                        tY = y;
                        List<ItemStack> subList = recentEats.subList(startIndex, endIndex);
                        for (ItemStack recentEat : subList) {
                            if (recentEat != null && !recentEat.func_190926_b()) {
                                List tooltip2 = recentEat.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                                if (recentEat.func_77948_v() && tooltip2.size() > 0) {
                                    tooltip2.set(0, TextFormatting.AQUA + (String)tooltip2.get(0));
                                }
                                if (guiPage.isLeftPage()) {
                                    RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, recentEat, tXL, tY, true);
                                    RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, recentEat, tXL, tY, null);
                                    if (!this.isSubPageOpen().booleanValue() && tooltip2.size() > 0) {
                                        this.tooltips.add(new GuiTooltip(tXL, tY, 16, 16, tooltip2));
                                    }
                                }
                                if (guiPage.isRightPage()) {
                                    RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, recentEat, tXR, tY, true);
                                    RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, recentEat, tXR, tY, null);
                                    if (!this.isSubPageOpen().booleanValue() && tooltip2.size() > 0) {
                                        this.tooltips.add(new GuiTooltip(tXR, tY, 16, 16, tooltip2));
                                    }
                                }
                            }
                            tXL += 20;
                            tXR += 20;
                        }
                        y += 20;
                    } else {
                        y += Font.small.fontRenderer.field_78288_b + 2 + 20;
                    }
                    String additionalProfessionsHeader = TextUtils.translate("tektopiaBook.residents.additionalprofessions", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(additionalProfessionsHeader).booleanValue()) {
                        additionalProfessionsHeader = TextFormatting.DARK_BLUE + additionalProfessionsHeader;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(additionalProfessionsHeader, this.x + 35, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(additionalProfessionsHeader, this.x + 268, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
                    String levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.level", new Object[0]);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    Map<String, Integer> additionalProfessions = resident.getAdditionalProfessions();
                    int startIndex = 0;
                    int endIndex = Math.min(additionalProfessions.size(), startIndex + 4);
                    List subList = resident.getAdditionalProfessions().entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
                    for (Map.Entry additionalProfessionType : subList) {
                        String additionalProfessionText = GuiTektopiaBook.getTypeName((String)additionalProfessionType.getKey());
                        String additionalProfessionLevel = GuiTektopiaBook.formatResidentLevel((Integer)additionalProfessionType.getValue(), (Integer)additionalProfessionType.getValue(), false, false);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(additionalProfessionText, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(additionalProfessionLevel, this.x + 247, y, this.field_73735_i);
                            x1 = this.x + 35 + indentX;
                            x2 = x1 + Font.small.getStringWidth(additionalProfessionText);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(additionalProfessionText, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(additionalProfessionLevel, this.x + 480, y, this.field_73735_i);
                            x1 = this.x + 268 + indentX;
                            x2 = x1 + Font.small.getStringWidth(additionalProfessionText);
                        }
                        if (!this.isSubPageOpen().booleanValue() && residentsData.getProfessionTypeCount(additionalProfessionText) > 0) {
                            button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey(additionalProfessionText)));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                        y += Font.small.fontRenderer.field_78288_b + 2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawPageStatistics(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        Map<Integer, List<ResidentData>> hungerMap;
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int x4 = 0;
        String[] dataKey = GuiTektopiaBook.getStatisticsPageKeyParts(guiPage.getDataKey());
        ResidentsData residentsData = this.villageData.getResidentsData();
        StructuresData structuresData = this.villageData.getStructuresData();
        String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
        Map<Integer, List<ResidentData>> happinessMap = residentsData == null ? null : residentsData.getResidentHappinessStatistics();
        Map<Integer, List<ResidentData>> map = hungerMap = residentsData == null ? null : residentsData.getResidentHungerStatistics();
        if (dataKey[0].equals("")) {
            String overcrowdingHeader;
            String hungerHeader;
            GuiTooltip toolTip;
            GuiHyperlink button;
            String happinessHeader = TextUtils.translate("tektopiaBook.statistics.happiness", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(happinessHeader).booleanValue()) {
                happinessHeader = TextFormatting.DARK_BLUE + happinessHeader;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(happinessHeader, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(happinessHeader, this.x + 268, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (happinessMap != null) {
                    int[] maxLength = new int[]{0, 0};
                    maxLength[0] = 40;
                    String rangeHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.range", new Object[0]);
                    String residentsHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.statistics.residents", new Object[0]);
                    maxLength[1] = maxLength[1] + 30;
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(rangeHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(residentsHeader, this.x + 141 + maxLength[1], y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(rangeHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(residentsHeader, this.x + 374 + maxLength[1], y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    for (Map.Entry<Integer, List<ResidentData>> entry : happinessMap.entrySet()) {
                        int n = entry.getKey();
                        String rangeName = GuiTektopiaBook.formatStatisticsRange(Math.max(0, n - 20 + 1), n, 100);
                        String rangeValue = "" + entry.getValue().size();
                        if (guiPage.isLeftPage()) {
                            Font.small.printRight(rangeName, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                            Font.small.printRight(rangeValue, this.x + 141 + maxLength[1], y, this.field_73735_i);
                            x2 = this.x + 35 + indentX + maxLength[0];
                            x1 = x2 - Font.small.getStringWidth(rangeName);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printRight(rangeName, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                            Font.small.printRight(rangeValue, this.x + 374 + maxLength[1], y, this.field_73735_i);
                            x2 = this.x + 268 + indentX + maxLength[0];
                            x1 = x2 - Font.small.getStringWidth(rangeName);
                        }
                        if (!this.isSubPageOpen().booleanValue()) {
                            button = new GuiHyperlink(BUTTON_KEY_STATISTICLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STATS, GuiTektopiaBook.getStatisticsPageKey("happiness", entry.getKey(), 0)));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.statisticsdetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                        y += Font.small.fontRenderer.field_78288_b + 2;
                    }
                }
                y += 2;
            }
            if (!StringUtils.isNullOrWhitespace(hungerHeader = TextUtils.translate("tektopiaBook.statistics.hunger", new Object[0])).booleanValue()) {
                hungerHeader = TextFormatting.DARK_BLUE + hungerHeader;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(hungerHeader, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(hungerHeader, this.x + 268, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (hungerMap != null) {
                    int[] maxLength = new int[]{0, 0};
                    maxLength[0] = 40;
                    String rangeHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.range", new Object[0]);
                    String residentsHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.statistics.residents", new Object[0]);
                    maxLength[1] = maxLength[1] + 30;
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(rangeHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(residentsHeader, this.x + 141 + maxLength[1], y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(rangeHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(residentsHeader, this.x + 374 + maxLength[1], y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    for (Map.Entry<Integer, List<ResidentData>> entry : hungerMap.entrySet()) {
                        int rangeEnd = entry.getKey();
                        String rangeName = GuiTektopiaBook.formatStatisticsRange(Math.max(0, rangeEnd - 20 + 1), rangeEnd, 100);
                        String rangeValue = "" + entry.getValue().size();
                        if (guiPage.isLeftPage()) {
                            Font.small.printRight(rangeName, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                            Font.small.printRight(rangeValue, this.x + 141 + maxLength[1], y, this.field_73735_i);
                            x2 = this.x + 35 + indentX + maxLength[0];
                            x1 = x2 - Font.small.getStringWidth(rangeName);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printRight(rangeName, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                            Font.small.printRight(rangeValue, this.x + 374 + maxLength[1], y, this.field_73735_i);
                            x2 = this.x + 268 + indentX + maxLength[0];
                            x1 = x2 - Font.small.getStringWidth(rangeName);
                        }
                        if (!this.isSubPageOpen().booleanValue()) {
                            button = new GuiHyperlink(BUTTON_KEY_STATISTICLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STATS, GuiTektopiaBook.getStatisticsPageKey("hunger", entry.getKey(), 0)));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.statisticsdetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                        y += Font.small.fontRenderer.field_78288_b + 2;
                    }
                }
                y += 2;
            }
            if (!StringUtils.isNullOrWhitespace(overcrowdingHeader = TextUtils.translate("tektopiaBook.statistics.overcrowding", new Object[0])).booleanValue()) {
                overcrowdingHeader = TextFormatting.DARK_BLUE + overcrowdingHeader;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(overcrowdingHeader, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(overcrowdingHeader, this.x + 268, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                List<StructureData> structures = structuresData.getStructures();
                if (structures != null && structures.size() > 0) {
                    int[] maxLength = new int[]{0, 0};
                    maxLength[0] = 40;
                    String string = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.statistics.overcrowded", new Object[0]);
                    String string2 = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.structures", new Object[0]);
                    maxLength[1] = maxLength[1] + 30;
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(string, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(string2, this.x + 141 + maxLength[1], y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(string, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(string2, this.x + 374 + maxLength[1], y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String overcrowdedLabel = TextFormatting.DARK_RED + "Yes";
                    String overcrowdedText = "" + structures.stream().filter(s -> s.isOvercrowded()).count();
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(overcrowdedLabel, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(overcrowdedText, this.x + 141 + maxLength[1], y, this.field_73735_i);
                        x2 = this.x + 35 + indentX + maxLength[0];
                        x1 = x2 - Font.small.getStringWidth(overcrowdedLabel);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(overcrowdedLabel, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(overcrowdedText, this.x + 374 + maxLength[1], y, this.field_73735_i);
                        x2 = this.x + 268 + indentX + maxLength[0];
                        x1 = x2 - Font.small.getStringWidth(overcrowdedLabel);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_STATISTICLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STATS, GuiTektopiaBook.getStatisticsPageKey("overcrowding", 0, 0)));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.statisticsdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String undercrowdedLabel = TextFormatting.DARK_GREEN + "No";
                    String undercrowdedText = "" + structures.stream().filter(s -> s.isOvercrowded() == false).count();
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(undercrowdedLabel, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(undercrowdedText, this.x + 141 + maxLength[1], y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(undercrowdedLabel, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printRight(undercrowdedText, this.x + 374 + maxLength[1], y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                y += 2;
            }
        } else {
            GuiTooltip toolTip;
            GuiHyperlink button;
            Map.Entry statisticsSetResidents = null;
            List<StructureData> statisticsSetStructures = null;
            String header = "";
            switch (dataKey[0]) {
                case "happiness": {
                    header = TextUtils.translate("tektopiaBook.statistics.happinessheader", new Object[0]);
                    statisticsSetResidents = happinessMap.entrySet().stream().filter(e -> dataKey[1].equals(((Integer)e.getKey()).toString())).findFirst().orElse(null);
                    break;
                }
                case "hunger": {
                    header = TextUtils.translate("tektopiaBook.statistics.hungerheader", new Object[0]);
                    statisticsSetResidents = hungerMap.entrySet().stream().filter(e -> dataKey[1].equals(((Integer)e.getKey()).toString())).findFirst().orElse(null);
                    break;
                }
                case "overcrowding": {
                    header = TextUtils.translate("tektopiaBook.statistics.overcrowdingheader", new Object[0]);
                    statisticsSetStructures = structuresData.getStructuresOvercrowded();
                    break;
                }
            }
            if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                if (!(dataKey[1].equals("0") && dataKey[2].equals("0") || StringUtils.isNullOrWhitespace(continued).booleanValue())) {
                    header = header + " " + continued;
                }
                header = TextFormatting.DARK_BLUE + header;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            if (statisticsSetResidents != null) {
                int page;
                String rangeLabel = TextUtils.translate("tektopiaBook.statistics.range", new Object[0]);
                String rangeText = "";
                if (!StringUtils.isNullOrWhitespace(rangeLabel).booleanValue()) {
                    int n = (Integer)statisticsSetResidents.getKey();
                    rangeText = rangeText + GuiTektopiaBook.formatStatisticsRange(Math.max(0, n - 20 + 1), n, 100);
                    if (!dataKey[2].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                        rangeText = rangeText + " " + continued;
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(rangeLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(rangeText, this.x + 141 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(rangeLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(rangeText, this.x + 374 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (dataKey[2].equals("0")) {
                    String string = TextUtils.translate("tektopiaBook.statistics.total", new Object[0]);
                    String string3 = "";
                    if (!StringUtils.isNullOrWhitespace(string).booleanValue()) {
                        void var25_50;
                        if (statisticsSetResidents.getValue() != null) {
                            String string4 = string3 + "" + ((List)statisticsSetResidents.getValue()).size();
                        }
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(string, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(var25_50, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(string, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(var25_50, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                String string = TextUtils.translate("tektopiaBook.statistics.residents", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(string).booleanValue()) {
                    String string5 = TextFormatting.DARK_BLUE + string;
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(string5, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(string5, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                List list = (List)statisticsSetResidents.getValue();
                int[] maxLength = new int[]{0};
                maxLength[0] = maxLength[0] + 10;
                String bedHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.bed", new Object[0]);
                String residentHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.resident", new Object[0]);
                String professionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.profession", new Object[0]);
                String levelHeader = "";
                switch (dataKey[0]) {
                    case "happiness": {
                        levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.statistics.happiness", new Object[0]);
                        break;
                    }
                    case "hunger": {
                        levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.statistics.hunger", new Object[0]);
                        break;
                    }
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(bedHeader, this.x + 35, y, this.field_73735_i);
                    Font.small.printLeft(residentHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printLeft(professionHeader, this.x + 141 + indentX + indentX, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(bedHeader, this.x + 268, y, this.field_73735_i);
                    Font.small.printLeft(residentHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printLeft(professionHeader, this.x + 374 + indentX + indentX, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[2]);
                }
                catch (NumberFormatException e2) {
                    page = 0;
                }
                int startIndex = page * 20;
                int endIndex = Math.min(list.size(), startIndex + 20);
                List subList = list.subList(startIndex, endIndex);
                for (ResidentData resident : subList) {
                    String residentBed = "";
                    if (resident.getCanHaveBed()) {
                        residentBed = residentBed + (resident.hasBed() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                    }
                    String residentName = GuiTektopiaBook.formatResidentName(resident.isMale(), resident.getName(), true);
                    String residentProfession = GuiTektopiaBook.getTypeName(resident.getProfessionType());
                    String residentLevel = "";
                    switch (dataKey[0]) {
                        case "happiness": {
                            residentLevel = "" + GuiTektopiaBook.formatResidentStatistic(resident.getHappy(), resident.getMaxHappy(), false);
                            break;
                        }
                        case "hunger": {
                            residentLevel = "" + GuiTektopiaBook.formatResidentStatistic(resident.getHunger(), resident.getMaxHunger(), false);
                            break;
                        }
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printRight(residentBed, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(residentName, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printLeft(residentProfession, this.x + 141 + indentX + indentX, y, this.field_73735_i);
                        Font.small.printRight(residentLevel, this.x + 247, y, this.field_73735_i);
                        x1 = this.x + 35 + indentX + maxLength[0];
                        x2 = x1 + Font.small.getStringWidth(residentName);
                        x3 = this.x + 141 + indentX + indentX;
                        x4 = x3 + Font.small.getStringWidth(residentProfession);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printRight(residentBed, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(residentName, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                        Font.small.printLeft(residentProfession, this.x + 374 + indentX + indentX, y, this.field_73735_i);
                        Font.small.printRight(residentLevel, this.x + 480, y, this.field_73735_i);
                        x1 = this.x + 268 + indentX + maxLength[0];
                        x2 = x1 + Font.small.getStringWidth(residentName);
                        x3 = this.x + 374 + indentX + indentX;
                        x4 = x3 + Font.small.getStringWidth(residentProfession);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_RESIDENTLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(resident.getId())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.residentdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                        button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey(residentProfession)));
                        button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
            }
            if (statisticsSetStructures != null) {
                int page;
                if (dataKey[2].equals("0")) {
                    String totalLabel = TextUtils.translate("tektopiaBook.structures.total", new Object[0]);
                    String totalText = "";
                    if (!StringUtils.isNullOrWhitespace(totalLabel).booleanValue()) {
                        totalText = totalText + "" + statisticsSetStructures.size();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(totalLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(totalText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(totalLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(totalText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                String structuresHeader = TextUtils.translate("tektopiaBook.headers.structures", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(structuresHeader).booleanValue()) {
                    structuresHeader = TextFormatting.DARK_BLUE + structuresHeader;
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(structuresHeader, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(structuresHeader, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                int[] maxLength = new int[]{0, 0};
                String string = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.statistics.tilesperoccupant", new Object[0]);
                String string6 = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.structure", new Object[0]);
                String positionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.position", new Object[0]);
                String minimumHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.minimum", new Object[0]);
                String currentHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.current", new Object[0]);
                maxLength[0] = maxLength[0] + (Font.small.getStringWidth(minimumHeader) + Font.small.getStringWidth(currentHeader) + 5) / 2;
                maxLength[1] = maxLength[1] + (Font.small.getStringWidth(currentHeader) + 5);
                if (guiPage.isLeftPage()) {
                    Font.small.printCentered(string, this.x + 247 - maxLength[0], y, this.field_73735_i);
                    Font.small.printLeft(string6, this.x + 35 + indentX, y += Font.small.fontRenderer.field_78288_b, this.field_73735_i);
                    Font.small.printLeft(positionHeader, this.x + 141 - indentX - indentX - indentX, y, this.field_73735_i);
                    Font.small.printRight(minimumHeader, this.x + 247 - maxLength[1], y, this.field_73735_i);
                    Font.small.printRight(currentHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printCentered(string, this.x + 480 - maxLength[0], y, this.field_73735_i);
                    Font.small.printLeft(string6, this.x + 268 + indentX, y += Font.small.fontRenderer.field_78288_b, this.field_73735_i);
                    Font.small.printLeft(positionHeader, this.x + 374 - indentX - indentX - indentX, y, this.field_73735_i);
                    Font.small.printRight(minimumHeader, this.x + 480 - maxLength[1], y, this.field_73735_i);
                    Font.small.printRight(currentHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[2]);
                }
                catch (NumberFormatException e3) {
                    page = 0;
                }
                int startIndex = page * 20;
                int endIndex = Math.min(statisticsSetStructures.size(), startIndex + 20);
                List<StructureData> subList = statisticsSetStructures.subList(startIndex, endIndex);
                for (StructureData structure : subList) {
                    String structureName = structure.getStructureTypeName();
                    String structurePosition = GuiTektopiaBook.formatBlockPos(structure.getFramePosition());
                    String structureMinimum = "" + structure.getTilesPerOccupant();
                    String structureCurrent = "" + structure.getOccupantDensityRatio();
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(structureName, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(structurePosition, this.x + 141 - indentX - indentX - indentX, y, this.field_73735_i);
                        Font.small.printRight(structureMinimum, this.x + 247 - maxLength[1], y, this.field_73735_i);
                        Font.small.printRight(structureCurrent, this.x + 247, y, this.field_73735_i);
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(structureName);
                        x3 = this.x + 141 - indentX - indentX - indentX;
                        x4 = x3 + Font.small.getStringWidth(structurePosition);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(structureName, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(structurePosition, this.x + 374 - indentX - indentX - indentX, y, this.field_73735_i);
                        Font.small.printRight(structureMinimum, this.x + 480 - maxLength[1], y, this.field_73735_i);
                        Font.small.printRight(structureCurrent, this.x + 480, y, this.field_73735_i);
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(structureName);
                        x3 = this.x + 374 - indentX - indentX - indentX;
                        x4 = x3 + Font.small.getStringWidth(structurePosition);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_STRUCTURELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structure.getStructureId())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.structuredetails", new Object[0]));
                        this.tooltips.add(toolTip);
                        button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structure.getStructureId())));
                        button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
            }
        }
    }

    protected void drawPageStructure(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        block83: {
            int structureId;
            String continued;
            StructuresData structuresData;
            String[] dataKey;
            int x4;
            int x3;
            int x2;
            int x1;
            int indentX;
            int y;
            block82: {
                int page;
                this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
                this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
                y = this.y + 32;
                indentX = 10;
                x1 = 0;
                x2 = 0;
                x3 = 0;
                x4 = 0;
                dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
                structuresData = this.villageData.getStructuresData();
                Map<VillageStructureType, Integer> structureTypeCounts = structuresData != null ? structuresData.getStructureTypeCounts() : null;
                continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
                if (!dataKey[0].equals("")) break block82;
                String typeHeader = TextUtils.translate("tektopiaBook.structures.structuretypes", new Object[0]);
                if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                    typeHeader = typeHeader + " " + continued;
                }
                if (!StringUtils.isNullOrWhitespace(typeHeader).booleanValue()) {
                    typeHeader = TextFormatting.DARK_BLUE + typeHeader;
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(typeHeader, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(typeHeader, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (structureTypeCounts == null) break block83;
                int[] maxLength = new int[]{0};
                String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
                String countHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.count", new Object[0]);
                maxLength[0] = maxLength[0] + Font.small.getStringWidth(countHeader);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(countHeader, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(countHeader, this.x + 374, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 24;
                int endIndex = Math.min(structureTypeCounts.size(), startIndex + 24);
                List subList = structureTypeCounts.entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
                for (Map.Entry entry : subList) {
                    String typeName = GuiTektopiaBook.getStructureTypeName((VillageStructureType)entry.getKey());
                    int typeCount = structureTypeCounts.get(entry.getKey());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(typeName, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(typeCount, this.x + 141 + maxLength[0], y, this.field_73735_i);
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(typeName);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(typeName, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(typeCount, this.x + 374 + maxLength[0], y, this.field_73735_i);
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(typeName);
                    }
                    if (!this.isSubPageOpen().booleanValue() && typeCount > 0) {
                        GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_STRUCTURELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURETYPE, GuiTektopiaBook.getStructureTypePageKey((VillageStructureType)entry.getKey())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.structuredetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                break block83;
            }
            try {
                structureId = Integer.parseInt(dataKey[0]);
            }
            catch (NumberFormatException e) {
                structureId = 0;
            }
            StructureData structureData = structuresData.getStructureById(structureId);
            if (structureData != null) {
                int page;
                String densityRatioText;
                String densityRatioLabel;
                String minimumTilesText;
                String minimumTilesLabel;
                GuiTooltip toolTip;
                GuiHyperlink button;
                String header = structureData.getStructureTypeName();
                if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                    if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == structureData.getStructureId()) {
                        header = TextFormatting.UNDERLINE + header;
                    } else if (this.villageData.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)structureData.getFramePosition())) {
                        header = TextFormatting.UNDERLINE + header;
                    }
                    if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                        header = header + " " + continued;
                    }
                    header = TextFormatting.DARK_BLUE + header;
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String framePositionLabel = TextUtils.translate("tektopiaBook.structures.frameposition", new Object[0]);
                String framePositionText = "";
                if (!StringUtils.isNullOrWhitespace(framePositionLabel).booleanValue()) {
                    framePositionText = framePositionText + GuiTektopiaBook.formatBlockPos(structureData.getFramePosition());
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(framePositionLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(framePositionText, this.x + 141, y, this.field_73735_i);
                        x1 = this.x + 141 - indentX;
                        x2 = x1 + Font.small.getStringWidth(framePositionText);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(framePositionLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(framePositionText, this.x + 374, y, this.field_73735_i);
                        x1 = this.x + 374 - indentX;
                        x2 = x1 + Font.small.getStringWidth(framePositionText);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structureData.getStructureId())));
                        button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                        this.buttons.add(button);
                        toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                        this.tooltips.add(toolTip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String floorTilesLabel = TextUtils.translate("tektopiaBook.structures.floortiles", new Object[0]);
                String floorTilesText = "";
                if (!StringUtils.isNullOrWhitespace(floorTilesLabel).booleanValue()) {
                    floorTilesText = floorTilesText + "" + structureData.getFloorTileCount();
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(floorTilesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(floorTilesText, this.x + 141 + indentX, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(floorTilesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(floorTilesText, this.x + 374 + indentX, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (structureData.isAnimalPen()) {
                    String currentAnimalsLabel = TextUtils.translate("tektopiaBook.structures.currentanimals", new Object[0]);
                    String currentAnimalsText = "";
                    if (!StringUtils.isNullOrWhitespace(currentAnimalsLabel).booleanValue()) {
                        currentAnimalsText = currentAnimalsText + "" + structureData.getAnimalCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(currentAnimalsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(currentAnimalsText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(currentAnimalsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(currentAnimalsText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                } else {
                    String currentOccupantsLabel = TextUtils.translate("tektopiaBook.structures.currentoccupants", new Object[0]);
                    String currentOccupantsText = "";
                    if (!StringUtils.isNullOrWhitespace(currentOccupantsLabel).booleanValue()) {
                        currentOccupantsText = currentOccupantsText + "" + structureData.getOccupantCount();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(currentOccupantsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(currentOccupantsText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(currentOccupantsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(currentOccupantsText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                if (structureData.isAnimalPen()) {
                    String tilesPerAnimalLabel = TextUtils.translate("tektopiaBook.structures.tilesperanimal", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(tilesPerAnimalLabel).booleanValue()) {
                        tilesPerAnimalLabel = TextFormatting.DARK_BLUE + tilesPerAnimalLabel;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(tilesPerAnimalLabel, this.x + 35, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(tilesPerAnimalLabel, this.x + 268, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    minimumTilesLabel = TextUtils.translate("tektopiaBook.structures.minimumtiles", new Object[0]);
                    minimumTilesText = "";
                    if (!StringUtils.isNullOrWhitespace(minimumTilesLabel).booleanValue()) {
                        minimumTilesText = minimumTilesText + "" + structureData.getAnimalSize();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(minimumTilesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(minimumTilesText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(minimumTilesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(minimumTilesText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    densityRatioLabel = TextUtils.translate("tektopiaBook.structures.currenttiles", new Object[0]);
                    densityRatioText = "";
                    if (!StringUtils.isNullOrWhitespace(densityRatioLabel).booleanValue()) {
                        densityRatioText = densityRatioText + "" + structureData.getAnimalDensityRatio();
                        densityRatioText = structureData.isPenFull() != false ? TextFormatting.DARK_RED + densityRatioText : TextFormatting.DARK_GREEN + densityRatioText;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(densityRatioLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(densityRatioText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(densityRatioLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(densityRatioText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String penFullLabel = TextUtils.translate("tektopiaBook.structures.penfull", new Object[0]);
                    String penFullText = "";
                    if (!StringUtils.isNullOrWhitespace(penFullLabel).booleanValue()) {
                        penFullText = penFullText + "" + (structureData.isPenFull() != false ? TextFormatting.DARK_RED + "Yes" : TextFormatting.DARK_GREEN + "No");
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(penFullLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(penFullText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(penFullLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(penFullText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                } else if (structureData.getTilesPerOccupant() > 0) {
                    String tilesPerOccupantLabel = TextUtils.translate("tektopiaBook.structures.tilesperoccupant", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(tilesPerOccupantLabel).booleanValue()) {
                        tilesPerOccupantLabel = TextFormatting.DARK_BLUE + tilesPerOccupantLabel;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(tilesPerOccupantLabel, this.x + 35, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(tilesPerOccupantLabel, this.x + 268, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    minimumTilesLabel = TextUtils.translate("tektopiaBook.structures.minimumtiles", new Object[0]);
                    minimumTilesText = "";
                    if (!StringUtils.isNullOrWhitespace(minimumTilesLabel).booleanValue()) {
                        minimumTilesText = minimumTilesText + "" + structureData.getTilesPerOccupant();
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(minimumTilesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(minimumTilesText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(minimumTilesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(minimumTilesText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    densityRatioLabel = TextUtils.translate("tektopiaBook.structures.currenttiles", new Object[0]);
                    densityRatioText = "";
                    if (!StringUtils.isNullOrWhitespace(densityRatioLabel).booleanValue()) {
                        densityRatioText = densityRatioText + "" + structureData.getOccupantDensityRatio();
                        densityRatioText = structureData.isOvercrowded() != false ? TextFormatting.DARK_RED + densityRatioText : TextFormatting.DARK_GREEN + densityRatioText;
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(densityRatioLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(densityRatioText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(densityRatioLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(densityRatioText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String overcrowdedLabel = TextUtils.translate("tektopiaBook.structures.overcrowded", new Object[0]);
                    String overcrowdedText = "";
                    if (!StringUtils.isNullOrWhitespace(overcrowdedLabel).booleanValue()) {
                        overcrowdedText = overcrowdedText + "" + (structureData.isOvercrowded() != false ? TextFormatting.DARK_RED + "Yes" : TextFormatting.DARK_GREEN + "No");
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(overcrowdedLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printRight(overcrowdedText, this.x + 141 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(overcrowdedLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printRight(overcrowdedText, this.x + 374 + indentX, y, this.field_73735_i);
                        }
                    }
                } else {
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
                y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                String occupantsText = TextUtils.translate("tektopiaBook.structures.occupants", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(occupantsText).booleanValue()) {
                    occupantsText = TextFormatting.DARK_BLUE + occupantsText;
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(occupantsText, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(occupantsText, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                List<ResidentData> occupants = structureData.getOccupants();
                String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
                String professionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.profession", new Object[0]);
                String levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.level", new Object[0]);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(professionHeader, this.x + 141, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(professionHeader, this.x + 374, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = page * 15;
                int endIndex = Math.min(occupants.size(), startIndex + 15);
                List<ResidentData> subList = occupants.subList(startIndex, endIndex);
                for (ResidentData occupant : subList) {
                    String occupantName = GuiTektopiaBook.formatResidentName(occupant.isMale(), occupant.getName(), true);
                    String occupantProfession = GuiTektopiaBook.getTypeName(occupant.getProfessionType());
                    String occupantLevel = "";
                    ProfessionType pt = TektopiaUtils.getProfessionType(occupant.getProfessionType());
                    if (pt != null) {
                        switch (pt) {
                            case CHILD: 
                            case NITWIT: {
                                break;
                            }
                            default: {
                                occupantLevel = GuiTektopiaBook.formatResidentLevel(occupant.getLevel(), occupant.getBaseLevel(), false, false);
                            }
                        }
                    }
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(occupantName, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(occupantProfession, this.x + 141, y, this.field_73735_i);
                        Font.small.printRight(occupantLevel, this.x + 247, y, this.field_73735_i);
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(occupantName);
                        x3 = this.x + 141;
                        x4 = x3 + Font.small.getStringWidth(occupantProfession);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(occupantName, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(occupantProfession, this.x + 374, y, this.field_73735_i);
                        Font.small.printRight(occupantLevel, this.x + 480, y, this.field_73735_i);
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(occupantName);
                        x3 = this.x + 374;
                        x4 = x3 + Font.small.getStringWidth(occupantProfession);
                    }
                    if (!this.isSubPageOpen().booleanValue()) {
                        if (occupant.isVisitor()) {
                            button = new GuiHyperlink(BUTTON_KEY_VISITORLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.VISITOR, GuiTektopiaBook.getResidentDetailPageKey(occupant.getId())));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.visitordetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        } else {
                            button = new GuiHyperlink(BUTTON_KEY_RESIDENTLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.RESIDENT, GuiTektopiaBook.getResidentDetailPageKey(occupant.getId())));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.residentdetails", new Object[0]));
                            this.tooltips.add(toolTip);
                            button = new GuiHyperlink(BUTTON_KEY_PROFESSIONLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.PROFESSIONTYPE, GuiTektopiaBook.getProfessionDetailPageKey(occupantProfession)));
                            button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.professiondetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
            }
        }
    }

    protected void drawPageStructureType(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int x4 = 0;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        VillageStructureType structureType = VillageStructureType.valueOf((String)dataKey[0]);
        String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
        String summary = TextUtils.translate("tektopiaBook.summary", new Object[0]);
        StructuresData structuresData = this.villageData.getStructuresData();
        Map<VillageStructureType, Integer> structureTypeCounts = structuresData != null ? structuresData.getStructureTypeCounts() : null;
        List<StructureData> structures = structuresData != null ? structuresData.getStructuresByType(structureType) : null;
        String typeName = GuiTektopiaBook.getStructureTypeName(structureType);
        if (!StringUtils.isNullOrWhitespace(typeName).booleanValue()) {
            typeName = typeName + " " + summary;
            if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                typeName = typeName + " " + continued;
            }
            typeName = TextFormatting.DARK_BLUE + typeName;
            if (guiPage.isLeftPage()) {
                Font.normal.printLeft(typeName, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printLeft(typeName, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (dataKey[1].equals("0")) {
            String totalLabel = TextUtils.translate("tektopiaBook.structuretypes.total", new Object[0]);
            String totalText = "";
            if (!StringUtils.isNullOrWhitespace(totalLabel).booleanValue()) {
                if (structureTypeCounts != null && structureTypeCounts.containsKey(structureType)) {
                    totalText = totalText + "" + structureTypeCounts.get(structureType);
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(totalLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(totalText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(totalLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(totalText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String header = TextUtils.translate("tektopiaBook.structuretypes.frameposition", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
            header = TextFormatting.DARK_BLUE + header;
            if (guiPage.isLeftPage()) {
                Font.small.printLeft(header, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printLeft(header, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (structures != null) {
            int page;
            int[] maxLength = new int[]{0, 0};
            maxLength[0] = maxLength[0] + 10;
            String indexHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.index", new Object[0]);
            String positionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.position", new Object[0]);
            String floorTilesHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.structuretypes.floor", new Object[0]);
            String validTextHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.valid", new Object[0]);
            maxLength[1] = maxLength[1] + Font.small.getStringWidth(floorTilesHeader);
            if (guiPage.isLeftPage()) {
                Font.small.printRight(indexHeader, this.x + 35 + indentX, y, this.field_73735_i);
                Font.small.printLeft(positionHeader, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                Font.small.printLeft(floorTilesHeader, this.x + 141, y, this.field_73735_i);
                Font.small.printRight(validTextHeader, this.x + 247, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printRight(indexHeader, this.x + 268 + indentX, y, this.field_73735_i);
                Font.small.printLeft(positionHeader, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                Font.small.printLeft(floorTilesHeader, this.x + 374, y, this.field_73735_i);
                Font.small.printRight(validTextHeader, this.x + 480, y, this.field_73735_i);
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            try {
                page = Integer.parseInt(dataKey[1]);
            }
            catch (NumberFormatException e) {
                page = 0;
            }
            int startIndex = page * 22;
            int endIndex = Math.min(structures.size(), startIndex + 22);
            List<StructureData> subList = structures.subList(startIndex, endIndex);
            for (StructureData structure : subList) {
                String indexName = "" + (startIndex + subList.indexOf(structure) + 1);
                String framePosition = GuiTektopiaBook.formatBlockPos(structure.getFramePosition());
                if (this.villageData.getStructureId() > 0 && this.villageData.getStructureId() == structure.getStructureId()) {
                    framePosition = TextFormatting.UNDERLINE + framePosition;
                } else if (this.villageData.getFramePosition() != null && structure.getFramePosition() != null && this.villageData.getFramePosition().equals((Object)structure.getFramePosition())) {
                    framePosition = TextFormatting.UNDERLINE + framePosition;
                }
                String floorTiles = "" + (structure.getFloorTileCount() >= 0 ? Integer.valueOf(structure.getFloorTileCount()) : "0");
                String validText = "" + (structure.isValid() ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                if (guiPage.isLeftPage()) {
                    Font.small.printRight(indexName, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(framePosition, this.x + 35 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printRight(floorTiles, this.x + 141 + maxLength[1], y, this.field_73735_i);
                    Font.small.printRight(validText, this.x + 247, y, this.field_73735_i);
                    x2 = this.x + 35 + indentX;
                    x1 = x2 - Font.small.getStringWidth(indexName);
                    x3 = this.x + 35 + indentX + maxLength[0];
                    x4 = x3 + Font.small.getStringWidth(framePosition);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printRight(indexName, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(framePosition, this.x + 268 + indentX + maxLength[0], y, this.field_73735_i);
                    Font.small.printRight(floorTiles, this.x + 374 + maxLength[1], y, this.field_73735_i);
                    Font.small.printRight(validText, this.x + 480, y, this.field_73735_i);
                    x2 = this.x + 268 + indentX;
                    x1 = x2 - Font.small.getStringWidth(indexName);
                    x3 = this.x + 268 + indentX + maxLength[0];
                    x4 = x3 + Font.small.getStringWidth(framePosition);
                }
                if (!this.isSubPageOpen().booleanValue()) {
                    GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_STRUCTURELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structure.getStructureId())));
                    button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.structuredetails", new Object[0]));
                    this.tooltips.add(toolTip);
                    button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structure.getStructureId())));
                    button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                    this.buttons.add(button);
                    toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                    this.tooltips.add(toolTip);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
            }
        }
    }

    protected void drawPageSummary(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        String[] dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
        String summaryName = "";
        String summaryInformation = "";
        String dataName = "";
        ArrayList<String> dataInformation = new ArrayList<String>();
        switch (dataKey[0]) {
            case "aifilters": {
                String homesTotalResidents;
                summaryName = TextUtils.translate("bookmark.aifilters.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.aifilters.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                ResidentsData residentsData = this.villageData.getResidentsData();
                if (residentsData == null || StringUtils.isNullOrWhitespace(homesTotalResidents = TextUtils.translate("tektopiaBook.homes.totalresidents", new Object[0])).booleanValue()) break;
                dataInformation.add(homesTotalResidents + "|" + residentsData.getResidentsCount());
                break;
            }
            case "economy": {
                String professionSales;
                summaryName = TextUtils.translate("bookmark.economy.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.economy.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                EconomyData economyData = this.villageData.getEconomyData();
                if (economyData == null) break;
                String merchantSales = TextUtils.translate("tektopiaBook.economy.merchantsales", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(merchantSales).booleanValue()) {
                    dataInformation.add(merchantSales + "|" + economyData.getMerchantSales());
                }
                if (StringUtils.isNullOrWhitespace(professionSales = TextUtils.translate("tektopiaBook.economy.professionsales", new Object[0])).booleanValue()) break;
                dataInformation.add(professionSales + "|" + economyData.getProfessionSales());
                break;
            }
            case "enemies": {
                String enemiesTotal;
                summaryName = TextUtils.translate("bookmark.enemies.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.enemies.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                EnemiesData enemiesData = this.villageData.getEnemiesData();
                if (enemiesData == null || StringUtils.isNullOrWhitespace(enemiesTotal = TextUtils.translate("tektopiaBook.enemies.total", new Object[0])).booleanValue()) break;
                dataInformation.add(enemiesTotal + "|" + enemiesData.getEnemiesCount());
                break;
            }
            case "homes": {
                String homesTotalResidents;
                summaryName = TextUtils.translate("bookmark.homes.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.homes.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                HomesData homesData = this.villageData.getHomesData();
                ResidentsData residentsData = this.villageData.getResidentsData();
                if (homesData != null) {
                    String homesTotalBeds;
                    String homesTotal = TextUtils.translate("tektopiaBook.homes.totalhomes", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(homesTotal).booleanValue()) {
                        dataInformation.add(homesTotal + "|" + homesData.getHomesCount());
                    }
                    if (!StringUtils.isNullOrWhitespace(homesTotalBeds = TextUtils.translate("tektopiaBook.homes.totalbeds", new Object[0])).booleanValue()) {
                        dataInformation.add(homesTotalBeds + "|" + homesData.getTotalBeds());
                    }
                }
                if (residentsData == null || StringUtils.isNullOrWhitespace(homesTotalResidents = TextUtils.translate("tektopiaBook.homes.totalresidents", new Object[0])).booleanValue()) break;
                dataInformation.add(homesTotalResidents + "|" + residentsData.getResidentsCount());
                break;
            }
            case "professions": {
                String professionsTotal;
                summaryName = TextUtils.translate("bookmark.professions.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.professions.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                ResidentsData residentsData = this.villageData.getResidentsData();
                if (residentsData == null || StringUtils.isNullOrWhitespace(professionsTotal = TextUtils.translate("tektopiaBook.professions.total", new Object[0])).booleanValue()) break;
                dataInformation.add(professionsTotal + "|" + residentsData.getResidentsCountAll());
                break;
            }
            case "residents": {
                String residentsTotalFemales;
                String residentsTotalMales;
                String residentsTotalChildren;
                String residentsTotalAdults;
                summaryName = TextUtils.translate("bookmark.residents.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.residents.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                ResidentsData residentsData = this.villageData.getResidentsData();
                if (residentsData == null) break;
                String residentsTotal = TextUtils.translate("tektopiaBook.residents.total", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(residentsTotal).booleanValue()) {
                    dataInformation.add(residentsTotal + "|" + residentsData.getResidentsCountAll());
                }
                if (!StringUtils.isNullOrWhitespace(residentsTotalAdults = TextUtils.translate("tektopiaBook.residents.adults", new Object[0])).booleanValue()) {
                    dataInformation.add(residentsTotalAdults + "|" + residentsData.getAdultCount());
                }
                if (!StringUtils.isNullOrWhitespace(residentsTotalChildren = TextUtils.translate("tektopiaBook.residents.children", new Object[0])).booleanValue()) {
                    dataInformation.add(residentsTotalChildren + "|" + residentsData.getChildCount());
                }
                if (!StringUtils.isNullOrWhitespace(residentsTotalMales = TextUtils.translate("tektopiaBook.residents.males", new Object[0])).booleanValue()) {
                    dataInformation.add(residentsTotalMales + "|" + residentsData.getMaleCount());
                }
                if (!StringUtils.isNullOrWhitespace(residentsTotalFemales = TextUtils.translate("tektopiaBook.residents.females", new Object[0])).booleanValue()) {
                    dataInformation.add(residentsTotalFemales + "|" + residentsData.getFemaleCount());
                }
                String residentsNobedsLabel = TextUtils.translate("tektopiaBook.residents.nobed", new Object[0]);
                String residentsNobedsText = "";
                if (StringUtils.isNullOrWhitespace(residentsNobedsLabel).booleanValue()) break;
                if (residentsData.getNoBedCount() > 0) {
                    residentsNobedsText = residentsNobedsText + TextFormatting.DARK_RED;
                }
                residentsNobedsText = residentsNobedsText + residentsData.getNoBedCount();
                dataInformation.add(residentsNobedsLabel + "|" + residentsNobedsText);
                break;
            }
            case "statistics": {
                String structuresTotal;
                String statisticsTotal;
                summaryName = TextUtils.translate("bookmark.statistics.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.statistics.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                ResidentsData residentsData = this.villageData.getResidentsData();
                StructuresData structuresData = this.villageData.getStructuresData();
                if (residentsData != null && !StringUtils.isNullOrWhitespace(statisticsTotal = TextUtils.translate("tektopiaBook.residents.total", new Object[0])).booleanValue()) {
                    dataInformation.add(statisticsTotal + "|" + residentsData.getResidentsCountAll());
                }
                if (structuresData == null || StringUtils.isNullOrWhitespace(structuresTotal = TextUtils.translate("tektopiaBook.structures.total", new Object[0])).booleanValue()) break;
                dataInformation.add(structuresTotal + "|" + structuresData.getStructuresCount());
                break;
            }
            case "structures": {
                String structuresTotal;
                summaryName = TextUtils.translate("bookmark.structures.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.structures.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                StructuresData structuresData = this.villageData.getStructuresData();
                if (structuresData == null || StringUtils.isNullOrWhitespace(structuresTotal = TextUtils.translate("tektopiaBook.structures.total", new Object[0])).booleanValue()) break;
                dataInformation.add(structuresTotal + "|" + structuresData.getStructuresCount());
                break;
            }
            case "village": {
                String villageTimeLabel;
                summaryName = TextUtils.translate("bookmark.village.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.village.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                String villageDaysLabel = TextUtils.translate("tektopiaBook.village.days", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(villageDaysLabel).booleanValue()) {
                    long villageDays = this.villageData.getVillageDays();
                    dataInformation.add(villageDaysLabel + "|" + villageDays);
                }
                if (StringUtils.isNullOrWhitespace(villageTimeLabel = TextUtils.translate("tektopiaBook.village.time", new Object[0])).booleanValue()) break;
                LocalTime villageTimeValue = LocalTime.of(6, 0).plusSeconds(this.villageData.getVillageSeconds());
                dataInformation.add(villageTimeLabel + "|" + villageTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss")) + "|" + (ModConfig.debug.enableDebug ? "village ticks: " + this.villageData.getVillageTicks() : "") + "||" + villageTimeValue.format(DateTimeFormatter.ofPattern("h:mm:ss a")) + "|" + (ModConfig.debug.enableDebug ? "world ticks: " + this.villageData.getWorldTime() : ""));
                break;
            }
            case "visitors": {
                String visitorsTotal;
                summaryName = TextUtils.translate("bookmark.visitors.name", new Object[0]);
                summaryInformation = TextUtils.translate("bookmark.visitors.information", new Object[0]);
                dataName = TextUtils.translate("tektopiaBook.headers.summary", new Object[0]);
                VisitorsData visitorsData = this.villageData.getVisitorsData();
                if (visitorsData == null || StringUtils.isNullOrWhitespace(visitorsTotal = TextUtils.translate("tektopiaBook.visitors.total", new Object[0])).booleanValue()) break;
                dataInformation.add(visitorsTotal + "|" + visitorsData.getVisitorsCount());
            }
        }
        y += 50;
        if (!StringUtils.isNullOrWhitespace(summaryName).booleanValue()) {
            summaryName = TextFormatting.DARK_BLUE + summaryName;
            if (guiPage.isLeftPage()) {
                Font.normal.printCentered(summaryName, this.x + 141, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printCentered(summaryName, this.x + 374, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        y += Font.small.fontRenderer.field_78288_b + 20;
        if (!StringUtils.isNullOrWhitespace(summaryInformation).booleanValue()) {
            List<String> textLines;
            if (guiPage.isLeftPage()) {
                textLines = StringUtils.split(summaryInformation, 212, Font.small.fontRenderer);
                for (String textLine : textLines) {
                    Font.small.printCentered(textLine, this.x + 141, y, this.field_73735_i);
                    y += Font.small.fontRenderer.field_78288_b;
                }
            }
            if (guiPage.isRightPage()) {
                textLines = StringUtils.split(summaryInformation, 212, Font.small.fontRenderer);
                for (String textLine : textLines) {
                    Font.small.printCentered(textLine, this.x + 374, y, this.field_73735_i);
                    y += Font.small.fontRenderer.field_78288_b;
                }
            }
        }
        y = this.y + 32 + 151;
        if (!StringUtils.isNullOrWhitespace(dataName).booleanValue()) {
            dataName = TextFormatting.DARK_BLUE + dataName;
            if (guiPage.isLeftPage()) {
                Font.small.printCentered(dataName, this.x + 141, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.small.printCentered(dataName, this.x + 374, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (dataInformation.size() > 0) {
            int x1 = 0;
            int x2 = 0;
            for (String dataLine : dataInformation) {
                GuiTooltip tooltip;
                if (StringUtils.isNullOrWhitespace(dataLine).booleanValue()) continue;
                String[] parts = dataLine.split("[|]");
                if (guiPage.isLeftPage()) {
                    if (parts.length > 0 && !StringUtils.isNullOrWhitespace(parts[0]).booleanValue()) {
                        Font.small.printLeft(parts[0], this.x + 35 + indentX, y, this.field_73735_i);
                    }
                    if (parts.length > 1 && !StringUtils.isNullOrWhitespace(parts[1]).booleanValue()) {
                        Font.small.printRight(parts[1], this.x + 141 + indentX, y, this.field_73735_i);
                    }
                    if (parts.length > 2 && !StringUtils.isNullOrWhitespace(parts[2]).booleanValue()) {
                        Font.small.printRight(parts[2], this.x + 247, y, this.field_73735_i);
                    }
                    if (parts.length > 3 && !StringUtils.isNullOrWhitespace(parts[3]).booleanValue()) {
                        x1 = this.x + 35 + indentX;
                        x2 = x1 + Font.small.getStringWidth(StringUtils.isNullOrWhitespace(parts[0]) != false ? parts[3] : parts[0]);
                        tooltip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, parts[3]);
                        this.tooltips.add(tooltip);
                    }
                    if (parts.length > 4 && !StringUtils.isNullOrWhitespace(parts[4]).booleanValue()) {
                        x2 = this.x + 141 + indentX;
                        x1 = x2 - Font.small.getStringWidth(StringUtils.isNullOrWhitespace(parts[1]) != false ? parts[4] : parts[1]);
                        tooltip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, parts[4]);
                        this.tooltips.add(tooltip);
                    }
                    if (parts.length > 5 && !StringUtils.isNullOrWhitespace(parts[5]).booleanValue()) {
                        x2 = this.x + 247;
                        x1 = x2 - Font.small.getStringWidth(StringUtils.isNullOrWhitespace(parts[2]) != false ? parts[5] : parts[2]);
                        tooltip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, parts[5]);
                        this.tooltips.add(tooltip);
                    }
                }
                if (guiPage.isRightPage()) {
                    if (parts.length > 0 && !StringUtils.isNullOrWhitespace(parts[0]).booleanValue()) {
                        Font.small.printLeft(parts[0], this.x + 268 + indentX, y, this.field_73735_i);
                    }
                    if (parts.length > 1 && !StringUtils.isNullOrWhitespace(parts[1]).booleanValue()) {
                        Font.small.printRight(parts[1], this.x + 374 + indentX, y, this.field_73735_i);
                    }
                    if (parts.length > 2 && !StringUtils.isNullOrWhitespace(parts[2]).booleanValue()) {
                        Font.small.printRight(parts[2], this.x + 480, y, this.field_73735_i);
                    }
                    if (parts.length > 3 && !StringUtils.isNullOrWhitespace(parts[3]).booleanValue()) {
                        x1 = this.x + 268 + indentX;
                        x2 = x1 + Font.small.getStringWidth(StringUtils.isNullOrWhitespace(parts[0]) != false ? parts[3] : parts[0]);
                        tooltip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, parts[3]);
                        this.tooltips.add(tooltip);
                    }
                    if (parts.length > 4 && !StringUtils.isNullOrWhitespace(parts[4]).booleanValue()) {
                        x2 = this.x + 374 + indentX;
                        x1 = x2 - Font.small.getStringWidth(StringUtils.isNullOrWhitespace(parts[1]) != false ? parts[4] : parts[1]);
                        tooltip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, parts[4]);
                        this.tooltips.add(tooltip);
                    }
                    if (parts.length > 5 && !StringUtils.isNullOrWhitespace(parts[5]).booleanValue()) {
                        x2 = this.x + 480;
                        x1 = x2 - Font.small.getStringWidth(StringUtils.isNullOrWhitespace(parts[2]) != false ? parts[5] : parts[2]);
                        tooltip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, parts[5]);
                        this.tooltips.add(tooltip);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
            }
        }
    }

    protected void drawPageVillage(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
        this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
        int y = this.y + 32;
        int indentX = 10;
        String header = TextUtils.translate("tektopiaBook.village.header", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
            header = TextFormatting.DARK_BLUE + header;
            if (guiPage.isLeftPage()) {
                Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (this.villageData != null) {
            String originLabel = TextUtils.translate("tektopiaBook.village.origin", new Object[0]);
            String originText = "";
            if (!StringUtils.isNullOrWhitespace(originLabel).booleanValue()) {
                originText = originText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageOrigin());
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(originLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(originText, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(originLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(originText, this.x + 374, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2 + 2;
            String boundaries = TextUtils.translate("tektopiaBook.village.boundaries", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(boundaries).booleanValue()) {
                boundaries = TextFormatting.DARK_BLUE + boundaries;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(boundaries, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(boundaries, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarynorthwest", new Object[0]);
            String boundaryText = "";
            if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
                boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageNorthWestCorner());
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 374, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarynortheast", new Object[0]);
            boundaryText = "";
            if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
                boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageNorthEastCorner());
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 374, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarysouthwest", new Object[0]);
            boundaryText = "";
            if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
                boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageSouthWestCorner());
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 374, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            boundaryLabel = TextUtils.translate("tektopiaBook.village.boundarysoutheast", new Object[0]);
            boundaryText = "";
            if (!StringUtils.isNullOrWhitespace(boundaryLabel).booleanValue()) {
                boundaryText = boundaryText + GuiTektopiaBook.formatBlockPos(this.villageData.getVillageSouthEastCorner());
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(boundaryLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(boundaryText, this.x + 374, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2 + 2;
            String totals = TextUtils.translate("tektopiaBook.village.totals", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(totals).booleanValue()) {
                totals = TextFormatting.DARK_BLUE + totals;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(totals, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(totals, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String structuresLabel = TextUtils.translate("tektopiaBook.village.structures", new Object[0]);
            String structuresText = "";
            if (!StringUtils.isNullOrWhitespace(structuresLabel).booleanValue()) {
                if (this.villageData.getStructuresData() != null) {
                    structuresText = structuresText + "" + this.villageData.getStructuresData().getStructuresCount();
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(structuresLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(structuresText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(structuresLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(structuresText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String residentsLabel = TextUtils.translate("tektopiaBook.village.residents", new Object[0]);
            String residentsText = "";
            if (!StringUtils.isNullOrWhitespace(residentsLabel).booleanValue()) {
                if (this.villageData.getResidentsData() != null) {
                    residentsText = residentsText + "" + this.villageData.getResidentsData().getResidentsCountAll();
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(residentsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(residentsText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(residentsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(residentsText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String visitorsLabel = TextUtils.translate("tektopiaBook.village.visitors", new Object[0]);
            String visitorsText = "";
            if (!StringUtils.isNullOrWhitespace(visitorsLabel).booleanValue()) {
                if (this.villageData.getResidentsData() != null) {
                    visitorsText = visitorsText + "" + this.villageData.getVisitorsData().getVisitorsCount();
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(visitorsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(visitorsText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(visitorsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(visitorsText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String enemiesLabel = TextUtils.translate("tektopiaBook.village.enemies", new Object[0]);
            String enemiesText = "";
            if (!StringUtils.isNullOrWhitespace(enemiesLabel).booleanValue()) {
                if (this.villageData.getResidentsData() != null) {
                    enemiesText = enemiesText + "" + this.villageData.getEnemiesData().getEnemiesCount();
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(enemiesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(enemiesText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(enemiesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(enemiesText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2 + 2;
            String statistics = TextUtils.translate("tektopiaBook.village.statistics", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(statistics).booleanValue()) {
                statistics = TextFormatting.DARK_BLUE + statistics;
                if (guiPage.isLeftPage()) {
                    Font.normal.printLeft(statistics, this.x + 35, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.normal.printLeft(statistics, this.x + 268, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String nobedsLabel = TextUtils.translate("tektopiaBook.village.nobed", new Object[0]);
            String nobedsText = "";
            if (!StringUtils.isNullOrWhitespace(nobedsLabel).booleanValue()) {
                if (this.villageData.getResidentsData() != null) {
                    int nobedsCount = this.villageData.getResidentsData().getNoBedCount();
                    if (nobedsCount > 0) {
                        nobedsText = nobedsText + TextFormatting.DARK_RED;
                    }
                    nobedsText = nobedsText + "" + nobedsCount;
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nobedsLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(nobedsText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nobedsLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(nobedsText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String professionSalesLabel = TextUtils.translate("tektopiaBook.village.professionsales", new Object[0]);
            String professionSalesText = "";
            if (!StringUtils.isNullOrWhitespace(professionSalesLabel).booleanValue()) {
                if (this.villageData.getEconomyData() != null) {
                    professionSalesText = professionSalesText + "" + this.villageData.getEconomyData().getProfessionSales();
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(professionSalesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(professionSalesText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(professionSalesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(professionSalesText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
            String merchantSalesLabel = TextUtils.translate("tektopiaBook.village.merchantsales", new Object[0]);
            String merchantSalesText = "";
            if (!StringUtils.isNullOrWhitespace(merchantSalesLabel).booleanValue()) {
                if (this.villageData.getEconomyData() != null) {
                    merchantSalesText = merchantSalesText + "" + this.villageData.getEconomyData().getMerchantSales();
                }
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(merchantSalesLabel, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(merchantSalesText, this.x + 141 + indentX, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(merchantSalesLabel, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(merchantSalesText, this.x + 374 + indentX, y, this.field_73735_i);
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
        }
    }

    protected void drawPageVisitor(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        block92: {
            VisitorData visitor;
            String[] dataKey;
            int indentX;
            int y;
            block93: {
                int page;
                int visitorId;
                StructuresData structuresData;
                VisitorsData visitorsData;
                int x4;
                int x3;
                int x2;
                int x1;
                block91: {
                    int page2;
                    this.drawPageHeader(mouseX, mouseY, partialTicks, guiPage);
                    this.drawPageFooter(mouseX, mouseY, partialTicks, guiPage);
                    y = this.y + 32;
                    indentX = 10;
                    x1 = 0;
                    x2 = 0;
                    x3 = 0;
                    x4 = 0;
                    dataKey = GuiTektopiaBook.getPageKeyParts(guiPage.getDataKey());
                    visitorsData = this.villageData.getVisitorsData();
                    structuresData = this.villageData.getStructuresData();
                    if (!dataKey[0].equals("")) break block91;
                    String pageHeader = TextUtils.translate("tektopiaBook.visitors.visitors", new Object[0]);
                    if (!StringUtils.isNullOrWhitespace(pageHeader).booleanValue()) {
                        pageHeader = TextFormatting.DARK_BLUE + pageHeader;
                        if (guiPage.isLeftPage()) {
                            Font.normal.printLeft(pageHeader, this.x + 35, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.normal.printLeft(pageHeader, this.x + 268, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    List<VisitorData> visitors = visitorsData.getVisitors();
                    if (visitors == null) break block92;
                    String visitorHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.visitor", new Object[0]);
                    String typeHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.type", new Object[0]);
                    String positionHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.position", new Object[0]);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(visitorHeader, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(typeHeader, this.x + 141, y, this.field_73735_i);
                        Font.small.printRight(positionHeader, this.x + 247, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(visitorHeader, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printLeft(typeHeader, this.x + 374, y, this.field_73735_i);
                        Font.small.printRight(positionHeader, this.x + 480, y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    try {
                        page2 = Integer.parseInt(dataKey[1]);
                    }
                    catch (NumberFormatException e) {
                        page2 = 0;
                    }
                    int startIndex = page2 * 24;
                    int endIndex = Math.min(visitors.size(), startIndex + 24);
                    List<VisitorData> subList = visitors.subList(startIndex, endIndex);
                    for (VisitorData visitor2 : subList) {
                        String visitorName = GuiTektopiaBook.formatResidentName(visitor2.isMale(), visitor2.getName(), true);
                        String visitorType = GuiTektopiaBook.getTypeName(visitor2.getProfessionType());
                        String visitorPosition = GuiTektopiaBook.formatBlockPos(visitor2.getCurrentPosition());
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(visitorName, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(visitorType, this.x + 141, y, this.field_73735_i);
                            Font.small.printRight(visitorPosition, this.x + 247, y, this.field_73735_i);
                            x1 = this.x + 35 + indentX;
                            x2 = x1 + Font.small.getStringWidth(visitorName);
                            x4 = this.x + 247;
                            x3 = x4 - Font.small.getStringWidth(visitorPosition);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(visitorName, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(visitorType, this.x + 374, y, this.field_73735_i);
                            Font.small.printRight(visitorPosition, this.x + 480, y, this.field_73735_i);
                            x1 = this.x + 268 + indentX;
                            x2 = x1 + Font.small.getStringWidth(visitorName);
                            x4 = this.x + 480;
                            x3 = x4 - Font.small.getStringWidth(visitorPosition);
                        }
                        if (!this.isSubPageOpen().booleanValue()) {
                            GuiHyperlink button = new GuiHyperlink(BUTTON_KEY_VISITORLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.VISITOR, GuiTektopiaBook.getResidentDetailPageKey(visitor2.getId())));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            ArrayList<String> visitorNameTooltip = new ArrayList<String>();
                            visitorNameTooltip.add(TextUtils.translate("tektopiaBook.links.visitordetails", new Object[0]));
                            if (ModConfig.debug.enableDebug) {
                                visitorNameTooltip.add("(" + TextUtils.translate("tektopiaBook.id", new Object[0]) + visitor2.getId() + ")");
                            }
                            GuiTooltip toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, visitorNameTooltip);
                            this.tooltips.add(toolTip);
                            button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.VISITOR, GuiTektopiaBook.getResidentDetailPageKey(visitor2.getId())));
                            button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                        y += Font.small.fontRenderer.field_78288_b + 2;
                    }
                    break block92;
                }
                try {
                    visitorId = Integer.parseInt(dataKey[0]);
                }
                catch (NumberFormatException e) {
                    visitorId = 0;
                }
                VisitorData visitorData = visitor = visitorId > 0 ? visitorsData.getVisitorById(visitorId) : null;
                if (visitor == null) break block92;
                String header = GuiTektopiaBook.stripTextFormatting(visitor.getName());
                if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
                    if (this.villageData.getEntityId() > 0 && this.villageData.getEntityId() == visitorId) {
                        header = TextFormatting.UNDERLINE + header;
                    }
                    header = visitor.isMale() ? TextFormatting.BLUE + header + " " + TextUtils.SYMBOL_MALE : TextFormatting.LIGHT_PURPLE + header + " " + TextUtils.SYMBOL_FEMALE;
                    if (ModConfig.debug.enableDebug) {
                        header = header + TextFormatting.RESET + " (" + TextUtils.translate("tektopiaBook.id", new Object[0]) + visitor.getId() + ")";
                    }
                    if (guiPage.isLeftPage()) {
                        Font.normal.printLeft(header, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printLeft(header, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                if (dataKey[1].equals("0")) {
                    GuiTooltip toolTip;
                    GuiHyperlink button;
                    int tXL = this.x + 191;
                    int tXR = this.x + 424;
                    int tY = y;
                    String modId = visitor.getModId();
                    if (modId.equals("tektopia")) {
                        modId = "tektopiainformation";
                    }
                    String className = visitor.getClassName();
                    String gender = visitor.isMale() ? "m" : "f";
                    ResourceLocation visitorResource = new ResourceLocation(modId, "textures/visitors/" + className + "_" + gender + ".png");
                    if (guiPage.isLeftPage()) {
                        RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(visitorResource, this.field_73735_i, tXL, tY, 0.0f, 0.0f, 56, 90, 56.0f, 90.0f);
                    }
                    if (guiPage.isRightPage()) {
                        RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(visitorResource, this.field_73735_i, tXR, tY, 0.0f, 0.0f, 56, 90, 56.0f, 90.0f);
                    }
                    String typeLabel = TextUtils.translate("tektopiaBook.visitors.visitortype", new Object[0]);
                    String typeText = "";
                    if (!StringUtils.isNullOrWhitespace(typeLabel).booleanValue()) {
                        typeText = typeText + GuiTektopiaBook.getTypeName(visitor.getProfessionType());
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(typeLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(typeText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(typeLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(typeText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String healthLabel = TextUtils.translate("tektopiaBook.residents.health", new Object[0]);
                    String healthText = "";
                    if (!StringUtils.isNullOrWhitespace(healthLabel).booleanValue()) {
                        healthText = healthText + GuiTektopiaBook.formatResidentStatistic(visitor.getHealth(), visitor.getMaxHealth(), true);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(healthLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(healthText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(healthLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(healthText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String hungerLabel = TextUtils.translate("tektopiaBook.residents.hunger", new Object[0]);
                    String hungerText = "";
                    if (!StringUtils.isNullOrWhitespace(hungerLabel).booleanValue()) {
                        hungerText = hungerText + GuiTektopiaBook.formatResidentStatistic(visitor.getHunger(), visitor.getMaxHunger(), true);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(hungerLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(hungerText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(hungerLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(hungerText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String happinessLabel = TextUtils.translate("tektopiaBook.residents.happiness", new Object[0]);
                    String happinessText = "";
                    if (!StringUtils.isNullOrWhitespace(happinessLabel).booleanValue()) {
                        happinessText = happinessText + GuiTektopiaBook.formatResidentStatistic(visitor.getHappy(), visitor.getMaxHappy(), true);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(happinessLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(happinessText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(happinessLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(happinessText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String intelligenceLabel = TextUtils.translate("tektopiaBook.residents.intelligence", new Object[0]);
                    String intelligenceText = "";
                    if (!StringUtils.isNullOrWhitespace(intelligenceLabel).booleanValue()) {
                        intelligenceText = intelligenceText + GuiTektopiaBook.formatResidentStatistic(visitor.getIntelligence(), visitor.getMaxIntelligence(), true);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(intelligenceLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(intelligenceText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(intelligenceLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(intelligenceText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String workTimeLabel = TextUtils.translate("tektopiaBook.residents.worktime", new Object[0]);
                    String workTimeText = "";
                    if (!StringUtils.isNullOrWhitespace(workTimeLabel).booleanValue()) {
                        LocalTime startTimeValue = LocalTime.of(6, 0).plusSeconds(visitor.getWorkStartSeconds());
                        LocalTime finishTimeValue = LocalTime.of(6, 0).plusSeconds(visitor.getWorkFinishSeconds());
                        workTimeText = workTimeText + startTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss")) + " - " + finishTimeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                        if (TektopiaUtils.isTimeOfDay(this.villageData.getVillageTicks(), visitor.getWorkStartTicks(), visitor.getWorkFinishTicks())) {
                            workTimeText = TextFormatting.DARK_AQUA + workTimeText;
                        }
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(workTimeLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(workTimeText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(workTimeLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(workTimeText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String taskLabel = TextUtils.translate("tektopiaBook.residents.task", new Object[0]);
                    String taskText = "";
                    if (!StringUtils.isNullOrWhitespace(taskLabel).booleanValue()) {
                        taskText = taskText + GuiTektopiaBook.getAiTaskName(visitor.getCurrentTask());
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(taskLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(taskText, this.x + 88 + indentX, y, this.field_73735_i);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(taskLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(taskText, this.x + 321 + indentX, y, this.field_73735_i);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String currentPositionLabel = TextUtils.translate("tektopiaBook.residents.position", new Object[0]);
                    String currentPositionText = "";
                    if (!StringUtils.isNullOrWhitespace(currentPositionLabel).booleanValue()) {
                        currentPositionText = currentPositionText + " " + GuiTektopiaBook.formatBlockPos(visitor.getCurrentPosition());
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(currentPositionLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(currentPositionText, this.x + 141 - indentX, y, this.field_73735_i);
                            x1 = this.x + 141 - indentX;
                            x2 = x1 + Font.small.getStringWidth(currentPositionText);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(currentPositionLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(currentPositionText, this.x + 374 - indentX, y, this.field_73735_i);
                            x1 = this.x + 374 - indentX;
                            x2 = x1 + Font.small.getStringWidth(currentPositionText);
                        }
                        if (!this.isSubPageOpen().booleanValue()) {
                            button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.VISITOR, GuiTektopiaBook.getResidentDetailPageKey(visitor.getId())));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                    String currentStructureLabel = TextUtils.translate("tektopiaBook.residents.structure", new Object[0]);
                    String currentStructureText = "";
                    String currentStructurePosition = "";
                    if (!StringUtils.isNullOrWhitespace(currentStructureLabel).booleanValue()) {
                        StructureData structureData;
                        int structureId = 0;
                        int textLength = 0;
                        if (structuresData != null && visitor.getCurrentStructure() != null && (structureData = structuresData.getStructureByFramePosition(visitor.getCurrentStructure())) != null) {
                            currentStructureText = currentStructureText + " " + structureData.getStructureTypeName();
                            currentStructurePosition = currentStructurePosition + " (" + GuiTektopiaBook.formatBlockPos(visitor.getCurrentStructure()) + ")";
                            structureId = structureData.getStructureId();
                        }
                        textLength = Font.small.getStringWidth(currentStructureText);
                        if (guiPage.isLeftPage()) {
                            Font.small.printLeft(currentStructureLabel, this.x + 35 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(currentStructureText, this.x + 141 - indentX, y, this.field_73735_i);
                            Font.small.printLeft(currentStructurePosition, this.x + 141 - indentX + textLength, y, this.field_73735_i);
                            x1 = this.x + 141 - indentX;
                            x2 = x1 + Font.small.getStringWidth(currentStructureText);
                            x3 = this.x + 141 - indentX + textLength;
                            x4 = x3 + Font.small.getStringWidth(currentStructurePosition);
                        }
                        if (guiPage.isRightPage()) {
                            Font.small.printLeft(currentStructureLabel, this.x + 268 + indentX, y, this.field_73735_i);
                            Font.small.printLeft(currentStructureText, this.x + 374 - indentX, y, this.field_73735_i);
                            Font.small.printLeft(currentStructurePosition, this.x + 374 - indentX + textLength, y, this.field_73735_i);
                            x1 = this.x + 374 - indentX;
                            x2 = x1 + Font.small.getStringWidth(currentStructureText);
                            x3 = this.x + 374 - indentX + textLength;
                            x4 = x3 + Font.small.getStringWidth(currentStructurePosition);
                        }
                        if (!this.isSubPageOpen().booleanValue() && structureId > 0) {
                            button = new GuiHyperlink(BUTTON_KEY_STRUCTURELINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structureId)));
                            button.setIcon(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x1, y, x2 - x1, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.structuredetails", new Object[0]));
                            this.tooltips.add(toolTip);
                            button = new GuiHyperlink(BUTTON_KEY_MAPLINK, GuiTektopiaBook.getHyperlinkData(GuiPageType.STRUCTURE, GuiTektopiaBook.getStructureDetailPageKey(structureId)));
                            button.setIcon(x3, y, x4 - x3, Font.small.fontRenderer.field_78288_b);
                            this.buttons.add(button);
                            toolTip = new GuiTooltip(x2, y, x4 - x3, Font.small.fontRenderer.field_78288_b, TextUtils.translate("tektopiaBook.links.mapdetails", new Object[0]));
                            this.tooltips.add(toolTip);
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2 + 2;
                }
                if (!visitor.isVendor()) break block93;
                String vendoritems = TextUtils.translate("tektopiaBook.visitors.vendoritems", new Object[0]);
                String continued = TextUtils.translate("tektopiaBook.continued", new Object[0]);
                if (!dataKey[1].equals("0") && !StringUtils.isNullOrWhitespace(continued).booleanValue()) {
                    vendoritems = vendoritems + " " + continued;
                }
                if (!StringUtils.isNullOrWhitespace(vendoritems).booleanValue()) {
                    vendoritems = TextFormatting.DARK_BLUE + vendoritems;
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(vendoritems, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(vendoritems, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String sellHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.sell", new Object[0]);
                String buyHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.buy", new Object[0]);
                String timesHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.times", new Object[0]);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(sellHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(buyHeader, this.x + 141, y, this.field_73735_i);
                    Font.small.printRight(timesHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(sellHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printLeft(buyHeader, this.x + 374, y, this.field_73735_i);
                    Font.small.printRight(timesHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 6;
                MerchantRecipeList recipeList = visitor.getRecipeList();
                if (recipeList == null || recipeList.size() <= 0) break block92;
                try {
                    page = Integer.parseInt(dataKey[1]);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
                int startIndex = 0;
                int endIndex = Math.min(recipeList.size(), startIndex + 8);
                if (page > 0) {
                    startIndex = 8 + (page - 1) * 15;
                    endIndex = Math.min(recipeList.size(), startIndex + 15);
                }
                y += 2;
                List recipes = recipeList.subList(startIndex, endIndex);
                for (MerchantRecipe recipe : recipes) {
                    ItemStack buyItem1Stack = recipe.func_77394_a();
                    ItemStack buyItem2Stack = recipe.func_77396_b();
                    ItemStack sellItemStack = recipe.func_77397_d();
                    String buyTimes = recipe.func_180321_e() + "/" + recipe.func_180320_f();
                    if (recipe.func_180321_e() >= recipe.func_180320_f()) {
                        buyTimes = TextFormatting.RED + buyTimes;
                    }
                    List buyItem1Tooltip = buyItem1Stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (buyItem1Stack.func_77948_v() && buyItem1Tooltip.size() > 0) {
                        buyItem1Tooltip.set(0, TextFormatting.AQUA + (String)buyItem1Tooltip.get(0));
                    }
                    List buyItem2Tooltip = buyItem2Stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (buyItem2Stack.func_77948_v() && buyItem2Tooltip.size() > 0) {
                        buyItem2Tooltip.set(0, TextFormatting.AQUA + (String)buyItem2Tooltip.get(0));
                    }
                    List sellTooltip = sellItemStack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (sellItemStack.func_77948_v() && sellTooltip.size() > 0) {
                        sellTooltip.set(0, TextFormatting.AQUA + (String)sellTooltip.get(0));
                    }
                    if (guiPage.isLeftPage()) {
                        Font.normal.printRight(buyTimes, this.x + 247, y, this.field_73735_i);
                        if (!buyItem1Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem1Stack, this.x + 35 + indentX, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem1Stack, this.x + 35 + indentX, y - 5, null);
                            if (buyItem1Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 35 + indentX, y - 5, 16, 16, buyItem1Tooltip));
                            }
                        }
                        if (!buyItem2Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem2Stack, this.x + 35 + indentX + 20, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem2Stack, this.x + 35 + indentX + 20, y - 5, null);
                            if (buyItem2Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 35 + indentX + 20, y - 5, 16, 16, buyItem2Tooltip));
                            }
                        }
                        if (!sellItemStack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, sellItemStack, this.x + 141, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, sellItemStack, this.x + 141, y - 5, null);
                            if (sellTooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 141, y - 5, 16, 16, sellTooltip));
                            }
                        }
                    }
                    if (guiPage.isRightPage()) {
                        Font.normal.printRight(buyTimes, this.x + 480, y, this.field_73735_i);
                        if (!buyItem1Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem1Stack, this.x + 268 + indentX, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem1Stack, this.x + 268 + indentX, y - 5, null);
                            if (buyItem1Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 268 + indentX, y - 5, 16, 16, buyItem1Tooltip));
                            }
                        }
                        if (!buyItem2Stack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, buyItem2Stack, this.x + 268 + indentX + 20, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, buyItem2Stack, this.x + 268 + indentX + 20, y - 5, null);
                            if (buyItem2Tooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 268 + indentX + 20, y - 5, 16, 16, buyItem2Tooltip));
                            }
                        }
                        if (!sellItemStack.func_190926_b()) {
                            RenderUtils.renderItemIntoGUI(this.field_146296_j, sellItemStack, this.x + 374, y - 5);
                            RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, sellItemStack, this.x + 374, y - 5, null);
                            if (sellTooltip.size() > 0) {
                                this.tooltips.add(new GuiTooltip(this.x + 374, y - 5, 16, 16, sellTooltip));
                            }
                        }
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2 + 6;
                }
                break block92;
            }
            if (dataKey[1].equals("0")) {
                String additionalProfessionsHeader = TextUtils.translate("tektopiaBook.visitors.professions", new Object[0]);
                if (!StringUtils.isNullOrWhitespace(additionalProfessionsHeader).booleanValue()) {
                    additionalProfessionsHeader = TextFormatting.DARK_BLUE + additionalProfessionsHeader;
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(additionalProfessionsHeader, this.x + 35, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(additionalProfessionsHeader, this.x + 268, y, this.field_73735_i);
                    }
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
                String levelHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.level", new Object[0]);
                if (guiPage.isLeftPage()) {
                    Font.small.printLeft(nameHeader, this.x + 35 + indentX, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 247, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printLeft(nameHeader, this.x + 268 + indentX, y, this.field_73735_i);
                    Font.small.printRight(levelHeader, this.x + 480, y, this.field_73735_i);
                }
                y += Font.small.fontRenderer.field_78288_b + 2;
                Map<String, Integer> additionalProfessions = visitor.getAdditionalProfessions();
                int startIndex = 0;
                int endIndex = Math.min(additionalProfessions.size(), startIndex + 4);
                List subList = additionalProfessions.entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
                for (Map.Entry additionalProfessionType : subList) {
                    String additionalProfessionText = GuiTektopiaBook.getTypeName((String)additionalProfessionType.getKey());
                    String additionalProfessionLevel = GuiTektopiaBook.formatResidentLevel((Integer)additionalProfessionType.getValue(), (Integer)additionalProfessionType.getValue(), false, false);
                    if (guiPage.isLeftPage()) {
                        Font.small.printLeft(additionalProfessionText, this.x + 35 + indentX, y, this.field_73735_i);
                        Font.small.printRight(additionalProfessionLevel, this.x + 247, y, this.field_73735_i);
                    }
                    if (guiPage.isRightPage()) {
                        Font.small.printLeft(additionalProfessionText, this.x + 268 + indentX, y, this.field_73735_i);
                        Font.small.printRight(additionalProfessionLevel, this.x + 480, y, this.field_73735_i);
                    }
                    y += Font.small.fontRenderer.field_78288_b + 2;
                }
            }
        }
    }

    protected void drawPageTitle(int mouseX, int mouseY, float partialTicks, GuiPage guiPage) {
        int y = this.y + 32;
        String bookName = TextUtils.translate("tektopiaBook.name", new Object[0]);
        String bookInformation = TextUtils.translate("tektopiaBook.information", new Object[0]);
        y += 50;
        if (!StringUtils.isNullOrWhitespace(bookName).booleanValue()) {
            bookName = TextFormatting.DARK_RED + bookName;
            if (guiPage.isLeftPage()) {
                Font.normal.printCentered(bookName, this.x + 141, y, this.field_73735_i);
            }
            if (guiPage.isRightPage()) {
                Font.normal.printCentered(bookName, this.x + 374, y, this.field_73735_i);
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        if (this.villageData != null) {
            String villageName = this.villageData.getVillageName();
            String villageText = TextUtils.translate("tektopiaBook.village.name", new Object[0]);
            if (!StringUtils.isNullOrWhitespace(villageName).booleanValue()) {
                if (!StringUtils.isNullOrWhitespace(villageText).booleanValue()) {
                    villageText = villageText + " ";
                }
                villageText = TextFormatting.GOLD + "-----< " + villageText + villageName + " >-----";
                if (guiPage.isLeftPage()) {
                    Font.small.printCentered(villageText, this.x + 141, y, this.field_73735_i);
                }
                if (guiPage.isRightPage()) {
                    Font.small.printCentered(villageText, this.x + 374, y, this.field_73735_i);
                }
            }
        }
        y += Font.small.fontRenderer.field_78288_b + 20;
        if (!StringUtils.isNullOrWhitespace(bookInformation).booleanValue()) {
            List<String> textLines;
            if (guiPage.isLeftPage()) {
                textLines = StringUtils.split(bookInformation, 212, Font.small.fontRenderer);
                for (String textLine : textLines) {
                    Font.small.printCentered(textLine, this.x + 141, y, this.field_73735_i);
                    y += Font.small.fontRenderer.field_78288_b;
                }
            }
            if (guiPage.isRightPage()) {
                textLines = StringUtils.split(bookInformation, 212, Font.small.fontRenderer);
                for (String textLine : textLines) {
                    Font.small.printCentered(textLine, this.x + 374, y, this.field_73735_i);
                    y += Font.small.fontRenderer.field_78288_b;
                }
            }
            y += Font.small.fontRenderer.field_78288_b + 2;
        }
    }

    protected void drawSubPages(int mouseX, int mouseY, float partialTicks) {
        if (!this.isSubPageOpen().booleanValue()) {
            return;
        }
        float oldZLevel = this.setZLevel(20.0f);
        String[] subKeyParts = GuiTektopiaBook.getSubPageKeyParts(this.subPageKey);
        switch (subKeyParts[0]) {
            case "aifilter": {
                this.drawSubPageAiFilters(mouseX, mouseY, partialTicks);
                break;
            }
            case "inventory": {
                this.drawSubPageInventory(mouseX, mouseY, partialTicks);
            }
        }
        this.setZLevel(oldZLevel);
    }

    protected void drawSubPageLandscapeBackground(int mouseX, int mouseY, float partialTicks) {
        RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(page_landscape, this.field_73735_i, this.xPageLandscape, this.yPageLandscape, 0.0f, 0.0f, 480, 384, 480.0f, 384.0f);
    }

    protected void drawSubPageLandscapeHeader(int mouseX, int mouseY, float partialTicks) {
        GuiButton closeButton = new GuiButton(BUTTON_KEY_CLOSE);
        closeButton.setIcon(buttonClose, this.field_73735_i, this.xPageLandscape + 440 - 13, this.yPageLandscape + 55 - 4, 24, 24, 0, 0, 24, 24);
        this.buttons.add(closeButton);
        GuiTooltip closeToolTip = new GuiTooltip(this.xPageLandscape + 440 - 13, this.yPageLandscape + 55 - 4, 24, 24, TextUtils.translate("button.close.name", new Object[0]));
        this.tooltips.add(closeToolTip);
    }

    protected void drawSubPageLandscapeFooter(int mouseX, int mouseY, float partialTicks) {
        Font.small.printCentered(this.subPageIndex, this.xPageLandscape + 240, this.yPageLandscape + 320 - 2, this.field_73735_i);
    }

    protected void drawSubPageLandscapePageArrows(int mouseX, int mouseY, float partialTicks) {
        if (this.subPageCount > 1 && this.subPageIndex > 1) {
            GuiButton previousButton = new GuiButton(BUTTON_KEY_PREVIOUSSUBPAGE);
            previousButton.setIcon(buttonPreviousPage, this.field_73735_i, this.xPageLandscape + 40, this.yPageLandscape + 320 - 6, 16, 16, 0, 0, 16, 16);
            this.buttons.add(previousButton);
            String previousTooltipText = previousButton.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(previousTooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(this.xPageLandscape + 40, this.yPageLandscape + 320 - 6, 16, 16, previousTooltipText));
            }
        }
        if (this.subPageCount > 1 && this.subPageIndex < this.subPageCount) {
            GuiButton nextButton = new GuiButton(BUTTON_KEY_NEXTSUBPAGE);
            nextButton.setIcon(buttonNextPage, this.field_73735_i, this.xPageLandscape + 440 - 16, this.yPageLandscape + 320 - 6, 16, 16, 0, 0, 16, 16);
            this.buttons.add(nextButton);
            String nextTooltipText = nextButton.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(nextTooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(this.xPageLandscape + 440 - 16, this.yPageLandscape + 320 - 6, 16, 16, nextTooltipText));
            }
        }
    }

    protected void drawSubPagePortraitBackground(int mouseX, int mouseY, float partialTicks) {
        RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(page_portrait, this.field_73735_i, this.xPagePortrait, this.yPagePortrait, 0.0f, 0.0f, 384, 384, 384.0f, 384.0f);
    }

    protected void drawSubPagePortraitHeader(int mouseX, int mouseY, float partialTicks) {
        GuiButton closeButton = new GuiButton(BUTTON_KEY_CLOSE);
        closeButton.setIcon(buttonClose, this.field_73735_i, this.xPagePortrait + 315 - 8, this.yPagePortrait + 25 - 4, 24, 24, 0, 0, 24, 24);
        this.buttons.add(closeButton);
        GuiTooltip closeToolTip = new GuiTooltip(this.xPagePortrait + 315 - 8, this.yPagePortrait + 25 - 4, 24, 24, TextUtils.translate("button.close.name", new Object[0]));
        this.tooltips.add(closeToolTip);
    }

    protected void drawSubPagePortraitFooter(int mouseX, int mouseY, float partialTicks) {
        Font.small.printCentered(this.subPageIndex, this.xPagePortrait + 190, this.yPagePortrait + 350 - 2, this.field_73735_i);
    }

    protected void drawSubPagePortraitPageArrows(int mouseX, int mouseY, float partialTicks) {
        if (this.subPageCount > 1 && this.subPageIndex > 1) {
            GuiButton previousButton = new GuiButton(BUTTON_KEY_PREVIOUSSUBPAGE);
            previousButton.setIcon(buttonPreviousPage, this.field_73735_i, this.xPagePortrait + 65, this.yPagePortrait + 350 - 6, 16, 16, 0, 0, 16, 16);
            this.buttons.add(previousButton);
            String previousTooltipText = previousButton.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(previousTooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(this.xPagePortrait + 65, this.yPagePortrait + 350 - 6, 16, 16, previousTooltipText));
            }
        }
        if (this.subPageCount > 1 && this.subPageIndex < this.subPageCount) {
            GuiButton nextButton = new GuiButton(BUTTON_KEY_NEXTSUBPAGE);
            nextButton.setIcon(buttonNextPage, this.field_73735_i, this.xPagePortrait + 315 - 16, this.yPagePortrait + 350 - 6, 16, 16, 0, 0, 16, 16);
            this.buttons.add(nextButton);
            String nextTooltipText = nextButton.getDisplayName();
            if (!StringUtils.isNullOrWhitespace(nextTooltipText).booleanValue()) {
                this.tooltips.add(new GuiTooltip(this.xPagePortrait + 315 - 16, this.yPagePortrait + 350 - 6, 16, 16, nextTooltipText));
            }
        }
    }

    protected void drawSubPageAiFilters(int mouseX, int mouseY, float partialTicks) {
        ResidentData resident;
        int residentId;
        this.drawSubPagePortraitBackground(mouseX, mouseY, partialTicks);
        this.drawSubPagePortraitHeader(mouseX, mouseY, partialTicks);
        this.drawSubPagePortraitFooter(mouseX, mouseY, partialTicks);
        String[] subPageKeyParts = GuiTektopiaBook.getSubPageKeyParts(this.subPageKey);
        try {
            residentId = Integer.parseInt(subPageKeyParts[1]);
        }
        catch (NumberFormatException e) {
            return;
        }
        ResidentsData residentsData = this.villageData.getResidentsData();
        ResidentData residentData = resident = residentsData != null ? residentsData.getResidentById(residentId) : null;
        if (resident == null) {
            return;
        }
        int count = resident.getAiFiltersCount();
        int pages = count / 23;
        if (count % 23 > 0) {
            ++pages;
        }
        this.setSubPageCount(pages);
        this.drawSubPagePortraitPageArrows(mouseX, mouseY, partialTicks);
        int y = this.yPagePortrait + 25 + 10;
        int indentX = 10;
        String residentName = GuiTektopiaBook.stripTextFormatting(resident.getName());
        if (!StringUtils.isNullOrWhitespace(residentName).booleanValue()) {
            residentName = resident.isMale() ? TextFormatting.BLUE + residentName + " " + TextUtils.SYMBOL_MALE : TextFormatting.LIGHT_PURPLE + residentName + " " + TextUtils.SYMBOL_FEMALE;
            Font.normal.printLeft(residentName, this.xPagePortrait + 65, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        String professionLabel = TextUtils.translate("tektopiaBook.residents.profession", new Object[0]);
        String professionText = "";
        if (!StringUtils.isNullOrWhitespace(professionLabel).booleanValue()) {
            professionText = professionText + GuiTektopiaBook.getTypeName(resident.getProfessionType());
            int professionLabelLength = Font.small.getStringWidth(professionLabel) + indentX;
            Font.small.printLeft(professionLabel, this.xPagePortrait + 65 + indentX, y, this.field_73735_i);
            Font.small.printLeft(professionText, this.xPagePortrait + 65 + professionLabelLength + indentX, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String header = TextUtils.translate("tektopiaBook.aifilters.header", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
            header = TextFormatting.DARK_BLUE + header;
            Font.small.printLeft(header, this.xPagePortrait + 65, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        Map<String, Boolean> aiFilters = resident.getAiFilters();
        int[] maxLength = new int[]{0};
        String enabledHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.enabled", new Object[0]);
        String nameHeader = TextFormatting.UNDERLINE + TextUtils.translate("tektopiaBook.headers.name", new Object[0]);
        maxLength[0] = maxLength[0] + Font.small.getStringWidth(enabledHeader);
        Font.small.printRight(enabledHeader, this.xPagePortrait + 65 + maxLength[0], y, this.field_73735_i);
        Font.small.printLeft(nameHeader, this.xPagePortrait + 65 + indentX + maxLength[0], y, this.field_73735_i);
        y += Font.small.fontRenderer.field_78288_b + 2;
        int page = this.subPageIndex - 1;
        int startIndex = page * 23;
        int endIndex = Math.min(aiFilters.size(), startIndex + 23);
        List subList = aiFilters.entrySet().stream().skip(startIndex).limit(endIndex - startIndex).collect(Collectors.toList());
        for (Map.Entry aiFilter : subList) {
            String aiFilterName = GuiTektopiaBook.getAiFilterName((String)aiFilter.getKey());
            String aiFilterValue = (Boolean)aiFilter.getValue() != false ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS;
            Font.small.printCentered(aiFilterValue, this.xPagePortrait + 65 + maxLength[0] / 2, y, this.field_73735_i);
            Font.small.printLeft(aiFilterName, this.xPagePortrait + 65 + indentX + maxLength[0], y, this.field_73735_i);
            y += Font.small.fontRenderer.field_78288_b + 2;
        }
    }

    protected void drawSubPageInventory(int mouseX, int mouseY, float partialTicks) {
        ResidentData resident;
        int residentId;
        this.drawSubPagePortraitBackground(mouseX, mouseY, partialTicks);
        this.drawSubPagePortraitHeader(mouseX, mouseY, partialTicks);
        this.drawSubPagePortraitFooter(mouseX, mouseY, partialTicks);
        RenderUtils.drawModalRectWithCustomSizedTextureWithZLevel(inventory, this.field_73735_i, this.xPagePortrait + 190 - 89, this.yPagePortrait + 90, 0.0f, 0.0f, 178, 69, 178.0f, 69.0f);
        String[] subPageKeyParts = GuiTektopiaBook.getSubPageKeyParts(this.subPageKey);
        try {
            residentId = Integer.parseInt(subPageKeyParts[1]);
        }
        catch (NumberFormatException e) {
            return;
        }
        ResidentsData residentsData = this.villageData.getResidentsData();
        ResidentData residentData = resident = residentsData != null ? residentsData.getResidentById(residentId) : null;
        if (resident == null) {
            return;
        }
        int count = resident.getInventoryCount();
        int lines = count / 9;
        int pages = lines / 3;
        if (lines % 3 > 0) {
            ++pages;
        }
        this.setSubPageCount(pages);
        this.drawSubPagePortraitPageArrows(mouseX, mouseY, partialTicks);
        int y = this.yPagePortrait + 25 + 10;
        int indentX = 10;
        String residentName = GuiTektopiaBook.stripTextFormatting(resident.getName());
        if (!StringUtils.isNullOrWhitespace(residentName).booleanValue()) {
            residentName = resident.isMale() ? TextFormatting.BLUE + residentName + " " + TextUtils.SYMBOL_MALE : TextFormatting.LIGHT_PURPLE + residentName + " " + TextUtils.SYMBOL_FEMALE;
            Font.normal.printLeft(residentName, this.xPagePortrait + 65, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        String professionLabel = TextUtils.translate("tektopiaBook.residents.profession", new Object[0]);
        String professionText = "";
        if (!StringUtils.isNullOrWhitespace(professionLabel).booleanValue()) {
            professionText = professionText + GuiTektopiaBook.getTypeName(resident.getProfessionType());
            int professionLabelLength = Font.small.getStringWidth(professionLabel) + indentX;
            Font.small.printLeft(professionLabel, this.xPagePortrait + 65 + indentX, y, this.field_73735_i);
            Font.small.printLeft(professionText, this.xPagePortrait + 65 + professionLabelLength + indentX, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2 + 2;
        String header = TextUtils.translate("tektopiaBook.inventory.header", new Object[0]);
        if (!StringUtils.isNullOrWhitespace(header).booleanValue()) {
            header = TextFormatting.DARK_BLUE + header;
            Font.small.printLeft(header, this.xPagePortrait + 65, y, this.field_73735_i);
        }
        y += Font.small.fontRenderer.field_78288_b + 2;
        List<ItemStack> inventory = resident.getInventory();
        if (inventory != null && inventory.size() > 0) {
            int page = this.subPageIndex - 1;
            int startIndex = page * 3 * 9;
            int endIndex = Math.min(inventory.size(), startIndex + 27);
            int tX = this.xPagePortrait + 65 + 44 + 1;
            int tY = y + 29;
            float oldZLevel = this.addZLevel(5.0f);
            List<ItemStack> subList = inventory.subList(startIndex, endIndex);
            for (ItemStack itemStack : subList) {
                if (subList.indexOf(itemStack) > 0 && subList.indexOf(itemStack) % 9 == 0) {
                    tX = this.xPagePortrait + 65 + 44 + 1;
                    tY += 18;
                }
                if (itemStack != null && !itemStack.func_190926_b()) {
                    List tooltip = itemStack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    if (itemStack.func_77948_v() && tooltip.size() > 0) {
                        tooltip.set(0, TextFormatting.AQUA + (String)tooltip.get(0));
                    }
                    RenderUtils.renderItemAndEffectIntoGUI(this.field_146296_j, itemStack, tX, tY, true);
                    RenderUtils.renderItemOverlayIntoGUI(this.field_146296_j, Font.normal.fontRenderer, itemStack, tX, tY, null);
                    if (tooltip.size() > 0) {
                        this.tooltips.add(new GuiTooltip(tX, tY, 16, 16, tooltip));
                    }
                }
                tX += 18;
            }
            this.setZLevel(oldZLevel);
        }
    }

    protected void actionPerformed(GuiBookmark bookmark) {
        if (bookmark == null) {
            return;
        }
        this.setLeftPageIndex(bookmark.getPageIndex());
        this.setSubPage(null);
        this.clearPageHistory();
        if (!bookmark.getKey().equals(BOOKMARK_KEY_MAP)) {
            this.villageData.ClearAssignments();
        }
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void actionPerformed(GuiButton button) {
        if (button == null) {
            return;
        }
        switch (button.getKey()) {
            case "back": {
                this.movePreviousPageHistory();
                return;
            }
            case "previouspage": {
                this.movePreviousPage();
                return;
            }
            case "nextpage": {
                this.moveNextPage();
                return;
            }
            case "startbook": {
                this.moveFirstPage();
                return;
            }
            case "endbook": {
                this.moveLastPage();
                return;
            }
            case "close": {
                this.setSubPage(null);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                return;
            }
            case "previoussubpage": {
                this.movePreviousSubPage();
                return;
            }
            case "nextsubpage": {
                this.moveNextSubPage();
                return;
            }
            case "aifilter": 
            case "inventory": {
                this.setSubPage(button.getButtonData());
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                return;
            }
            case "showmapboundaries": {
                showMapBoundaries = showMapBoundaries == false;
                return;
            }
            case "showmapenemies": {
                showMapEnemies = showMapEnemies == false;
                return;
            }
            case "showmaphomes": {
                showMapHomes = showMapHomes == false;
                return;
            }
            case "showmapvisitors": {
                showMapVisitors = showMapVisitors == false;
                return;
            }
            case "showmapplayer": {
                showMapPlayer = showMapPlayer == false;
                return;
            }
            case "showmapresidents": {
                showMapResidents = showMapResidents == false;
                return;
            }
            case "showmapstructures": {
                showMapStructures = showMapStructures == false;
                return;
            }
            case "showmaptownhall": {
                showMapTownHall = showMapTownHall == false;
                return;
            }
            case "showmapselectedalways": {
                showSelectedAlways = showSelectedAlways == false;
                return;
            }
            case "showmapselectedonly": {
                this.showSelectedOnly = this.showSelectedOnly == false;
                return;
            }
            case "clearselection": {
                this.villageData.ClearAssignments();
                this.showSelectedOnly = false;
                return;
            }
        }
        if (button instanceof GuiHyperlink) {
            GuiHyperlink hyperlink = (GuiHyperlink)button;
            block55 : switch (button.getKey()) {
                case "aifilterLink": {
                    String[] pageData;
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() == GuiPageType.RESIDENT && page.getDataKey().equals(linkData[1])) {
                            this.pushPageHistory();
                            this.setLeftPageIndex(page.getPageIndex());
                            pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                            this.setSubPage(GuiTektopiaBook.getAiFilterSubPageKey(Integer.parseInt(pageData[0])));
                            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                            break block55;
                        }
                        if (page.getGuiPageType() != GuiPageType.AIFILTER || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "mapLink": {
                    String[] pageData;
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.MAP) continue;
                        if (linkData[0].equals(GuiPageType.RESIDENT.name()) || linkData[0].equals(GuiPageType.VISITOR.name()) || linkData[0].equals(GuiPageType.ENEMY.name())) {
                            this.pushPageHistory();
                            pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                            this.villageData.setEntityId(Integer.parseInt(pageData[0]));
                            this.setLeftPageIndex(page.getPageIndex());
                            this.showSelectedOnly = true;
                            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                            break block55;
                        }
                        if (!linkData[0].equals(GuiPageType.STRUCTURE.name()) && !linkData[0].equals(GuiPageType.HOME.name())) continue;
                        this.pushPageHistory();
                        pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                        this.villageData.setStructureId(Integer.parseInt(pageData[0]));
                        this.setLeftPageIndex(page.getPageIndex());
                        this.showSelectedOnly = true;
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "homeLink": {
                    String[] pageData;
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() == GuiPageType.HOME && page.getDataKey().equals(linkData[1])) {
                            this.pushPageHistory();
                            pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                            this.villageData.setStructureId(Integer.parseInt(pageData[0]));
                            this.setLeftPageIndex(page.getPageIndex());
                            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                            break block55;
                        }
                        if (page.getGuiPageType() != GuiPageType.HOMETYPE || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "professionLink": {
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.PROFESSIONTYPE || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "residentLink": {
                    String[] pageData;
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.RESIDENT || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                        this.villageData.setEntityId(Integer.parseInt(pageData[0]));
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "statisticLink": {
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.STATS || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "structureLink": {
                    String[] pageData;
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() == GuiPageType.STRUCTURE && page.getDataKey().equals(linkData[1])) {
                            this.pushPageHistory();
                            pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                            this.villageData.setStructureId(Integer.parseInt(pageData[0]));
                            this.setLeftPageIndex(page.getPageIndex());
                            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                            break block55;
                        }
                        if (page.getGuiPageType() != GuiPageType.STRUCTURETYPE || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
                case "visitorLink": {
                    String[] pageData;
                    String[] linkData = GuiTektopiaBook.getHyperlinkDataParts(hyperlink.getLinkData());
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.VISITOR || !page.getDataKey().equals(linkData[1])) continue;
                        this.pushPageHistory();
                        pageData = GuiTektopiaBook.getPageKeyParts(linkData[1]);
                        this.villageData.setEntityId(Integer.parseInt(pageData[0]));
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block55;
                    }
                    break;
                }
            }
        }
        if (button instanceof GuiMapMarker) {
            GuiMapMarker mapMarker = (GuiMapMarker)button;
            block65 : switch (mapMarker.getMarkerType()) {
                case PLAYER: {
                    break;
                }
                case RESIDENT: 
                case VISITOR: 
                case ENEMY: {
                    String[] keyParts = GuiTektopiaBook.getPageKeyParts(mapMarker.key);
                    for (GuiPage page : this.pages) {
                        if (!page.getDataKey().equals(mapMarker.key)) continue;
                        this.pushPageHistory();
                        this.villageData.setEntityId(Integer.parseInt(keyParts[0]));
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block65;
                    }
                    break;
                }
                case HOME: {
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.HOME || !page.getDataKey().equals(mapMarker.key)) continue;
                        this.pushPageHistory();
                        this.villageData.setFramePosition(mapMarker.getPosition());
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block65;
                    }
                    break;
                }
                case STRUCTURE: 
                case TOWNHALL: {
                    for (GuiPage page : this.pages) {
                        if (page.getGuiPageType() != GuiPageType.STRUCTURETYPE || !page.getDataKey().equals(mapMarker.key)) continue;
                        this.pushPageHistory();
                        this.villageData.setFramePosition(mapMarker.getPosition());
                        this.setLeftPageIndex(page.getPageIndex());
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
                        break block65;
                    }
                    break;
                }
            }
        }
    }

    private static String formatBlockPos(BlockPos blockPos) {
        if (blockPos == null) {
            return "";
        }
        return blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p();
    }

    private static String formatResidentLevel(int level, int baseLevel, boolean showBaseLevel, boolean showPrefix) {
        String residentLevel = "";
        if (level > 0) {
            if (showPrefix) {
                residentLevel = residentLevel + TextUtils.translate("tektopiaBook.residents.level", new Object[0]) + " ";
            }
            residentLevel = level > baseLevel ? residentLevel + "" + TextFormatting.DARK_GREEN + level + TextFormatting.RESET + (showBaseLevel ? " (" + baseLevel + ")" : "") : residentLevel + "" + level;
        }
        return residentLevel;
    }

    private static String formatResidentName(Boolean isMale, String name, Boolean includeGenderSymbol) {
        String residentName = (isMale != false ? TextFormatting.BLUE : TextFormatting.LIGHT_PURPLE) + GuiTektopiaBook.stripTextFormatting(name);
        if (includeGenderSymbol.booleanValue()) {
            residentName = residentName + " " + (isMale != false ? TextUtils.SYMBOL_MALE : TextUtils.SYMBOL_FEMALE);
        }
        return residentName;
    }

    private static String formatResidentStatistic(int value, int maxValue, boolean showMaxLevel) {
        int percentage = 100 / maxValue * value;
        if (percentage <= 10) {
            return "" + TextFormatting.DARK_RED + value + TextFormatting.RESET + (showMaxLevel ? " (" + maxValue + ")" : "");
        }
        if (percentage <= 50) {
            return "" + TextFormatting.GOLD + value + TextFormatting.RESET + (showMaxLevel ? " (" + maxValue + ")" : "");
        }
        return "" + TextFormatting.DARK_GREEN + value + TextFormatting.RESET + (showMaxLevel ? " (" + maxValue + ")" : "");
    }

    private static String formatResidentStatistic(float value, float maxValue, boolean showMaxLevel) {
        float percentage = 100.0f / maxValue * value;
        if (percentage <= 10.0f) {
            return "" + TextFormatting.DARK_RED + value + TextFormatting.RESET + (showMaxLevel ? " (" + maxValue + ")" : "");
        }
        if (percentage <= 50.0f) {
            return "" + TextFormatting.GOLD + value + TextFormatting.RESET + (showMaxLevel ? " (" + maxValue + ")" : "");
        }
        return "" + TextFormatting.DARK_GREEN + value + TextFormatting.RESET + (showMaxLevel ? " (" + maxValue + ")" : "");
    }

    private static String formatStatisticsRange(int lowValue, int highValue, int maxValue) {
        float percentage = 100 / maxValue * highValue;
        if (percentage <= 10.0f) {
            return "" + TextFormatting.DARK_RED + lowValue + (lowValue != highValue ? " - " + highValue : "");
        }
        if (percentage <= 50.0f) {
            return "" + TextFormatting.GOLD + lowValue + (lowValue != highValue ? " - " + highValue : "");
        }
        return "" + TextFormatting.DARK_GREEN + lowValue + (lowValue != highValue ? " - " + highValue : "");
    }

    private static String getAiFilterName(String aiFilerKey) {
        if (StringUtils.isNullOrWhitespace(aiFilerKey).booleanValue()) {
            return "";
        }
        return TextUtils.translate("ai.filter." + aiFilerKey, new Object[0]);
    }

    private static String getAiTaskName(String aiTaskKey) {
        if (StringUtils.isNullOrWhitespace(aiTaskKey).booleanValue()) {
            return "";
        }
        String key = aiTaskKey;
        String result = "";
        if (key.startsWith("EntityAI")) {
            key = key.substring("EntityAI".length());
        }
        String delimiter = "";
        for (int index = 0; index < key.length(); ++index) {
            char value = key.charAt(index);
            if (Character.isUpperCase(value)) {
                result = result + delimiter;
                delimiter = " ";
            }
            result = result + value;
        }
        result = result.replaceAll("Generic", "");
        result = result.replaceAll("Idle Check", "Idle");
        result = result.replaceAll("[0-9]", "");
        result = result.replaceAll("  ", " ");
        return result.trim();
    }

    private static String getPageKey(String pageKey, int pageNumber) {
        if (pageKey == null) {
            pageKey = "";
        }
        return pageKey + "@" + pageNumber;
    }

    private static String[] getPageKeyParts(String pageKey) {
        String[] result = new String[]{"", "0"};
        if (!StringUtils.isNullOrWhitespace(pageKey).booleanValue()) {
            if (pageKey.contains("@")) {
                String[] parts = pageKey.split("@");
                if (parts.length > 0) {
                    result[0] = parts[0];
                }
                if (parts.length > 1) {
                    result[1] = parts[1];
                }
            } else {
                result[0] = pageKey;
            }
        }
        return result;
    }

    private static String getStatisticsPageKey(String pageKey, int rangekey, int pageNumber) {
        if (pageKey == null) {
            pageKey = "";
        }
        return pageKey + "@" + rangekey + "@" + pageNumber;
    }

    private static String[] getStatisticsPageKeyParts(String pageKey) {
        String[] result = new String[]{"", "0", "0"};
        if (!StringUtils.isNullOrWhitespace(pageKey).booleanValue()) {
            if (pageKey.contains("@")) {
                String[] parts = pageKey.split("@");
                if (parts.length > 0) {
                    result[0] = parts[0];
                }
                if (parts.length > 1) {
                    result[1] = parts[1];
                }
                if (parts.length > 2) {
                    result[2] = parts[2];
                }
            } else {
                result[0] = pageKey;
            }
        }
        return result;
    }

    private static String getStructureTypeName(VillageStructureType structureType) {
        if (structureType == null || structureType.itemStack == null) {
            return "";
        }
        return structureType.itemStack.func_82833_r();
    }

    private static String getTypeName(String typeName) {
        if (typeName == null) {
            return "";
        }
        String result = TextUtils.translate("entity." + typeName.toLowerCase() + ".name", new Object[0]);
        return result == null || result.trim().isEmpty() ? typeName : result;
    }

    protected void setLeftPageIndex(int pageIndex) {
        if (pageIndex < 0) {
            pageIndex = 1;
        }
        if (pageIndex >= this.pages.size()) {
            pageIndex = this.pages.size() - 1;
        }
        boolean isEven = pageIndex % 2 == 0;
        this.leftPageIndex = isEven ? pageIndex : pageIndex - 1;
    }

    private static String stripTextFormatting(String value) {
        if (StringUtils.isNullOrWhitespace(value).booleanValue()) {
            return "";
        }
        return TextFormatting.func_110646_a((String)value);
    }

    private static String getHyperlinkData(GuiPageType pageType, String pageKey) {
        if (pageType == null) {
            pageType = GuiPageType.BLANK;
        }
        if (pageKey == null) {
            pageKey = "";
        }
        return pageType.name() + ":" + pageKey;
    }

    private static String[] getHyperlinkDataParts(String linkData) {
        String[] result = new String[]{"", ""};
        if (!StringUtils.isNullOrWhitespace(linkData).booleanValue()) {
            if (linkData.contains(":")) {
                String[] parts = linkData.split(":");
                if (parts.length > 0) {
                    result[0] = parts[0];
                }
                if (parts.length > 1) {
                    result[1] = parts[1];
                }
            } else {
                result[0] = linkData;
            }
        }
        return result;
    }

    private static String getAIFilterDetailPageKey(String professionType) {
        return GuiTektopiaBook.getAIFilterDetailPageKey(professionType, 0);
    }

    private static String getAIFilterDetailPageKey(String professionType, int page) {
        return GuiTektopiaBook.getPageKey(professionType.toUpperCase(), page);
    }

    private static String getProfessionDetailPageKey(String professionType) {
        return GuiTektopiaBook.getProfessionDetailPageKey(professionType, 0);
    }

    private static String getProfessionDetailPageKey(String professionType, int page) {
        return GuiTektopiaBook.getPageKey(professionType.toUpperCase(), page);
    }

    private static String getResidentDetailPageKey(int residentId) {
        return GuiTektopiaBook.getPageKey("" + residentId, 0);
    }

    private static String getResidentDetailPageKey(int residentId, int page) {
        return GuiTektopiaBook.getPageKey("" + residentId, page);
    }

    private static String getStructureDetailPageKey(int structureId) {
        return GuiTektopiaBook.getStructureDetailPageKey(structureId, 0);
    }

    private static String getStructureDetailPageKey(int structureId, int page) {
        return GuiTektopiaBook.getPageKey("" + structureId, page);
    }

    private static String getStructureTypePageKey(VillageStructureType structureType) {
        return GuiTektopiaBook.getStructureTypePageKey(structureType, 0);
    }

    private static String getStructureTypePageKey(VillageStructureType structureType, int page) {
        return GuiTektopiaBook.getPageKey(structureType.name(), page);
    }

    private Boolean isSubPageOpen() {
        return StringUtils.isNullOrWhitespace(this.subPageKey) == false;
    }

    protected void clearPageHistory() {
        this.pageHistory.clear();
    }

    private int popPageHistory() {
        if (this.pageHistory.empty()) {
            return this.leftPageIndex;
        }
        return this.pageHistory.pop();
    }

    protected void pushPageHistory() {
        this.pushPageHistory(this.leftPageIndex);
    }

    protected void pushPageHistory(int pageIndex) {
        if (pageIndex < 0) {
            return;
        }
        this.pageHistory.push(pageIndex);
        while (this.pageHistory.size() > 10) {
            this.pageHistory.remove(0);
        }
    }

    public static String getAiFilterSubPageKey(int residentId) {
        return GuiTektopiaBook.getSubPageKey("aifilter", "" + residentId);
    }

    public static String getInventorySubPageKey(int residentId) {
        return GuiTektopiaBook.getSubPageKey("inventory", "" + residentId);
    }

    public static String getSubPageKey(String subPageKey, String subPageData) {
        return subPageKey + ":" + subPageData;
    }

    public static String[] getSubPageKeyParts(String subPageKey) {
        String[] result = new String[]{"", ""};
        if (!StringUtils.isNullOrWhitespace(subPageKey).booleanValue()) {
            if (subPageKey.contains(":")) {
                String[] parts = subPageKey.split(":");
                if (parts.length > 0) {
                    result[0] = parts[0];
                }
                if (parts.length > 1) {
                    result[1] = parts[1];
                }
            } else {
                result[0] = subPageKey;
            }
        }
        return result;
    }

    protected void setSubPage(String subPageKey) {
        this.subPageKey = subPageKey;
        this.setSubPageCount(1);
        this.setSubPageIndex(1);
    }

    protected void setSubPageIndex(int subPageIndex) {
        if (subPageIndex < 1) {
            subPageIndex = 1;
        }
        if (subPageIndex > this.subPageCount) {
            subPageIndex = this.subPageCount;
        }
        this.subPageIndex = subPageIndex;
    }

    protected void setSubPageCount(int subPageCount) {
        if (subPageCount < 1) {
            subPageCount = 1;
        }
        this.subPageCount = subPageCount;
        if (this.subPageIndex > this.subPageCount) {
            this.subPageIndex = this.subPageCount;
        }
    }

    protected float addZLevel(float zAddition) {
        float oldZLevel = this.field_73735_i;
        this.field_73735_i += zAddition;
        this.field_146296_j.field_77023_b += zAddition;
        return oldZLevel;
    }

    protected float setZLevel(float zLevel) {
        float oldZLevel = this.field_73735_i;
        this.field_73735_i = zLevel;
        this.field_146296_j.field_77023_b = zLevel;
        return oldZLevel;
    }

    protected void moveNextBookmark() {
        for (GuiBookmark bookmark : this.bookmarks) {
            if (bookmark.getPageIndex() <= this.leftPageIndex) continue;
            this.actionPerformed(bookmark);
            return;
        }
        this.moveLastPage();
    }

    protected void movePreviousBookmark() {
        for (int index = this.bookmarks.size() - 1; index >= 0; --index) {
            if (this.bookmarks.get(index).getPageIndex() >= this.leftPageIndex) continue;
            this.actionPerformed(this.bookmarks.get(index));
            return;
        }
        this.moveFirstPage();
    }

    protected void moveFirstPage() {
        this.setSubPage(null);
        this.setLeftPageIndex(0);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void moveNextPage() {
        this.setSubPage(null);
        this.setLeftPageIndex(this.leftPageIndex + 2);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void movePreviousPage() {
        this.setSubPage(null);
        this.setLeftPageIndex(this.leftPageIndex - 2);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void moveLastPage() {
        this.setSubPage(null);
        this.setLeftPageIndex(this.pages.size());
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void moveFirstSubPage() {
        this.setSubPageIndex(0);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void moveNextSubPage() {
        this.setSubPageIndex(this.subPageIndex + 1);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void movePreviousSubPage() {
        this.setSubPageIndex(this.subPageIndex - 1);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void moveLastSubPage() {
        this.setSubPageIndex(this.subPageCount);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
    }

    protected void movePreviousPageHistory() {
        if (!this.pageHistory.empty()) {
            this.setSubPage(null);
            this.setLeftPageIndex(this.popPageHistory());
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BOOK_PAGE_TURN, (float)1.0f));
        }
    }

    protected void outputVillageDetails() {
        String outputFilename = "/debug/tektopiainformation_{datetime}.csv".replace("{datetime}", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")));
        LoggerUtils logger = new LoggerUtils();
        logger.Initialise(TektopiaInformation.proxy.getMinecraftDirectory() + outputFilename);
        logger.output("Resident Details");
        logger.output("id,Name,isMale,isChild,level,daysAlive,health,hunger,happy,intelligence,profession");
        ResidentsData residentsData = this.villageData.getResidentsData();
        for (ResidentData resident : residentsData.getResidents()) {
            String output = new String();
            output = output + resident.getId();
            output = output + "," + resident.getName();
            output = output + "," + resident.isMale();
            output = output + "," + resident.isChild();
            output = output + "," + resident.getBaseLevel();
            output = output + "," + resident.getDaysAlive();
            output = output + "," + resident.getHealth();
            output = output + "," + resident.getHunger();
            output = output + "," + resident.getHappy();
            output = output + "," + resident.getIntelligence();
            output = output + "," + resident.getProfessionType();
            logger.output(output);
        }
        logger.output("");
        logger.output("Profession Details");
        logger.output("professionType,count");
        Map<String, Integer> professionTypeCounts = residentsData != null ? residentsData.getProfessionTypeCountsAll() : null;
        professionTypeCounts.forEach((key, value) -> {
            String output = new String();
            output = output + GuiTektopiaBook.getTypeName(key);
            output = output + "," + value;
            logger.output(output);
        });
        logger.output("");
        logger.output("Structure Details");
        logger.output("type,x,y,z,floorTileCount,isAnimalPen,animalCount");
        StructuresData structuresData = this.villageData.getStructuresData();
        for (StructureData structure : structuresData.getStructures()) {
            String output = new String();
            output = output + structure.getStructureTypeName();
            output = output + "," + structure.getFramePosition().func_177958_n();
            output = output + "," + structure.getFramePosition().func_177956_o();
            output = output + "," + structure.getFramePosition().func_177952_p();
            output = output + "," + structure.getFloorTileCount();
            output = output + "," + structure.isAnimalPen();
            output = output + "," + structure.getAnimalCount();
            logger.output(output);
        }
    }
}

