/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseContainer;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseModClient;
import gcewing.sg.BaseUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class BaseGui {
    public static final int defaultTextColor = 0x404040;

    static boolean isFocused(IWidget widget) {
        if (widget == null) {
            return false;
        }
        if (widget instanceof Root) {
            return true;
        }
        IWidgetContainer parent = widget.parent();
        return parent != null && parent.getFocus() == widget && BaseGui.isFocused(parent);
    }

    static void tellFocusChanged(IWidget widget, boolean state) {
        if (widget != null) {
            widget.focusChanged(state);
            if (widget instanceof IWidgetContainer) {
                BaseGui.tellFocusChanged(((IWidgetContainer)widget).getFocus(), state);
            }
        }
    }

    static String name(Object obj) {
        if (obj != null) {
            return obj.getClass().getSimpleName();
        }
        return "null";
    }

    public static Ref ref(Object target, String name) {
        return new FieldRef(target, name);
    }

    public static Ref ref(Object target, String getterName, String setterName) {
        return new PropertyRef(target, getterName, setterName);
    }

    public static Action action(Object target, String name) {
        return new MethodAction(target, name);
    }

    public static class GState {
        public GState previous;
        public double uscale;
        public double vscale;
        public float red;
        public float green;
        public float blue;
        public int textColor;
        public boolean textShadow;
        public ResourceLocation texture;

        public GState() {
            this.uscale = 1.0;
            this.vscale = 1.0;
            this.blue = 1.0f;
            this.green = 1.0f;
            this.red = 1.0f;
            this.textColor = 0x404040;
            this.textShadow = false;
        }

        public GState(GState previous) {
            this.previous = previous;
            this.uscale = previous.uscale;
            this.vscale = previous.vscale;
            this.red = previous.red;
            this.green = previous.green;
            this.blue = previous.blue;
            this.textColor = previous.textColor;
            this.textShadow = previous.textShadow;
            this.texture = previous.texture;
        }
    }

    public static class MethodAction
    implements Action {
        Object target;
        Method method;

        public MethodAction(Object target, String name) {
            try {
                this.target = target;
                this.method = target.getClass().getMethod(name, new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void perform() {
            try {
                this.method.invoke(this.target, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Action {
        public void perform();
    }

    public static class PropertyRef
    implements Ref {
        public Object target;
        public Method getter;
        public Method setter;

        public PropertyRef(Object target, String getterName, String setterName) {
            this.target = target;
            try {
                Class<?> cls = target.getClass();
                this.getter = cls.getMethod(getterName, new Class[0]);
                this.setter = cls.getMethod(setterName, this.getter.getReturnType());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object get() {
            try {
                return this.getter.invoke(this.target, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void set(Object value) {
            try {
                this.setter.invoke(this.target, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class FieldRef
    implements Ref {
        public Object target;
        public Field field;

        public FieldRef(Object target, String name) {
            try {
                this.target = target;
                this.field = target.getClass().getField(name);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object get() {
            try {
                return this.field.get(this.target);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void set(Object value) {
            try {
                this.field.set(this.target, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Ref {
        public Object get();

        public void set(Object var1);
    }

    public static class Root
    extends Group {
        public Screen screen;
        public List<IWidget> popupStack;

        public Root(Screen screen) {
            this.screen = screen;
            this.popupStack = new ArrayList<IWidget>();
        }

        @Override
        public int width() {
            return this.screen.getWidth();
        }

        @Override
        public int height() {
            return this.screen.getHeight();
        }

        @Override
        public IWidget dispatchMousePress(int x, int y, int button) {
            IWidget w = this.topPopup();
            if (w == null) {
                w = super.dispatchMousePress(x, y, button);
            }
            return w;
        }

        @Override
        public void addPopup(int x, int y, IWidget widget) {
            this.add(x, y, widget);
            this.popupStack.add(widget);
            this.screen.focusOn(widget);
        }

        @Override
        public void remove(IWidget widget) {
            super.remove(widget);
            this.popupStack.remove(widget);
            this.focusTopPopup();
        }

        public IWidget topPopup() {
            int n = this.popupStack.size();
            if (n > 0) {
                return this.popupStack.get(n - 1);
            }
            return null;
        }

        void focusTopPopup() {
            IWidget w = this.topPopup();
            if (w != null) {
                this.screen.focusOn(w);
            }
        }
    }

    public static class Group
    extends Widget
    implements IWidgetContainer {
        protected List<IWidget> widgets = new ArrayList<IWidget>();
        protected IWidget focus;

        @Override
        public IWidget getFocus() {
            return this.focus;
        }

        @Override
        public void setFocus(IWidget widget) {
            this.focus = widget;
        }

        public void add(int left, int top, IWidget widget) {
            widget.setLeft(left);
            widget.setTop(top);
            widget.setParent(this);
            this.widgets.add(widget);
        }

        public void remove(IWidget widget) {
            this.widgets.remove(widget);
            if (this.getFocus() == widget) {
                if (BaseGui.isFocused(this)) {
                    BaseGui.tellFocusChanged(widget, false);
                }
                this.setFocus(null);
            }
        }

        @Override
        public void draw(Screen scr, int mouseX, int mouseY) {
            super.draw(scr, mouseX, mouseY);
            for (IWidget w : this.widgets) {
                int dx = w.left();
                int dy = w.top();
                GL11.glPushMatrix();
                GL11.glTranslated((double)dx, (double)dy, (double)0.0);
                w.draw(scr, mouseX - dx, mouseY - dy);
                GL11.glPopMatrix();
            }
        }

        @Override
        public IWidget dispatchMousePress(int x, int y, int button) {
            IWidget target = this.findWidget(x, y);
            if (target != null) {
                return target.dispatchMousePress(x - target.left(), y - target.top(), button);
            }
            return this;
        }

        @Override
        public boolean dispatchKeyPress(char c, int key) {
            IWidget focus = this.getFocus();
            if (focus != null && focus.dispatchKeyPress(c, key)) {
                return true;
            }
            return super.dispatchKeyPress(c, key);
        }

        public IWidget findWidget(int x, int y) {
            for (int i = this.widgets.size() - 1; i >= 0; --i) {
                IWidget w = this.widgets.get(i);
                int l = w.left();
                int t = w.top();
                if (x < l || y < t || x >= l + w.width() || y >= t + w.height()) continue;
                return w;
            }
            return null;
        }

        @Override
        public void layout() {
            for (IWidget w : this.widgets) {
                w.layout();
            }
        }
    }

    public static interface IWidgetContainer
    extends IWidget {
        public IWidget getFocus();

        public void setFocus(IWidget var1);
    }

    public static class Widget
    implements IWidget {
        public IWidgetContainer parent;
        public int left;
        public int top;
        public int width;
        public int height;

        public Widget() {
        }

        public Widget(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public IWidgetContainer parent() {
            return this.parent;
        }

        @Override
        public void setParent(IWidgetContainer widget) {
            this.parent = widget;
        }

        @Override
        public int left() {
            return this.left;
        }

        @Override
        public int top() {
            return this.top;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public int height() {
            return this.height;
        }

        @Override
        public void setLeft(int x) {
            this.left = x;
        }

        @Override
        public void setTop(int y) {
            this.top = y;
        }

        @Override
        public void draw(Screen scr, int mouseX, int mouseY) {
        }

        @Override
        public void mousePressed(MouseCoords m, int button) {
        }

        @Override
        public void mouseDragged(MouseCoords m, int button) {
        }

        @Override
        public void mouseReleased(MouseCoords m, int button) {
        }

        @Override
        public boolean keyPressed(char c, int key) {
            return false;
        }

        @Override
        public void focusChanged(boolean state) {
        }

        @Override
        public void close() {
        }

        @Override
        public void layout() {
        }

        @Override
        public IWidget dispatchMousePress(int x, int y, int button) {
            return this;
        }

        @Override
        public boolean dispatchKeyPress(char c, int key) {
            return this.keyPressed(c, key);
        }

        public static int stringWidth(String s) {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
        }

        public void addPopup(int x, int y, IWidget widget) {
            IWidget w = this;
            while (!(w instanceof Root)) {
                x += w.left();
                y += w.top();
                w = w.parent();
            }
            ((Root)w).addPopup(x, y, widget);
        }

        public void removePopup() {
            Root root = this.getRoot();
            root.remove(this);
        }

        public Root getRoot() {
            IWidget w;
            for (w = this; w != null && !(w instanceof Root); w = w.parent()) {
            }
            return (Root)w;
        }
    }

    public static interface IWidget {
        public IWidgetContainer parent();

        public void setParent(IWidgetContainer var1);

        public int left();

        public int top();

        public int width();

        public int height();

        public void setLeft(int var1);

        public void setTop(int var1);

        public void draw(Screen var1, int var2, int var3);

        public IWidget dispatchMousePress(int var1, int var2, int var3);

        public boolean dispatchKeyPress(char var1, int var2);

        public void mousePressed(MouseCoords var1, int var2);

        public void mouseDragged(MouseCoords var1, int var2);

        public void mouseReleased(MouseCoords var1, int var2);

        public boolean keyPressed(char var1, int var2);

        public void focusChanged(boolean var1);

        public void close();

        public void layout();
    }

    public static class MouseCoords {
        int x;
        int y;

        public MouseCoords(IWidget widget, int x, int y) {
            while (widget != null) {
                x -= widget.left();
                y -= widget.top();
                widget = widget.parent();
            }
            this.x = x;
            this.y = y;
        }
    }

    public static class Screen
    extends GuiContainer
    implements BaseMod.ISetMod {
        protected BaseMod mod;
        protected Root root;
        protected String title;
        protected Tessellator tess;
        protected BufferBuilder vb;
        protected IWidget mouseWidget;
        protected GState gstate;

        public Screen(Container container, int width, int height) {
            super(container);
            this.field_146999_f = width;
            this.field_147000_g = height;
            this.root = new Root(this);
            this.tess = Tessellator.func_178181_a();
            this.vb = this.tess.func_178180_c();
            this.gstate = new GState();
        }

        public Screen(BaseContainer container) {
            this(container, container.xSize, container.ySize);
        }

        public int getWidth() {
            return this.field_146999_f;
        }

        public int getHeight() {
            return this.field_147000_g;
        }

        @Override
        public void setMod(BaseMod mod) {
            this.mod = mod;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.root.layout();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float f, int mouseX, int mouseY) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
            this.drawBackgroundLayer();
            if (this.title != null) {
                this.drawTitle(this.title);
            }
            this.root.draw(this, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            GL11.glPopMatrix();
        }

        protected void drawBackgroundLayer() {
            this.drawGuiBackground(0.0, 0.0, this.field_146999_f, this.field_147000_g);
        }

        protected void func_146979_b(int par1, int par2) {
            this.drawForegroundLayer();
        }

        protected void drawForegroundLayer() {
        }

        public void close() {
            this.dispatchClosure(this.root);
            this.onClose();
            this.field_146297_k.field_71439_g.func_71053_j();
        }

        protected void onClose() {
        }

        public void bindTexture(String path) {
            this.bindTexture(path, 1, 1);
        }

        public void bindTexture(String path, int usize, int vsize) {
            this.bindTexture(((BaseModClient)this.mod.client).textureLocation(path), usize, vsize);
        }

        public void bindTexture(ResourceLocation rsrc) {
            this.bindTexture(rsrc, 1, 1);
        }

        public void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
            this.gstate.texture = rsrc;
            this.field_146297_k.func_110434_K().func_110577_a(rsrc);
            this.gstate.uscale = 1.0 / (double)usize;
            this.gstate.vscale = 1.0 / (double)vsize;
        }

        public void gSave() {
            this.gstate = new GState(this.gstate);
        }

        public void gRestore() {
            if (this.gstate.previous != null) {
                this.gstate = this.gstate.previous;
                this.field_146297_k.func_110434_K().func_110577_a(this.gstate.texture);
            } else {
                System.out.printf("BaseGui: Warning: Graphics state stack underflow\n", new Object[0]);
            }
        }

        public void drawRect(double x, double y, double w, double h) {
            GL11.glDisable((int)3553);
            GL11.glColor3d((double)this.gstate.red, (double)this.gstate.green, (double)this.gstate.blue);
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)x, (double)(y + h), (double)this.field_73735_i);
            GL11.glVertex3d((double)(x + w), (double)(y + h), (double)this.field_73735_i);
            GL11.glVertex3d((double)(x + w), (double)y, (double)this.field_73735_i);
            GL11.glVertex3d((double)x, (double)y, (double)this.field_73735_i);
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }

        public void drawBorderedRect(double x, double y, double w, double h, double u, double v, double uSize, double vSize, double cornerWidth, double cornerHeight) {
            double cw = cornerWidth;
            double ch = cornerHeight;
            double sw = w - 2.0 * cornerWidth;
            double sh = h - 2.0 * cornerHeight;
            double usw = uSize - 2.0 * cornerWidth;
            double ush = vSize - 2.0 * cornerHeight;
            double x1 = x + cw;
            double x2 = w - cw;
            double y1 = y + ch;
            double y2 = h - ch;
            double u1 = u + cw;
            double u2 = uSize - cw;
            double v1 = v + ch;
            double v2 = vSize - cw;
            this.drawTexturedRect(x, y, cw, ch, u, v);
            this.drawTexturedRect(x2, y, cw, ch, u2, v);
            this.drawTexturedRect(x, y2, cw, ch, u, v2);
            this.drawTexturedRect(x2, y2, cw, ch, u2, v2);
            this.drawTexturedRect(x1, y, sw, ch, u1, v, usw, ch);
            this.drawTexturedRect(x1, y2, sw, ch, u1, v2, usw, ch);
            this.drawTexturedRect(x, y1, cw, sh, u, v1, cw, ush);
            this.drawTexturedRect(x2, y1, cw, sh, u2, v1, cw, ush);
            this.drawTexturedRect(x1, y1, sw, sh, u1, v1, usw, ush);
        }

        public void drawGuiBackground(double x, double y, double w, double h) {
            this.bindTexture("gui/gui_background.png", 16, 16);
            this.setColor(0xFFFFFF);
            this.drawBorderedRect(x, y, w, h, 0.0, 0.0, 16.0, 16.0, 4.0, 4.0);
        }

        public void drawTexturedRect(double x, double y, double w, double h) {
            this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
        }

        public void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
            this.drawTexturedRect(x, y, w, h, u, v, w, h);
        }

        public void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
            this.drawTexturedRectUV(x, y, w, h, u * this.gstate.uscale, v * this.gstate.vscale, us * this.gstate.uscale, vs * this.gstate.vscale);
        }

        public void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
            GL11.glBegin((int)7);
            GL11.glColor3f((float)this.gstate.red, (float)this.gstate.green, (float)this.gstate.blue);
            GL11.glTexCoord2d((double)u, (double)(v + vs));
            GL11.glVertex3d((double)x, (double)(y + h), (double)this.field_73735_i);
            GL11.glTexCoord2d((double)(u + us), (double)(v + vs));
            GL11.glVertex3d((double)(x + w), (double)(y + h), (double)this.field_73735_i);
            GL11.glTexCoord2d((double)(u + us), (double)v);
            GL11.glVertex3d((double)(x + w), (double)y, (double)this.field_73735_i);
            GL11.glTexCoord2d((double)u, (double)v);
            GL11.glVertex3d((double)x, (double)y, (double)this.field_73735_i);
            GL11.glEnd();
        }

        public void setColor(int hex) {
            this.setColor((double)(hex >> 16) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
        }

        public void setColor(double r, double g, double b) {
            this.gstate.red = (float)r;
            this.gstate.green = (float)g;
            this.gstate.blue = (float)b;
        }

        public void resetColor() {
            this.setColor(1.0, 1.0, 1.0);
        }

        public void setTextColor(int hex) {
            this.gstate.textColor = hex;
        }

        public void setTextColor(double red, double green, double blue) {
            this.setTextColor(BaseUtils.packedColor(red, green, blue));
        }

        public void setTextShadow(boolean state) {
            this.gstate.textShadow = state;
        }

        public void drawString(String s, int x, int y) {
            this.field_146289_q.func_175065_a(s, (float)x, (float)y, this.gstate.textColor, this.gstate.textShadow);
        }

        public void drawCenteredString(String s, int x, int y) {
            this.field_146289_q.func_175065_a(s, (float)(x - this.field_146289_q.func_78256_a(s) / 2), (float)y, this.gstate.textColor, this.gstate.textShadow);
        }

        public void drawRightAlignedString(String s, int x, int y) {
            this.field_146289_q.func_175065_a(s, (float)(x - this.field_146289_q.func_78256_a(s)), (float)y, this.gstate.textColor, this.gstate.textShadow);
        }

        public void drawTitle(String s) {
            this.drawCenteredString(s, this.field_146999_f / 2, 4);
        }

        public void drawPlayerInventoryName() {
            this.drawString(Screen.playerInventoryName(), 8, this.field_147000_g - 96 + 2);
        }

        public static String playerInventoryName() {
            return I18n.func_74838_a((String)"container.inventory");
        }

        protected void func_73864_a(int x, int y, int button) throws IOException {
            super.func_73864_a(x, y, button);
            this.mousePressed(x - this.field_147003_i, y - this.field_147009_r, button);
        }

        protected void mousePressed(int x, int y, int button) {
            this.mouseWidget = this.root.dispatchMousePress(x, y, button);
            if (this.mouseWidget != null) {
                this.closeOldFocus(this.mouseWidget);
                this.focusOn(this.mouseWidget);
                this.mouseWidget.mousePressed(new MouseCoords(this.mouseWidget, x - this.field_147003_i, y - this.field_147009_r), button);
            }
        }

        protected void func_146273_a(int x, int y, int button, long timeSinceLastClick) {
            super.func_146273_a(x, y, button, timeSinceLastClick);
            if (this.mouseWidget != null) {
                MouseCoords m = new MouseCoords(this.mouseWidget, x, y);
                this.mouseWidget.mouseDragged(m, button);
            }
        }

        protected void func_146286_b(int x, int y, int button) {
            super.func_146286_b(x, y, button);
            if (this.mouseWidget != null) {
                MouseCoords m = new MouseCoords(this.mouseWidget, x, y);
                this.mouseWidget.mouseReleased(m, button);
            }
        }

        void closeOldFocus(IWidget clickedWidget) {
            if (!BaseGui.isFocused(clickedWidget)) {
                IWidgetContainer parent = clickedWidget.parent();
                while (!BaseGui.isFocused(parent)) {
                    parent = parent.parent();
                }
                this.dispatchClosure(parent.getFocus());
            }
        }

        void dispatchClosure(IWidget target) {
            while (target != null) {
                target.close();
                target = this.getFocusOf(target);
            }
        }

        IWidget getFocusOf(IWidget widget) {
            if (widget instanceof IWidgetContainer) {
                return ((IWidgetContainer)widget).getFocus();
            }
            return null;
        }

        protected void func_73869_a(char c, int key) throws IOException {
            if (!this.root.dispatchKeyPress(c, key)) {
                if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                    this.close();
                } else {
                    super.func_73869_a(c, key);
                }
            }
        }

        public void focusOn(IWidget newFocus) {
            IWidgetContainer parent = newFocus.parent();
            if (parent != null) {
                IWidget oldFocus = parent.getFocus();
                if (BaseGui.isFocused(parent)) {
                    if (oldFocus != newFocus) {
                        BaseGui.tellFocusChanged(oldFocus, false);
                        parent.setFocus(newFocus);
                        BaseGui.tellFocusChanged(newFocus, true);
                    }
                } else {
                    parent.setFocus(newFocus);
                    this.focusOn(parent);
                }
            }
        }

        public void focusChanged(boolean state) {
        }
    }
}

