/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.gegy1000.justnow.executor.CurrentThreadExecutor;
import net.gegy1000.justnow.executor.LocalExecutor;
import net.gegy1000.justnow.executor.TaskHandle;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.terrarium.server.world.data.DataGenerator;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.minecraft.util.math.ChunkPos;

public final class ColumnDataLoader
implements AutoCloseable {
    private final DataGenerator generator;
    private final Long2ObjectMap<TaskHandle<DataSample>> taskMap = new Long2ObjectOpenHashMap();
    private final LocalExecutor executor = new LocalExecutor();

    ColumnDataLoader(DataGenerator generator) {
        this.generator = generator;
    }

    public void advanceUntil(long endNanoTime) {
        while (System.nanoTime() < endNanoTime && this.executor.advanceAll()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<DataSample> spawn(ChunkPos columnPos) {
        TaskHandle<DataSample> handle = this.executor.spawn(this.generate(columnPos));
        Long2ObjectMap<TaskHandle<DataSample>> long2ObjectMap = this.taskMap;
        synchronized (long2ObjectMap) {
            this.taskMap.put(ChunkPos.func_77272_a((int)columnPos.field_77276_a, (int)columnPos.field_77275_b), handle);
        }
        return handle;
    }

    public DataSample getNow(ChunkPos columnPos) {
        Future<DataSample> future = this.stealTask(ChunkPos.func_77272_a((int)columnPos.field_77276_a, (int)columnPos.field_77275_b));
        if (future == null) {
            future = this.generate(columnPos);
        }
        return CurrentThreadExecutor.blockOn(future);
    }

    private Future<DataSample> generate(ChunkPos columnPos) {
        return this.generator.generate(DataView.of(columnPos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<DataSample> stealTask(long columnPos) {
        TaskHandle task;
        Long2ObjectMap<TaskHandle<DataSample>> long2ObjectMap = this.taskMap;
        synchronized (long2ObjectMap) {
            task = (TaskHandle)this.taskMap.remove(columnPos);
        }
        return task != null ? this.executor.steal(task) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(long columnPos) {
        Long2ObjectMap<TaskHandle<DataSample>> long2ObjectMap = this.taskMap;
        synchronized (long2ObjectMap) {
            TaskHandle handle = (TaskHandle)this.taskMap.remove(columnPos);
            if (handle != null) {
                this.executor.cancel(handle);
            }
        }
    }

    @Override
    public void close() {
        this.cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAll() {
        Long2ObjectMap<TaskHandle<DataSample>> long2ObjectMap = this.taskMap;
        synchronized (long2ObjectMap) {
            for (TaskHandle handle : this.taskMap.values()) {
                this.executor.cancel(handle);
            }
            this.taskMap.clear();
        }
    }
}

