/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.capability;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import net.gegy1000.terrarium.server.capability.TerrariumAuxCaps;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.capability.VoidStorage;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class TerrariumCapabilities {
    public static final ResourceLocation WORLD_DATA_ID = new ResourceLocation("terrarium", "world_data");
    public static final ResourceLocation AUX_DATA_ID = new ResourceLocation("terrarium", "aux_data");
    @CapabilityInject(value=TerrariumWorld.class)
    private static Capability<TerrariumWorld> world;
    @CapabilityInject(value=TerrariumAuxCaps.class)
    private static Capability<TerrariumAuxCaps> aux;

    public static void onPreInit() {
        CapabilityManager.INSTANCE.register(TerrariumWorld.class, new VoidStorage(), TerrariumCapabilities.unsupported());
        CapabilityManager.INSTANCE.register(TerrariumAuxCaps.class, new VoidStorage(), TerrariumAuxCaps.Implementation::new);
    }

    private static <T> Callable<T> unsupported() {
        return () -> {
            throw new UnsupportedOperationException();
        };
    }

    public static Capability<TerrariumWorld> world() {
        Preconditions.checkNotNull(world, (Object)"terrarium world cap not initialized");
        return world;
    }

    public static Capability<TerrariumAuxCaps> aux() {
        Preconditions.checkNotNull(aux, (Object)"terrarium aux world cap not initialized");
        return aux;
    }
}

