/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.justnow.future;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.gegy1000.justnow.Waker;
import net.gegy1000.justnow.future.AndThen;
import net.gegy1000.justnow.future.Cancelable;
import net.gegy1000.justnow.future.Handle;
import net.gegy1000.justnow.future.Join2;
import net.gegy1000.justnow.future.JoinAll;
import net.gegy1000.justnow.future.JoinAllMap;
import net.gegy1000.justnow.future.JoinHandle;
import net.gegy1000.justnow.future.Lazy;
import net.gegy1000.justnow.future.Map1;
import net.gegy1000.justnow.future.Map2;
import net.gegy1000.justnow.future.MaybeDone;
import net.gegy1000.justnow.future.Pending;
import net.gegy1000.justnow.future.Ready;
import net.gegy1000.justnow.future.Select2;
import net.gegy1000.justnow.future.SelectAll;
import net.gegy1000.justnow.tuple.Either;
import net.gegy1000.justnow.tuple.Two;

public interface Future<T> {
    @Nullable
    public T poll(Waker var1);

    public static <T> JoinHandle<T> spawnBlocking(Executor executor, Supplier<T> supplier) {
        JoinHandle handle = new JoinHandle();
        executor.execute(() -> {
            handle.setExecutingThread(Thread.currentThread());
            Object result = supplier.get();
            handle.completeOk(result);
        });
        return handle;
    }

    public static <T> Future<T> ready(T value) {
        if (value == null) {
            throw new IllegalArgumentException("ready value cannot be null");
        }
        return new Ready<T>(value);
    }

    public static <T> Future<T> pending() {
        return new Pending();
    }

    public static <T> Future<T> lazy(Supplier<T> op) {
        return new Lazy<T>(op);
    }

    public static <T> Cancelable<T> cancelable(Future<T> future) {
        return new Cancelable<T>(future);
    }

    public static <T> MaybeDone<T> maybeDone(Future<T> future) {
        return new MaybeDone<T>(future);
    }

    public static <A, B> Future<Two<A, B>> join2(Future<A> a, Future<B> b) {
        return new Join2<A, B>(a, b);
    }

    public static <A, B, R> Future<Either<A, B>> select2(Future<A> a, Future<B> b) {
        return new Select2<A, B>(a, b);
    }

    public static <T> Future<Collection<T>> joinAll(Collection<Future<T>> futures) {
        return new JoinAll<T>(futures);
    }

    public static <T> Future<Collection<T>> joinAll(Stream<Future<T>> futures) {
        return new JoinAll(futures.collect(Collectors.toCollection(LinkedList::new)));
    }

    public static <K, V> Future<Map<K, V>> joinAll(Map<K, Future<V>> map) {
        return new JoinAllMap<K, V>(map);
    }

    public static <T> Future<T> selectAll(Collection<Future<T>> futures) {
        return new SelectAll<T>(futures);
    }

    public static <A, B, R> Future<R> map2(Future<A> a, Future<B> b, BiFunction<A, B, R> map) {
        return new Map2<A, B, R>(a, b, map);
    }

    public static <A, B, R> Future<R> andThen2(Future<A> a, Future<B> b, BiFunction<A, B, Future<R>> andThen) {
        return new Map2<A, B, Future<R>>(a, b, andThen).andThen(f -> f);
    }

    default public <U> Future<U> map(Function<T, U> map) {
        return new Map1<T, U>(this, map);
    }

    default public <U> Future<U> andThen(Function<T, Future<U>> andThen) {
        return new AndThen<T, U>(this, andThen);
    }

    default public <U> Future<U> handle(BiFunction<T, Throwable, U> handle) {
        return new Handle<T, U>(this, handle);
    }

    default public <U> Future<Two<T, U>> join(Future<U> future) {
        return new Join2(this, future);
    }

    default public <U> Future<Either<T, U>> select(Future<U> future) {
        return new Select2(this, future);
    }
}

