/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import net.gegy1000.earth.server.util.IoFunction;
import net.gegy1000.earth.server.util.zoom.ZoomLevels;
import net.gegy1000.earth.server.util.zoom.Zoomable;
import net.gegy1000.earth.server.world.data.source.cache.CachingInput;
import net.gegy1000.earth.server.world.data.source.cache.FileTileCache;
import net.gegy1000.terrarium.server.util.Vec2i;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.gegy1000.terrarium.server.world.data.source.TerrariumCacheDirs;
import net.gegy1000.terrarium.server.world.data.source.TiledDataSource;
import net.minecraft.util.math.MathHelper;

public final class StdSource<T>
extends TiledDataSource<T> {
    public static final int TILE_SIZE = 1000;
    private static final int ZOOM_BASE = 3;
    public static final String ENDPOINT = "https://terrarium.gegy.dev/geo3";
    private final IoFunction<InputStream, T> read;
    private final String endpoint;
    private final int zoom;
    private final CachingInput<Vec2i> cachingInput;

    private StdSource(String cacheName, String endpoint, IoFunction<InputStream, T> read, int zoom) {
        super(1000.0);
        this.read = read;
        this.endpoint = "https://terrarium.gegy.dev/geo3/" + endpoint + "/" + zoom;
        this.zoom = zoom;
        Path cacheRoot = TerrariumCacheDirs.GLOBAL_ROOT.resolve(cacheName + "/" + zoom);
        FileTileCache<Vec2i> cache = new FileTileCache<Vec2i>(pos -> cacheRoot.resolve(pos.x + "/" + pos.y));
        this.cachingInput = new CachingInput<Vec2i>(cache);
    }

    public static <T> Builder<T> builder(ZoomLevels zoomLevels) {
        return new Builder(zoomLevels);
    }

    public static CoordinateReference crs(double worldScale, int zoom) {
        double globalWidth = StdSource.globalWidth(zoom);
        double globalHeight = StdSource.globalHeight(zoom);
        double scale = 4.0075017E7 / (worldScale * globalWidth);
        double offsetX = -globalWidth / 2.0;
        double offsetZ = -globalHeight / 2.0;
        return CoordinateReference.scaleAndOffset(scale, scale, offsetX, offsetZ);
    }

    public static double tileSizeDeg(int zoom) {
        return 360.0 / StdSource.tileCountX(zoom);
    }

    public static double tileCountX(int zoom) {
        return StdSource.tileCountY(zoom) * 2.0;
    }

    public static double tileCountY(int zoom) {
        return Math.pow(3.0, zoom);
    }

    public static double globalWidth(int zoom) {
        return StdSource.tileCountX(zoom) * 1000.0;
    }

    public static double globalHeight(int zoom) {
        return StdSource.tileCountY(zoom) * 1000.0;
    }

    public static double metersPerPixel(int zoom) {
        return 4.0075017E7 / StdSource.globalWidth(zoom);
    }

    public static double zoomForScale(double meters) {
        return Math.log(4.0075017E7 / (2000.0 * meters)) / Math.log(3.0);
    }

    public static boolean containsTile(Vec2i pos, int zoom) {
        int tileCountX = MathHelper.func_76143_f((double)StdSource.tileCountX(zoom));
        int tileCountY = MathHelper.func_76143_f((double)StdSource.tileCountY(zoom));
        return pos.x >= 0 && pos.y >= 0 && pos.x < tileCountX && pos.y < tileCountY;
    }

    @Override
    public Optional<T> load(Vec2i pos) throws IOException {
        if (!StdSource.containsTile(pos, this.zoom)) {
            return Optional.empty();
        }
        return Optional.of(this.cachingInput.tryLoad(pos, key -> StdSource.httpGet(new URL(this.endpoint + "/" + key.x + "/" + key.y)), this.read));
    }

    public static class Builder<T> {
        private final ZoomLevels zoomLevels;
        private String cacheName;
        private IoFunction<InputStream, T> read;
        private String endpoint;

        private Builder(ZoomLevels zoomLevels) {
            this.zoomLevels = zoomLevels;
        }

        public Builder<T> cacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        public Builder<T> endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder<T> read(IoFunction<InputStream, T> read) {
            this.read = read;
            return this;
        }

        public Zoomable<StdSource<T>> build() {
            return this.zoomLevels.map(zoom -> new StdSource(this.cacheName, this.endpoint, this.read, zoom));
        }
    }
}

