/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.cover;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.gegy1000.earth.server.world.cover.Cover;

public interface CoverSelector
extends Iterable<Cover> {
    public boolean contains(Cover var1);

    default public Stream<Cover> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public CoverSelector or(CoverSelector rhs) {
        return new Or(this, rhs);
    }

    default public CoverSelector and(CoverSelector rhs) {
        return new And(this, rhs);
    }

    default public CoverSelector not() {
        return new Not(this);
    }

    public static class Not
    implements CoverSelector {
        private final CoverSelector not;
        private Set<Cover> collected;

        Not(CoverSelector not) {
            this.not = not;
        }

        @Override
        public boolean contains(Cover cover) {
            return !this.not.contains(cover);
        }

        @Override
        public Iterator<Cover> iterator() {
            if (this.collected == null) {
                this.collected = Sets.difference((Set)Sets.newHashSet((Object[])Cover.values()), (Set)Sets.newHashSet((Iterable)this.not));
            }
            return this.collected.iterator();
        }
    }

    public static class And
    implements CoverSelector {
        private final CoverSelector a;
        private final CoverSelector b;
        private Set<Cover> collected;

        And(CoverSelector a, CoverSelector b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean contains(Cover cover) {
            return this.a.contains(cover) && this.b.contains(cover);
        }

        @Override
        public Iterator<Cover> iterator() {
            if (this.collected == null) {
                this.collected = Sets.intersection((Set)Sets.newHashSet((Iterable)this.a), (Set)Sets.newHashSet((Iterable)this.b));
            }
            return this.collected.iterator();
        }
    }

    public static class Or
    implements CoverSelector {
        private final CoverSelector a;
        private final CoverSelector b;
        private Set<Cover> collected;

        Or(CoverSelector a, CoverSelector b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean contains(Cover cover) {
            return this.a.contains(cover) || this.b.contains(cover);
        }

        @Override
        public Iterator<Cover> iterator() {
            if (this.collected == null) {
                this.collected = Sets.union((Set)Sets.newHashSet((Iterable)this.a), (Set)Sets.newHashSet((Iterable)this.b));
            }
            return this.collected.iterator();
        }
    }
}

