/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure;

import dev.gegy.gengen.api.HeightFunction;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.gegy1000.earth.server.world.composer.structure.ColumnStructureComposer;
import net.gegy1000.earth.server.world.composer.structure.placement.CellStructurePlacement;
import net.gegy1000.terrarium.server.world.composer.structure.StructureComposer;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureStart;

public final class TempleStructureComposer {
    private static final List<Biome> TEMPLE_BIOMES = Arrays.asList(Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_76780_h, Biomes.field_76774_n, Biomes.field_150584_S);

    public static StructureComposer create(WorldServer world, HeightFunction surfaceFunction) {
        CellStructurePlacement placement = new CellStructurePlacement(32, 8, 14357617).setPredicate(TempleStructureComposer::canSpawnAt);
        return ColumnStructureComposer.builder().setStructureName("Temple").setPlacement(placement).setSurfaceFunction(surfaceFunction).setStartConstructor(TempleStructureComposer::makeStart).build(world);
    }

    private static StructureStart makeStart(World world, Random random, int chunkX, int chunkZ) {
        return new MapGenScatteredFeature.Start(world, random, chunkX, chunkZ);
    }

    private static boolean canSpawnAt(World world, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        return world.func_72959_q().func_76940_a(x, z, 0, TEMPLE_BIOMES);
    }
}

