/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure;

import dev.gegy.gengen.api.HeightFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.gegy1000.earth.server.world.composer.structure.ColumnStructureComposer;
import net.gegy1000.earth.server.world.composer.structure.placement.CellStructurePlacement;
import net.gegy1000.terrarium.server.world.composer.structure.StructureComposer;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.BiomeManager;

public final class StrongholdStructureComposer {
    private static final List<Biome> STRONGHOLD_BIOMES = StrongholdStructureComposer.collectStrongholdBiomes();

    private static List<Biome> collectStrongholdBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || !(biome.func_185355_j() > 0.0f) || BiomeManager.strongHoldBiomesBlackList.contains(biome)) continue;
            biomes.add(biome);
        }
        for (Biome biome : BiomeManager.strongHoldBiomes) {
            if (biomes.contains(biome)) continue;
            biomes.add(biome);
        }
        biomes.remove(Biomes.field_185440_P);
        return biomes;
    }

    public static StructureComposer create(WorldServer world, HeightFunction surfaceFunction) {
        CellStructurePlacement placement = new CellStructurePlacement(128, 32, 1660845913).setPredicate(StrongholdStructureComposer::canSpawnAt);
        return ColumnStructureComposer.builder().setStructureName("Stronghold").setPlacement(placement).setSurfaceFunction(surfaceFunction).setStartConstructor(StrongholdStructureComposer::makeStart).build(world);
    }

    private static StructureStart makeStart(World world, Random random, int chunkX, int chunkZ) {
        return new MapGenStronghold.Start(world, random, chunkX, chunkZ);
    }

    private static boolean canSpawnAt(World world, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        return world.func_72959_q().func_76940_a(x, z, 16, STRONGHOLD_BIOMES);
    }
}

