/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.core.GenGen;
import io.github.opencubicchunks.cubicchunks.api.util.Box;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import io.github.opencubicchunks.cubicchunks.api.worldgen.ICubeGenerator;
import io.github.opencubicchunks.cubicchunks.core.server.CubeProviderServer;
import io.github.opencubicchunks.cubicchunks.core.world.cube.Cube;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibilityWorld;
import net.gegy1000.earth.server.world.compatibility.capability.CcColumnCompatibilityMetadata;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public final class ColumnCompatibility {
    private static final ShortRaster.Sampler HEIGHT_SAMPLER = ShortRaster.sampler(EarthData.TERRAIN_HEIGHT);
    private static final int COMPAT_SURFACE_Y = 74;
    private final World world;
    private final boolean cubic;
    private final ColumnCompatibilityWorld compatibilityWorld;

    public ColumnCompatibility(WorldServer world) {
        this.world = world;
        this.cubic = GenGen.isCubic((World)world);
        this.compatibilityWorld = ColumnCompatibilityWorld.create(world);
    }

    public void generateInColumn(TerrariumWorld terrarium, CubicPos pos, ColumnGenerator generator) {
        ChunkPos columnPos = new ChunkPos(pos.getX(), pos.getZ());
        GenerationRange range = this.getCompatibilityRange(terrarium, columnPos);
        if (!range.contains(pos.getY())) {
            return;
        }
        if (this.cubic) {
            this.generateInCubicChunksColumn(pos, range, generator);
        } else {
            this.generateInVanillaColumn(pos, range, generator);
        }
    }

    private void generateInVanillaColumn(CubicPos pos, GenerationRange range, ColumnGenerator generator) {
        if (pos.getY() == range.minCubeY) {
            ChunkPos columnPos = new ChunkPos(pos.getX(), pos.getZ());
            try (ColumnCompatibilityWorld world = this.compatibilityWorld.setupAt(columnPos, range.minY());){
                generator.generate(world, columnPos);
            }
        }
    }

    private void generateInCubicChunksColumn(CubicPos pos, GenerationRange range, ColumnGenerator generator) {
        Chunk chunk = this.world.func_72964_e(pos.getX(), pos.getZ());
        CcColumnCompatibilityMetadata metadata = CcColumnCompatibilityMetadata.get(chunk);
        if (metadata != null && metadata.tryRunGenerator()) {
            ChunkPos columnPos = new ChunkPos(pos.getX(), pos.getZ());
            Cubic.prepareCubesInColumn(this.world, columnPos, range);
            try (ColumnCompatibilityWorld world = this.compatibilityWorld.setupAt(columnPos, range.minY());){
                generator.generate(world, columnPos);
            }
        }
    }

    private GenerationRange getCompatibilityRange(TerrariumWorld terrarium, ChunkPos columnPos) {
        int x = columnPos.func_180334_c() + 8;
        int z = columnPos.func_180333_d() + 8;
        short surfaceY = HEIGHT_SAMPLER.sample(terrarium.getDataCache(), x, z);
        int minY = surfaceY - 74;
        if (!this.cubic) {
            minY = Math.max(surfaceY, 0);
        }
        int minCubeY = minY >> 4;
        int maxCubeY = minCubeY + 15;
        return new GenerationRange(minCubeY, maxCubeY);
    }

    public static interface ColumnGenerator {
        public void generate(ColumnCompatibilityWorld var1, ChunkPos var2);
    }

    static class Cubic {
        Cubic() {
        }

        static void prepareCubesInColumn(World world, ChunkPos columnPos, GenerationRange range) {
            ICubicWorld cubicWorld = (ICubicWorld)world;
            if (cubicWorld.getCubeCache() instanceof CubeProviderServer) {
                CubeProviderServer cache = (CubeProviderServer)cubicWorld.getCubeCache();
                ICubeGenerator generator = cache.getCubeGenerator();
                for (int cubeY = range.minCubeY; cubeY <= range.maxCubeY; ++cubeY) {
                    Cube cube = cache.getCube(columnPos.field_77276_a, cubeY, columnPos.field_77275_b);
                    Cubic.populateCube(cache, generator, cube);
                }
            }
        }

        static void populateCube(CubeProviderServer cache, ICubeGenerator generator, Cube cube) {
            Box requirements = generator.getPopulationPregenerationRequirements((ICube)cube);
            requirements.forEachPoint((x, y, z) -> cache.getCube(cube.getX() + x, cube.getY() + y, cube.getZ() + z));
            if (!cube.isPopulated()) {
                generator.populate((ICube)cube);
                cube.setPopulated(true);
            }
        }
    }

    static final class GenerationRange {
        final int minCubeY;
        final int maxCubeY;

        GenerationRange(int minCubeY, int maxCubeY) {
            this.minCubeY = minCubeY;
            this.maxCubeY = maxCubeY;
        }

        public boolean contains(int y) {
            return y >= this.minCubeY && y <= this.maxCubeY;
        }

        public int minY() {
            return this.minCubeY << 4;
        }
    }
}

