/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.preview;

import net.gegy1000.earth.client.gui.preview.PreviewRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class PreviewController {
    private final PreviewRenderer renderer;
    private final float minZoom;
    private final float maxZoom;
    private float rotationX;
    private float prevRotationX;
    private float rotationY;
    private float prevRotationY;
    private float zoom;
    private float prevZoom;
    private int prevMouseX;
    private int prevMouseY;
    private boolean mouseDown;

    public PreviewController(PreviewRenderer renderer, float minZoom, float maxZoom) {
        this.prevRotationX = this.rotationX = 10.0f;
        this.prevRotationY = this.rotationY = 45.0f;
        this.renderer = renderer;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.zoom = this.prevZoom = minZoom;
    }

    public void update() {
        this.prevRotationX = this.rotationX;
        this.prevRotationY = this.rotationY;
        this.prevZoom = this.zoom;
        if (!this.mouseDown) {
            this.rotationY -= 0.25f;
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isSelected(mouseX, mouseY)) {
            this.mouseDown = true;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.mouseDown = false;
        }
    }

    public void mouseDragged(int mouseX, int mouseY, int mouseButton) {
        if (this.mouseDown) {
            this.rotationY += (float)(mouseX - this.prevMouseX) * 0.5f;
            this.rotationX += (float)(mouseY - this.prevMouseY) * 0.5f;
            this.rotationX = MathHelper.func_76131_a((float)this.rotationX, (float)10.0f, (float)50.0f);
        }
    }

    public void updateMouse(int mouseX, int mouseY) {
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
        int scroll = Mouse.getDWheel();
        if (this.isSelected(mouseX, mouseY)) {
            this.zoom = MathHelper.func_76131_a((float)(this.zoom + (float)scroll / 1600.0f), (float)this.minZoom, (float)this.maxZoom);
        }
    }

    public float getRotationX(float partialTicks) {
        return this.prevRotationX + (this.rotationX - this.prevRotationX) * partialTicks;
    }

    public float getRotationY(float partialTicks) {
        return this.prevRotationY + (this.rotationY - this.prevRotationY) * partialTicks;
    }

    public float getZoom(float partialTicks) {
        return this.prevZoom + (this.zoom - this.prevZoom) * partialTicks;
    }

    private boolean isSelected(int mouseX, int mouseY) {
        return (double)mouseX >= this.renderer.getX() && (double)mouseY >= this.renderer.getY() && (double)mouseX <= this.renderer.getX() + this.renderer.getWidth() && (double)mouseY <= this.renderer.getY() + this.renderer.getHeight();
    }
}

