/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapPoint;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapWidget;
import net.gegy1000.earth.client.gui.widget.map.component.MarkerMapComponent;
import net.gegy1000.earth.client.gui.widget.map.component.RectMapComponent;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.message.OpenDownloadMessage;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EarthPreloadGui
extends GuiScreen {
    private static final int CANCEL_BUTTON = 0;
    private static final int DOWNLOAD_BUTTON = 1;
    private final EarthWorld earth;
    private final double latitude;
    private final double longitude;
    private GuiButton downloadButton;
    private SlippyMapWidget mapWidget;
    private RectMapComponent mapSelection;

    public EarthPreloadGui(EarthWorld earth, double latitude, double longitude) {
        this.earth = earth;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void func_73866_w_() {
        if (this.mapWidget != null) {
            this.mapWidget.close();
        }
        this.field_146292_n.clear();
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.downloadButton = this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.earth.download", (Object[])new Object[0])));
        this.mapWidget = new SlippyMapWidget(60, 20, this.field_146294_l - 120, this.field_146295_m - 100);
        this.mapWidget.getMap().focus(0.0, 0.0, 3);
        this.mapSelection = this.mapWidget.addComponent(new RectMapComponent());
        this.mapWidget.addComponent(new MarkerMapComponent(new SlippyMapPoint(this.latitude, this.longitude)));
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 1) {
            Tuple<ChunkPos, ChunkPos> selection = this.getSelection();
            if (selection == null) {
                return;
            }
            TerrariumEarth.NETWORK.sendToServer((IMessage)new OpenDownloadMessage((ChunkPos)selection.func_76341_a(), (ChunkPos)selection.func_76340_b()));
            this.field_146297_k.func_147108_a(null);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.mapWidget.draw(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.earth.preload", (Object[])new Object[0]), this.field_146294_l / 2, 4, 0xFFFFFF);
        Tuple<ChunkPos, ChunkPos> selection = this.getSelection();
        if (selection != null) {
            ChunkPos minChunk = (ChunkPos)selection.func_76341_a();
            ChunkPos maxChunk = (ChunkPos)selection.func_76340_b();
            int width = maxChunk.field_77276_a - minChunk.field_77276_a + 1;
            int height = maxChunk.field_77275_b - minChunk.field_77275_b + 1;
            long chunkCount = (long)width * (long)height;
            this.func_73732_a(this.field_146289_q, width + "x" + height + " = " + chunkCount + " chunks", this.field_146294_l / 2, this.field_146295_m - 60, 0xFFFFFF);
        }
        this.downloadButton.field_146124_l = selection != null;
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.mapWidget.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.mapWidget.mouseDragged(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        this.mapWidget.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.mapWidget.close();
    }

    @Nullable
    private Tuple<ChunkPos, ChunkPos> getSelection() {
        RectMapComponent.Rect selection = this.mapSelection.getSelectedRect();
        if (selection != null) {
            CoordinateReference crs = this.earth.getCrs();
            Coordinate min = crs.coord(selection.minLongitude, selection.minLatitude).toBlock();
            Coordinate max = crs.coord(selection.maxLongitude, selection.maxLatitude).toBlock();
            return new Tuple((Object)new ChunkPos(Coordinate.min(min, max).toBlockPos()), (Object)new ChunkPos(Coordinate.max(min, max).toBlockPos()));
        }
        return null;
    }
}

