/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.core.impl.cubic;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.writer.ChunkPopulationWriter;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CubePopulationWriterImpl
implements ChunkPopulationWriter {
    private final World world;
    private final CubicPos pos;

    public CubePopulationWriterImpl(World world, CubicPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public void set(BlockPos pos, IBlockState state) {
        this.world.func_175656_a(pos, state);
    }

    @Override
    public IBlockState get(BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    @Override
    public boolean getSurfaceMut(BlockPos.MutableBlockPos pos) {
        Chunk chunk = this.world.func_175726_f((BlockPos)pos);
        int minY = this.pos.getCenterY();
        pos.func_185336_p(minY + 16);
        while (pos.func_177956_o() >= minY) {
            pos.func_189536_c(EnumFacing.DOWN);
            if (chunk.func_177435_g((BlockPos)pos).getLightOpacity((IBlockAccess)this.world, (BlockPos)pos) == 0) continue;
            pos.func_189536_c(EnumFacing.UP);
            return true;
        }
        return false;
    }

    @Override
    public Biome getCenterBiome() {
        return this.world.func_72964_e(this.pos.getX(), this.pos.getZ()).func_177411_a(POPULATION_CENTER, this.world.func_72959_q());
    }

    @Override
    public World getGlobal() {
        return this.world;
    }
}

