/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.util.IFluidHandlerInternal;

public class ModuleLiquidIndicator
extends ModuleBase {
    IFluidHandler tile;
    IFluidHandlerInternal tile2;
    ResourceLocation fluidIcon = new ResourceLocation("advancedrocketry:textures/blocks/fluid/oxygen_flow.png");
    int prevLiquidUUID;
    int prevLiquidAmt;
    private static final int invalidFluid = -1;

    public ModuleLiquidIndicator(int offsetX, int offsetY, IFluidHandler progress) {
        super(offsetX, offsetY);
        this.tile = progress;
        if (progress instanceof IFluidHandlerInternal) {
            this.tile2 = (IFluidHandlerInternal)progress;
        }
    }

    @Override
    public int numberOfChangesToSend() {
        return 3;
    }

    private Fluid getFluid(int id) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluidIDs().keySet()) {
            if ((Integer)FluidRegistry.getRegisteredFluidIDs().get(fluid) != id) continue;
            return fluid;
        }
        return FluidRegistry.WATER;
    }

    private int getFluidID(Fluid fluid) {
        return (Integer)FluidRegistry.getRegisteredFluidIDs().get(fluid);
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        IFluidTankProperties info = this.tile.getTankProperties()[0];
        if (localId == 0 && info.getContents() != null) {
            crafter.func_71112_a(container, variableId, info.getContents().amount & 0xFFFF);
        } else if (localId == 1 && info.getContents() != null) {
            crafter.func_71112_a(container, variableId, info.getContents().amount >>> 16 & 0xFFFF);
        } else if (localId == 2) {
            if (info.getContents() == null) {
                crafter.func_71112_a(container, variableId, -1);
            } else {
                crafter.func_71112_a(container, variableId, this.getFluidID(info.getContents().getFluid()));
            }
        }
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        IFluidTankProperties info = this.tile.getTankProperties()[0];
        if (slot == 2) {
            if (info.getContents() == null && value != -1) {
                if (this.tile2 != null) {
                    this.tile2.fillInternal(new FluidStack(this.getFluid(value), 1), true);
                } else {
                    this.tile.fill(new FluidStack(this.getFluid(value), 1), true);
                }
            } else if (value == -1) {
                if (this.tile2 != null) {
                    this.tile2.drainInternal(info.getCapacity(), true);
                } else {
                    this.tile.drain(info.getCapacity(), true);
                }
            } else if (info.getContents() != null && value != this.getFluidID(info.getContents().getFluid())) {
                FluidStack stack = this.tile2 != null ? this.tile2.drainInternal(info.getCapacity(), true) : this.tile.drain(info.getCapacity(), true);
                stack = new FluidStack(stack.getFluid(), stack.amount);
                this.tile.fill(stack, true);
            }
        } else if ((slot == 0 || slot == 1) && info.getContents() != null) {
            int difference = slot == 0 ? (value & 0xFFFF) - (info.getContents().amount & 0xFFFF) : (value << 16 & 0xFFFF0000) - (info.getContents().amount & 0xFFFF0000);
            if (difference > 0) {
                if (this.tile2 != null) {
                    this.tile2.fillInternal(new FluidStack(info.getContents().getFluid(), difference), true);
                } else {
                    this.tile.fill(new FluidStack(info.getContents().getFluid(), difference), true);
                }
            } else if (this.tile2 != null) {
                this.tile2.drainInternal(-difference, true);
            } else {
                this.tile.drain(-difference, true);
            }
        }
    }

    @Override
    public boolean needsUpdate(int localId) {
        IFluidTankProperties info = this.tile.getTankProperties()[0];
        if (localId == 0 || localId == 1) {
            return info.getContents() != null && this.prevLiquidAmt != info.getContents().amount;
        }
        if (localId == 2) {
            if (info.getContents() == null) {
                return this.prevLiquidUUID != -1;
            }
            return this.getFluidID(info.getContents().getFluid()) != this.prevLiquidUUID;
        }
        return false;
    }

    @Override
    protected void updatePreviousState(int localId) {
        IFluidTankProperties info = this.tile.getTankProperties()[0];
        if (localId == 0 && info.getContents() != null) {
            this.prevLiquidAmt = info.getContents().amount;
        } else if (localId == 1) {
            this.prevLiquidUUID = info.getContents() == null ? -1 : this.getFluidID(info.getContents().getFluid());
        }
    }

    protected float getProgress() {
        IFluidTankProperties[] info = this.tile.getTankProperties();
        int capacity = 0;
        int fillAmount = 0;
        for (IFluidTankProperties fluidInfo : info) {
            capacity += fluidInfo.getCapacity();
            if (fluidInfo.getContents() == null) continue;
            fillAmount += fluidInfo.getContents().amount;
        }
        return (float)fillAmount / (float)capacity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        int ySize = 52;
        int xSize = 12;
        if (relativeX > 0 && relativeX < xSize && relativeY > 0 && relativeY < ySize) {
            LinkedList<String> list = new LinkedList<String>();
            FluidStack fluidStack = this.tile.getTankProperties()[0].getContents();
            if (fluidStack != null) {
                list.add(fluidStack.getLocalizedName() + ": " + fluidStack.amount + " / " + this.tile.getTankProperties()[0].getCapacity() + " mB");
            } else {
                list.add("Empty");
            }
            this.drawTooltip(gui, list, mouseX, mouseY, zLevel, font);
        }
    }

    @Override
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, x, y, mouseX, mouseY, font);
        gui.func_73729_b(x + this.offsetX, y + this.offsetY, 176, 58, 14, 54);
        IFluidTankProperties info = this.tile.getTankProperties()[0];
        if (info.getContents() != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.fluidIcon);
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            TextureAtlasSprite sprite = map.getTextureExtry(info.getContents().getFluid().getStill().toString());
            int color = info.getContents().getFluid().getColor(info.getContents());
            GL11.glColor3b((byte)((byte)(color >>> 16 & 0x7F)), (byte)((byte)(color >>> 8 & 0x7F)), (byte)((byte)(color & 0x7F)));
            float percent = this.getProgress();
            int ySize = 52;
            int xSize = 12;
            if (sprite == null) {
                gui.func_73729_b(this.offsetX + x + 1, this.offsetY + y + 1 + (ySize - (int)(percent * (float)ySize)), 0, 0, xSize, (int)(percent * (float)ySize));
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                gui.func_175175_a(this.offsetX + x + 1, this.offsetY + y + 1 + (ySize - (int)(percent * (float)ySize)), sprite, xSize, (int)(percent * (float)ySize));
            }
        }
    }
}

