/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.util;

import crafttweaker.CraftTweakerAPI;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RecipeMapModification;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.MachineOutput;

public class RemoveMekanismRecipe<INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>>
extends RecipeMapModification<INPUT, RECIPE> {
    private final IngredientWrapper input;
    private final IngredientWrapper output;

    public RemoveMekanismRecipe(String name, RecipeHandler.Recipe<INPUT, OUTPUT, RECIPE> recipeType, IngredientWrapper output, IngredientWrapper input) {
        super(name, false, recipeType);
        this.input = input;
        this.output = output;
    }

    @Override
    public void apply() {
        this.map.forEach((key, value) -> {
            if (IngredientHelper.matches(key, this.input) && IngredientHelper.matches(value.getOutput(), this.output)) {
                this.recipes.put(key, value);
            }
        });
        if (this.recipes.isEmpty()) {
            String warning = "";
            if (this.input.isEmpty()) {
                if (!this.output.isEmpty()) {
                    warning = String.format("output: '%s'", this.output.toString());
                }
            } else {
                warning = this.output.isEmpty() ? String.format("input: '%s'", this.input.toString()) : String.format("input: '%s' and output: '%s'", this.input.toString(), this.output.toString());
            }
            if (!warning.isEmpty()) {
                CraftTweakerAPI.logWarning((String)String.format("No %s recipe found for %s. Command ignored!", this.name, warning));
            }
        } else {
            super.apply();
            CraftTweakerAPI.logInfo((String)super.describe());
        }
    }

    @Override
    public String describe() {
        return null;
    }
}

